# coding: utf-8

"""
    DocuSign Monitor API - v2

    An API for an integrator to access the features of DocuSign Monitor  # noqa: E501

    OpenAPI spec version: v2.0
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..client.configuration import Configuration
from ..client.api_client import ApiClient


class DataSetApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_stream_for_dataset(self, data_set_name, version, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stream_for_dataset(data_set_name, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_set_name: The name of the dataset to stream (required)
        :param str version: The requested API version (required)
        :param str cursor: Starting cursor position
        :param int limit: Max number of results to return
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_stream_for_dataset_with_http_info(data_set_name, version, **kwargs)
        else:
            (data) = self.get_stream_for_dataset_with_http_info(data_set_name, version, **kwargs)
            return data

    def get_stream_for_dataset_with_http_info(self, data_set_name, version, **kwargs):
        """
        
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_stream_for_dataset_with_http_info(data_set_name, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_set_name: The name of the dataset to stream (required)
        :param str version: The requested API version (required)
        :param str cursor: Starting cursor position
        :param int limit: Max number of results to return
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_set_name', 'version', 'cursor', 'limit']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stream_for_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_set_name' is set
        if ('data_set_name' not in params) or (params['data_set_name'] is None):
            raise ValueError("Missing the required parameter `data_set_name` when calling `get_stream_for_dataset`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_stream_for_dataset`")


        collection_formats = {}

        resource_path = '/api/v{version}/datasets/{dataSetName}/stream'.replace('{format}', 'json')
        path_params = {}
        if 'data_set_name' in params:
            path_params['dataSetName'] = params['data_set_name']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = {}
        if 'cursor' in params:
            query_params['cursor'] = params['cursor']
        if 'limit' in params:
            query_params['limit'] = params['limit']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def get_web_query_for_dataset(self, data_set_name, version, **kwargs):
        """
        Supplies secured, processed data for web-based dashboards
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_web_query_for_dataset(data_set_name, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_set_name: The name of the dataset to query (required)
        :param str version: The requested API version (required)
        :param str filters: A JSON list of filters to apply to the underlying dataset
        :param str aggregations: A JSON list of aggregations to apply to the filtered dataset
        :param str query_scope: The scope to limit the query by. If omitted, defaults to the QueryScope of the DataSet.               DocuSign.API.Lens.Common.QueryScope
        :param str query_scope_id: The AccountId or OrganizationId for this query, which will be double-checked against the User JWT.               If QueryScope==AccountId, this is required.               If QueryScope==OrganizationId, this is optional.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.get_web_query_for_dataset_with_http_info(data_set_name, version, **kwargs)
        else:
            (data) = self.get_web_query_for_dataset_with_http_info(data_set_name, version, **kwargs)
            return data

    def get_web_query_for_dataset_with_http_info(self, data_set_name, version, **kwargs):
        """
        Supplies secured, processed data for web-based dashboards
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_web_query_for_dataset_with_http_info(data_set_name, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_set_name: The name of the dataset to query (required)
        :param str version: The requested API version (required)
        :param str filters: A JSON list of filters to apply to the underlying dataset
        :param str aggregations: A JSON list of aggregations to apply to the filtered dataset
        :param str query_scope: The scope to limit the query by. If omitted, defaults to the QueryScope of the DataSet.               DocuSign.API.Lens.Common.QueryScope
        :param str query_scope_id: The AccountId or OrganizationId for this query, which will be double-checked against the User JWT.               If QueryScope==AccountId, this is required.               If QueryScope==OrganizationId, this is optional.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_set_name', 'version', 'filters', 'aggregations', 'query_scope', 'query_scope_id']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_web_query_for_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_set_name' is set
        if ('data_set_name' not in params) or (params['data_set_name'] is None):
            raise ValueError("Missing the required parameter `data_set_name` when calling `get_web_query_for_dataset`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_web_query_for_dataset`")


        collection_formats = {}

        resource_path = '/api/v{version}/datasets/{dataSetName}/web_query'.replace('{format}', 'json')
        path_params = {}
        if 'data_set_name' in params:
            path_params['dataSetName'] = params['data_set_name']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = {}
        if 'filters' in params:
            query_params['filters'] = params['filters']
        if 'aggregations' in params:
            query_params['aggregations'] = params['aggregations']
        if 'query_scope' in params:
            query_params['queryScope'] = params['query_scope']
        if 'query_scope_id' in params:
            query_params['queryScopeId'] = params['query_scope_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'GET',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_raw_for_dataset(self, data_set_name, version, **kwargs):
        """
        Provides a raw kusto query capability to internal Docusign services
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_raw_for_dataset(data_set_name, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_set_name: The name of the dataset to query (required)
        :param RawRequest raw_request: The request body DocuSign.API.Lens.Common.RawRequest
        :param str version: The requested API version (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_raw_for_dataset_with_http_info(data_set_name, version, **kwargs)
        else:
            (data) = self.post_raw_for_dataset_with_http_info(data_set_name, version, **kwargs)
            return data

    def post_raw_for_dataset_with_http_info(self, data_set_name, version, **kwargs):
        """
        Provides a raw kusto query capability to internal Docusign services
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_raw_for_dataset_with_http_info(data_set_name, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_set_name: The name of the dataset to query (required)
        :param RawRequest raw_request: The request body DocuSign.API.Lens.Common.RawRequest
        :param str version: The requested API version (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_set_name', 'raw_request', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_raw_for_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_set_name' is set
        if ('data_set_name' not in params) or (params['data_set_name'] is None):
            raise ValueError("Missing the required parameter `data_set_name` when calling `post_raw_for_dataset`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `post_raw_for_dataset`")


        collection_formats = {}

        resource_path = '/api/v{version}/datasets/{dataSetName}/raw'.replace('{format}', 'json')
        path_params = {}
        if 'data_set_name' in params:
            path_params['dataSetName'] = params['data_set_name']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'raw_request' in params:
            body_params = params['raw_request']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)

    def post_web_query_for_dataset(self, data_set_name, version, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_web_query_for_dataset(data_set_name, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_set_name: (required)
        :param WebQuery web_query:
        :param str version: The requested API version (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('callback'):
            return self.post_web_query_for_dataset_with_http_info(data_set_name, version, **kwargs)
        else:
            (data) = self.post_web_query_for_dataset_with_http_info(data_set_name, version, **kwargs)
            return data

    def post_web_query_for_dataset_with_http_info(self, data_set_name, version, **kwargs):
        """
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_web_query_for_dataset_with_http_info(data_set_name, version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str data_set_name: (required)
        :param WebQuery web_query:
        :param str version: The requested API version (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['data_set_name', 'web_query', 'version']
        all_params.append('callback')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_web_query_for_dataset" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'data_set_name' is set
        if ('data_set_name' not in params) or (params['data_set_name'] is None):
            raise ValueError("Missing the required parameter `data_set_name` when calling `post_web_query_for_dataset`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `post_web_query_for_dataset`")


        collection_formats = {}

        resource_path = '/api/v{version}/datasets/{dataSetName}/web_query'.replace('{format}', 'json')
        path_params = {}
        if 'data_set_name' in params:
            path_params['dataSetName'] = params['data_set_name']
        if 'version' in params:
            path_params['version'] = params['version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'web_query' in params:
            body_params = params['web_query']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])

        # Authentication setting
        auth_settings = []

        return self.api_client.call_api(resource_path, 'POST',
                                        path_params,
                                        query_params,
                                        header_params,
                                        body=body_params,
                                        post_params=form_params,
                                        files=local_var_files,
                                        response_type='object',
                                        auth_settings=auth_settings,
                                        callback=params.get('callback'),
                                        _return_http_data_only=params.get('_return_http_data_only'),
                                        _preload_content=params.get('_preload_content', True),
                                        _request_timeout=params.get('_request_timeout'),
                                        collection_formats=collection_formats)
