/**
 * Conditions that can be applied to string attributes.
 *
 * @stability stable
 */
export interface StringConditions {
    /**
     * Match one or more values.
     *
     * @default - None
     * @stability stable
     */
    readonly whitelist?: string[];
    /**
     * Match any value that doesn't include any of the specified values.
     *
     * @default - None
     * @stability stable
     */
    readonly blacklist?: string[];
    /**
     * Matches values that begins with the specified prefixes.
     *
     * @default - None
     * @stability stable
     */
    readonly matchPrefixes?: string[];
}
/**
 * Between condition for a numeric attribute.
 *
 * @stability stable
 */
export interface BetweenCondition {
    /**
     * The start value.
     *
     * @stability stable
     */
    readonly start: number;
    /**
     * The stop value.
     *
     * @stability stable
     */
    readonly stop: number;
}
/**
 * Conditions that can be applied to numeric attributes.
 *
 * @stability stable
 */
export interface NumericConditions {
    /**
     * Match one or more values.
     *
     * @default - None
     * @stability stable
     */
    readonly whitelist?: number[];
    /**
     * Match values that are greater than the specified value.
     *
     * @default - None
     * @stability stable
     */
    readonly greaterThan?: number;
    /**
     * Match values that are greater than or equal to the specified value.
     *
     * @default - None
     * @stability stable
     */
    readonly greaterThanOrEqualTo?: number;
    /**
     * Match values that are less than the specified value.
     *
     * @default - None
     * @stability stable
     */
    readonly lessThan?: number;
    /**
     * Match values that are less than or equal to the specified value.
     *
     * @default - None
     * @stability stable
     */
    readonly lessThanOrEqualTo?: number;
    /**
     * Match values that are between the specified values.
     *
     * @default - None
     * @stability stable
     */
    readonly between?: BetweenCondition;
    /**
     * Match values that are strictly between the specified values.
     *
     * @default - None
     * @stability stable
     */
    readonly betweenStrict?: BetweenCondition;
}
/**
 * A subscription filter for an attribute.
 *
 * @stability stable
 */
export declare class SubscriptionFilter {
    readonly conditions: any[];
    /**
     * Returns a subscription filter for a string attribute.
     *
     * @stability stable
     */
    static stringFilter(stringConditions: StringConditions): SubscriptionFilter;
    /**
     * Returns a subscription filter for a numeric attribute.
     *
     * @stability stable
     */
    static numericFilter(numericConditions: NumericConditions): SubscriptionFilter;
    /**
     * Returns a subscription filter for attribute key matching.
     *
     * @stability stable
     */
    static existsFilter(): SubscriptionFilter;
    /**
     * @param conditions conditions that specify the message attributes that should be included, excluded, matched, etc.
     * @stability stable
     */
    constructor(conditions?: any[]);
}
