#!/usr/bin/env python3
import os
import re
import shutil
import sys
from io import open

from setuptools import find_packages, setup

CURRENT_PYTHON = sys.version_info[:2]
REQUIRED_PYTHON = (3, 6)

if CURRENT_PYTHON < REQUIRED_PYTHON:
    sys.stderr.write("""
==========================
Unsupported Python version
==========================
""".format(*(REQUIRED_PYTHON + CURRENT_PYTHON)))
    sys.exit(1)


def read(f):
    return open(f, 'r', encoding='utf-8').read()


def get_version(package):
    init_py = open(os.path.join(package, '__init__.py')).read()
    return re.search("__version__ = ['\"]([^'\"]+)['\"]", init_py).group(1)


version = get_version('sofa')


if sys.argv[-1] == 'publish':
    shutil.rmtree('dist')
    shutil.rmtree('build')
    shutil.rmtree('django-sofa.egg-info')
    sys.exit()


setup(
    name='django-sofa',
    version=version,
    url='https://github.com/faxioman/django-sofa',
    license='BSD',
    description='When Django pretends to be CouchDB',
    long_description=read('README.md'),
    long_description_content_type='text/markdown',
    author='Faxioman',
    author_email='fabio@rapidosoft.it',
    packages=find_packages(exclude=['tests*']),
    include_package_data=True,
    install_requires=["django>=2.2", "djangorestframework>=3.0"],
    python_requires=">=3.6",
    zip_safe=False,
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: Web Environment',
        'Framework :: Django',
        'Framework :: Django :: 2.2',
        'Framework :: Django :: 3.0',
        'Framework :: Django :: 3.1',
        'Framework :: Django :: 3.2',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3 :: Only',
        'Topic :: Internet :: WWW/HTTP',
    ],
    project_urls={
        'Source': 'https://github.com/faxioman/django-sofa',
    },
)
