"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.handler = void 0;
const path = require("path");
const aws_sdk_1 = require("aws-sdk"); // eslint-disable-line import/no-extraneous-dependencies
const s3 = new aws_sdk_1.S3();
async function handler(assetHashes) {
    var _a;
    if (!process.env.BUCKET_NAME) {
        throw new Error('Missing BUCKET_NAME');
    }
    let deleted = 0;
    let reclaimed = 0;
    let nextToken;
    let finished = false;
    while (!finished) {
        const response = await s3.listObjectsV2({
            Bucket: process.env.BUCKET_NAME,
            ContinuationToken: nextToken,
        }).promise();
        const toDelete = (_a = response.Contents) === null || _a === void 0 ? void 0 : _a.filter(x => {
            let pred = x.Key && !assetHashes.includes(path.basename(x.Key));
            if (process.env.RETAIN_MILLISECONDS) {
                const limitDate = new Date(Date.now() - parseInt(process.env.RETAIN_MILLISECONDS));
                pred = pred && x.LastModified && x.LastModified < limitDate;
            }
            return pred;
        });
        if (toDelete && toDelete.length !== 0) {
            if (process.env.RUN) {
                await s3.deleteObjects({
                    Bucket: process.env.BUCKET_NAME,
                    Delete: {
                        Objects: toDelete.map(x => ({ Key: x.Key })),
                    },
                }).promise();
            }
            deleted += toDelete.length;
            reclaimed += toDelete.reduce((acc, x) => { var _a; return acc + ((_a = x.Size) !== null && _a !== void 0 ? _a : 0); }, 0);
        }
        nextToken = response.NextContinuationToken;
        if (nextToken === undefined) {
            finished = true;
        }
    }
    return {
        Deleted: deleted,
        Reclaimed: reclaimed,
    };
}
exports.handler = handler;
//# sourceMappingURL=data:application/json;base64,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