import { IConstruct } from 'constructs';
/**
 * Properties for a Slack app manifest.
 *
 * @see https://api.slack.com/reference/manifests
 * @stability stable
 */
export interface SlackAppManifestProps {
    /**
     * The name of the app.
     *
     * Maximum length is 35 characters.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * A short description of the app for display to users.
     *
     * Maximum length is 140 characters.
     *
     * @default - no short description
     * @stability stable
     */
    readonly description?: string;
    /**
     * A longer version of the description of the app.
     *
     * Maximum length is 4000 characters.
     *
     * @stability stable
     */
    readonly longDescription?: string;
    /**
     * A hex color value that specifies the background color used on hovercards that display information about your app.
     *
     * Can be 3-digit (#000) or 6-digit (#000000) hex values with or without #
     *
     * @stability stable
     */
    readonly backgroundColor?: string;
    /**
     * The major version of the manifest schema to target.
     *
     * @default - do not target a specific major version
     * @stability stable
     */
    readonly majorVersion?: number;
    /**
     * The minor version of the manifest schema to target.
     *
     * @default - do not target a specific minor version
     * @stability stable
     */
    readonly minorVersion?: number;
    /**
     * An array of IP addresses that conform to the Allowed IP Ranges feature.
     *
     * @see https://api.slack.com/authentication/best-practices#ip_allowlisting
     * @stability stable
     */
    readonly allowedIpAddressRanges?: string[];
    /**
     * Events API configuration for the app.
     *
     * @see https://api.slack.com/events-api
     * @stability stable
     */
    readonly eventSubscriptions?: SlackAppManifestEventSubscriptions;
    /**
     * Interactivity configuration for the app.
     *
     * @stability stable
     */
    readonly interactivity?: SlackAppManifestInteractivity;
    /**
     * Whether org-wide deploy is enabled.
     *
     * @default false
     * @see https://api.slack.com/enterprise/apps
     * @stability stable
     */
    readonly orgDeploy?: boolean;
    /**
     * Whether Socket Mode is enabled.
     *
     * @default false
     * @see https://api.slack.com/apis/connections/socket
     * @stability stable
     */
    readonly socketMode?: boolean;
    /**
     * App Home configuration.
     *
     * @see https://api.slack.com/surfaces/tabs
     * @stability stable
     */
    readonly appHome?: SlackAppManifestAppHome;
    /**
     * Bot user configuration.
     *
     * @see https://api.slack.com/bot-users
     * @stability stable
     */
    readonly botUser?: SlackkAppManifestBotUser;
    /**
     * Shortcuts configuration.
     *
     * A maximum of 5 shortcuts can be included.
     *
     * @see https://api.slack.com/interactivity/shortcuts
     * @stability stable
     */
    readonly shortcuts?: SlackAppManifestShortcut[];
    /**
     * Slash commands configuration.
     *
     * A maximum of 5 slash commands can be included.
     *
     * @see https://api.slack.com/interactivity/slash-commands
     * @stability stable
     */
    readonly slashCommands?: SlackAppManifestSlashCommand[];
    /**
     * Workflow steps.
     *
     * A maximum of 10 workflow steps can be included.
     *
     * @see https://api.slack.com/workflows/steps
     * @stability stable
     */
    readonly workflowSteps?: SlackAppManifestWorkflowStep[];
    /**
     * Valid unfurl domains to register.
     *
     * A maximum of 5 unfurl domains can be included.
     *
     * @see https://api.slack.com/reference/messaging/link-unfurling#configuring_domains
     * @stability stable
     */
    readonly unfurlDomains?: string[];
    /**
     * OAuth configuration for the app.
     *
     * @stability stable
     */
    readonly oauthConfig?: SlackAppManifestOauthConfig;
}
/**
 * Settings section of the app config pages.
 *
 * @stability stable
 */
export interface SlackAppManifestSettings {
    /**
     * An array of IP addresses that conform to the Allowed IP Ranges feature.
     *
     * @see https://api.slack.com/authentication/best-practices#ip_allowlisting
     * @stability stable
     */
    readonly allowedIpAddressRanges?: string[];
    /**
     * Events API configuration for the app.
     *
     * @see https://api.slack.com/events-api
     * @stability stable
     */
    readonly eventSubscriptions?: SlackAppManifestEventSubscriptions;
    /**
     * Interactivity configuration for the app.
     *
     * @stability stable
     */
    readonly interactivity?: SlackAppManifestInteractivity;
    /**
     * Whether org-wide deploy is enabled.
     *
     * @default false
     * @see https://api.slack.com/enterprise/apps
     * @stability stable
     */
    readonly orgDeploy?: boolean;
    /**
     * Whether Socket Mode is enabled.
     *
     * @default false
     * @see https://api.slack.com/apis/connections/socket
     * @stability stable
     */
    readonly socketMode?: boolean;
}
/**
 * Events API configuration for the app.
 *
 * @see https://api.slack.com/events-api
 * @stability stable
 */
export interface SlackAppManifestEventSubscriptions {
    /**
     * The full https URL that acts as the Events API request URL.
     *
     * @see https://api.slack.com/events-api#the-events-api__subscribing-to-event-types__events-api-request-urls
     * @stability stable
     */
    readonly requestUrl: string;
    /**
     * Event types you want the app to subscribe to.
     *
     * A maximum of 100 event types can be used
     *
     * @see https://api.slack.com/events
     * @stability stable
     */
    readonly botEvents?: string[];
    /**
     * Event types you want the app to subscribe to on behalf of authorized users.
     *
     * A maximum of 100 event types can be used.
     *
     * @stability stable
     */
    readonly userEvents?: string[];
}
/**
 * Interactivity configuration for the app.
 *
 * @see https://api.slack.com/interactivity/handling#setup
 * @stability stable
 */
export interface SlackAppManifestInteractivity {
    /**
     * Whether or not interactivity features are enabled.
     *
     * @default true
     * @stability stable
     */
    readonly enabled?: boolean;
    /**
     * The full https URL that acts as the interactive Request URL.
     *
     * @stability stable
     */
    readonly requestUrl?: string;
    /**
     * The full https URL that acts as th interactive Options Load URL.
     *
     * @stability stable
     */
    readonly messageMenuOptionsUrl?: string;
}
/**
 * App Home configuration.
 *
 * @see https://api.slack.com/surfaces/tabs
 * @stability stable
 */
export interface SlackAppManifestAppHome {
    /**
     * Wether the Home tab is enabled.
     *
     * @default false
     * @stability stable
     */
    readonly homeTab?: boolean;
    /**
     * Wether the Messages is enabled.
     *
     * @default false
     * @stability stable
     */
    readonly messagesTab?: boolean;
    /**
     * Whether the users can send messages to your app in the Messages tab of your App Home.
     *
     * @default false
     * @stability stable
     */
    readonly messagesTabReadOnly?: boolean;
}
/**
 * Bot user configuration.
 *
 * @see https://api.slack.com/bot-users
 * @stability stable
 */
export interface SlackkAppManifestBotUser {
    /**
     * The display name of the bot user.
     *
     * Maximum length is 80 characters.
     *
     * @stability stable
     */
    readonly displayName: string;
    /**
     * Whether the bot user will always appear to be online.
     *
     * @default false
     * @stability stable
     */
    readonly alwaysOnline?: boolean;
}
/**
 * Shortcut configuration.
 *
 * @see https://api.slack.com/interactivity/shortcuts
 * @stability stable
 */
export interface SlackAppManifestShortcut {
    /**
     * The name of the shortcut.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The type of shortcut.
     *
     * @see https://api.slack.com/interactivity/shortcuts
     * @stability stable
     */
    readonly type: SlackAppManifestShortcutType;
    /**
     * The callback ID of the shortcut.
     *
     * Maximum length is 255 characters.
     *
     * @stability stable
     */
    readonly callbackId: string;
    /**
     * A short description of the shortcut.
     *
     * Maximum length is 150 characters
     *
     * @stability stable
     */
    readonly description: string;
}
/**
 * Type of shortcuts.
 *
 * @see https://api.slack.com/interactivity/shortcuts
 * @stability stable
 */
export declare enum SlackAppManifestShortcutType {
    /**
     * Message shortcuts are shown to users in the context menus of messages within Slack.
     *
     * @see https://api.slack.com/interactivity/shortcuts/using#message_shortcuts
     * @stability stable
     */
    MESSAGE = "message",
    /**
     * Global shortcuts are available to users via the shortcuts button in the composer, and when using search in Slack.
     *
     * @see https://api.slack.com/interactivity/shortcuts/using#global_shortcuts
     * @stability stable
     */
    GLOBAL = "global"
}
/**
 * Slash command configuration.
 *
 * @see https://api.slack.com/interactivity/slash-commands
 * @stability stable
 */
export interface SlackAppManifestSlashCommand {
    /**
     * The actual slash command.
     *
     * Maximum length is 32 characters
     *
     * @stability stable
     */
    readonly command: string;
    /**
     * The description of the slash command.
     *
     * Maximum length is 2000 characters.
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * The full https URL that acts as the slash command's request URL.
     *
     * @see https://api.slack.com/interactivity/slash-commands#creating_commands
     * @stability stable
     */
    readonly url?: string;
    /**
     * The short usage hint about the slash command for users.
     *
     * Maximum length is 1000 characters.
     *
     * @stability stable
     */
    readonly usageHint?: string;
    /**
     * Whether channels, users, and links typed with the slash command should be escaped.
     *
     * @default false
     * @stability stable
     */
    readonly shouldEscape?: boolean;
}
/**
 * Workflow step.
 *
 * @see https://api.slack.com/workflows/steps
 * @stability stable
 */
export interface SlackAppManifestWorkflowStep {
    /**
     * The name of the workflow step.
     *
     * Maximum length of 50 characters.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The callback ID of the workflow step.
     *
     * Maximum length of 50 characters.
     *
     * @stability stable
     */
    readonly callbackId: string;
}
/**
 * OAuth configuration for the app.
 *
 * @stability stable
 */
export interface SlackAppManifestOauthConfig {
    /**
     * OAuth redirect URLs.
     *
     * A maximum of 1000 redirect URLs can be included.
     *
     * @see https://api.slack.com/authentication/oauth-v2#redirect_urls
     * @stability stable
     */
    readonly redirectUrls?: string[];
    /**
     * Bot scopes to request upon app installation.
     *
     * A maximum of 255 scopes can be included.
     *
     * @see https://api.slack.com/scopes
     * @stability stable
     */
    readonly botScopes?: string[];
    /**
     * User scopes to request upon app installation.
     *
     * A maximum of 255 scopes can be included.
     *
     * @see https://api.slack.com/scopes
     * @stability stable
     */
    readonly userScopes?: string[];
}
/**
 * A Slack app manifest.
 *
 * @see https://api.slack.com/reference/manifests
 * @stability stable
 */
export declare class SlackAppManifest {
    private readonly props;
    /**
     * @stability stable
     */
    constructor(props: SlackAppManifestProps);
    /**
     * @stability stable
     */
    render(construct: IConstruct): string;
}
