var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __markAsModule = (target) => __defProp(target, "__esModule", { value: true });
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __reExport = (target, module2, copyDefault, desc) => {
  if (module2 && typeof module2 === "object" || typeof module2 === "function") {
    for (let key of __getOwnPropNames(module2))
      if (!__hasOwnProp.call(target, key) && (copyDefault || key !== "default"))
        __defProp(target, key, { get: () => module2[key], enumerable: !(desc = __getOwnPropDesc(module2, key)) || desc.enumerable });
  }
  return target;
};
var __toESM = (module2, isNodeMode) => {
  return __reExport(__markAsModule(__defProp(module2 != null ? __create(__getProtoOf(module2)) : {}, "default", !isNodeMode && module2 && module2.__esModule ? { get: () => module2.default, enumerable: true } : { value: module2, enumerable: true })), module2);
};
var __toCommonJS = /* @__PURE__ */ ((cache) => {
  return (module2, temp) => {
    return cache && cache.get(module2) || (temp = __reExport(__markAsModule({}), module2, 1), cache && cache.set(module2, temp), temp);
  };
})(typeof WeakMap !== "undefined" ? /* @__PURE__ */ new WeakMap() : 0);

// src/slack-events/events.lambda.ts
var events_lambda_exports = {};
__export(events_lambda_exports, {
  handler: () => handler
});
var import_aws_sdk = require("aws-sdk");

// src/slack-events/signature.ts
var crypto = __toESM(require("crypto"));
function verifyRequestSignature(options) {
  const fiveMinutesAgo = Math.floor(Date.now() / 1e3) - 60 * 5;
  if (options.requestTimestamp < fiveMinutesAgo) {
    console.error("Slack request signing verification outdated");
    return false;
  }
  const hmac = crypto.createHmac("sha256", options.signingSecret);
  const [version, hash] = options.requestSignature.split("=");
  hmac.update(`${version}:${options.requestTimestamp}:${options.body}`);
  const hex = hmac.digest("hex");
  if (hash.length !== hex.length || !crypto.timingSafeEqual(Buffer.from(hash), Buffer.from(hex))) {
    console.error("Slack request signing verification failed");
    return false;
  }
  return true;
}

// src/slack-events/events.lambda.ts
async function handler(event) {
  console.log("Event: %j", event);
  const response = {
    statusCode: 200,
    body: ""
  };
  try {
    if (!process.env.SLACK_SIGNING_SECRET)
      throw new Error("The environment variable SLACK_SIGNING_SECRET is not defined");
    if (!event.body)
      throw new Error("Missing body");
    if (!event.headers["X-Slack-Signature"])
      throw new Error("Missing X-Slack-Signature");
    if (!event.headers["X-Slack-Request-Timestamp"])
      throw new Error("Missing X-Slack-Request-Timestamp");
    if (!verifyRequestSignature({
      body: event.body,
      requestSignature: event.headers["X-Slack-Signature"],
      requestTimestamp: parseInt(event.headers["X-Slack-Request-Timestamp"], 10),
      signingSecret: process.env.SLACK_SIGNING_SECRET
    })) {
      response.statusCode = 403;
      return response;
    }
    const body = JSON.parse(event.body);
    console.log("Body: %j", body);
    if (body.type === "url_verification") {
      console.log("URL verification");
      response.body = JSON.stringify({ challenge: body.challenge });
      return response;
    }
    const eventBridge = new import_aws_sdk.EventBridge({ apiVersion: "2015-10-07" });
    const putEvents = await eventBridge.putEvents({
      Entries: [
        {
          Detail: event.body,
          DetailType: "Slack Event",
          Source: "slack",
          Resources: [body.api_app_id],
          EventBusName: process.env.EVENT_BUS_NAME,
          Time: new Date(body.event_time)
        }
      ]
    }).promise();
    console.log("Put events: %j", putEvents);
    return response;
  } catch (err) {
    console.log(err);
    response.statusCode = 500;
    return response;
  }
}
module.exports = __toCommonJS(events_lambda_exports);
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  handler
});
