# coding: utf-8

"""
    Intrinio API

    Welcome to the Intrinio API! Through our Financial Data Marketplace, we offer a wide selection of financial data feed APIs sourced by our own proprietary processes as well as from many data vendors. For a complete API request / response reference please view the [Intrinio API documentation](https://intrinio.com/documentation/api_v2). If you need additional help in using the API, please visit the [Intrinio website](https://intrinio.com) and click on the chat icon in the lower right corner.  # noqa: E501

    OpenAPI spec version: 2.18.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from intrinio_sdk.api_client import ApiClient


class CompanyApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_all_companies(self, **kwargs):  # noqa: E501
        """All Companies  # noqa: E501

        Returns all Companies. When parameters are specified, returns matching companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_companies(_async=True)
        >>> result = thread.get()

        :param async bool
        :param date latest_filing_date: Return companies whose latest 10-Q or 10-K was filed on or after this date
        :param str sic: Return companies with the given Standard Industrial Classification code
        :param str template: Return companies with the given financial statement template
        :param str sector: Return companies in the given industry sector
        :param str industry_category: Return companies in the given industry category
        :param str industry_group: Return companies in the given industry group
        :param bool has_fundamentals: Return only companies that have fundamentals when true
        :param bool has_stock_prices: Return only companies that have stock prices when true
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanies
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_all_companies_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_companies_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_companies_with_http_info(self, **kwargs):  # noqa: E501
        """All Companies  # noqa: E501

        Returns all Companies. When parameters are specified, returns matching companies.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_companies_with_http_info(_async=True)
        >>> result = thread.get()

        :param async bool
        :param date latest_filing_date: Return companies whose latest 10-Q or 10-K was filed on or after this date
        :param str sic: Return companies with the given Standard Industrial Classification code
        :param str template: Return companies with the given financial statement template
        :param str sector: Return companies in the given industry sector
        :param str industry_category: Return companies in the given industry category
        :param str industry_group: Return companies in the given industry group
        :param bool has_fundamentals: Return only companies that have fundamentals when true
        :param bool has_stock_prices: Return only companies that have stock prices when true
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanies
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['latest_filing_date', 'sic', 'template', 'sector', 'industry_category', 'industry_group', 'has_fundamentals', 'has_stock_prices', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_companies" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_all_companies`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'latest_filing_date' in params:
            query_params.append(('latest_filing_date', params['latest_filing_date']))  # noqa: E501
        if 'sic' in params:
            query_params.append(('sic', params['sic']))  # noqa: E501
        if 'template' in params:
            query_params.append(('template', params['template']))  # noqa: E501
        if 'sector' in params:
            query_params.append(('sector', params['sector']))  # noqa: E501
        if 'industry_category' in params:
            query_params.append(('industry_category', params['industry_category']))  # noqa: E501
        if 'industry_group' in params:
            query_params.append(('industry_group', params['industry_group']))  # noqa: E501
        if 'has_fundamentals' in params:
            query_params.append(('has_fundamentals', params['has_fundamentals']))  # noqa: E501
        if 'has_stock_prices' in params:
            query_params.append(('has_stock_prices', params['has_stock_prices']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseCompanies',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_all_company_news(self, **kwargs):  # noqa: E501
        """All News  # noqa: E501

        Returns all News for all Companies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_company_news(_async=True)
        >>> result = thread.get()

        :param async bool
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseNews
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_all_company_news_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_all_company_news_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_all_company_news_with_http_info(self, **kwargs):  # noqa: E501
        """All News  # noqa: E501

        Returns all News for all Companies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_all_company_news_with_http_info(_async=True)
        >>> result = thread.get()

        :param async bool
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseNews
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_all_company_news" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_all_company_news`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/news', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseNews',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_company(self, identifier, **kwargs):  # noqa: E501
        """Lookup Company  # noqa: E501

        Returns the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :return: Company
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_company_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_company_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_company_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """Lookup Company  # noqa: E501

        Returns the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :return: Company
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_company" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_company`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/{identifier}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Company',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_company_data_point_number(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for Company  # noqa: E501

        Returns a numeric value for the given `tag` for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_data_point_number(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_company_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_company_data_point_number_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_company_data_point_number_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Number) for Company  # noqa: E501

        Returns a numeric value for the given `tag` for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_data_point_number_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :return: float
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_company_data_point_number" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_company_data_point_number`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_company_data_point_number`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/{identifier}/data_point/{tag}/number', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='float',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_company_data_point_text(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for Company  # noqa: E501

        Returns a text value for the given `tag` for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_data_point_text(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_company_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_company_data_point_text_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_company_data_point_text_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Data Point (Text) for Company  # noqa: E501

        Returns a text value for the given `tag` for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_data_point_text_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_company_data_point_text" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_company_data_point_text`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_company_data_point_text`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain; charset=utf-8'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/{identifier}/data_point/{tag}/text', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_company_filings(self, identifier, **kwargs):  # noqa: E501
        """All Filings by Company  # noqa: E501

        Returns a complete list of SEC filings for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_filings(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str report_type: Filter by <a href=\"https://docs.intrinio.com/documentation/sec_filing_report_types\" target=\"_blank\">report type</a>. Separate values with commas to return multiple report types.
        :param date start_date: Filed on or after the given date
        :param date end_date: Filed before or after the given date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanyFilings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_company_filings_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_company_filings_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_company_filings_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """All Filings by Company  # noqa: E501

        Returns a complete list of SEC filings for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_filings_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str report_type: Filter by <a href=\"https://docs.intrinio.com/documentation/sec_filing_report_types\" target=\"_blank\">report type</a>. Separate values with commas to return multiple report types.
        :param date start_date: Filed on or after the given date
        :param date end_date: Filed before or after the given date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanyFilings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'report_type', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_company_filings" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_company_filings`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_company_filings`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'report_type' in params:
            query_params.append(('report_type', params['report_type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/{identifier}/filings', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseCompanyFilings',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_company_fundamentals(self, identifier, **kwargs):  # noqa: E501
        """All Fundamentals by Company  # noqa: E501

        Returns all Fundamentals for the Company with the given `identifier`. Returns Fundamentals matching parameters when supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_fundamentals(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param date filed_after: Filed on or after this date
        :param date filed_before: Filed on or before this date
        :param bool reported_only: Only as-reported fundamentals
        :param int fiscal_year: Only for the given fiscal year
        :param str statement_code: Only of the given statement code
        :param str type: Only of the given type
        :param date start_date: Only on or after the given date
        :param date end_date: Only on or before the given date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanyFundamentals
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_company_fundamentals_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_company_fundamentals_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_company_fundamentals_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """All Fundamentals by Company  # noqa: E501

        Returns all Fundamentals for the Company with the given `identifier`. Returns Fundamentals matching parameters when supplied.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_fundamentals_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param date filed_after: Filed on or after this date
        :param date filed_before: Filed on or before this date
        :param bool reported_only: Only as-reported fundamentals
        :param int fiscal_year: Only for the given fiscal year
        :param str statement_code: Only of the given statement code
        :param str type: Only of the given type
        :param date start_date: Only on or after the given date
        :param date end_date: Only on or before the given date
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanyFundamentals
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'filed_after', 'filed_before', 'reported_only', 'fiscal_year', 'statement_code', 'type', 'start_date', 'end_date', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_company_fundamentals" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_company_fundamentals`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_company_fundamentals`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'filed_after' in params:
            query_params.append(('filed_after', params['filed_after']))  # noqa: E501
        if 'filed_before' in params:
            query_params.append(('filed_before', params['filed_before']))  # noqa: E501
        if 'reported_only' in params:
            query_params.append(('reported_only', params['reported_only']))  # noqa: E501
        if 'fiscal_year' in params:
            query_params.append(('fiscal_year', params['fiscal_year']))  # noqa: E501
        if 'statement_code' in params:
            query_params.append(('statement_code', params['statement_code']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/{identifier}/fundamentals', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseCompanyFundamentals',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_company_historical_data(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for Company  # noqa: E501

        Returns historical values for the given `tag` and the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_historical_data(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :param str frequency: Return historical data in the given frequency
        :param str type: Return historical data for given fiscal period type
        :param date start_date: Return historical data on or after this date
        :param date end_date: Return historical data on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanyHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_company_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.get_company_historical_data_with_http_info(identifier, tag, **kwargs)  # noqa: E501
            return data

    def get_company_historical_data_with_http_info(self, identifier, tag, **kwargs):  # noqa: E501
        """Historical Data for Company  # noqa: E501

        Returns historical values for the given `tag` and the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_historical_data_with_http_info(identifier, tag, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str tag: An Intrinio data tag ID or code (<a href='https://data.intrinio.com/data-tags'>reference</a>) (required)
        :param str frequency: Return historical data in the given frequency
        :param str type: Return historical data for given fiscal period type
        :param date start_date: Return historical data on or after this date
        :param date end_date: Return historical data on or before this date
        :param str sort_order: Sort by date `asc` or `desc`
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanyHistoricalData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'tag', 'frequency', 'type', 'start_date', 'end_date', 'sort_order', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_company_historical_data" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_company_historical_data`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `get_company_historical_data`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_company_historical_data`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'tag' in params:
            path_params['tag'] = params['tag']  # noqa: E501

        query_params = []
        if 'frequency' in params:
            query_params.append(('frequency', params['frequency']))  # noqa: E501
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'sort_order' in params:
            query_params.append(('sort_order', params['sort_order']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/{identifier}/historical_data/{tag}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseCompanyHistoricalData',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_company_ipos(self, **kwargs):  # noqa: E501
        """IPOs  # noqa: E501

        Returns initial public offerings (IPOs). An IPO is a public offering of private company stock. The act of \"going public\" is initiated by an IPO, at which point the company's stock trades on a major stock exchange (such as NYSE or NASDAQ). Intrinio covers all upcoming and recent IPOs for US exchanges.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_ipos(_async=True)
        >>> result = thread.get()

        :param async bool
        :param str ticker: Return IPOs with the given ticker (typically the IPO for the company)
        :param str status: Return IPOs with the given status. Upcoming IPOs are scheduled to occur in the future. Priced IPOs have occured and the company should be trading publicly. Withdrawn IPOs were planned to occurr but were withdrawn beforehand
        :param date start_date: Return IPOs on or after the given date
        :param date end_date: Return IPOs on or before the given date
        :param int offer_amount_greater_than: Return IPOs with an offer dollar amount greater than the given amount
        :param int offer_amount_less_than: Return IPOs with an offer dollar amount less than the given amount
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseInitialPublicOfferings
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_company_ipos_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_company_ipos_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_company_ipos_with_http_info(self, **kwargs):  # noqa: E501
        """IPOs  # noqa: E501

        Returns initial public offerings (IPOs). An IPO is a public offering of private company stock. The act of \"going public\" is initiated by an IPO, at which point the company's stock trades on a major stock exchange (such as NYSE or NASDAQ). Intrinio covers all upcoming and recent IPOs for US exchanges.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_ipos_with_http_info(_async=True)
        >>> result = thread.get()

        :param async bool
        :param str ticker: Return IPOs with the given ticker (typically the IPO for the company)
        :param str status: Return IPOs with the given status. Upcoming IPOs are scheduled to occur in the future. Priced IPOs have occured and the company should be trading publicly. Withdrawn IPOs were planned to occurr but were withdrawn beforehand
        :param date start_date: Return IPOs on or after the given date
        :param date end_date: Return IPOs on or before the given date
        :param int offer_amount_greater_than: Return IPOs with an offer dollar amount greater than the given amount
        :param int offer_amount_less_than: Return IPOs with an offer dollar amount less than the given amount
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseInitialPublicOfferings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ticker', 'status', 'start_date', 'end_date', 'offer_amount_greater_than', 'offer_amount_less_than', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_company_ipos" % key
                )
            params[key] = val
        del params['kwargs']

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_company_ipos`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'ticker' in params:
            query_params.append(('ticker', params['ticker']))  # noqa: E501
        if 'status' in params:
            query_params.append(('status', params['status']))  # noqa: E501
        if 'start_date' in params:
            query_params.append(('start_date', params['start_date']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'offer_amount_greater_than' in params:
            query_params.append(('offer_amount_greater_than', params['offer_amount_greater_than']))  # noqa: E501
        if 'offer_amount_less_than' in params:
            query_params.append(('offer_amount_less_than', params['offer_amount_less_than']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/ipos', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseInitialPublicOfferings',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_company_news(self, identifier, **kwargs):  # noqa: E501
        """All News by Company  # noqa: E501

        Returns news for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_news(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanyNews
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_company_news_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_company_news_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_company_news_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """All News by Company  # noqa: E501

        Returns news for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_news_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param int page_size: The number of results to return
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanyNews
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'page_size', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_company_news" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_company_news`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_company_news`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/{identifier}/news', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseCompanyNews',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_company_securities(self, identifier, **kwargs):  # noqa: E501
        """All Securities by Company  # noqa: E501

        Returns Securities for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_securities(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanySecurities
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_company_securities_with_http_info(identifier, **kwargs)  # noqa: E501
        else:
            (data) = self.get_company_securities_with_http_info(identifier, **kwargs)  # noqa: E501
            return data

    def get_company_securities_with_http_info(self, identifier, **kwargs):  # noqa: E501
        """All Securities by Company  # noqa: E501

        Returns Securities for the Company with the given `identifier`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_company_securities_with_http_info(identifier, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str next_page: Gets the next page of data from a previous API call
        :return: ApiResponseCompanySecurities
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'next_page']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_company_securities" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `get_company_securities`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501

        query_params = []
        if 'next_page' in params:
            query_params.append(('next_page', params['next_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/{identifier}/securities', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseCompanySecurities',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def lookup_company_fundamental(self, identifier, statement_code, fiscal_period, fiscal_year, **kwargs):  # noqa: E501
        """Lookup Fundamental by Company  # noqa: E501

        Returns the Fundamental for the Company with the given `identifier` and with the given parameters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.lookup_company_fundamental(identifier, statement_code, fiscal_period, fiscal_year, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str statement_code: The statement code (required)
        :param str fiscal_period: The fiscal period (required)
        :param int fiscal_year: The fiscal year (required)
        :return: Fundamental
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.lookup_company_fundamental_with_http_info(identifier, statement_code, fiscal_period, fiscal_year, **kwargs)  # noqa: E501
        else:
            (data) = self.lookup_company_fundamental_with_http_info(identifier, statement_code, fiscal_period, fiscal_year, **kwargs)  # noqa: E501
            return data

    def lookup_company_fundamental_with_http_info(self, identifier, statement_code, fiscal_period, fiscal_year, **kwargs):  # noqa: E501
        """Lookup Fundamental by Company  # noqa: E501

        Returns the Fundamental for the Company with the given `identifier` and with the given parameters  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.lookup_company_fundamental_with_http_info(identifier, statement_code, fiscal_period, fiscal_year, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str identifier: A Company identifier (Ticker, CIK, LEI, Intrinio ID) (required)
        :param str statement_code: The statement code (required)
        :param str fiscal_period: The fiscal period (required)
        :param int fiscal_year: The fiscal year (required)
        :return: Fundamental
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['identifier', 'statement_code', 'fiscal_period', 'fiscal_year']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method lookup_company_fundamental" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'identifier' is set
        if ('identifier' not in params or
                params['identifier'] is None):
            raise ValueError("Missing the required parameter `identifier` when calling `lookup_company_fundamental`")  # noqa: E501
        # verify the required parameter 'statement_code' is set
        if ('statement_code' not in params or
                params['statement_code'] is None):
            raise ValueError("Missing the required parameter `statement_code` when calling `lookup_company_fundamental`")  # noqa: E501
        # verify the required parameter 'fiscal_period' is set
        if ('fiscal_period' not in params or
                params['fiscal_period'] is None):
            raise ValueError("Missing the required parameter `fiscal_period` when calling `lookup_company_fundamental`")  # noqa: E501
        # verify the required parameter 'fiscal_year' is set
        if ('fiscal_year' not in params or
                params['fiscal_year'] is None):
            raise ValueError("Missing the required parameter `fiscal_year` when calling `lookup_company_fundamental`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'identifier' in params:
            path_params['identifier'] = params['identifier']  # noqa: E501
        if 'statement_code' in params:
            path_params['statement_code'] = params['statement_code']  # noqa: E501
        if 'fiscal_period' in params:
            path_params['fiscal_period'] = params['fiscal_period']  # noqa: E501
        if 'fiscal_year' in params:
            path_params['fiscal_year'] = params['fiscal_year']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/{identifier}/fundamentals/lookup/{statement_code}/{fiscal_year}/{fiscal_period}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Fundamental',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def search_companies(self, query, **kwargs):  # noqa: E501
        """Search Companies  # noqa: E501

        Searches for Companies matching the text `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_companies(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: Search parameters (required)
        :param bool active: When true, return companies that are actively traded (having stock prices within the past 14 days). When false, return companies that are not actively traded or never have been traded.
        :param int page_size: The number of results to return
        :return: ApiResponseCompaniesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.search_companies_with_http_info(query, **kwargs)  # noqa: E501
        else:
            (data) = self.search_companies_with_http_info(query, **kwargs)  # noqa: E501
            return data

    def search_companies_with_http_info(self, query, **kwargs):  # noqa: E501
        """Search Companies  # noqa: E501

        Searches for Companies matching the text `query`  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.search_companies_with_http_info(query, _async=True)
        >>> result = thread.get()

        :param async bool
        :param str query: Search parameters (required)
        :param bool active: When true, return companies that are actively traded (having stock prices within the past 14 days). When false, return companies that are not actively traded or never have been traded.
        :param int page_size: The number of results to return
        :return: ApiResponseCompaniesSearch
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['query', 'active', 'page_size']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method search_companies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'query' is set
        if ('query' not in params or
                params['query'] is None):
            raise ValueError("Missing the required parameter `query` when calling `search_companies`")  # noqa: E501

        if 'page_size' in params and params['page_size'] > 10000:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `search_companies`, must be a value less than or equal to `10000`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'query' in params:
            query_params.append(('query', params['query']))  # noqa: E501
        if 'active' in params:
            query_params.append(('active', params['active']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyAuth']  # noqa: E501

        return self.api_client.call_api(
            '/companies/search', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ApiResponseCompaniesSearch',  # noqa: E501
            auth_settings=auth_settings,
            _async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
