"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToKinesisFirehose = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const constructs_1 = require("constructs");
const defaults = require("@aws-solutions-constructs/core");
const iam = require("aws-cdk-lib/aws-iam");
class FargateToKinesisFirehose extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        if (!props.existingKinesisFirehose.deliveryStreamName) {
            throw new Error('existingKinesisFirehose must have a defined deliveryStreamName');
        }
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.KINESIS_FIREHOSE);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        this.kinesisFirehose = props.existingKinesisFirehose;
        const taskPolicyStatement = new iam.PolicyStatement({
            actions: [
                "firehose:DeleteDeliveryStream",
                "firehose:PutRecord",
                "firehose:PutRecordBatch",
                "firehose:UpdateDestination"
            ],
            resources: [this.kinesisFirehose.attrArn],
        });
        this.service.taskDefinition.taskRole.addToPrincipalPolicy(taskPolicyStatement);
        // Configure environment variables
        const deliveryStreamEnvironmentVariableName = props.firehoseEnvironmentVariableName || 'FIREHOSE_DELIVERYSTREAM_NAME';
        // We can use ! because we checked for a stream name on props.existingKinesisFirehose at the top of this function
        this.container.addEnvironment(deliveryStreamEnvironmentVariableName, this.kinesisFirehose.deliveryStreamName);
    }
}
exports.FargateToKinesisFirehose = FargateToKinesisFirehose;
_a = JSII_RTTI_SYMBOL_1;
FargateToKinesisFirehose[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-kinesisfirehose.FargateToKinesisFirehose", version: "2.32.0" };
//# sourceMappingURL=data:application/json;base64,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