# -*- coding: utf-8 -*-
"""edaPRO.ipynb

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1UlZGLoGxe3Jf2doFJ34Qs6G7VTevX6YF
"""

import pandas as pd
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
from iris import iris

import pandas as pd
iris = pd.read_csv('iris.csv', names=['sepal_length', 'sepal_width', 'petal_length', 'petal_width', 'class'])

iris.describe()

data=iris.drop(['class'], axis = 1)

sns.boxplot(x='sepal_length',y='sepal_width',data=data)

plt.figure(figsize=(15,5))
sns.violinplot(x='sepal_length',y='sepal_width',data=data)
plt.show()

sns.scatterplot(data['sepal_length'],data['petal_length'])
plt.show()

sns.heatmap(data.isnull())
plt.show()

plt.figure(figsize=(15,7))
corr_matrix = data.corr()
mask = np.zeros_like(corr_matrix)
mask[np.triu_indices_from(mask)] = True
with sns.axes_style("white"):
    sns.heatmap(corr_matrix, mask=mask, square=True)

plt.figure(figsize=(10,5))
sns.displot(data['sepal_length'])
plt.show()


