"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FileSystem = exports.FileSystemProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const nas_generated_1 = require("./nas.generated");
Object.defineProperty(exports, "FileSystemProperty", { enumerable: true, get: function () { return nas_generated_1.RosFileSystem; } });
/**
 * A ROS resource type:  `ALIYUN::NAS::FileSystem`
 */
class FileSystem extends ros.Resource {
    /**
     * Create a new `ALIYUN::NAS::FileSystem`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosFileSystem = new nas_generated_1.RosFileSystem(this, id, {
            description: props.description,
            storageType: props.storageType,
            zoneId: props.zoneId,
            vSwitchId: props.vSwitchId,
            duration: props.duration,
            snapshotId: props.snapshotId,
            deletionForce: props.deletionForce ? props.deletionForce : false,
            encryptType: props.encryptType,
            vpcId: props.vpcId,
            capacity: props.capacity,
            protocolType: props.protocolType,
            chargeType: props.chargeType,
            fileSystemType: props.fileSystemType,
            bandwidth: props.bandwidth,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosFileSystem;
        this.attrFileSystemId = rosFileSystem.attrFileSystemId;
    }
}
exports.FileSystem = FileSystem;
//# sourceMappingURL=data:application/json;base64,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