"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessRule = exports.AccessRuleProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const nas_generated_1 = require("./nas.generated");
Object.defineProperty(exports, "AccessRuleProperty", { enumerable: true, get: function () { return nas_generated_1.RosAccessRule; } });
/**
 * A ROS resource type:  `ALIYUN::NAS::AccessRule`
 */
class AccessRule extends ros.Resource {
    /**
     * Create a new `ALIYUN::NAS::AccessRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccessRule = new nas_generated_1.RosAccessRule(this, id, {
            userAccessType: props.userAccessType ? props.userAccessType : 'no_squash',
            priority: props.priority ? props.priority : 1,
            accessGroupName: props.accessGroupName,
            sourceCidrIp: props.sourceCidrIp,
            rwAccessType: props.rwAccessType ? props.rwAccessType : 'RDWR',
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccessRule;
        this.attrAccessRuleId = rosAccessRule.attrAccessRuleId;
    }
}
exports.AccessRule = AccessRule;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWNjZXNzcnVsZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFjY2Vzc3J1bGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsOENBQThDO0FBQzlDLG1EQUFnRDtBQUV0QixtR0FGakIsNkJBQWEsT0FFc0I7QUFpQzVDOztHQUVHO0FBQ0gsTUFBYSxVQUFXLFNBQVEsR0FBRyxDQUFDLFFBQVE7SUFZeEM7Ozs7OztPQU1HO0lBQ0gsWUFBWSxLQUFvQixFQUFFLEVBQVUsRUFBRSxLQUFzQixFQUFFLG1DQUEyQyxJQUFJO1FBQ2pILEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxhQUFhLEdBQUcsSUFBSSw2QkFBYSxDQUFDLElBQUksRUFBRSxFQUFFLEVBQUc7WUFDL0MsY0FBYyxFQUFFLEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFdBQVc7WUFDekUsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDN0MsZUFBZSxFQUFFLEtBQUssQ0FBQyxlQUFlO1lBQ3RDLFlBQVksRUFBRSxLQUFLLENBQUMsWUFBWTtZQUNoQyxZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsTUFBTTtTQUNqRSxFQUFFLGdDQUFnQyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsZ0NBQWdDLENBQUMsQ0FBQztRQUNwRixJQUFJLENBQUMsUUFBUSxHQUFHLGFBQWEsQ0FBQztRQUM5QixJQUFJLENBQUMsZ0JBQWdCLEdBQUcsYUFBYSxDQUFDLGdCQUFnQixDQUFDO0lBQzNELENBQUM7Q0FDSjtBQWhDRCxnQ0FnQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyByb3MgZnJvbSAnQGFsaWNsb3VkL3Jvcy1jZGstY29yZSc7XHJcbmltcG9ydCB7IFJvc0FjY2Vzc1J1bGUgfSBmcm9tICcuL25hcy5nZW5lcmF0ZWQnO1xyXG4vLyBHZW5lcmF0ZWQgZnJvbSB0aGUgQWxpQ2xvdWQgUk9TIFJlc291cmNlIFNwZWNpZmljYXRpb25cclxuZXhwb3J0IHsgUm9zQWNjZXNzUnVsZSBhcyBBY2Nlc3NSdWxlUHJvcGVydHkgfTtcclxuXHJcbi8qKlxyXG4gKiBQcm9wZXJ0aWVzIGZvciBkZWZpbmluZyBhIGBBTElZVU46Ok5BUzo6QWNjZXNzUnVsZWBcclxuICovXHJcbmV4cG9ydCBpbnRlcmZhY2UgQWNjZXNzUnVsZVByb3BzIHtcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBhY2Nlc3NHcm91cE5hbWU6IFBlcm1pc3Npb24gZ3JvdXAgbmFtZVxyXG4gICAgICovXHJcbiAgICByZWFkb25seSBhY2Nlc3NHcm91cE5hbWU6IHN0cmluZztcclxuXHJcbiAgICAvKipcclxuICAgICAqIEBQcm9wZXJ0eSBzb3VyY2VDaWRySXA6IEFkZHJlc3Mgb3IgYWRkcmVzcyBzZWdtZW50XHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHNvdXJjZUNpZHJJcDogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHByaW9yaXR5OiBQcmlvcml0eSBsZXZlbC4gUmFuZ2U6IDEtMTAwLiBEZWZhdWx0IHZhbHVlOiAxXHJcbiAgICAgKi9cclxuICAgIHJlYWRvbmx5IHByaW9yaXR5PzogbnVtYmVyO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHJ3QWNjZXNzVHlwZTogUmVhZC13cml0ZSBwZXJtaXNzaW9uIHR5cGU6IFJEV1IgKGRlZmF1bHQpLCBSRE9OTFlcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgcndBY2Nlc3NUeXBlPzogc3RyaW5nO1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQFByb3BlcnR5IHVzZXJBY2Nlc3NUeXBlOiBVc2VyIHBlcm1pc3Npb24gdHlwZTogbm9fc3F1YXNoIChkZWZhdWx0KSwgcm9vdF9zcXVhc2gsIGFsbF9zcXVhc2hcclxuICAgICAqL1xyXG4gICAgcmVhZG9ubHkgdXNlckFjY2Vzc1R5cGU/OiBzdHJpbmc7XHJcbn1cclxuXHJcbi8qKlxyXG4gKiBBIFJPUyByZXNvdXJjZSB0eXBlOiAgYEFMSVlVTjo6TkFTOjpBY2Nlc3NSdWxlYFxyXG4gKi9cclxuZXhwb3J0IGNsYXNzIEFjY2Vzc1J1bGUgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xyXG5cclxuICAgIC8qKlxyXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxyXG4gICAgICogY29udGFpbmluZyB0aGUgcHJvcGVydGllcyBvZiB0aGlzIFJPUyByZXNvdXJjZSwgd2hpY2ggd2lsbCBiZSBhc3NpZ25lZCB0byBST1MgcmVzb3VyY2UuXHJcbiAgICAgKi9cclxuXHJcbiAgICAvKipcclxuICAgICAqIEBBdHRyaWJ1dGUgQWNjZXNzUnVsZUlkOiBSdWxlIHNlcmlhbCBudW1iZXJcclxuICAgICAqL1xyXG4gICAgcHVibGljIHJlYWRvbmx5IGF0dHJBY2Nlc3NSdWxlSWQ6IGFueTtcclxuXHJcbiAgICAvKipcclxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpOQVM6OkFjY2Vzc1J1bGVgLlxyXG4gICAgICpcclxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxyXG4gICAgICogQHBhcmFtIGlkICAgIC0gc2NvcGVkIGlkIG9mIHRoZSByZXNvdXJjZVxyXG4gICAgICogQHBhcmFtIHByb3BzIC0gcmVzb3VyY2UgcHJvcGVydGllc1xyXG4gICAgICovXHJcbiAgICBjb25zdHJ1Y3RvcihzY29wZTogcm9zLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEFjY2Vzc1J1bGVQcm9wcywgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQ6Ym9vbGVhbiA9IHRydWUpIHtcclxuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xyXG5cclxuICAgICAgICBjb25zdCByb3NBY2Nlc3NSdWxlID0gbmV3IFJvc0FjY2Vzc1J1bGUodGhpcywgaWQsICB7XHJcbiAgICAgICAgICAgIHVzZXJBY2Nlc3NUeXBlOiBwcm9wcy51c2VyQWNjZXNzVHlwZSA/IHByb3BzLnVzZXJBY2Nlc3NUeXBlIDogJ25vX3NxdWFzaCcsXHJcbiAgICAgICAgICAgIHByaW9yaXR5OiBwcm9wcy5wcmlvcml0eSA/IHByb3BzLnByaW9yaXR5IDogMSxcclxuICAgICAgICAgICAgYWNjZXNzR3JvdXBOYW1lOiBwcm9wcy5hY2Nlc3NHcm91cE5hbWUsXHJcbiAgICAgICAgICAgIHNvdXJjZUNpZHJJcDogcHJvcHMuc291cmNlQ2lkcklwLFxyXG4gICAgICAgICAgICByd0FjY2Vzc1R5cGU6IHByb3BzLnJ3QWNjZXNzVHlwZSA/IHByb3BzLnJ3QWNjZXNzVHlwZSA6ICdSRFdSJyxcclxuICAgICAgICB9LCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCAmJiB0aGlzLnN0YWNrLmVuYWJsZVJlc291cmNlUHJvcGVydHlDb25zdHJhaW50KTtcclxuICAgICAgICB0aGlzLnJlc291cmNlID0gcm9zQWNjZXNzUnVsZTtcclxuICAgICAgICB0aGlzLmF0dHJBY2Nlc3NSdWxlSWQgPSByb3NBY2Nlc3NSdWxlLmF0dHJBY2Nlc3NSdWxlSWQ7XHJcbiAgICB9XHJcbn1cclxuIl19