"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessGroup = exports.AccessGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const nas_generated_1 = require("./nas.generated");
Object.defineProperty(exports, "AccessGroupProperty", { enumerable: true, get: function () { return nas_generated_1.RosAccessGroup; } });
/**
 * A ROS resource type:  `ALIYUN::NAS::AccessGroup`
 */
class AccessGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::NAS::AccessGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosAccessGroup = new nas_generated_1.RosAccessGroup(this, id, {
            accessGroupType: props.accessGroupType,
            description: props.description,
            accessGroupName: props.accessGroupName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosAccessGroup;
        this.attrAccessGroupName = rosAccessGroup.attrAccessGroupName;
    }
}
exports.AccessGroup = AccessGroup;
//# sourceMappingURL=data:application/json;base64,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