# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['structlog_sentry_logger']

package_data = \
{'': ['*']}

install_requires = \
['colorama>=0.4.3,<0.5.0',
 'gitpython>=3.1.7,<4.0.0',
 'orjson>=3.6.4,<4.0.0',
 'python-dotenv>=0.19.0,<0.20.0',
 'sentry-sdk>0.17.0',
 'structlog>=21.1.0,<22.0.0']

extras_require = \
{'docs': ['emoji>=1.4.2,<2.0.0',
          'importlib-metadata>=4.6.3,<5.0.0',
          'myst-parser>=0.15.0,<0.16.0',
          'pygments>=2.9.0,<3.0.0',
          'sphinx>=4.1.2,<5.0.0',
          'sphinx-autoapi>=1.8.1,<2.0.0',
          'sphinx-rtd-theme>=0.5.1,<1.1.0',
          'sphinxcontrib-confluencebuilder>=1.5.0,<2.0.0',
          'types-emoji>=1.2.4,<2.0.0']}

setup_kwargs = {
    'name': 'structlog-sentry-logger',
    'version': '0.12.2',
    'description': 'Log without the setup via a pre-configured structlog logger with optional Sentry integration',
    'long_description': 'Structlog-Sentry-Logger\n==============================\n![CI](https://github.com/TeoZosa/structlog-sentry-logger/workflows/CI/badge.svg)\n![codecov](https://codecov.io/gh/TeoZosa/structlog-sentry-logger/branch/master/graph/badge.svg?token=3HF21UWY82)\n![License](https://img.shields.io/github/license/TeoZosa/structlog-sentry-logger?style=plastic)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/structlog-sentry-logger?style=plastic)\n![PyPI](https://img.shields.io/pypi/v/structlog-sentry-logger?color=informational&style=plastic)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![powered by semgrep](https://img.shields.io/badge/powered%20by-semgrep-1B2F3D?labelColor=lightgrey&link=https://semgrep.dev/&logo=data%3Aimage%2Fpng%3Bbase64%2CiVBORw0KGgoAAAANSUhEUgAAAA0AAAAOCAYAAAD0f5bSAAAABmJLR0QA/gD+AP+cH+QUAAAACXBIWXMAAA3XAAAN1wFCKJt4AAAAB3RJTUUH5AYMEy0l8dkqrQAAAvFJREFUKBUB5gIZ/QEAAP8BAAAAAAMG6AD9+hn/GzA//wD//wAAAAD+AAAAAgABAQDl0MEBAwbmAf36GQAAAAAAAQEC9QH//gv/Gi1GFQEC+OoAAAAAAAAAAAABAQAA//8AAAAAAAAAAAD//ggX5tO66gID9AEBFSRxAgYLzRQAAADpAAAAAP7+/gDl0cMPAAAA+wAAAPkbLz39AgICAAAAAAAAAAAs+vU12AEbLz4bAAAA5P8AAAAA//4A5NDDEwEBAO///wABAQEAAP//ABwcMD7hAQEBAAAAAAAAAAAaAgAAAOAAAAAAAQEBAOXRwxUAAADw//8AAgAAAAD//wAAAAAA5OXRwhcAAQEAAAAAAAAAAOICAAAABP3+/gDjzsAT//8A7gAAAAEAAAD+AAAA/wAAAAAAAAAA//8A7ePOwA/+/v4AAAAABAIAAAAAAAAAAAAAAO8AAAABAAAAAAAAAAIAAAABAAAAAAAAAAgAAAD/AAAA8wAAAAAAAAAAAgAAAAAAAAAAAAAAAAAAAA8AAAAEAAAA/gAAAP8AAAADAAAA/gAAAP8AAAAAAAAAAAAAAAACAAAAAAAAAAAAAAAAAAAA7wAAAPsAAAARAAAABAAAAP4AAAAAAAAAAgAAABYAAAAAAAAAAAIAAAD8AwICAB0yQP78/v4GAAAA/wAAAPAAAAD9AAAA/wAAAPr9//8aHTJA6AICAgAAAAD8AgAAADIAAAAAAP//AB4wPvgAAAARAQEA/gEBAP4BAQABAAAAGB0vPeIA//8AAAAAAAAAABAC+vUz1QAAAA8AAAAAAwMDABwwPu3//wAe//8AAv//ABAcMD7lAwMDAAAAAAAAAAAG+vU0+QEBAvUB//4L/xotRhUBAvjqAAAAAAAAAAAAAQEAAP//AAAAAAAAAAAA//4IF+bTuuoCA/QBAQAA/wEAAAAAAwboAP36Gf8bMD//AP//AAAAAP4AAAACAAEBAOXQwQEDBuYB/foZAAAAAAD4I6qbK3+1zQAAAABJRU5ErkJggg==)](https://semgrep.dev/)\n\n\n---\n\n**Documentation**: [https://structlog-sentry-logger.readthedocs.io](https://structlog-sentry-logger.readthedocs.io)\n\n**Source Code**: [https://github.com/TeoZosa/structlog-sentry-logger](https://github.com/TeoZosa/structlog-sentry-logger)\n\n---\n\n\n:teacher: Overview\n------------------\n\nA multi-purpose, pre-configured,\nperformance-optimized [`structlog`](https://www.structlog.org/en/stable/) logger with\n(optional) [Sentry](https://sentry.io/welcome/) integration\nvia [`structlog-sentry`](https://github.com/kiwicom/structlog-sentry).\n\n:sparkles: Features\n-------------------\n\n1. Makes logging as easy as using print statements, but prettier and easier to capture and filter!\n2. Highly opinionated! There are\n   only [two (2) distinct configurations](#chart_with_downwards_trend-output-formatting--storage).\n3. Structured logs in JSON format means they are ready to be ingested by many of your\n   favorite log analysis tools!\n4. [Cloud Logging compatible](#cloud-cloud-logging-compatibility)!\n\n:confetti_ball: What You Get\n----------------------------\n\n### :muscle: Powerful Automatic Context Fields\n\nThe pre-configured options include:\n\n1. :watch: Timestamps\n    - `DATETIME_FORMAT = "%Y-%m-%d %H:%M:%S"`\n2. :vertical_traffic_light: Log levels\n    - Added to the JSON context for filtering and categorization\n3. :mag: Logger names\n    - Automatically assigned to namespaced versions of the initializing python\n      modules (`.py` files), relative to your project directory.\n        - e.g., the logger in `docs_src/sentry_integration.py` is\n          named `docs_src.sentry_integration`\n\nWith fields sorted by key for easier at-a-glance analysis.\n\n### :zap: Performance\n\n`structlog-sentry-logger` is C-compiled and fully-tuned,\nleveraging [`orjson`](https://github.com/ijl/orjson)\nas the JSON serializer for lightning-fast logging (more than a 4x speedup over Python\'s\nbuilt-in JSON library[[1]](#1); see\n[here](https://teozosa.github.io/structlog-sentry-logger/dev/bench/Linux/CPython/3.8/64bit/c_library/)\nfor sample performance benchmarks). Don\'t let your obligate cross-cutting concerns\ncripple performance any longer!\n\nFor further reference, see:\n\n- "[`orjson`: Serialize](https://github.com/ijl/orjson#serialize)" for benchmarks\n- "[`structlog`: Performance](https://www.structlog.org/en/stable/performance.html)" for\n  salient performance-related configurations.\n\n<a id="1">[1]</a>\nsource:\n[Choosing a faster JSON library for Python: Benchmarking](https://pythonspeed.com/articles/faster-json-library/#step-4-benchmarking)\n\n### :robot: Built-in Sentry Integration (Optional)\n\nAutomatically add much richer context to your Sentry reports.\n\n- Your entire logging context is sent as a Sentry event when\n  the `structlog-sentry-logger`\n  log level is `error` or higher.\n    - i.e., `logger.error("")`, `logger.exception("")`\n- See [`structlog-sentry`](https://github.com/kiwicom/structlog-sentry) for more\n  details.\n\n------------\n\nTable of Contents\n\n<!-- toc -->\n\n- [:tada: Installation](#tada-installation)\n- [:rocket: Usage](#rocket-usage)\n  * [:loud_sound: Pure `structlog` Logging (Without Sentry)](#loud_sound-pure-structlog-logging-without-sentry)\n  * [:goal_net: Sentry Integration](#goal_net-sentry-integration)\n    + [:outbox_tray: Log Custom Context Directly to Sentry](#outbox_tray-log-custom-context-directly-to-sentry)\n  * [:cloud: Cloud Logging Compatibility](#cloud-cloud-logging-compatibility)\n- [:chart_with_downwards_trend: Output: Formatting & Storage](#chart_with_downwards_trend-output-formatting--storage)\n- [:wrench: Development](#wrench-development)\n  * [:building_construction: Package and Dependencies Installation](#building_construction-package-and-dependencies-installation)\n  * [:package: Python Module to C-Extension Compilation](#package-python-module-to-c-extension-compilation)\n  * [:white_check_mark: Testing](#white_check_mark-testing)\n  * [:rotating_light: Code Quality](#rotating_light-code-quality)\n    + [:arrows_counterclockwise: Automate via Git Pre-Commit Hooks](#arrows_counterclockwise-automate-via-git-pre-commit-hooks)\n  * [:memo: Documentation](#memo-documentation)\n- [:clipboard: Summary](#clipboard-summary)\n- [:books: Further Reading](#books-further-reading)\n  * [:one: `structlog`: Structured Logging for Python](#one-structlog-structured-logging-for-python)\n  * [:two: `Sentry`: Monitor and fix crashes in realtime](#two-sentry-monitor-and-fix-crashes-in-realtime)\n  * [:three: `structlog-sentry`: Provides the `structlog` integration for Sentry](#three-structlog-sentry-provides-the-structlog-integration-for-sentry)\n- [:judge: Legal](#judge-legal)\n  * [:page_facing_up: License](#page_facing_up-license)\n  * [:busts_in_silhouette: Credits](#busts_in_silhouette-credits)\n\n<!-- tocstop -->\n\n:tada: Installation\n===================\n\n ```shell script\npip install structlog-sentry-logger\n```\n\n:rocket: Usage\n==============\n:loud_sound: Pure `structlog` Logging (Without Sentry)\n------------------------------------------------------\nAt the top of your Python module, import and instantiate the logger:\n\n```python\nimport structlog_sentry_logger\n\nLOGGER = structlog_sentry_logger.get_logger()\n```\n\nNow anytime you want to print anything, don\'t. Instead do this:\n\n```python\nLOG_MSG = "Information that\'s useful for future me and others"\nLOGGER.info(LOG_MSG, extra_field="extra_value")\n```\n\n> :memo: **Note**  \n> All the regular\n> [Python logging levels](https://docs.python.org/3/library/logging.html#levels)\n> are supported.\n\nWhich automatically produces this:\n\n```json\n{\n    "event": "Information that\'s useful for future me and others",\n    "extra_field": "extra_value",\n    "level": "info",\n    "logger": "docs_src.pure_structlog_logging_without_sentry",\n    "sentry": "skipped",\n    "timestamp": "2020-10-18 15:30:05"\n}\n```\n\n:goal_net: Sentry Integration\n-----------------------------\nExport your [Sentry DSN](https://docs.sentry.io/platforms/python/#configure)\ninto your local environment.\n\n- An easy way to do this is to put it into a local `.env` file[*](#automatic-env-loading):\n\n ```shell script\n# On the command line:\n SENTRY_DSN=YOUR_SENTRY_DSN\n echo "SENTRY_DSN=${SENTRY_DSN}" >> .env\n```\n\nThen load the `.env` file in your Python code prior to instantiating the logger, e.g.:\n\n```python\nimport structlog_sentry_logger\n\nLOGGER = structlog_sentry_logger.get_logger()\n```\n\n### :outbox_tray: Log Custom Context Directly to Sentry\n\nWith `structlog`, you can even incorporate custom messages in your exception handling\nwhich will automatically be reported to Sentry (thanks to the `structlog-sentry`\nmodule):\n\n```python\nimport uuid\n\nimport structlog_sentry_logger\n\nLOGGER = structlog_sentry_logger.get_logger()\n\ncurr_user_logger = LOGGER.bind(uuid=uuid.uuid4().hex)  # LOGGER instance with bound UUID\ntry:\n    curr_user_logger.warn("A dummy error for testing purposes is about to be thrown!")\n    x = 1 / 0\nexcept ZeroDivisionError as err:\n    ERR_MSG = (\n        "I threw an error on purpose for this example!\\n"\n        "Now throwing another that explicitly chains from that one!"\n    )\n    curr_user_logger.exception(ERR_MSG)\n    raise RuntimeError(ERR_MSG) from err\n```\n\n```json lines\n{\n    "event": "A dummy error for testing purposes is about to be thrown!",\n    "level": "warning",\n    "logger": "docs_src.sentry_integration",\n    "sentry": "skipped",\n    "timestamp": "2020-10-18 15:29:55",\n    "uuid": "181e0e00b9034732af4fed2b8424fb11"\n}\n{\n    "event": "I threw an error on purpose for this example!\\nNow throwing another that explicitly chains from that one!",\n    "exception": \'Traceback (most recent call last):\\n  File "/app/structlog-sentry-logger/docs_src/sentry_integration.py", line 10, in <module>\\n    x = 1 / 0\\nZeroDivisionError: division by zero\',\n    "level": "error",\n    "logger": "docs_src.sentry_integration",\n    "sentry": "sent",\n    "sentry_id": null,\n    "timestamp": "2020-10-18 15:29:55",\n    "uuid": "181e0e00b9034732af4fed2b8424fb11"\n}\nTraceback (most recent call last):\n  File "/app/structlog-sentry-logger/docs_src/sentry_integration.py", line 10, in <module>\n    x = 1 / 0\nZeroDivisionError: division by zero\n\nThe above exception was the direct cause of the following exception:\n\nTraceback (most recent call last):\n  File "/app/structlog-sentry-logger/docs_src/sentry_integration.py", line 17, in <module>\n    raise RuntimeError(ERR_MSG) from err\nRuntimeError: I threw an error on purpose for this example!\nNow throwing another that explicitly chains from that one!\n```\n\n:cloud: Cloud Logging Compatibility\n-----------------------------------\nThe logger will attempt to infer if an application is running in a cloud environment by\ninspecting for the presence of environment variables that may be automatically injected\nby cloud providers (namely, `KUBERNETES_SERVICE_HOST`, `GCP_PROJECT`,\nand `GOOGLE_CLOUD_PROJECT`).\n\nIf any of these environment variables are detected, log levels will be duplicated to a\nreserved `severity` key in the emitted logs to enable parsing of the log level and the\nremaining log context (as `jsonPayload`) by [Cloud Logging](https://cloud.google.com/logging)\n(see: [Cloud Logging: Structured logging](https://cloud.google.com/logging/docs/structured-logging)).\n\n> :memo: **️Note**  \n> This behavior can also be manually enabled by adding the\n> `STRUCTLOG_SENTRY_LOGGER_CLOUD_LOGGING_COMPATIBILITY_MODE_ON`\n> variable to your environment, e.g., via a `.env` file[*](#automatic-env-loading).\n\n> :warning:️ **Warning**  \n> If a user manually specifies a value for the `severity` key, it will be overwritten!\n> Avoid using this key if possible to preempt any future issues.\n\n\n:chart_with_downwards_trend: Output: Formatting & Storage\n=========================================================\nThe default behavior is to stream JSON logs directly to the standard output\nstream [like a proper 12 Factor App](https://12factor.net/logs).\n\nFor local development, it often helps to prettify logging to stdout and save JSON logs\nto a `.logs` folder at the root of your project directory for later debugging. To enable\nthis behavior, set the following environment variable\n(assuming you are populating environment variables via a `.env` file[*](#automatic-env-loading), as in\nthe [Sentry Integration](#sentry-integration) section):\n\n```bash\necho "STRUCTLOG_SENTRY_LOGGER_LOCAL_DEVELOPMENT_LOGGING_MODE_ON=" >> .env\n```\n\nIn doing so, with our previous exception handling example we would get:\n\n![Output_Formatting_example](./.static/Output_Formatting_example.png)\n\n<a name="automatic-env-loading">\n    * This library uses [`python-dotenv`](https://github.com/theskumar/python-dotenv)\nto automatically populate your environment with this variable (if it exists)\n</a>\n\n:wrench: Development\n====================\n\nFor convenience, implementation details of the below processes are abstracted away and\nencapsulated in single [Make](https://www.gnu.org/software/make/) targets.\n\n\n> :fire: **Tip**  \n> Invoking `make` without any arguments will display\n> auto-generated documentation on available commands.\n\n:building_construction: Package and Dependencies Installation\n-------------------------------------------------------------\n\nMake sure you have Python 3.7+ and [`poetry`](https://python-poetry.org/)\ninstalled and configured.\n\nTo install the package and all dev dependencies, run:\n\n```shell script\nmake provision-environment\n```\n\n> :fire: **Tip**  \n> Invoking the above without `poetry` installed will emit a\n> helpful error message letting you know how you can install poetry.\n\n:package: Python Module to C-Extension Compilation\n--------------------------------------------------\nThe projects\'s [build.py](./build.py) file specifies which modules to package.\n\nFor manual per-module compilation, see:\n[Mypyc Documentation: Getting started - Compiling and running](https://mypyc.readthedocs.io/en/latest/getting_started.html#compiling-and-running)\n\n:white_check_mark: Testing\n--------------------------\n\nWe use [`tox`](https://tox.readthedocs.io/en/latest/)\nand [`pytest`](https://pytest.readthedocs.io/) for our test automation and testing\nframeworks, respectively.\n\nTo invoke the tests, run:\n\n```shell script\nmake test\n```\n\nRun [mutation tests](https://opensource.com/article/20/7/mutmut-python) to validate test\nsuite robustness (Optional):\n\n```shell script\nmake test-mutations\n```\n\n> :information_source: **Technical Details**  \n> Test time scales with the complexity of the codebase. Results are cached\n> in `.mutmut-cache`, so once you get past the initial [cold start problem](https://en.wikipedia.org/wiki/Cold_start_(recommender_systems)),\n> subsequent mutation test runs will be much faster; new mutations will only\n> be applied to modified code paths.\n\n:rotating_light: Code Quality\n-----------------------------\n\nWe use [`pre-commit`](https://pre-commit.com/) for our static analysis automation and\nmanagement framework.\n\nTo invoke the analyses and auto-formatting over all version-controlled files, run:\n\n```shell script\nmake lint\n```\n\n> :rotating_light: **Danger**  \n> CI will fail if either testing or code quality fail,\n> so it is recommended to automatically run the above locally\n> prior to every commit that is pushed.\n\n### :arrows_counterclockwise: Automate via Git Pre-Commit Hooks\n\nTo automatically run code quality validation on every commit (over to-be-committed\nfiles), run:\n\n```shell script\nmake install-pre-commit-hooks\n```\n\n> :warning:️ **Warning**  \n> This will prevent commits if any single pre-commit hook fails\n> (unless it is allowed to fail)\n> or a file is modified by an auto-formatting job;\n> in the latter case, you may simply repeat the commit and it should pass.\n\n:memo: Documentation\n--------------------\n\n```shell script\nmake docs-clean docs-html\n```\n\n> :fire: **Tip**  \n> For faster feedback loops, this will attempt to automatically open the newly\n> built documentation static HTML in your browser.\n\n:clipboard: Summary\n===================\nThat\'s it. Now no excuses. Get out there and program with pride knowing no one will\nlaugh at you in production! For not logging properly, that is. You\'re on your own for\nthat\nother [observability](https://devops.com/metrics-logs-and-traces-the-golden-triangle-of-observability-in-monitoring/)\nstuff.\n\n:books: Further Reading\n=======================\n<img src="https://www.structlog.org/en/stable/_static/structlog_logo_small.png" width="200">\n\n## :one: `structlog`: Structured Logging for Python\n- [https://www.structlog.org/en/stable/](https://www.structlog.org/en/stable/#)\n\n<img src="https://camo.githubusercontent.com/2dfeafbee0904d6df16ddf7200993dace1629e60/68747470733a2f2f73656e7472792d6272616e642e73746f726167652e676f6f676c65617069732e636f6d2f73656e7472792d6c6f676f2d626c61636b2e706e67" width="400">\n\n## :two: `Sentry`: Monitor and fix crashes in realtime\n- [https://sentry.io/welcome/](https://sentry.io/welcome/)\n\n## :three: `structlog-sentry`: Provides the `structlog` integration for Sentry\n- [https://github.com/kiwicom/structlog-sentry](https://github.com/kiwicom/structlog-sentry)\n\n---\n\n:judge: Legal\n=============\n\n:page_facing_up: License\n------------------------\n\nStructlog-Sentry-Logger is licensed under the Apache License, Version 2.0.\nSee [LICENSE](./LICENSE) for the full license text.\n\n\n:busts_in_silhouette: Credits\n-----------------------------\n\nThis project was generated from\n[`@TeoZosa`\'s](https://github.com/TeoZosa)\n[`cookiecutter-cruft-poetry-tox-pre-commit-ci-cd`](https://github.com/TeoZosa/cookiecutter-cruft-poetry-tox-pre-commit-ci-cd)\ntemplate.\n',
    'author': 'Teo Zosa',
    'author_email': 'teo@sonosim.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/TeoZosa/structlog-sentry-logger',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.7,<4.0',
}
from build import *
build(setup_kwargs)

setup(**setup_kwargs)
