"""
    SnapTrade

    Connect brokerage accounts to your app for live positions and trading  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Contact: api@snaptrade.com
    Generated by: https://konfigthis.com
"""


import re  # noqa: F401
import sys  # noqa: F401

from snaptrade_client.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from snaptrade_client.exceptions import ApiAttributeError


def lazy_import():
    from snaptrade_client.model.option_strategy import OptionStrategy
    globals()['OptionStrategy'] = OptionStrategy


class StrategyOrderRecord(ModelNormal):
    """NOTE: This class is auto generated by Konfig.
    Ref: https://konfigthis.com

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('status',): {
            'PENDING': "PENDING",
            'ACCEPTED': "ACCEPTED",
            'FAILED': "FAILED",
            'REJECTED': "REJECTED",
            'CANCELED': "CANCELED",
            'PARTIAL_CANCELED': "PARTIAL_CANCELED",
            'CANCEL_PENDING': "CANCEL_PENDING",
            'EXECUTED': "EXECUTED",
            'PARTIAL': "PARTIAL",
            'REPLACE_PENDING': "REPLACE_PENDING",
            'REPLACED': "REPLACED",
            'STOPPED': "STOPPED",
            'SUSPENDED': "SUSPENDED",
            'EXPIRED': "EXPIRED",
            'QUEUED': "QUEUED",
            'TRIGGERED': "TRIGGERED",
            'ACTIVATED': "ACTIVATED",
            'PENDING_RISK_REVIEW': "PENDING_RISK_REVIEW",
            'CONTINGENT_ORDER': "CONTINGENT_ORDER",
        },
        ('order_type',): {
            'LIMIT': "Limit",
            'MARKET': "Market",
            'NETDEBIT': "NetDebit",
            'NETCREDIT': "NetCredit",
        },
        ('time_in_force',): {
            'DAY': "DAY",
            'GTC': "GTC",
        },
    }

    validations = {
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'strategy': (OptionStrategy,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'filled_quantity': (float,),  # noqa: E501
            'open_quantity': (float,),  # noqa: E501
            'closed_quantity': (float,),  # noqa: E501
            'order_type': (str,),  # noqa: E501
            'time_in_force': (str,),  # noqa: E501
            'limit_price': (float,),  # noqa: E501
            'execution_price': (float,),  # noqa: E501
            'time_placed': (str,),  # noqa: E501
            'time_updated': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'strategy': 'strategy',  # noqa: E501
        'status': 'status',  # noqa: E501
        'filled_quantity': 'filled_quantity',  # noqa: E501
        'open_quantity': 'open_quantity',  # noqa: E501
        'closed_quantity': 'closed_quantity',  # noqa: E501
        'order_type': 'order_type',  # noqa: E501
        'time_in_force': 'time_in_force',  # noqa: E501
        'limit_price': 'limit_price',  # noqa: E501
        'execution_price': 'execution_price',  # noqa: E501
        'time_placed': 'time_placed',  # noqa: E501
        'time_updated': 'time_updated',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """StrategyOrderRecord - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            strategy (OptionStrategy): [optional]  # noqa: E501
            status (str): [optional]  # noqa: E501
            filled_quantity (float): [optional]  # noqa: E501
            open_quantity (float): [optional]  # noqa: E501
            closed_quantity (float): [optional]  # noqa: E501
            order_type (str): [optional]  # noqa: E501
            time_in_force (str): [optional]  # noqa: E501
            limit_price (float): Trade Price if limit or stop limit order. [optional]  # noqa: E501
            execution_price (float): Trade Price if limit or stop limit order. [optional]  # noqa: E501
            time_placed (str): Time. [optional]  # noqa: E501
            time_updated (str): Time. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', True)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """StrategyOrderRecord - a model defined in OpenAPI

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            strategy (OptionStrategy): [optional]  # noqa: E501
            status (str): [optional]  # noqa: E501
            filled_quantity (float): [optional]  # noqa: E501
            open_quantity (float): [optional]  # noqa: E501
            closed_quantity (float): [optional]  # noqa: E501
            order_type (str): [optional]  # noqa: E501
            time_in_force (str): [optional]  # noqa: E501
            limit_price (float): Trade Price if limit or stop limit order. [optional]  # noqa: E501
            execution_price (float): Trade Price if limit or stop limit order. [optional]  # noqa: E501
            time_placed (str): Time. [optional]  # noqa: E501
            time_updated (str): Time. [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
