# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: services/provider/v1/provider.proto
# plugin: python-betterproto
import warnings
from dataclasses import dataclass
from typing import (
    TYPE_CHECKING,
    Dict,
    List,
    Optional,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...account import v1 as __account_v1__
from ...common import v1 as __common_v1__


if TYPE_CHECKING:
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ParticipantType(betterproto.Enum):
    """Type of participant being invited to ecosystem"""

    participant_type_individual = 0
    """Participant is an individual"""

    participant_type_organization = 1
    """Participant is an organization"""


class InvitationStatusResponseStatus(betterproto.Enum):
    Error = 0
    """Onboarding resulted in error"""

    InvitationSent = 1
    """The participant has been invited"""

    Completed = 2
    """The participant has been onboarded"""

    Expired = 3
    """The invite has expired"""


class IonOptionsIonNetwork(betterproto.Enum):
    TestNet = 0
    MainNet = 1


@dataclass(eq=False, repr=False)
class InviteRequest(betterproto.Message):
    """Request to invite a participant to an ecosystem"""

    participant: "ParticipantType" = betterproto.enum_field(1)
    """Type of participant being invited (individual/organization)"""

    description: str = betterproto.string_field(2)
    """Description of invitation"""

    details: "__account_v1__.AccountDetails" = betterproto.message_field(3)
    """Account details of invitee"""


@dataclass(eq=False, repr=False)
class InviteRequestDidCommInvitation(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class InviteResponse(betterproto.Message):
    """Response to `InviteRequest`"""

    invitation_id: str = betterproto.string_field(10)
    """ID of created invitation"""

    invitation_code: str = betterproto.string_field(11)
    """Invitation code -- must be passed back in `LoginRequest`"""


@dataclass(eq=False, repr=False)
class InvitationStatusRequest(betterproto.Message):
    """Request details for the status of an invitation"""

    invitation_id: str = betterproto.string_field(1)
    """ID of invitation, received from `InviteResponse`"""


@dataclass(eq=False, repr=False)
class InvitationStatusResponse(betterproto.Message):
    """Response to `InvitationStatusRequest`"""

    status: "InvitationStatusResponseStatus" = betterproto.enum_field(1)
    """Status of invitation"""

    status_details: str = betterproto.string_field(2)
    """Human-readable string with details about invitation status"""


@dataclass(eq=False, repr=False)
class Ecosystem(betterproto.Message):
    """Details of an ecosystem"""

    id: str = betterproto.string_field(1)
    """URN of the ecosystem"""

    name: str = betterproto.string_field(2)
    """Globally unique name for the ecosystem"""

    description: str = betterproto.string_field(3)
    """Ecosystem description"""

    uri: str = betterproto.string_field(4)
    """External URL associated with the organization or ecosystem entity"""

    webhooks: List["WebhookConfig"] = betterproto.message_field(5)
    """Configured webhooks, if any"""

    display: "EcosystemDisplay" = betterproto.message_field(6)
    """Display details"""

    domain: str = betterproto.string_field(7)
    """Domain"""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("uri"):
            warnings.warn("Ecosystem.uri is deprecated", DeprecationWarning)


@dataclass(eq=False, repr=False)
class WebhookConfig(betterproto.Message):
    """Webhook configured on an ecosystem"""

    id: str = betterproto.string_field(1)
    """UUID of the webhook"""

    destination_url: str = betterproto.string_field(2)
    """HTTPS URL to POST webhook calls to"""

    events: List[str] = betterproto.string_field(4)
    """Events the webhook is subscribed to"""

    status: str = betterproto.string_field(5)
    """
    Last known status of webhook (whether or not Trinsic can successfully reach
    destination)
    """


@dataclass(eq=False, repr=False)
class Grant(betterproto.Message):
    """A grant authorizing `actions` on a `resourceId`"""

    resource_id: str = betterproto.string_field(1)
    """the urn of the resource"""

    actions: List[str] = betterproto.string_field(2)
    """list of actions that are allowed"""

    child_grants: List["Grant"] = betterproto.message_field(3)
    """any child grants"""


@dataclass(eq=False, repr=False)
class CreateEcosystemRequest(betterproto.Message):
    """Request to create an ecosystem"""

    name: str = betterproto.string_field(1)
    """
    Globally unique name for the Ecosystem. This name will be part of the
    ecosystem-specific URLs and namespaces. Allowed characters are lowercase
    letters, numbers, underscore and hyphen. If not passed, ecosystem name will
    be auto-generated.
    """

    description: str = betterproto.string_field(2)
    """Ecosystem description"""

    uri: str = betterproto.string_field(3)
    """External URL associated with your organization or ecosystem entity"""

    details: "__account_v1__.AccountDetails" = betterproto.message_field(4)
    """The account details of the owner of the ecosystem"""

    domain: str = betterproto.string_field(5)
    """New domain URL"""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("uri"):
            warnings.warn(
                "CreateEcosystemRequest.uri is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class CreateEcosystemResponse(betterproto.Message):
    """Response to `CreateEcosystemRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Details of the created ecosystem"""

    profile: "__account_v1__.AccountProfile" = betterproto.message_field(2)
    """Account profile for auth of the owner of the ecosystem"""

    confirmation_method: "__account_v1__.ConfirmationMethod" = betterproto.enum_field(3)
    """Indicates if confirmation of account is required."""


@dataclass(eq=False, repr=False)
class UpdateEcosystemRequest(betterproto.Message):
    """Request to update an ecosystem's metadata"""

    description: str = betterproto.string_field(1)
    """New description of the ecosystem"""

    uri: str = betterproto.string_field(2)
    """
    New external URL associated with the organization or ecosystem entity
    """

    domain: str = betterproto.string_field(3)
    """New domain URL"""

    name: str = betterproto.string_field(4)
    """New name"""

    display: "EcosystemDisplay" = betterproto.message_field(5)
    """Display details"""

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("uri"):
            warnings.warn(
                "UpdateEcosystemRequest.uri is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class EcosystemDisplay(betterproto.Message):
    dark: "EcosystemDisplayDetails" = betterproto.message_field(1)
    light: "EcosystemDisplayDetails" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EcosystemDisplayDetails(betterproto.Message):
    logo_url: str = betterproto.string_field(3)
    """string id = 1; string name = 2;"""

    color: str = betterproto.string_field(4)


@dataclass(eq=False, repr=False)
class UpdateEcosystemResponse(betterproto.Message):
    """Response to `UpdateEcosystemRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Current ecosystem metadata, post-update"""


@dataclass(eq=False, repr=False)
class AddWebhookRequest(betterproto.Message):
    """Request to add a webhook to an ecosystem"""

    destination_url: str = betterproto.string_field(1)
    """Destination to post webhook calls to. Must be a reachable HTTPS URL."""

    secret: str = betterproto.string_field(2)
    """
    Secret string used for HMAC-SHA256 signing of webhook payloads to verify
    that a webhook comes from Trinsic
    """

    events: List[str] = betterproto.string_field(3)
    """Events to subscribe to. Default is "*" (all events)"""


@dataclass(eq=False, repr=False)
class AddWebhookResponse(betterproto.Message):
    """Response to `AddWebhookRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Ecosystem data with new webhook"""


@dataclass(eq=False, repr=False)
class DeleteWebhookRequest(betterproto.Message):
    """Request to delete a webhook from an ecosystem"""

    webhook_id: str = betterproto.string_field(1)
    """ID of webhook to delete"""


@dataclass(eq=False, repr=False)
class DeleteWebhookResponse(betterproto.Message):
    """Response to `DeleteWebhookRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Ecosystem data after removal of webhook"""


@dataclass(eq=False, repr=False)
class EcosystemInfoRequest(betterproto.Message):
    """Request to fetch information about an ecosystem"""

    pass


@dataclass(eq=False, repr=False)
class EcosystemInfoResponse(betterproto.Message):
    """Response to `InfoRequest`"""

    ecosystem: "Ecosystem" = betterproto.message_field(1)
    """Ecosystem corresponding to current ecosystem in the account token"""


@dataclass(eq=False, repr=False)
class GetPublicEcosystemInfoRequest(betterproto.Message):
    """Request to fetch information about an ecosystem"""

    ecosystem_id: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class GetPublicEcosystemInfoResponse(betterproto.Message):
    """Response to `InfoRequest`"""

    ecosystem: "PublicEcosystemInformation" = betterproto.message_field(1)
    """Ecosystem corresponding to requested `ecosystem_id`"""


@dataclass(eq=False, repr=False)
class PublicEcosystemInformation(betterproto.Message):
    name: str = betterproto.string_field(1)
    """Public name of this ecosystem"""

    domain: str = betterproto.string_field(2)
    """Public domain for the owner of this ecosystem"""

    domain_verified: bool = betterproto.bool_field(3)
    """Trinsic verified the domain is owned by the owner of this ecosystem"""

    style_display: "EcosystemDisplay" = betterproto.message_field(4)
    """Style display information"""


@dataclass(eq=False, repr=False)
class GenerateTokenRequest(betterproto.Message):
    """Request to generate an authentication token for the current account"""

    description: str = betterproto.string_field(1)
    """Description to identify this token"""


@dataclass(eq=False, repr=False)
class GenerateTokenResponse(betterproto.Message):
    """Response to `GenerateTokenRequest`"""

    profile: "__account_v1__.AccountProfile" = betterproto.message_field(1)
    """Account authentication profile that contains unprotected token"""


@dataclass(eq=False, repr=False)
class GetOberonKeyRequest(betterproto.Message):
    """
    Request to fetch the Trinsic public key used to verify authentication token
    validity
    """

    pass


@dataclass(eq=False, repr=False)
class GetOberonKeyResponse(betterproto.Message):
    """Response to `GetOberonKeyRequest`"""

    key: str = betterproto.string_field(1)
    """Oberon Public Key as RAW base64-url encoded string"""


@dataclass(eq=False, repr=False)
class GetEventTokenRequest(betterproto.Message):
    """Generates an events token bound to the provided ed25519 public key."""

    pk: bytes = betterproto.bytes_field(1)
    """Raw public key to generate event token for"""


@dataclass(eq=False, repr=False)
class GetEventTokenResponse(betterproto.Message):
    """
    Response message containing a token (JWT) that can be used to connect
    directly to the message streaming architecture
    """

    token: str = betterproto.string_field(1)
    """JWT bound to the public key provided in `GetEventTokenRequest`"""


@dataclass(eq=False, repr=False)
class RetrieveDomainVerificationRecordRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RetrieveDomainVerificationRecordResponse(betterproto.Message):
    """
    Response message containing a TXT record content for domain url
    verification
    """

    verification_txt: str = betterproto.string_field(1)
    """TXT code to use for domain verification"""


@dataclass(eq=False, repr=False)
class RefreshDomainVerificationStatusRequest(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class RefreshDomainVerificationStatusResponse(betterproto.Message):
    domain: str = betterproto.string_field(1)
    """Domain URL verified"""

    domain_verified: bool = betterproto.bool_field(2)
    """Specifies if the above `domain` was successfully verified"""


@dataclass(eq=False, repr=False)
class GrantAuthorizationRequest(betterproto.Message):
    """Grant permissions to a resource or path in the ecosystem"""

    email: str = betterproto.string_field(1, group="account")
    """
    Email address of account being granted permission. Mutually exclusive with
    `walletId`.
    """

    wallet_id: str = betterproto.string_field(2, group="account")
    """
    Wallet ID of account being granted permission. Mutually exclusive with
    `email`.
    """

    resource: str = betterproto.string_field(3)
    """
    Resource string that account is receiving permissions for. Resources are
    specified as a RESTful path: /{ecoId}/{resource type}/{resource id}.
    `ecoId` may be omitted.
    """

    action: str = betterproto.string_field(4)
    """Action to authorize. Default is "*" (all)"""


@dataclass(eq=False, repr=False)
class GrantAuthorizationResponse(betterproto.Message):
    """Response to `GrantAuthorizationRequest`"""

    pass


@dataclass(eq=False, repr=False)
class RevokeAuthorizationRequest(betterproto.Message):
    """Revoke permissions to a resource or path in the ecosystem"""

    email: str = betterproto.string_field(1, group="account")
    """
    Email address of account having permission revoked. Mutually exclusive with
    `walletId`.
    """

    wallet_id: str = betterproto.string_field(2, group="account")
    """
    Wallet ID of account having permission revoked. Mutually exclusive with
    `email`.
    """

    resource: str = betterproto.string_field(3)
    """
    Resource string that account is losing permissions for. Resources are
    specified as a RESTful path: /{ecoId}/{resource type}/{resource id}.
    `ecoId` may be omitted.
    """

    action: str = betterproto.string_field(4)
    """Action to revoke. Default is "*" (all)"""


@dataclass(eq=False, repr=False)
class RevokeAuthorizationResponse(betterproto.Message):
    """Response to `RevokeAuthorizationRequest`"""

    pass


@dataclass(eq=False, repr=False)
class GetAuthorizationsRequest(betterproto.Message):
    """
    Fetch list of grants that the current account has access to in its
    ecosystem
    """

    pass


@dataclass(eq=False, repr=False)
class GetAuthorizationsResponse(betterproto.Message):
    """Response to `GetAuthorizationsRequest`"""

    grants: List["Grant"] = betterproto.message_field(1)
    """Grants attached to account"""


@dataclass(eq=False, repr=False)
class SearchWalletConfigurationsRequest(betterproto.Message):
    """Search for issuers/holders/verifiers"""

    query_filter: str = betterproto.string_field(1)
    """SQL filter to execute. `SELECT * FROM _ WHERE [**queryFilter**]`"""

    continuation_token: str = betterproto.string_field(2)
    """
    Token provided by previous `SearchResponse` if more data is available for
    query
    """


@dataclass(eq=False, repr=False)
class SearchWalletConfigurationResponse(betterproto.Message):
    results: List["WalletConfiguration"] = betterproto.message_field(1)
    """Results matching the search query"""

    has_more: bool = betterproto.bool_field(2)
    """
    Whether more results are available for this query via `continuation_token`
    """

    continuation_token: str = betterproto.string_field(4)
    """Token to fetch next set of results via `SearchRequest`"""


@dataclass(eq=False, repr=False)
class WalletConfiguration(betterproto.Message):
    """Strongly typed information about wallet configurations"""

    name: str = betterproto.string_field(1)
    email: str = betterproto.string_field(2)
    sms: str = betterproto.string_field(3)
    wallet_id: str = betterproto.string_field(4)
    public_did: str = betterproto.string_field(5)


@dataclass(eq=False, repr=False)
class IonOptions(betterproto.Message):
    """Options for creation of DID on the ION network"""

    network: "IonOptionsIonNetwork" = betterproto.enum_field(1)
    """ION network on which DID should be published"""


@dataclass(eq=False, repr=False)
class UpgradeDidRequest(betterproto.Message):
    """Request to upgrade a wallet"""

    email: str = betterproto.string_field(1, group="account")
    """
    Email address of account to upgrade. Mutually exclusive with `walletId`.
    """

    wallet_id: str = betterproto.string_field(2, group="account")
    """Wallet ID of account to upgrade. Mutually exclusive with `email`."""

    method: "__common_v1__.SupportedDidMethod" = betterproto.enum_field(3)
    """DID Method to which wallet should be upgraded"""

    ion_options: "IonOptions" = betterproto.message_field(4, group="options")
    """Configuration for creation of DID on ION network"""


@dataclass(eq=False, repr=False)
class UpgradeDidResponse(betterproto.Message):
    """Response to `UpgradeDIDRequest`"""

    did: str = betterproto.string_field(1)
    """New DID of wallet"""


class ProviderStub(betterproto.ServiceStub):
    async def create_ecosystem(
        self,
        create_ecosystem_request: "CreateEcosystemRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "CreateEcosystemResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/CreateEcosystem",
            create_ecosystem_request,
            CreateEcosystemResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_ecosystem(
        self,
        update_ecosystem_request: "UpdateEcosystemRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "UpdateEcosystemResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/UpdateEcosystem",
            update_ecosystem_request,
            UpdateEcosystemResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def grant_authorization(
        self,
        grant_authorization_request: "GrantAuthorizationRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GrantAuthorizationResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/GrantAuthorization",
            grant_authorization_request,
            GrantAuthorizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def revoke_authorization(
        self,
        revoke_authorization_request: "RevokeAuthorizationRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "RevokeAuthorizationResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/RevokeAuthorization",
            revoke_authorization_request,
            RevokeAuthorizationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_authorizations(
        self,
        get_authorizations_request: "GetAuthorizationsRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GetAuthorizationsResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/GetAuthorizations",
            get_authorizations_request,
            GetAuthorizationsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def add_webhook(
        self,
        add_webhook_request: "AddWebhookRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "AddWebhookResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/AddWebhook",
            add_webhook_request,
            AddWebhookResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def delete_webhook(
        self,
        delete_webhook_request: "DeleteWebhookRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "DeleteWebhookResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/DeleteWebhook",
            delete_webhook_request,
            DeleteWebhookResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def ecosystem_info(
        self,
        ecosystem_info_request: "EcosystemInfoRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "EcosystemInfoResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/EcosystemInfo",
            ecosystem_info_request,
            EcosystemInfoResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_public_ecosystem_info(
        self,
        get_public_ecosystem_info_request: "GetPublicEcosystemInfoRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GetPublicEcosystemInfoResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/GetPublicEcosystemInfo",
            get_public_ecosystem_info_request,
            GetPublicEcosystemInfoResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def generate_token(
        self,
        generate_token_request: "GenerateTokenRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GenerateTokenResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/GenerateToken",
            generate_token_request,
            GenerateTokenResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def invite(
        self,
        invite_request: "InviteRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "InviteResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/Invite",
            invite_request,
            InviteResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def invitation_status(
        self,
        invitation_status_request: "InvitationStatusRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "InvitationStatusResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/InvitationStatus",
            invitation_status_request,
            InvitationStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_oberon_key(
        self,
        get_oberon_key_request: "GetOberonKeyRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GetOberonKeyResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/GetOberonKey",
            get_oberon_key_request,
            GetOberonKeyResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_event_token(
        self,
        get_event_token_request: "GetEventTokenRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "GetEventTokenResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/GetEventToken",
            get_event_token_request,
            GetEventTokenResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def upgrade_did(
        self,
        upgrade_did_request: "UpgradeDidRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "UpgradeDidResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/UpgradeDID",
            upgrade_did_request,
            UpgradeDidResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def retrieve_domain_verification_record(
        self,
        retrieve_domain_verification_record_request: "RetrieveDomainVerificationRecordRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "RetrieveDomainVerificationRecordResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/RetrieveDomainVerificationRecord",
            retrieve_domain_verification_record_request,
            RetrieveDomainVerificationRecordResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def refresh_domain_verification_status(
        self,
        refresh_domain_verification_status_request: "RefreshDomainVerificationStatusRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "RefreshDomainVerificationStatusResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/RefreshDomainVerificationStatus",
            refresh_domain_verification_status_request,
            RefreshDomainVerificationStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def search_wallet_configurations(
        self,
        search_wallet_configurations_request: "SearchWalletConfigurationsRequest",
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["_MetadataLike"] = None,
    ) -> "SearchWalletConfigurationResponse":
        return await self._unary_unary(
            "/services.provider.v1.Provider/SearchWalletConfigurations",
            search_wallet_configurations_request,
            SearchWalletConfigurationResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )


class ProviderBase(ServiceBase):
    async def create_ecosystem(
        self, create_ecosystem_request: "CreateEcosystemRequest"
    ) -> "CreateEcosystemResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_ecosystem(
        self, update_ecosystem_request: "UpdateEcosystemRequest"
    ) -> "UpdateEcosystemResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def grant_authorization(
        self, grant_authorization_request: "GrantAuthorizationRequest"
    ) -> "GrantAuthorizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def revoke_authorization(
        self, revoke_authorization_request: "RevokeAuthorizationRequest"
    ) -> "RevokeAuthorizationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_authorizations(
        self, get_authorizations_request: "GetAuthorizationsRequest"
    ) -> "GetAuthorizationsResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def add_webhook(
        self, add_webhook_request: "AddWebhookRequest"
    ) -> "AddWebhookResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def delete_webhook(
        self, delete_webhook_request: "DeleteWebhookRequest"
    ) -> "DeleteWebhookResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def ecosystem_info(
        self, ecosystem_info_request: "EcosystemInfoRequest"
    ) -> "EcosystemInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_public_ecosystem_info(
        self, get_public_ecosystem_info_request: "GetPublicEcosystemInfoRequest"
    ) -> "GetPublicEcosystemInfoResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def generate_token(
        self, generate_token_request: "GenerateTokenRequest"
    ) -> "GenerateTokenResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def invite(self, invite_request: "InviteRequest") -> "InviteResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def invitation_status(
        self, invitation_status_request: "InvitationStatusRequest"
    ) -> "InvitationStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_oberon_key(
        self, get_oberon_key_request: "GetOberonKeyRequest"
    ) -> "GetOberonKeyResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_event_token(
        self, get_event_token_request: "GetEventTokenRequest"
    ) -> "GetEventTokenResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def upgrade_did(
        self, upgrade_did_request: "UpgradeDidRequest"
    ) -> "UpgradeDidResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def retrieve_domain_verification_record(
        self,
        retrieve_domain_verification_record_request: "RetrieveDomainVerificationRecordRequest",
    ) -> "RetrieveDomainVerificationRecordResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def refresh_domain_verification_status(
        self,
        refresh_domain_verification_status_request: "RefreshDomainVerificationStatusRequest",
    ) -> "RefreshDomainVerificationStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def search_wallet_configurations(
        self, search_wallet_configurations_request: "SearchWalletConfigurationsRequest"
    ) -> "SearchWalletConfigurationResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def __rpc_create_ecosystem(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.create_ecosystem(request)
        await stream.send_message(response)

    async def __rpc_update_ecosystem(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.update_ecosystem(request)
        await stream.send_message(response)

    async def __rpc_grant_authorization(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.grant_authorization(request)
        await stream.send_message(response)

    async def __rpc_revoke_authorization(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.revoke_authorization(request)
        await stream.send_message(response)

    async def __rpc_get_authorizations(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.get_authorizations(request)
        await stream.send_message(response)

    async def __rpc_add_webhook(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.add_webhook(request)
        await stream.send_message(response)

    async def __rpc_delete_webhook(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.delete_webhook(request)
        await stream.send_message(response)

    async def __rpc_ecosystem_info(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.ecosystem_info(request)
        await stream.send_message(response)

    async def __rpc_get_public_ecosystem_info(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_public_ecosystem_info(request)
        await stream.send_message(response)

    async def __rpc_generate_token(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.generate_token(request)
        await stream.send_message(response)

    async def __rpc_invite(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.invite(request)
        await stream.send_message(response)

    async def __rpc_invitation_status(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.invitation_status(request)
        await stream.send_message(response)

    async def __rpc_get_oberon_key(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.get_oberon_key(request)
        await stream.send_message(response)

    async def __rpc_get_event_token(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.get_event_token(request)
        await stream.send_message(response)

    async def __rpc_upgrade_did(self, stream: grpclib.server.Stream) -> None:
        request = await stream.recv_message()
        response = await self.upgrade_did(request)
        await stream.send_message(response)

    async def __rpc_retrieve_domain_verification_record(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()
        response = await self.retrieve_domain_verification_record(request)
        await stream.send_message(response)

    async def __rpc_refresh_domain_verification_status(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()
        response = await self.refresh_domain_verification_status(request)
        await stream.send_message(response)

    async def __rpc_search_wallet_configurations(
        self, stream: grpclib.server.Stream
    ) -> None:
        request = await stream.recv_message()
        response = await self.search_wallet_configurations(request)
        await stream.send_message(response)

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/services.provider.v1.Provider/CreateEcosystem": grpclib.const.Handler(
                self.__rpc_create_ecosystem,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateEcosystemRequest,
                CreateEcosystemResponse,
            ),
            "/services.provider.v1.Provider/UpdateEcosystem": grpclib.const.Handler(
                self.__rpc_update_ecosystem,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateEcosystemRequest,
                UpdateEcosystemResponse,
            ),
            "/services.provider.v1.Provider/GrantAuthorization": grpclib.const.Handler(
                self.__rpc_grant_authorization,
                grpclib.const.Cardinality.UNARY_UNARY,
                GrantAuthorizationRequest,
                GrantAuthorizationResponse,
            ),
            "/services.provider.v1.Provider/RevokeAuthorization": grpclib.const.Handler(
                self.__rpc_revoke_authorization,
                grpclib.const.Cardinality.UNARY_UNARY,
                RevokeAuthorizationRequest,
                RevokeAuthorizationResponse,
            ),
            "/services.provider.v1.Provider/GetAuthorizations": grpclib.const.Handler(
                self.__rpc_get_authorizations,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetAuthorizationsRequest,
                GetAuthorizationsResponse,
            ),
            "/services.provider.v1.Provider/AddWebhook": grpclib.const.Handler(
                self.__rpc_add_webhook,
                grpclib.const.Cardinality.UNARY_UNARY,
                AddWebhookRequest,
                AddWebhookResponse,
            ),
            "/services.provider.v1.Provider/DeleteWebhook": grpclib.const.Handler(
                self.__rpc_delete_webhook,
                grpclib.const.Cardinality.UNARY_UNARY,
                DeleteWebhookRequest,
                DeleteWebhookResponse,
            ),
            "/services.provider.v1.Provider/EcosystemInfo": grpclib.const.Handler(
                self.__rpc_ecosystem_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                EcosystemInfoRequest,
                EcosystemInfoResponse,
            ),
            "/services.provider.v1.Provider/GetPublicEcosystemInfo": grpclib.const.Handler(
                self.__rpc_get_public_ecosystem_info,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetPublicEcosystemInfoRequest,
                GetPublicEcosystemInfoResponse,
            ),
            "/services.provider.v1.Provider/GenerateToken": grpclib.const.Handler(
                self.__rpc_generate_token,
                grpclib.const.Cardinality.UNARY_UNARY,
                GenerateTokenRequest,
                GenerateTokenResponse,
            ),
            "/services.provider.v1.Provider/Invite": grpclib.const.Handler(
                self.__rpc_invite,
                grpclib.const.Cardinality.UNARY_UNARY,
                InviteRequest,
                InviteResponse,
            ),
            "/services.provider.v1.Provider/InvitationStatus": grpclib.const.Handler(
                self.__rpc_invitation_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                InvitationStatusRequest,
                InvitationStatusResponse,
            ),
            "/services.provider.v1.Provider/GetOberonKey": grpclib.const.Handler(
                self.__rpc_get_oberon_key,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetOberonKeyRequest,
                GetOberonKeyResponse,
            ),
            "/services.provider.v1.Provider/GetEventToken": grpclib.const.Handler(
                self.__rpc_get_event_token,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetEventTokenRequest,
                GetEventTokenResponse,
            ),
            "/services.provider.v1.Provider/UpgradeDID": grpclib.const.Handler(
                self.__rpc_upgrade_did,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpgradeDidRequest,
                UpgradeDidResponse,
            ),
            "/services.provider.v1.Provider/RetrieveDomainVerificationRecord": grpclib.const.Handler(
                self.__rpc_retrieve_domain_verification_record,
                grpclib.const.Cardinality.UNARY_UNARY,
                RetrieveDomainVerificationRecordRequest,
                RetrieveDomainVerificationRecordResponse,
            ),
            "/services.provider.v1.Provider/RefreshDomainVerificationStatus": grpclib.const.Handler(
                self.__rpc_refresh_domain_verification_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                RefreshDomainVerificationStatusRequest,
                RefreshDomainVerificationStatusResponse,
            ),
            "/services.provider.v1.Provider/SearchWalletConfigurations": grpclib.const.Handler(
                self.__rpc_search_wallet_configurations,
                grpclib.const.Cardinality.UNARY_UNARY,
                SearchWalletConfigurationsRequest,
                SearchWalletConfigurationResponse,
            ),
        }
