import base64
import binascii
from platone.packages.gmssl import sm2, func


def test_sm2():
    private_key = '00B9AB0B828FF68872F21A837FC303668428DEA11DCD1B24429D0C99E24EED83D5'
    public_key = 'B9C9A6E04E9C91F7BA880429273747D7EF5DDEB0BB2FF6317EB00BEF331A83081A6994B8993F3F5D6EADDDB81872266C87C018FB4162F5AF347B483E24620207'

    sm2_crypt = sm2.CryptSM2(
        public_key=public_key, private_key=private_key)
    data = b"111"
    enc_data = sm2_crypt.encrypt(data)
    # print("enc_data:%s" % enc_data)
    # print("enc_data_base64:%s" % base64.b64encode(bytes.fromhex(enc_data)))
    dec_data = sm2_crypt.decrypt(enc_data)
    print(b"dec_data:%s" % dec_data)
    assert data == dec_data

    print("-----------------test sign and verify---------------")
    random_hex_str = func.random_hex(sm2_crypt.para_len)
    sign = sm2_crypt.sign(data, random_hex_str)
    print(sign)
    verify = sm2_crypt.verify(sign, data)
    print('verify:%s' % verify)
    assert verify


def test_sm3():
    private_key = "3945208F7B2144B13F36E38AC6D39F95889393692860B51A42FB81EF4DF7C5B8"
    public_key = "09F9DF311E5421A150DD7D161E4BC5C672179FAD1833FC076BB08FF356F35020" \
                 "CCEA490CE26775A52DC6EA718CC1AA600AED05FBF35E084A6632F6072DA9AD13"
    random_hex_str = "59276E27D506861A16680F3AD9C02DCCEF3CC1FA3CDBE4CE6D54B80DEAC1BC21"

    sm2_crypt = sm2.CryptSM2(public_key=public_key, private_key=private_key)
    data = b"message digest"

    print("-----------------test SM2withSM3 sign and verify---------------")
    sign = sm2_crypt.sign_with_sm3(data, random_hex_str)
    print('sign: %s' % sign)
    verify = sm2_crypt.verify_with_sm3(sign, data)
    print('verify: %s' % verify)
    assert verify


if __name__ == '__main__':
    # private_key = '00B9AB0B828FF68872F21A837FC303668428DEA11DCD1B24429D0C99E24EED83D5'
    # public_key = 'B9C9A6E04E9C91F7BA880429273747D7EF5DDEB0BB2FF6317EB00BEF331A83081A6994B8993F3F5D6EADDDB81872266C87C018FB4162F5AF347B483E24620207'
    # keys = sm2.CryptSM2(private_key, public_key)
    # keypair =keys.generateKeyPair()
    # print(keypair)
    test_sm2()

