from gql.dsl import DSLMetaField


class CrawlFields:
    @staticmethod
    def fields(ds):
        return (
            ds.Crawl.id,
            ds.Crawl.archivedAt,
            ds.Crawl.archivingAt,
            ds.Crawl.brokenAt,
            ds.Crawl.bucketSlot,
            ds.Crawl.canceledAt,
            ds.Crawl.cancelingAt,
            ds.Crawl.comparedToCrawlId,
            ds.Crawl.coreUIUrl,
            ds.Crawl.crawlLevels,
            ds.Crawl.crawlTypes,
            ds.Crawl.crawlability,
            ds.Crawl.crawlabilityTrend,
            ds.Crawl.crawledAt,
            ds.Crawl.crawledPerSecond,
            ds.Crawl.crawledPhase1At,
            ds.Crawl.crawledPhase2At,
            ds.Crawl.crawlerType,
            ds.Crawl.crawlingAt,
            ds.Crawl.crawlingPhase1At,
            ds.Crawl.crawlingPhase2At,
            ds.Crawl.createdAt,
            ds.Crawl.discoveredUrlsAt,
            ds.Crawl.discoveringUrlsAt,
            ds.Crawl.errorMessage,
            ds.Crawl.erroredAt,
            ds.Crawl.finishedAt,
            ds.Crawl.fsmExtTransitionedAt,
            ds.Crawl.fsmTransitionedAt,
            ds.Crawl.incomplete,
            ds.Crawl.isContainer,
            ds.Crawl.isScheduled,
            ds.Crawl.languageSettings,
            ds.Crawl.languageSettingsAdded,
            ds.Crawl.languageSettingsRemoved,
            ds.Crawl.limitLevelsMax,
            ds.Crawl.limitPagesMax,
            ds.Crawl.maxProcessLinks,
            ds.Crawl.metricsServerId,
            ds.Crawl.migratedAt,
            ds.Crawl.migratingAt,
            ds.Crawl.optimusTransformedAt,
            ds.Crawl.optimusTransformingAt,
            ds.Crawl.pageGroupings,
            ds.Crawl.parquetFilesUrls,
            ds.Crawl.partition,
            ds.Crawl.pauseReason,
            ds.Crawl.pausedReminderSent,
            ds.Crawl.populatedAt,
            ds.Crawl.populatingAt,
            ds.Crawl.postPopulatedAt,
            ds.Crawl.postPopulatingAt,
            ds.Crawl.postTransformedAt,
            ds.Crawl.postTransformingAt,
            ds.Crawl.processInstanceType,
            ds.Crawl.processedAt,
            ds.Crawl.processingAt,
            ds.Crawl.progressCrawled,
            ds.Crawl.progressDiscovered,
            ds.Crawl.progressEnqueued,
            ds.Crawl.progressStepped,
            ds.Crawl.progressUpdatedAt,
            ds.Crawl.projectId,
            ds.Crawl.queueingAt,
            ds.Crawl.queuedAt,
            ds.Crawl.rawID,
            ds.Crawl.readyAt,
            ds.Crawl.refineryEnabled,
            ds.Crawl.refineryProcessedAt,
            ds.Crawl.refineryProcessingAt,
            ds.Crawl.refineryProcessingEnabled,
            ds.Crawl.robotsOverwrite,
            ds.Crawl.scheduleRunningEmailSentAt,
            ds.Crawl.scheduled,
            ds.Crawl.siteExplorer,
            ds.Crawl.startedByApi,
            ds.Crawl.status,
            ds.Crawl.statusEnum,
            ds.Crawl.totalStepLinks,
            ds.Crawl.totalSteps,
            ds.Crawl.transformedAt,
            ds.Crawl.transformingAt,
            ds.Crawl.useEsReportStats,
            ds.Crawl.updatedAt,
            ds.Crawl.useRewriteRules,
            ds.Crawl.useRobotsOverwrite,
            ds.Crawl.version,
            ds.Crawl.progress.select(ds.LevelProgress.level, ds.LevelProgress.stepsProcessed),
            ds.Crawl.createdByUser.select(
                ds.UserInfo.firstName,
                ds.UserInfo.lastName,
                ds.UserInfo.username,
            ),
            ds.Crawl.advancedCrawlStats.select(
                ds.AdvancedCrawlStats.crawledCrawlRate,
                ds.AdvancedCrawlStats.externalCrawlRate,
                ds.AdvancedCrawlStats.internalCrawlRate,
                ds.AdvancedCrawlStats.uncrawledCrawlRate,
            ),
            DSLMetaField("__typename"),
        )

    @staticmethod
    def parquet_files_fields(ds):
        return (
            ds.CrawlParquetFile.datasourceName,
            ds.CrawlParquetFile.expiresAt,
            ds.CrawlParquetFile.files,
            DSLMetaField("__typename"),
        )

    @staticmethod
    def crawl_type_counts_fields(ds):
        return (
            ds.CrawlTypeCount.count,
            ds.CrawlTypeCount.crawlTypes,
            DSLMetaField("__typename"),
        )
