css = '''
.theme-dark {
  --background-primary: #272b34;
  --background-primary-alt: #20242b;
  --background-secondary: #20242b;
  --background-secondary-alt: #1a1e24;
  --background-accent: #000;
  --background-modifier-border: #424958;
  --background-modifier-form-field: rgba(0, 0, 0, 0.3);
  --background-modifier-form-field-highlighted: rgba(0, 0, 0, 0.22);
  --background-modifier-box-shadow: rgba(0, 0, 0, 0.3);
  --background-modifier-success: #539126;
  --background-modifier-error: #3d0000;
  --background-modifier-error-rgb: 61, 0, 0;
  --background-modifier-error-hover: #470000;
  --background-modifier-cover: rgba(0, 0, 0, 0.6);
  --text-accent: #61afef;
  --text-accent-hover: #69bafd;
  --text-normal: #dcddde;
  --text-muted: #888;
  --text-faint: rgb(81, 86, 99);
  --text-error: #e16d76;
  --text-error-hover: #c9626a;
  --text-highlight-bg: rgba(255, 255, 0, 0.4);
  --text-selection: rgba(0, 122, 255, 0.2);
  --text-on-accent: #dcddde;
  --interactive-normal: #20242b;
  --interactive-hover: #353b47;
  --interactive-accent: #4c78cc;
  --interactive-accent-rgb: 76, 120, 204;
  --interactive-accent-hover: #5082df;
  --scrollbar-active-thumb-bg: rgba(255, 255, 255, 0.2);
  --scrollbar-bg: rgba(255, 255, 255, 0.05);
  --scrollbar-thumb-bg: rgba(255, 255, 255, 0.1);
  --panel-border-color: #18191e;

  --gray-1: #5C6370;
  --gray-2: #abb2bf;
  --red: #e06c75;
  --orange: #d19a66;
  --green: #98c379;
  --aqua: #56b6c2;
  --purple: #c678dd;
  --blue: #61afef;
  --yellow: #e5c07b;
}

.theme-light {
  --background-primary: #fafafa;
  --background-primary-alt: #eaeaeb;
  --background-secondary: #eaeaeb;
  --background-secondary-alt: #dbdbdc;
  --background-accent: #fff;
  --background-modifier-border: #dbdbdc;
  --background-modifier-form-field: #fff;
  --background-modifier-form-field-highlighted: #fff;
  --background-modifier-box-shadow: rgba(0, 0, 0, 0.1);
  --background-modifier-success: #A4E7C3;
  --background-modifier-error: #e68787;
  --background-modifier-error-rgb: 230, 135, 135;
  --background-modifier-error-hover: #FF9494;
  --background-modifier-cover: rgba(0, 0, 0, 0.8);
  --text-accent: #1592ff;
  --text-accent-hover: #2d9dff;
  --text-normal: #383a42;
  --text-muted: #8e8e90;
  --text-faint: #999999;
  --text-error: #e75545;
  --text-error-hover: #f86959;
  --text-highlight-bg: rgba(255, 255, 0, 0.4);
  --text-selection: rgba(0, 122, 255, 0.15);
  --text-on-accent: #f2f2f2;
  --interactive-normal: #eaeaeb;
  --interactive-hover: #dbdbdc;
  --interactive-accent-rgb: 21, 146, 255;
  --interactive-accent: #5871ef;
  --interactive-accent-hover: #445bd1;
  --scrollbar-active-thumb-bg: rgba(0, 0, 0, 0.2);
  --scrollbar-bg: rgba(0, 0, 0, 0.05);
  --scrollbar-thumb-bg: rgba(0, 0, 0, 0.1);
  --panel-border-color: #dbdbdc;

  --gray-1: #383a42;
  --gray-2: #383a42;
  --red: #e75545;
  --green: #4ea24c;
  --blue: #3d74f6;
  --purple: #a625a4;
  --aqua: #0084bc;
  --yellow: #e35649;
  --orange: #986800;
}

body {
  -webkit-font-smoothing: auto;
}

.search-result-file-title {
  color: var(--blue);
}

li {
  padding-top: 0.5px;
  padding-bottom: 0.5px;
}

.tag, .tag:hover {
  color: var(--yellow);
  background-color: var(--background-primary-alt);
  padding: 2px 4px;
  border-radius: 4px;
}

.markdown-preview-view .task-list-item-checkbox {
  -webkit-appearance: none;
  box-sizing: border-box;
  border: 1px solid var(--text-muted);
  border-radius: 2px;
  position: relative;
  width: 1.3em;
  height: 1.3em;
  margin: 0;
  filter: none;
  outline: none;
  margin-right: 4px;
  margin-bottom: 2px;
  cursor: pointer;
  vertical-align: baseline;
}

.markdown-preview-view .task-list-item-checkbox:checked {
  border: none;
  background-color: var(--interactive-accent);
}

.markdown-preview-view .task-list-item-checkbox:checked::before {
  content: ' ';
  position: absolute;
  background-color: white;
  left: 2px;
  top: 2px;
  right: 2px;
  bottom: 2px;
  -webkit-mask-image: url('data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' viewBox=\'0 0 14 14\'%3E%3Cpolygon points=\'5.5 11.9993304 14 3.49933039 12.5 2 5.5 8.99933039 1.5 4.9968652 0 6.49933039\'%3E%3C/polygon%3E%3C/svg%3E');
}

.nav-file-title, .nav-folder-title {
  display: flex;
  align-items: baseline;
  flex-direction: row;
}

.nav-file-title-content, .nav-folder-title-content {
  white-space: nowrap;
  text-overflow: ellipsis;
  overflow: hidden;
  display: block;
}

.markdown-preview-view.is-readable-line-width .markdown-preview-section,
.markdown-source-view.is-readable-line-width .CodeMirror {
  max-width: 900px !important;
  line-height: 26px;
}

blockquote {
  margin: 20px 0;
}

body {
  --font-monospace: 'Fira Code', 'Source Code Pro', monospace;
}

mjx-container[jax='CHTML'] {
  text-align: left;
  outline: none;
  font-size: 20px;
}

.cm-s-obsidian pre.HyperMD-codeblock,
.cm-s-obsidian span.cm-inline-code,
.cm-s-obsidian span.cm-math:not(.cm-formatting-math-begin):not(.cm-formatting-math-end),
.markdown-preview-view code {
  color: inherit;
}

.cm-s-obsidian span.cm-inline-code,
.cm-s-obsidian span.cm-math,
.cm-s-obsidian span.hmd-fold-math-placeholder {
  font-weight: 600;
  font-style: normal;
}

.markdown-preview-view code {
  vertical-align: text-top;
  word-break: break-word;
}

.markdown-preview-section:not(:first-child) h1,
.markdown-preview-section:not(:first-child) h2,
.markdown-preview-section:not(:first-child) h3,
.markdown-preview-section:not(:first-child) h4,
.markdown-preview-section:not(:first-child) h5,
.markdown-preview-section:not(:first-child) h6 {
  margin-top: 40px !important;
}

h1, h2, h3, h4, h5, h6, strong, b, .view-header-title {
  font-weight: 600;
}

.workspace > .workspace-split > .workspace-leaf:first-of-type:last-of-type .view-header {
  border: none;
}

.status-bar, .side-dock.mod-right, .side-dock.mod-left {
  border-color: var(--panel-border-color);
  border-width: 1px;
}

.status-bar {
  --bar-vertical-padding: 4px;
  --bar-height: calc(22px + (var(--bar-vertical-padding) * 2));
  line-height: 20px;
  padding: 0 20px;
  height: var(--bar-height);
  max-height: var(--bar-height);
  min-height: var(--bar-height);
  overflow: hidden;
}

.status-bar-item {
  margin: auto 0;
}

.status-bar-item > * {
  padding-top: var(--bar-vertical-padding) !important;
  padding-bottom: var(--bar-vertical-padding) !important;
}

.nav-file.is-active {
  --background-secondary-alt: var(--interactive-accent);
  --text-normal: #ffffff;
}

.nav-file:not(.is-active):hover .nav-file-title,
.nav-folder:hover .nav-folder-content {
  background-color: transparent;
}

.side-dock-plugin-panel-inner {
  padding-left: 6px;
}

a,
.markdown-preview-view .internal-link {
  text-decoration: none;
}

a:hover,
.markdown-preview-view .internal-link:hover {
  text-decoration: underline;
}

.theme-dark :not(pre) > code[class*='language-'],
.theme-dark pre[class*='language-'] {
  background: var(--background-primary-alt);
}

.theme-light :not(pre) > code[class*='language-'],
.theme-light pre[class*='language-'] {
  background: var(--background-primary);
  box-shadow: inset 0 0 0 1px var(--background-primary-alt);
  border-radius: 4px;
}

.markdown-preview-view blockquote {
  border-radius: 4px;
}

.markdown-preview-view .markdown-embed,
.markdown-preview-view .file-embed {
  margin: 0;
  border-radius: 4px;
}

.theme-light .token.operator,
.theme-light .token.entity,
.theme-light .token.url,
.theme-light .language-css .token.string,
.theme-light .style .token.string {
  background: transparent;
}

body:not(.is-grabbing) .nav-file:not(.is-active) .nav-file-title:hover,
body:not(.is-grabbing) .nav-folder:not(.is-active) .nav-folder-title:hover {
  --text-normal: var(--text-muted);
  --background-secondary-alt: var(--background-secondary);
}

/* Source: https://github.com/AGMStudio/prism-theme-one-dark */

code[class*='language-'],
pre[class*='language-'] {
  text-align: left !important;
  white-space: pre !important;
  word-spacing: normal !important;
  word-break: normal !important;
  word-wrap: normal !important;
  line-height: 1.5 !important;
  -moz-tab-size: 4 !important;
  -o-tab-size: 4 !important;
  tab-size: 4 !important;
  -webkit-hyphens: none !important;
  -moz-hyphens: none !important;
  -ms-hyphens: none !important;
  hyphens: none !important;
}

/* Code blocks */
pre[class*='language-'] {
  padding: 1em !important;
  margin: .5em 0 !important;
  overflow: auto !important;
}

/* Inline code */
:not(pre) > code[class*='language-'] {
  padding: .1em !important;
  border-radius: .3em !important;
  white-space: normal !important;
}

.token.comment,
.token.prolog,
.token.doctype,
.token.cdata {
  color: var(--gray-1) !important;
}

.token.punctuation {
  color: var(--gray-2) !important;
}

.token.selector,
.token.tag {
  color: var(--red) !important;
}

.token.property,
.token.boolean,
.token.number,
.token.constant,
.token.symbol,
.token.attr-name,
.token.deleted {
  color: var(--orange) !important;
}

.token.string,
.token.char,
.token.attr-value,
.token.builtin,
.token.inserted {
  color: var(--green) !important;
}

.token.operator,
.token.entity,
.token.url,
.language-css .token.string,
.style .token.string {
  color: var(--aqua) !important;
}

.token.atrule,
.token.keyword {
  color: var(--purple) !important;
}

.token.function,
.token.macro.property {
  color: var(--blue) !important;
}

.token.class-name {
  color: var(--yellow) !important;
}

.token.regex,
.token.important,
.token.variable {
  color: var(--purple) !important;
}

.token.important,
.token.bold {
  font-weight: bold !important;
}

.token.italic {
  font-style: italic !important;
}

.token.entity {
  cursor: help !important;
}

pre.line-numbers {
  position: relative !important;
  padding-left: 3.8em !important;
  counter-reset: linenumber !important;
}

pre.line-numbers > code {
  position: relative !important;
}

.line-numbers .line-numbers-rows {
  position: absolute !important;
  pointer-events: none !important;
  top: 0 !important;
  font-size: 100% !important;
  left: -3.8em !important;
  width: 3em !important; /* works for line-numbers below 1000 lines */
  letter-spacing: -1px !important;
  border-right: 0 !important;

  -webkit-user-select: none !important;
  -moz-user-select: none !important;
  -ms-user-select: none !important;
  user-select: none !important;
}

.line-numbers-rows > span {
  pointer-events: none !important;
  display: block !important;
  counter-increment: linenumber !important;
}

.line-numbers-rows > span:before {
  content: counter(linenumber) !important;
  color: var(--syntax-gray-1) !important;
  display: block !important;
  padding-right: 0.8em !important;
  text-align: right !important;
}
'''
