/*
 * Decompiled with CFR 0.152.
 */
package io.github.prospector.modmenu;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.prospector.modmenu.api.ConfigScreenFactory;
import io.github.prospector.modmenu.api.ModMenuApi;
import io.github.prospector.modmenu.config.ModMenuConfigManager;
import io.github.prospector.modmenu.util.HardcodedUtil;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModMenu
implements ClientModInitializer {
    public static final String MOD_ID = "modmenu";
    public static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().create();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<String, Runnable> LEGACY_CONFIG_SCREEN_TASKS = new HashMap<String, Runnable>();
    public static final Set<String> LIBRARY_MODS = new HashSet<String>();
    public static final Set<String> ROOT_LIBRARIES = new HashSet<String>();
    public static final Set<String> CHILD_LIBRARIES = new HashSet<String>();
    public static final Set<String> ALL_NONLIB_MODS = new HashSet<String>();
    public static final Set<String> ROOT_NONLIB_MODS = new HashSet<String>();
    public static final Set<String> CHILD_NONLIB_MODS = new HashSet<String>();
    public static final Set<String> CLIENTSIDE_MODS = new HashSet<String>();
    public static final Set<String> DEPRECATED_MODS = new HashSet<String>();
    public static final Set<String> PATCHWORK_FORGE_MODS = new HashSet<String>();
    public static final LinkedListMultimap<ModContainer, ModContainer> PARENT_MAP = LinkedListMultimap.create();
    private static ImmutableMap<String, ConfigScreenFactory<?>> configScreenFactories = ImmutableMap.of();

    public static boolean hasConfigScreenFactory(String modid) {
        try {
            return configScreenFactories.containsKey((Object)modid) && ((ConfigScreenFactory)configScreenFactories.get((Object)modid)).create(class_310.method_1551().field_1755) != null;
        }
        catch (Throwable e) {
            LOGGER.error("Caught exception from " + modid + " on ModMenu.hasConfigScreenFactory");
            e.printStackTrace();
            return false;
        }
    }

    public static class_437 getConfigScreen(String modid, class_437 menuScreen) {
        ConfigScreenFactory factory = (ConfigScreenFactory)configScreenFactories.get((Object)modid);
        return factory != null ? (class_437)factory.create(menuScreen) : null;
    }

    public static void openConfigScreen(String modid) {
        Runnable opener = LEGACY_CONFIG_SCREEN_TASKS.get(modid);
        if (opener != null) {
            opener.run();
        }
    }

    public static void addLegacyConfigScreenTask(String modid, Runnable task) {
        LEGACY_CONFIG_SCREEN_TASKS.putIfAbsent(modid, task);
    }

    public static boolean hasLegacyConfigScreenTask(String modid) {
        return LEGACY_CONFIG_SCREEN_TASKS.containsKey(modid);
    }

    public static void addLibraryMod(String modid) {
        LIBRARY_MODS.add(modid);
    }

    public void onInitializeClient() {
        ModMenuConfigManager.initializeConfig();
        HashMap factories = new HashMap();
        FabricLoader.getInstance().getEntrypointContainers(MOD_ID, ModMenuApi.class).forEach(entrypoint -> {
            ModMenuApi api = (ModMenuApi)entrypoint.getEntrypoint();
            factories.put(entrypoint.getProvider().getMetadata().getId(), api.getModConfigScreenFactory());
            api.getProvidedConfigScreenFactories().forEach(factories::putIfAbsent);
        });
        configScreenFactories = new ImmutableMap.Builder().putAll(factories).build();
        Collection mods = FabricLoader.getInstance().getAllMods();
        HardcodedUtil.initializeHardcodings();
        for (ModContainer mod : mods) {
            boolean clientsideOnlyValue;
            boolean isLibrary;
            ModMetadata metadata = mod.getMetadata();
            String id = metadata.getId();
            if ("minecraft".equals(id)) continue;
            boolean bl = isLibrary = metadata.containsCustomValue("modmenu:api") && metadata.getCustomValue("modmenu:api").getAsBoolean() || metadata.containsCustomValue("fabric-loom:generated") && metadata.getCustomValue("fabric-loom:generated").getAsBoolean();
            if (isLibrary) {
                ModMenu.addLibraryMod(id);
            }
            boolean hasClientValue = metadata.containsCustomValue("modmenu:clientsideOnly");
            boolean clientEnvironmentOnly = metadata.getEnvironment() == ModEnvironment.CLIENT;
            boolean bl2 = clientsideOnlyValue = hasClientValue && metadata.getCustomValue("modmenu:clientsideOnly").getAsBoolean();
            if (clientEnvironmentOnly && !hasClientValue || hasClientValue && clientsideOnlyValue) {
                if (clientEnvironmentOnly && clientsideOnlyValue) {
                    LOGGER.info("Mod '" + metadata.getId() + "' uses the modmenu:clientsideOnly custom value unnecessarily, as it can be inferred from the mod's declared environment.");
                }
                CLIENTSIDE_MODS.add(id);
            }
            if (metadata.containsCustomValue("modmenu:deprecated") && metadata.getCustomValue("modmenu:deprecated").getAsBoolean()) {
                DEPRECATED_MODS.add(id);
            }
            if (metadata.containsCustomValue("patchwork:patcherMeta")) {
                PATCHWORK_FORGE_MODS.add(id);
            }
            boolean hasParent = false;
            if (metadata.containsCustomValue("modmenu:parent")) {
                Optional parent;
                String parentId = metadata.getCustomValue("modmenu:parent").getAsString();
                if (parentId != null && (parent = FabricLoader.getInstance().getModContainer(parentId)).isPresent()) {
                    hasParent = true;
                    PARENT_MAP.put(parent.get(), (Object)mod);
                    if (isLibrary) {
                        CHILD_LIBRARIES.add(id);
                    } else {
                        CHILD_NONLIB_MODS.add(id);
                        ALL_NONLIB_MODS.add(id);
                    }
                }
            } else {
                HardcodedUtil.hardcodeModuleMetadata(mod, metadata, id);
                isLibrary = LIBRARY_MODS.contains(id);
                hasParent = PARENT_MAP.containsValue((Object)mod);
            }
            if (isLibrary) {
                (hasParent ? CHILD_LIBRARIES : ROOT_LIBRARIES).add(id);
                continue;
            }
            (hasParent ? CHILD_NONLIB_MODS : ROOT_NONLIB_MODS).add(id);
            ALL_NONLIB_MODS.add(id);
        }
    }

    public static String getDisplayedModCount() {
        return NumberFormat.getInstance().format(ROOT_NONLIB_MODS.size());
    }
}

