/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import carpet.utils.Messenger;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;

public class CarpetProfiler {
    private static final Map<String, Long> SECTION_STATS = new HashMap<String, Long>();
    private static final Object2LongMap<Pair<class_1937, Object>> ENTITY_TIMES = new Object2LongOpenHashMap();
    private static final Object2LongMap<Pair<class_1937, Object>> ENTITY_COUNT = new Object2LongOpenHashMap();
    private static class_2168 currentRequester = null;
    public static int tick_health_requested = 0;
    private static int tick_health_elapsed = 0;
    private static TYPE test_type = TYPE.NONE;
    private static long current_tick_start = 0L;
    private static final String[] GENERAL_SECTIONS = new String[]{"Network", "Autosave", "Async Tasks", "Datapacks"};
    private static final String[] SECTIONS = new String[]{"Spawning and Random Ticks", "Ticket Manager", "Unloading", "Blocks", "Entities", "Block Entities", "Entities (Client)", "Block Entities (Client)", "Village", "Environment"};

    private static String getSectionString(class_1937 world, String section) {
        return String.format("%s.%s%s", world.method_27983().method_29177().method_12832(), section, world.field_9236 ? " (Client)" : "");
    }

    private static String getDimName(class_5321<class_1937> world) {
        return world.method_29177().method_12832();
    }

    public static void prepare_tick_report(class_2168 source, int ticks) {
        SECTION_STATS.clear();
        ENTITY_COUNT.clear();
        ENTITY_TIMES.clear();
        test_type = TYPE.GENERAL;
        SECTION_STATS.put("tick", 0L);
        SECTION_STATS.put("Network", 0L);
        SECTION_STATS.put("Autosave", 0L);
        for (String section : GENERAL_SECTIONS) {
            SECTION_STATS.put(section, 0L);
        }
        for (class_5321 level : source.method_9211().method_29435()) {
            for (String section : SECTIONS) {
                SECTION_STATS.put(CarpetProfiler.getDimName((class_5321<class_1937>)level) + "." + section, 0L);
            }
        }
        tick_health_elapsed = ticks;
        tick_health_requested = ticks;
        current_tick_start = 0L;
        currentRequester = source;
    }

    public static void prepare_entity_report(class_2168 source, int ticks) {
        SECTION_STATS.clear();
        SECTION_STATS.put("tick", 0L);
        ENTITY_COUNT.clear();
        ENTITY_TIMES.clear();
        test_type = TYPE.ENTITY;
        tick_health_elapsed = ticks;
        tick_health_requested = ticks;
        current_tick_start = 0L;
        currentRequester = source;
    }

    public static ProfilerToken start_section(class_1937 world, String name, TYPE type) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.GENERAL || current_tick_start == 0L) {
            return null;
        }
        return new ProfilerToken(type, name, world, System.nanoTime());
    }

    public static ProfilerToken start_entity_section(class_1937 world, class_1297 e, TYPE type) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.ENTITY || current_tick_start == 0L) {
            return null;
        }
        return new ProfilerToken(type, e.method_5864(), world, System.nanoTime());
    }

    public static ProfilerToken start_block_entity_section(class_1937 world, class_2586 be, TYPE type) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.ENTITY || current_tick_start == 0L) {
            return null;
        }
        return new ProfilerToken(type, be.method_11017(), world, System.nanoTime());
    }

    public static void end_current_section(ProfilerToken tok) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.GENERAL || current_tick_start == 0L || tok == null) {
            return;
        }
        long end_time = System.nanoTime();
        if (tok.type == TYPE.GENERAL) {
            String current_section;
            String string = current_section = tok.world == null ? (String)tok.section : CarpetProfiler.getSectionString(tok.world, (String)tok.section);
            if (SECTION_STATS.get(current_section) == null) {
                CarpetSettings.LOG.error("Current section: " + current_section);
            } else {
                SECTION_STATS.put(current_section, SECTION_STATS.get(current_section) + end_time - tok.start);
            }
        }
    }

    public static void end_current_entity_section(ProfilerToken tok) {
        if ((long)tick_health_requested == 0L || test_type != TYPE.ENTITY || current_tick_start == 0L || tok == null) {
            return;
        }
        long end_time = System.nanoTime();
        Pair section = Pair.of((Object)tok.world, (Object)tok.section);
        ENTITY_TIMES.put((Object)section, ENTITY_TIMES.getOrDefault((Object)section, 0L) + end_time - tok.start);
        ENTITY_COUNT.put((Object)section, ENTITY_COUNT.getOrDefault((Object)section, 0L) + 1L);
    }

    public static void start_tick_profiling() {
        current_tick_start = System.nanoTime();
    }

    public static void end_tick_profiling(MinecraftServer server, ProfilerToken postTasks) {
        if (current_tick_start == 0L) {
            return;
        }
        if (postTasks != null) {
            CarpetProfiler.end_current_section(postTasks);
        }
        SECTION_STATS.put("tick", SECTION_STATS.get("tick") + System.nanoTime() - current_tick_start);
        if (--tick_health_elapsed <= 0) {
            CarpetProfiler.finalize_tick_report(server);
        }
    }

    public static void finalize_tick_report(MinecraftServer server) {
        if (test_type == TYPE.GENERAL) {
            CarpetProfiler.finalize_tick_report_for_time(server);
        }
        if (test_type == TYPE.ENTITY) {
            CarpetProfiler.finalize_tick_report_for_entities(server);
        }
        CarpetProfiler.cleanup_tick_report();
    }

    public static void cleanup_tick_report() {
        SECTION_STATS.clear();
        SECTION_STATS.put("tick", 0L);
        ENTITY_TIMES.clear();
        ENTITY_COUNT.clear();
        test_type = TYPE.NONE;
        tick_health_elapsed = 0;
        tick_health_requested = 0;
        current_tick_start = 0L;
        currentRequester = null;
    }

    public static void finalize_tick_report_for_time(MinecraftServer server) {
        if (currentRequester == null) {
            return;
        }
        long total_tick_time = SECTION_STATS.get("tick");
        double divider = 1.0 / (double)tick_health_requested / 1000000.0;
        Messenger.m(currentRequester, "w ");
        Messenger.m(currentRequester, String.format("gi Avg. server tick time: %.3fms", divider * (double)total_tick_time));
        long accumulated = 0L;
        for (String section : GENERAL_SECTIONS) {
            double amount = divider * (double)SECTION_STATS.get(section).longValue();
            if (!(amount > 0.01)) continue;
            accumulated += SECTION_STATS.get(section).longValue();
            Messenger.m(currentRequester, String.format("gi %s: %.3fms", section, amount));
        }
        for (class_5321 dim : server.method_29435()) {
            double amount;
            String dimension = CarpetProfiler.getDimName((class_5321<class_1937>)dim);
            boolean hasSomethin = false;
            for (String section : SECTIONS) {
                amount = divider * (double)SECTION_STATS.get(dimension + "." + section).longValue();
                if (!(amount > 0.01)) continue;
                hasSomethin = true;
                break;
            }
            if (!hasSomethin) continue;
            Messenger.m(currentRequester, "gi " + dimension + ":");
            for (String section : SECTIONS) {
                amount = divider * (double)SECTION_STATS.get(dimension + "." + section).longValue();
                if (!(amount > 0.01)) continue;
                if (!section.endsWith("(Client)")) {
                    accumulated += SECTION_STATS.get(dimension + "." + section).longValue();
                }
                Messenger.m(currentRequester, String.format("gi  - %s: %.3fms", section, amount));
            }
        }
        long rest = total_tick_time - accumulated;
        Messenger.m(currentRequester, String.format("gi The Rest, whatever that might be: %.3fms", divider * (double)rest));
    }

    private static String sectionName(Pair<class_1937, Object> section) {
        String name = section.getValue() instanceof class_1299 ? class_2378.field_11145.method_10221((Object)((class_1299)section.getValue())).method_12832() : class_2378.field_11137.method_10221((Object)((class_2591)section.getValue())).method_12832();
        if (((class_1937)section.getKey()).field_9236) {
            name = name + " (client)";
        }
        String dim = ((class_1937)section.getKey()).method_27983().method_29177().method_12832();
        return name + " in " + dim;
    }

    public static void finalize_tick_report_for_entities(MinecraftServer server) {
        Pair section;
        if (currentRequester == null) {
            return;
        }
        long total_tick_time = SECTION_STATS.get("tick");
        double divider = 1.0 / (double)tick_health_requested / 1000000.0;
        double divider_1 = 1.0 / (double)(tick_health_requested - 1) / 1000000.0;
        Messenger.m(currentRequester, "gi ");
        Messenger.m(currentRequester, String.format("gi Average tick time: %.3fms", divider * (double)total_tick_time));
        SECTION_STATS.remove("tick");
        Messenger.m(currentRequester, "gi Top 10 counts:");
        int total = 0;
        for (Object2LongMap.Entry sectionEntry : ENTITY_COUNT.object2LongEntrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList())) {
            if (++total > 10) break;
            section = (Pair)sectionEntry.getKey();
            Messenger.m(currentRequester, String.format("gi  - %s: %.1f", CarpetProfiler.sectionName((Pair<class_1937, Object>)section), 1.0 * (double)sectionEntry.getLongValue() / (double)(tick_health_requested - (((class_1937)section.getKey()).field_9236 ? 1 : 0))));
        }
        Messenger.m(currentRequester, "gi Top 10 CPU hogs:");
        total = 0;
        for (Object2LongMap.Entry sectionEntry : ENTITY_TIMES.object2LongEntrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).collect(Collectors.toList())) {
            if (++total > 10) break;
            section = (Pair)sectionEntry.getKey();
            Messenger.m(currentRequester, String.format("gi  - %s: %.2fms", CarpetProfiler.sectionName((Pair<class_1937, Object>)section), (((class_1937)section.getKey()).field_9236 ? divider : divider_1) * (double)sectionEntry.getLongValue()));
        }
    }

    public static class ProfilerToken {
        public final TYPE type;
        public final Object section;
        public final long start;
        public final class_1937 world;

        public ProfilerToken(TYPE type, Object section, class_1937 world, long start) {
            this.type = type;
            this.section = section;
            this.start = start;
            this.world = world;
        }
    }

    public static enum TYPE {
        NONE,
        GENERAL,
        ENTITY,
        TILEENTITY;

    }
}

