/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.exception.InternalExpressionException;
import carpet.script.value.AbstractListValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public abstract class LazyListValue
extends AbstractListValue
implements Iterator<Value> {
    public static LazyListValue range(final long from, final long to, final long step) {
        return new LazyListValue(){
            private long start;
            private long current;
            private long limit;
            private long stepp;
            {
                if (step == 0L) {
                    throw new InternalExpressionException("Range will never end with a zero step");
                }
                this.current = this.start = from;
                this.limit = to;
                this.stepp = step;
            }

            @Override
            public Value next() {
                NumericValue val = new NumericValue(this.current);
                this.current += this.stepp;
                return val;
            }

            @Override
            public void reset() {
                this.current = this.start;
            }

            @Override
            public boolean hasNext() {
                return this.stepp > 0L ? this.current < this.limit : this.current > this.limit;
            }

            @Override
            public String getString() {
                return String.format(Locale.ROOT, "[%d, %d, ..., %d)", this.start, this.start + this.stepp, this.limit);
            }
        };
    }

    @Override
    public String getString() {
        return "[...]";
    }

    @Override
    public boolean getBoolean() {
        return this.hasNext();
    }

    @Override
    public abstract boolean hasNext();

    @Override
    public abstract Value next();

    @Override
    public void fatality() {
        this.reset();
    }

    public abstract void reset();

    @Override
    public Iterator<Value> iterator() {
        return this;
    }

    public List<Value> unroll() {
        ArrayList<Value> result = new ArrayList<Value>();
        this.forEachRemaining(result::add);
        this.fatality();
        return result;
    }

    @Override
    public Value slice(long from, long to) {
        if (to < 0L) {
            to = Integer.MAX_VALUE;
        }
        if (from < 0L) {
            from = 0L;
        }
        if (from > to) {
            return ListValue.of(new Value[0]);
        }
        ArrayList<Value> result = new ArrayList<Value>();
        int i = 0;
        while ((long)i < from) {
            if (!this.hasNext()) {
                this.fatality();
                return ListValue.wrap(result);
            }
            this.next();
            ++i;
        }
        i = (int)from;
        while ((long)i < to) {
            if (!this.hasNext()) {
                this.fatality();
                return ListValue.wrap(result);
            }
            result.add(this.next());
            ++i;
        }
        return ListValue.wrap(result);
    }

    @Override
    public Value add(Value other) {
        throw new InternalExpressionException("Cannot add to iterators");
    }

    @Override
    public boolean equals(Object o) {
        return false;
    }

    @Override
    public String getTypeString() {
        return "iterator";
    }

    public Object clone() {
        Object copy;
        try {
            copy = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalExpressionException("Cannot copy iterators");
        }
        ((LazyListValue)copy).reset();
        return copy;
    }

    @Override
    public int hashCode() {
        return ("i" + this.getString()).hashCode();
    }

    @Override
    public class_2520 toTag(boolean force) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        return class_2519.method_23256((String)this.getString());
    }
}

