# Minimal Core.
class console:
    @classmethod
    def create(self, **kwd):
        return self()

    def __init__(self):
        self.input_queue = []


    # I/O -- from compartment.world.peer.
    prompt = '-> '
    debug = False

    def next_command(self):
        # Embedded compartment compliance.
        try:
            try: return self.input_queue[0]
            finally: del self.input_queue[0]
        except IndexError: pass

    def _get_input(self):
        return self.next_command()
    def _set_input(self, input):
        self.forceInput(input)
        core.event += self.handleNextInput

    input = property(_get_input, _set_input) # Embedded compartment compliance.
    del _get_input, _set_input

    def forceInput(self, input):
        # Embedded compartment compliance.
        self.input_queue.append(input)

    def handleCommand(self, comm):
        if comm:
            # if self.interpreter and self.interpreter(self, comm):
            #     return

            from game import nanny
            nanny.handleInput(self, comm)

    def handleNextInput(self):
        comm = self.next_command()
        self.handleCommand(comm)


def runCore(argv = None):
    from stuphos.components.system.core import Core
    from stuphos.components.system.cli import getCmdln, parseCmdln, ConsoleBusiness
    from stuphos.components.system.api import world
    from stuphos.components.system import network # Installing bridge events.


    # But only for world-booting purposes which don't exist without a directory:
    # def bootWorld(self, options, stuphlib, worldModule):
    #     if options.world_dir:

    stuphlib = None


    class baseConsole(console, ConsoleBusiness):
        pass


    # Run application -- might want to provide at least the headless option.
    Core(parseCmdln(getCmdln(argv)),
         stuphlib, world,
         globalize = True,
         consoleClass = baseConsole)


if __name__ == '__main__':
    runCore()

