#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['satmad',
 'satmad.coordinates',
 'satmad.coordinates.tests',
 'satmad.core',
 'satmad.core.tests',
 'satmad.propagation',
 'satmad.propagation.tests',
 'satmad.propagation.tests.num_prop_analysis',
 'satmad.tests',
 'satmad.utils',
 'satmad.utils.tests']

package_data = \
{'': ['*'],
 'satmad': ['data/*', 'temp/*'],
 'satmad.coordinates': ['data/*'],
 'satmad.coordinates.tests': ['.pytest_cache/*',
                              '.pytest_cache/v/*',
                              '.pytest_cache/v/cache/*'],
 'satmad.tests': ['data/*'],
 'satmad.utils.tests': ['.pytest_cache/*',
                        '.pytest_cache/v/*',
                        '.pytest_cache/v/cache/*']}

install_requires = \
['astropy', 'matplotlib', 'numpy', 'portion', 'scipy', 'sgp4']

extras_require = \
{'doc': ['sphinx'], 'test': ['pytest', 'pytest-cov', 'pytest-xdist']}

setup(name='satmad',
      version='0.0.7',
      description='satmad',
      author='Egemen Imre',
      author_email=None,
      url='https://github.com/egemenimre/satmad/',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
     )
