# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['figenv']
setup_kwargs = {
    'name': 'figenv',
    'version': '0.1.4',
    'description': 'Metaclass for handling configuration class objects using environment variables',
    'long_description': "Figenv\n======\n\nMetaclass for handling configuration class objects using environment variables.\n\nIf an environment variable is specified, the metaclass will pull the variable\nfrom the environment, the variable defined on the class will be used.\n\nThis was built to be a dropin replacement for `flask-env\n<https://pypi.org/project/Flask-Env/>`_ but supporting change environment\nvariables after the meta class is loaded.\n\nConfig\n------\n\nThere are 2 configuration options, that are set on the base class object.\n\n``ENV_LOAD_ALL = <True/False>``\n\n   Setting this on the class will allow loading any environment variable even\n   if it is not set on the base class.\n\n``ENV_PREFIX = <string>``\n\n   Setting this will will be a prefix for variables in the environment.\n\nInstall\n-------\n\nThis should just be pip installed\n\n.. code-block:: bash\n\n   python3 -m pip install figenv\n\nUsage\n-----\n\nThe basic usecase is below.\n\n.. code-block:: python\n\n   import os\n\n   import figenv\n\n   class Config(metaclass=figenv.MetaConfig):\n\n      ENV_LOAD_ALL = True\n      ENV_PREFIX = 'ROCKSTEADY_'\n\n      BLAH = True\n      TIMEOUT = 5\n\n   assert Config.TIMEOUT == 5\n   assert Config.BLAH is True\n   try:\n       Config.WHAT\n   except AttributeError:\n       pass\n\n   os.environ.update({\n       'ROCKSTEADY_BLAH': 'false',\n       'ROCKSTEADY_TIMEOUT': '15',\n       'ROCKSTEADY_WHAT': '2.9',\n   })\n\n   assert Config.TIMEOUT == 15\n   assert Config.BLAH is False\n   assert Config.WHAT == 2.9\n",
    'author': 'Daniel Wallace',
    'author_email': 'daniel@gtmanfred.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'py_modules': modules,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
