# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sports',
 'sports.fb',
 'sports.mlb',
 'sports.nba',
 'sports.ncaab',
 'sports.ncaaf',
 'sports.nfl',
 'sports.nhl']

package_data = \
{'': ['*']}

install_requires = \
['numpy>=1.21.3,<2.0.0', 'pandas>=0.24.1', 'pyquery>=1.4.0', 'requests>=2.18.4']

setup_kwargs = {
    'name': 'pysports-stats',
    'version': '0.2.0.post1',
    'description': 'A free sports API written for python',
    'long_description': "sports: A free sports API written for python\n###############################################\n**Development Status: This project is no longer undergoing active development. Please consider\nopening a pull request for any new features or bug fixes to be reviewed and\nmerged.**\n\n.. image:: https://github.com/bveber/pysports-stats/actions/workflows/build.yml/badge.svg\n    :target: https://github.com/bveber/sports/actions\n.. image:: https://readthedocs.org/projects/pysports-stats/badge/?version=latest\n    :target: https://pysports-stats.readthedocs.io/en/latest/?badge=latest\n    :alt: Documentation Status\n.. image:: https://img.shields.io/pypi/v/pysports-stats.svg\n    :target: https://pypi.org/project/pysports-stats\n\n.. contents::\n\nsports is a free python API that pulls the stats from\nwww.sports-reference.com and allows them to be easily be used in python-based\napplications, especially ones involving data analytics and machine learning.\n\nsports exposes a plethora of sports information from major sports\nleagues in North America, such as the MLB, NBA, College Football and Basketball,\nNFL, and NHL. sports also now supports Professional Football (or\nSoccer) for thousands of teams from leagues around the world. Every sport has\nits own set of valid API queries ranging from the list of teams in a league, to\nthe date and time of a game, to the total number of wins a team has secured\nduring the season, and many, many more metrics that paint a more detailed\npicture of how a team has performed during a game or throughout a season.\n\nNOTE (2022-11-23): The source website has implemented traffic restrictions that \nwill result in your IP being temporarily blacklisted if you exceed 20 requests \nper minute. Therefore all outgoing requests are now passed through a utility function\nthat ensures you will not surpass the rate limit threshold. This runtime slowdown\nis most noticeable for sports with many teams. If you are trying to bulk gather data\nyou will need to schedule a long running job, and its recommended that you cache any \nhistorical data you intend to reuse.\n\n\nInstallation\n============\n\nTODO: This has not been released to Pypi yet, so standard pip install will not work.\nBut I'm keepin the documentation as a template for now. \n\nThe easiest way to install `pysports-stats` is by downloading the latest\nreleased binary from PyPI using PIP. For instructions on installing PIP, visit\n`PyPA.io <https://pip.pypa.io/en/stable/installing/>`_ for detailed steps on\ninstalling the package manager for your local environment.\n\nNext, run::\n\n    pip install pysports-stats\n\nto download and install the latest official release of `pysports-stats` on\nyour machine. You now have the latest stable version of `pysports-stats`\ninstalled and can begin using it following the examples below!\n\nIf the bleeding-edge version of `pysports-stats` is desired, clone this\nrepository using git and install all of the package requirements with PIP::\n\n    git clone https://github.com/bveber/pysports-stats\n    cd pysports-stats\n    poetry install\n\nOnce complete, create a Python wheel for your default version of Python by\nrunning the following command::\n\n    poetry build\n\nThis will create a `.whl` file in the `dist` directory which can be installed\nwith the following command::\n\n    pip install dist/*.whl\n\nExamples\n========\n\nThe following are a few examples showcasing how easy it can be to collect\nan abundance of metrics and information from all of the tracked leagues. The\nexamples below are only a miniscule subset of the total number of statistics\nthat can be pulled using pysports-stats. TODO: Create documentation \n\nGet instances of all NHL teams for the 2018 season\n--------------------------------------------------\n\n.. code-block:: python\n\n    from sports.nhl.teams import Teams\n\n    teams = Teams(2018)\n\nPrint every NBA team's name and abbreviation\n--------------------------------------------\n\n.. code-block:: python\n\n    from sports.nba.teams import Teams\n\n    teams = Teams()\n    for team in teams:\n        print(team.name, team.abbreviation)\n\nGet a specific NFL team's season information\n--------------------------------------------\n\n.. code-block:: python\n\n    from sports.nfl.teams import Teams\n\n    teams = Teams()\n    lions = teams('DET')\n\nPrint the date of every game for a NCAA Men's Basketball team\n-------------------------------------------------------------\n\n.. code-block:: python\n\n    from sports.ncaab.schedule import Schedule\n\n    purdue_schedule = Schedule('purdue')\n    for game in purdue_schedule:\n        print(game.date)\n\nPrint the number of interceptions by the away team in a NCAA Football game\n--------------------------------------------------------------------------\n\n.. code-block:: python\n\n    from sports.ncaaf.boxscore import Boxscore\n\n    championship_game = Boxscore('2018-01-08-georgia')\n    print(championship_game.away_interceptions)\n\nGet a Pandas DataFrame of all stats for a MLB game\n--------------------------------------------------\n\n.. code-block:: python\n\n    from sports.mlb.boxscore import Boxscore\n\n    game = Boxscore('BOS201806070')\n    df = game.dataframe\n\nFind the number of goals a football team has scored\n---------------------------------------------------\n\n.. code-block:: python\n\n    from sports.fb.team import Team\n\n    tottenham = Team('Tottenham Hotspur')\n    print(tottenham.goals_scored)\n\nDocumentation\n=============\n\nThis repository is based on `sportsipy`. I am incredibly grateful for\nthe work done by Robert Clark in creating this code base. Some internal components\nhave been changed, but the basic interface remains the same.\nTwo blog posts detailing the creation and basic usage of `sportsipy` can\nbe found on The Medium at the following links:\n\n- `Part 1: Creating a public sports API <https://medium.com/clarktech-sports/python-sports-analytics-made-simple-part-1-14569d6e9a86>`_\n- `Part 2: Pull any sports metric in 10 lines of Python <https://medium.com/clarktech-sports/python-sports-analytics-made-simple-part-2-40e591a7f3db>`_\n\nThe second post in particular is a great guide for getting started with\n`pysports-stats` and is highly recommended for anyone who is new to the\npackage. \n\nTesting\n=======\n\nPysports-stats contains a testing suite which aims to test all major portions\nof code for proper functionality. To run the test suite against your\nenvironment, ensure all of the requirements are installed by running::\n\n    pip install -r requirements.txt\n    pip install coverage flexmock mock pycodestyle pytest pytest-cov pytest-xdist\n\nNext, start the tests by running py.test while optionally including coverage\nflags which identify the amount of production code covered by the testing\nframework::\n\n    py.test --cov=sports --cov-report term-missing tests/\n\nIf the tests were successful, it will return a green line will show a message at\nthe end of the output similar to the following::\n\n    ======================= 752 passed in 158.03s (0:02:38) =======================\n\nIf a test failed, it will show the number of failed and what went wrong within\nthe test output. If that's the case, ensure you have the latest version of code\nand are in a supported environment. Otherwise, create an issue on GitHub to\nattempt to get the issue resolved.\n\nNOTE (2022-11-23): Due to traffic restriction on the source webpage the exhaustive\nare unusable. They have been commented out for now, but should be replaced with a more \nsensible set of tests to validate connectivity.",
    'author': 'Brandon Veber',
    'author_email': 'None',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
