# AUTOGENERATED! DO NOT EDIT! File to edit: notebooks/aggregates_from_pote.ipynb (unless otherwise specified).

__all__ = [
    "config",
    "tc",
    "extraction_date",
    "ref_pote_2018",
    "ref_pote_2019",
    "labels",
    "perimeter",
    "metadata",
    "year",
    "liste_des_variables_csg_2018",
    "liste_des_variables_csg_2019",
    "pote",
]

# Cell


import time
import unittest

# import numpy as np
import pandas as pd
from leximpact_socio_fisca_simu_etat.config import Configuration

from .aggregate import Perimeter, Reference

# from typing import List, Union


# from leximpact_socio_fisca_simu_etat.logger import logger
# from ruamel.yaml import YAML
# from tqdm import tqdm


config = Configuration(project_folder="leximpact-aggregates")
tc = unittest.TestCase()


# yaml = YAML()  # typ='unsafe' for testing

extraction_date = time.strftime("%Y-%m-%d")

# Cell

ref_pote_2018 = Reference(
    title="POTE 2018 (DGFIP)",
    href="https://www.casd.eu/source/declarations-dimpot-sur-le-revenu-des-foyers-fiscaux-formulaire-2042-et-annexes/",
)
ref_pote_2019 = Reference(
    title="POTE 2019 (DGFIP)",
    href="https://www.casd.eu/source/declarations-dimpot-sur-le-revenu-des-foyers-fiscaux-formulaire-2042-et-annexes/",
)
labels = {
    "V": "Veuf(ve)",
    "C": "Célibataire",
    "O": "Pacsé(e)s",
    "D": "Divorcé(e)/séparé(e)",
    "M": "Marié(e)s",
}
perimeter = Perimeter(entity="foyer", period="year", geographic="France entière")

# Cell

metadata = {
    "mat": {
        "ux_name": "Situation matrimoniale",
        "description": "Situation matrimoniale du foyer fiscal",
        "openfisca_variable": "statut_marital",
        "ux_template": "Parmi les foyers français {value} sont {label}.",
        "labels": labels,
    },
    "n": {
        "ux_name": "NOMBRE D'ENFANTS MARIÉS RATTACHÉS".lower(),
        "description": "Nombre d'enfants mariés/pacsés et d'enfants non mariés chargés de famille",
        "short_name": "nb_enfants_maries",
        "openfisca_variable": "nbN",
        "ux_template": "Parmi les foyers français {value} ont fait le choix de rattacher {label} enfants mariés ou chargés de famille.",
    },
    "nbefi": {
        "ux_name": "NB TOTAL ENFANT A CHARGE I".lower(),
        "description": "Nombre d'enfants à charge non mariés, qui ne sont pas en résidence alternée, de moins de 18 ans au 1er janvier de l'année de perception des revenus, ou nés durant la même année ou handicapés quel que soit leur âge",
        "openfisca_variable": "nbF",
        "short_name": "nb_enfants_a_charge",
        "ux_template": "Parmi les foyers français {value} sont {label}.",
    },
    "revkire": {
        "ux_name": "Revenu fiscal de référence",
        "openfisca_variable": "rfr",
    },
}
year = "2019"

# Cell
pd.set_option("display.max_colwidth", 80)
pd.options.display.float_format = "{:,.7f}".format

liste_des_variables_csg_2018 = pd.read_csv(
    config.get("DATASETS") + "agregats_des_variables_csg-POTE_2018.csv"
)
liste_des_variables_csg_2019 = pd.read_csv(
    config.get("DATASETS") + "20220407_ExtractAgg/data/agregats_POTE_2019.csv"
)


pote = {"2019": liste_des_variables_csg_2019, "2018": liste_des_variables_csg_2018}

# Cell
