from huobi.model.market.market_detail import MarketDetail

class MarketDetailReq:
    """
     The 24H trade statistics received by request of trade statistics only once.

     :member
         rep: The topic you subscribed.
         ts: The UNIX formatted timestamp generated by server in UTC.
         trade_statistics: The trade statistics.
     """

    def __init__(self):
        self.rep = 0
        self.ts = 0
        self.data = MarketDetail()

    def print_object(self, format_data=""):
        from huobi.utils.print_mix_object import PrintBasic
        PrintBasic.print_basic(self.ts, format_data + "Timestamp")
        PrintBasic.print_basic(self.rep, format_data + "Channel")
        self.data.print_object()