from huobi.model.market.market_detail import MarketDetail

class MarketDetailEvent:
    """
     The 24H trade statistics received by subscription of trade statistics.

     :member
         Channel: topic you subscribe, include symbol.
         timestamp: The UNIX formatted timestamp generated by server in UTC.
         trade_statistics: The trade statistics.
     """

    def __init__(self):
        self.ch = ""
        self.ts = 0
        self.tick = MarketDetail()

    def print_object(self, format_data=""):
        from huobi.utils.print_mix_object import PrintBasic
        PrintBasic.print_basic(self.ch, format_data + "Channel")
        PrintBasic.print_basic(self.ts, format_data + "Timestamp")
        self.tick.print_object()