# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['colrev',
 'colrev.env',
 'colrev.hooks',
 'colrev.ops',
 'colrev.ops.built_in',
 'colrev.ops.built_in.data',
 'colrev.ops.built_in.dedupe',
 'colrev.ops.built_in.load_conversion',
 'colrev.ops.built_in.pdf_get',
 'colrev.ops.built_in.pdf_get_man',
 'colrev.ops.built_in.pdf_prep',
 'colrev.ops.built_in.pdf_prep_man',
 'colrev.ops.built_in.prep',
 'colrev.ops.built_in.prep_man',
 'colrev.ops.built_in.prescreen',
 'colrev.ops.built_in.review_types',
 'colrev.ops.built_in.screen',
 'colrev.ops.built_in.search_sources',
 'colrev.template.custom_scripts',
 'colrev.ui_cli',
 'colrev.ui_web']

package_data = \
{'': ['*'],
 'colrev': ['template/*',
            'template/example/*',
            'template/github_pages/*',
            'template/init/*',
            'template/manuscript/*',
            'template/ops/*',
            'template/prisma/*',
            'template/review_type/curated_masterdata/*',
            'template/review_type/meta_analysis/*'],
 'colrev.ui_web': ['build/*',
                   'build/static/css/*',
                   'build/static/js/*',
                   'public/*',
                   'src/*',
                   'src/components/common/*',
                   'src/components/common/icons/*',
                   'src/components/data/*',
                   'src/components/dedupe/*',
                   'src/components/fields/*',
                   'src/components/packages/*',
                   'src/components/pages/*',
                   'src/components/pdf/*',
                   'src/components/prep/*',
                   'src/components/prescreen/*',
                   'src/components/project/*',
                   'src/components/screen/*',
                   'src/components/search/*',
                   'src/components/sources/*',
                   'src/models/*',
                   'src/services/*']}

install_requires = \
['Flask-Cors>=3.0.10,<4.0.0',
 'Flask>=2.2.2,<3.0.0',
 'GitPython>=3.1.29,<4.0.0',
 'Jinja2>=3.1.2,<4.0.0',
 'PyPDF2>=1.28.6,<2.0.0',
 'PyYAML>=6.0.0,<7.0.0',
 'alphabet-detector>=0.0.7,<0.0.8',
 'beautifulsoup4>=4.11.1,<5.0.0',
 'click8>=8.0.1,<9.0.0',
 'click_completion>=0.5.2,<0.6.0',
 'crossrefapi>=1.5.0,<2.0.0',
 'cx-Freeze>=6.11.1,<7.0.0',
 'dacite>=1.6.0,<2.0.0',
 'daff>=1.3.46,<2.0.0',
 'dataclasses-jsonschema>=2.15.3,<3.0.0',
 'dedupe>=2.0.20,<3.0.0',
 'dictdiffer>=0.9.0,<0.10.0',
 'docker==6.0.0',
 'glom>=22.1.0,<23.0.0',
 'lingua-language-detector>=1.1.3,<2.0.0',
 'lxml>=4.9.1,<5.0.0',
 'nameparser>=1.1.1,<2.0.0',
 'opensearch-py>=2.0.0,<3.0.0',
 'pandas>=1.5.0,<2.0.0',
 'pandasql>=0.7.3,<0.8.0',
 'pdfminer.six>=20220524,<20220525',
 'pre-commit>=2.20.0,<3.0.0',
 'psutil>=5.9.2,<6.0.0',
 'pybtex>=0.24.0,<0.25.0',
 'pycountry>=22.3.5,<23.0.0',
 'python-Levenshtein>=0.12.2,<0.13.0',
 'requests-cache>=0.9.6,<0.10.0',
 'requests>=2.28.1,<3.0.0',
 'thefuzz>=0.19.0,<0.20.0',
 'timeout-decorator>=0.5.0,<0.6.0',
 'tqdm>=4.64.1,<5.0.0',
 'transitions>=0.8.11,<0.9.0',
 'zope.interface>=5.5.0,<6.0.0']

entry_points = \
{'console_scripts': ['colrev = colrev.ui_cli.cli:main',
                     'colrev-hooks-check = colrev.hooks.check:main',
                     'colrev-hooks-format = colrev.hooks.format:main',
                     'colrev-hooks-report = colrev.hooks.report:main',
                     'colrev-hooks-share = colrev.hooks.share:main']}

setup_kwargs = {
    'name': 'colrev',
    'version': '0.7.0',
    'description': 'CoLRev: An open-source environment for collaborative reviews',
    'long_description': '<p align="center">\n<img src="../../figures/logo_small.png" width="400">\n</p>\n\n# Collaborative Literature Reviews (CoLRev)\n\n[![License](https://img.shields.io/github/license/geritwagner/colrev.svg)](https://github.com/geritwagner/colrev/releases/)\n[![Python 3.8](https://img.shields.io/badge/python-3.8-blue.svg)](https://www.python.org/downloads/release/python-380/)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n[![GitHub release](https://img.shields.io/github/v/release/geritwagner/colrev.svg)](https://github.com/geritwagner/colrev/releases/)\n[![PRs Welcome](https://img.shields.io/badge/PRs-welcome-brightgreen.svg?style=flat-square)](https://makeapullrequest.com)\n\nCoLRev is an open-source environment for collaborative reviews.\nTo make major improvements in terms of efficiency and trustworthiness and to automatically augment reviews with community-curated content, CoLRev advances the design of review technology at the intersection of methods, engineering, cognition, and community building.\nCompared to other environments, the following features stand out:\n\n- an **extensible and open platform** based on shared data and process standards\n- builds on **git** and its transparent collaboration model for the entire literature review process\n- offers a **self-explanatory, fault-tolerant, and configurable** user workflow\n- implements a granular **data provenance** model and **robust identification** schemes\n- provides **end-to-end process support** and allows you to **plug in state-of-the-art tools**\n- enables **typological and methodological pluralism** throughout the process\n- operates a **built-in model for content curation** and reuse\n\n## Getting started\n\nAfter installing [git](https://git-scm.com/) and [docker](https://www.docker.com/):\n\n```\n# Install\ngit clone https://github.com/geritwagner/colrev && cd colrev && pip install .\n# or\npip install colrev\n\n# ... and start with the main command\ncolrev status\n```\n\n**The workflow** consists of three steps. This is all you need to remember. The status command displays the current state of the review and guides you to the next [operation](docs/build/user_resources/manual.html).\nAfter each operation, [validate the changes](docs/build/user_resources/manual/1_workflow.html#colrev-validate).\n\n<p align="center">\n<img src="../../figures/workflow.svg" width="700">\n</p>\n\n<!-- .. figure:: docs/figures/workflow.svg\n   :width: 600\n   :align: center\n   :alt: Workflow cycle -->\n\n**The operations** allow you to complete a literature review. It should be as simple as running the following commands:\n\n```\n# Initialize the project, formulate the objectives, specify the review type\ncolrev init\n\n# Store search results in the data/search directory\n# Load, prepare, and deduplicate the metadata reocrds\ncolrev retrieve\n\n# Conduct a prescreen\ncolrev prescreen\n\n# Get and prepare the PDFs\ncolrev pdfs\n\n# Conduct a screen based on PDFs\ncolrev screen\n\n# Complete the forms of data analysis and synthesis, as specified in the settings\ncolrev data\n\n```\n\nFor each operation, the **colrev settings** document the tools and parameters. You can rely on the built-in reference implementation of colrev, specify external tools, or include custom scripts. The settings are adapted to the type of review and suggest reasonable defaults. You have the option to customize and adapt.\n\n\n<p align="center">\n<img src="../../figures/settings.svg" width="700">\n</p>\n\n<!-- .. figure:: ../figures/settings.svg\n   :width: 600\n   :align: center\n   :alt: Settings -->\n\n\n**The project collaboration loop** allows you to synchronize the project repository with your team.\nThe *colrev pull* and *colrev push* operations make it easy to collaborate on a specific project while reusing and updating record data from multiple curated repositories.\nIn essence, a CoLRev repository is a git repository that follows the CoLRev data standard and is augmented with a record-level curation loop.\n\n**The record curation loop** proposes a new vision for the review process.\nReuse of community-curated data from different sources is built into each operation.\nIt can substantially reduce required efforts and improve richness, e.g., through annotations of methods, theories, and findings.\nThe more records are curated, the more you can focus on the synthesis.\n\n\n<p align="center">\n<img src="../../figures/reuse-vision_loop.svg" width="800">\n</p>\n\n<!-- .. figure:: ../figures/reuse-vision_loop.svg\n   :width: 800\n   :align: center\n   :alt: Reuse vision -->\n\nFurther information is provided in the [documentation](docs/source/index.rst), the developer [api reference](docs/build/technical_documentation/api.html), and the [CoLRev framework](docs/build/technical_documentation/colrev.html) summarizing the scientific foundations.\n\n## Contributing, changes, and releases\n\nContributions, code and features are always welcome\n\n- See [contributing guidelines](CONTRIBUTING.md), [help page](docs/build/user_resources/help.html), and [github repository](https://github.com/geritwagner/colrev).\n- Bug reports or feedback? Please use the [issue tracker](https://github.com/geritwagner/colrev/issues) and let us know.\n- To get your work included, fork the repository, implement your changes, and create a [pull request](https://docs.github.com/en/github/collaborating-with-issues-and-pull-requests/proposing-changes-to-your-work-with-pull-requests/about-pull-requests).\n\nFor further information, see [changes](CHANGELOG.md) and [releases](https://github.com/geritwagner/colrev/releases).\n\n## License\n\nThis project is distributed under the [MIT License](LICENSE) the documentation is distributed under the [CC-0](https://creativecommons.org/publicdomain/zero/1.0/) license.\nIf you contribute to the project, you agree to share your contribution following these licenses.\n\n## Citing CoLRev\n\nPlease [cite](docs/_static/colrev_citation.bib) the project as follows:\n\nWagner, G. and Prester, J. (2022) CoLRev - A Framework for Collaborative Literature Reviews. Available at https://github.com/geritwagner/colrev.\n',
    'author': 'Gerit Wagner',
    'author_email': 'gerit.wagner@hec.ca',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/geritwagner/colrev',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
