# coding: utf-8

"""
    cloudFPGA Resource Manager API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 0.8
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ClustersApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cf_manager_rest_api_delete_cluster(self, username, password, cluster_id, **kwargs):  # noqa: E501
        """Delete a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_delete_cluster(username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_delete_cluster_with_http_info(username, password, cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_delete_cluster_with_http_info(username, password, cluster_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_delete_cluster_with_http_info(self, username, password, cluster_id, **kwargs):  # noqa: E501
        """Delete a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_delete_cluster_with_http_info(username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_delete_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_delete_cluster`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_delete_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `cf_manager_rest_api_delete_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/clusters/{cluster_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_extend_cluster(self, body, username, password, cluster_id, **kwargs):  # noqa: E501
        """Add nodes to an existing cluster  # noqa: E501

        This adds nodes to an existing cluster, as specified in the parameter `cluster_details`.  **Details** on how to describe a cluster can be found at the **Implementation Notes of the `POST /clusters` API call**. All mentioned rules apply for this method as well.  After creating all new nodes, the runtime information of all nodes will be updated. The Roles of the already existing FPGA nodes are **not** reset during this method.  If errors occur during this method (e.g. 424 or 507), the original cluster will be unaffected.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_extend_cluster(body, username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ClustersBody] body: Mapping of Node-IDs to Images (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_extend_cluster_with_http_info(body, username, password, cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_extend_cluster_with_http_info(body, username, password, cluster_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_extend_cluster_with_http_info(self, body, username, password, cluster_id, **kwargs):  # noqa: E501
        """Add nodes to an existing cluster  # noqa: E501

        This adds nodes to an existing cluster, as specified in the parameter `cluster_details`.  **Details** on how to describe a cluster can be found at the **Implementation Notes of the `POST /clusters` API call**. All mentioned rules apply for this method as well.  After creating all new nodes, the runtime information of all nodes will be updated. The Roles of the already existing FPGA nodes are **not** reset during this method.  If errors occur during this method (e.g. 424 or 507), the original cluster will be unaffected.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_extend_cluster_with_http_info(body, username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ClustersBody] body: Mapping of Node-IDs to Images (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'username', 'password', 'cluster_id', 'dont_verify_memory']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_extend_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cf_manager_rest_api_extend_cluster`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_extend_cluster`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_extend_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `cf_manager_rest_api_extend_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'dont_verify_memory' in params:
            query_params.append(('dont_verify_memory', params['dont_verify_memory']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/clusters/{cluster_id}/extend', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_cluster_single(self, username, password, cluster_id, **kwargs):  # noqa: E501
        """Get a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_cluster_single(username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_cluster_single_with_http_info(username, password, cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_cluster_single_with_http_info(username, password, cluster_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_cluster_single_with_http_info(self, username, password, cluster_id, **kwargs):  # noqa: E501
        """Get a cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_cluster_single_with_http_info(username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_cluster_single" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_cluster_single`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_cluster_single`")  # noqa: E501
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `cf_manager_rest_api_get_cluster_single`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/clusters/{cluster_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_clusters(self, username, password, **kwargs):  # noqa: E501
        """Get all clusters of a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_clusters(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int limit:
        :return: list[Cluster]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_clusters_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_clusters_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_clusters_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Get all clusters of a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_clusters_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int limit:
        :return: list[Cluster]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'limit']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_clusters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_clusters`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_clusters`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'limit' in params:
            query_params.append(('limit', params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/clusters', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Cluster]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_post_clusters(self, body, username, password, **kwargs):  # noqa: E501
        """Request a cluster  # noqa: E501

        This triggers the configuration of all *FPGA nodes* of a cluster as specified in the parameter `cluster_details`.  The entry for an FPGA node must look like:  ```json {   \"node_id\": unique integer,   \"image_id\": \"XXX-XX-XXX\" } ```  The parameters `instance_id` and `node_ip` are set by the Resource Manager. The `node_id`s must be unique for the whole cluster (FPGAs and CPUs).   It is necessary to submit the information about the CPU nodes of a heterogeneous cluster to compile and distribute the *network routing configuration for the FPGAs correctly*.  Hence, the entry for a CPU must look like:  ```json {   \"node_id\": unique integer,   \"image_id\": \"NON_FPGA\",   \"node_ip\": \"10.12.47.11\" } ```  The setup of the CPU nodes must be done by the users themselves. The `node_ip` of a CPU must be in the OpenStack user subnetwork (i.e. `10.12.X.Y`). Currently, the maximum supported size of a cluster is 64 (FPGA + CPU nodes).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_clusters(body, username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ClustersBody] body: Mapping of Node-IDs to Images (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str project_name: Name of the OpenStack project the quota should be acounted to, if a user has multiple projects.
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_post_clusters_with_http_info(body, username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_post_clusters_with_http_info(body, username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_post_clusters_with_http_info(self, body, username, password, **kwargs):  # noqa: E501
        """Request a cluster  # noqa: E501

        This triggers the configuration of all *FPGA nodes* of a cluster as specified in the parameter `cluster_details`.  The entry for an FPGA node must look like:  ```json {   \"node_id\": unique integer,   \"image_id\": \"XXX-XX-XXX\" } ```  The parameters `instance_id` and `node_ip` are set by the Resource Manager. The `node_id`s must be unique for the whole cluster (FPGAs and CPUs).   It is necessary to submit the information about the CPU nodes of a heterogeneous cluster to compile and distribute the *network routing configuration for the FPGAs correctly*.  Hence, the entry for a CPU must look like:  ```json {   \"node_id\": unique integer,   \"image_id\": \"NON_FPGA\",   \"node_ip\": \"10.12.47.11\" } ```  The setup of the CPU nodes must be done by the users themselves. The `node_ip` of a CPU must be in the OpenStack user subnetwork (i.e. `10.12.X.Y`). Currently, the maximum supported size of a cluster is 64 (FPGA + CPU nodes).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_clusters_with_http_info(body, username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[ClustersBody] body: Mapping of Node-IDs to Images (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str project_name: Name of the OpenStack project the quota should be acounted to, if a user has multiple projects.
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'username', 'password', 'project_name', 'dont_verify_memory']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_post_clusters" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cf_manager_rest_api_post_clusters`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_post_clusters`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_post_clusters`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'project_name' in params:
            query_params.append(('project_name', params['project_name']))  # noqa: E501
        if 'dont_verify_memory' in params:
            query_params.append(('dont_verify_memory', params['dont_verify_memory']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/clusters', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_reduce_cluster(self, body, username, password, cluster_id, **kwargs):  # noqa: E501
        """Remove nodes from an existing cluster  # noqa: E501

        This remove nodes the nodes in the `nodes_to_remove` list from an existing cluster.  The `nodes_to_remove` list must contain the `node_id`s of the nodes that should be removed.  After removing all specified nodes, the runtime information of all remaining nodes will be updated. The Roles of the remaining FPGA nodes are **not** reset during this method.  If the last remaining FPGA node is removed, the complete cluster will be deleted (like `DELETE /cluster/{cluster_id}`).  If errors occur during this method, the original/remaining cluster will be unaffected.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_reduce_cluster(body, username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body: List of Node-IDs that should be removed (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_reduce_cluster_with_http_info(body, username, password, cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_reduce_cluster_with_http_info(body, username, password, cluster_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_reduce_cluster_with_http_info(self, body, username, password, cluster_id, **kwargs):  # noqa: E501
        """Remove nodes from an existing cluster  # noqa: E501

        This remove nodes the nodes in the `nodes_to_remove` list from an existing cluster.  The `nodes_to_remove` list must contain the `node_id`s of the nodes that should be removed.  After removing all specified nodes, the runtime information of all remaining nodes will be updated. The Roles of the remaining FPGA nodes are **not** reset during this method.  If the last remaining FPGA node is removed, the complete cluster will be deleted (like `DELETE /cluster/{cluster_id}`).  If errors occur during this method, the original/remaining cluster will be unaffected.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_reduce_cluster_with_http_info(body, username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[int] body: List of Node-IDs that should be removed (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'username', 'password', 'cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_reduce_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cf_manager_rest_api_reduce_cluster`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_reduce_cluster`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_reduce_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `cf_manager_rest_api_reduce_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/clusters/{cluster_id}/reduce', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_restart_cluster(self, username, password, cluster_id, **kwargs):  # noqa: E501
        """Restart all application on FPGAs in this cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_restart_cluster(username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_restart_cluster_with_http_info(username, password, cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_restart_cluster_with_http_info(username, password, cluster_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_restart_cluster_with_http_info(self, username, password, cluster_id, **kwargs):  # noqa: E501
        """Restart all application on FPGAs in this cluster  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_restart_cluster_with_http_info(username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_restart_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_restart_cluster`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_restart_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `cf_manager_rest_api_restart_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/clusters/{cluster_id}/restart', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_update_node_of_cluster(self, image_id, username, password, cluster_id, node_id, **kwargs):  # noqa: E501
        """Reconfigure one FPGA node of an existing cluster  # noqa: E501

        This method re-configures the given FPGA node in the given cluster. All settings remain the same and the runtime information of the cluster will be written to the updated instance again.  The Roles of the other FPGA nodes are **not** reset during this method.  If errors occur during this method, the other nodes of the cluster will be unaffected. **If this call fails with `507`** and the FPGA worked without any problems before, then the submitted image probably doesn't work (i.e. `507` doesn't imply a failure of the FPGA board).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_update_node_of_cluster(image_id, username, password, cluster_id, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_id: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :param int node_id: ID of a node within a cluster (required)
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_update_node_of_cluster_with_http_info(image_id, username, password, cluster_id, node_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_update_node_of_cluster_with_http_info(image_id, username, password, cluster_id, node_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_update_node_of_cluster_with_http_info(self, image_id, username, password, cluster_id, node_id, **kwargs):  # noqa: E501
        """Reconfigure one FPGA node of an existing cluster  # noqa: E501

        This method re-configures the given FPGA node in the given cluster. All settings remain the same and the runtime information of the cluster will be written to the updated instance again.  The Roles of the other FPGA nodes are **not** reset during this method.  If errors occur during this method, the other nodes of the cluster will be unaffected. **If this call fails with `507`** and the FPGA worked without any problems before, then the submitted image probably doesn't work (i.e. `507` doesn't imply a failure of the FPGA board).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_update_node_of_cluster_with_http_info(image_id, username, password, cluster_id, node_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_id: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :param int node_id: ID of a node within a cluster (required)
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: Cluster
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_id', 'username', 'password', 'cluster_id', 'node_id', 'dont_verify_memory']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_update_node_of_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_id' is set
        if ('image_id' not in params or
                params['image_id'] is None):
            raise ValueError("Missing the required parameter `image_id` when calling `cf_manager_rest_api_update_node_of_cluster`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_update_node_of_cluster`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_update_node_of_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `cf_manager_rest_api_update_node_of_cluster`")  # noqa: E501
        # verify the required parameter 'node_id' is set
        if ('node_id' not in params or
                params['node_id'] is None):
            raise ValueError("Missing the required parameter `node_id` when calling `cf_manager_rest_api_update_node_of_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501
        if 'node_id' in params:
            path_params['node_id'] = params['node_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'dont_verify_memory' in params:
            query_params.append(('dont_verify_memory', params['dont_verify_memory']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_id' in params:
            form_params.append(('image_id', params['image_id']))  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/clusters/{cluster_id}/{node_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Cluster',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
