from rdkit import Chem
import pdbinf
import pytest

thrombin_pdb = """\
HEADER    BLOOD CLOTTING/HYDROLASE INHIBITOR      04-JAN-08   2ZFF
TITLE     EXPLORING THROMBIN S1-POCKET
EXPDTA    X-RAY DIFFRACTION
REMARK   2 RESOLUTION.    1.47 ANGSTROMS
REMARK   3  R VALUE : 0.156000
REMARK   3  FREE R VALUE : 0.260000
REMARK   4 2ZFF COMPLIES WITH FORMAT V. 3.30,
REMARK 200  TEMPERATURE           (KELVIN) : 110.00
REMARK 200  PH                             : 7.50
REMARK 350 BIOMOLECULE: 1
REMARK 350 APPLY THE FOLLOWING TO CHAINS: L, H, I
REMARK 350   BIOMT1  1   1.000000 0.000000 0.000000   0.000000
REMARK 350   BIOMT2  1   0.000000 1.000000 0.000000   0.000000
REMARK 350   BIOMT3  1   0.000000 0.000000 1.000000   0.000000
REMARK 888
REMARK 888 WRITTEN BY MAESTRO (A PRODUCT OF SCHRODINGER, LLC)
SEQRES   1 H  260  ACE ILE VAL GLU GLY SER ASP ALA GLU ILE GLY MET SER
SEQRES   2 H  260  PRO TRP GLN VAL MET LEU PHE ARG LYS SER PRO GLN GLU
SEQRES   3 H  260  LEU LEU CYS GLY ALA SER LEU ILE SER ASP ARG TRP VAL
SEQRES   4 H  260  LEU THR ALA ALA HIS CYS LEU LEU TYR PRO PRO TRP ASP
SEQRES   5 H  260  LYS ASN PHE THR GLU ASN ASP LEU LEU VAL ARG ILE GLY
SEQRES   6 H  260  LYS HIS SER ARG THR ARG TYR GLU ARG ASN ILE GLU LYS
SEQRES   7 H  260  ILE SER MET LEU GLU LYS ILE TYR ILE HIS PRO ARG TYR
SEQRES   8 H  260  ASN TRP ARG GLU ASN LEU ASP ARG ASP ILE ALA LEU MET
SEQRES   9 H  260  LYS LEU LYS LYS PRO VAL ALA PHE SER ASP TYR ILE HIS
SEQRES  10 H  260  PRO VAL CYS LEU PRO ASP ARG GLU THR ALA ALA SER LEU
SEQRES  11 H  260  LEU GLN ALA GLY TYR LYS GLY ARG VAL THR GLY TRP GLY
SEQRES  12 H  260  ASN LEU LYS GLU THR TRP THR ALA ASN VAL GLY LYS GLY
SEQRES  13 H  260  GLN PRO SER VAL LEU GLN VAL VAL ASN LEU PRO ILE VAL
SEQRES  14 H  260  GLU ARG PRO VAL CYS LYS ASP SER THR ARG ILE ARG ILE
SEQRES  15 H  260  THR ASP ASN MET PHE CYS ALA GLY TYR LYS PRO ASP GLU
SEQRES  16 H  260  GLY LYS ARG GLY ASP ALA CYS GLU GLY ASP SER GLY GLY
SEQRES  17 H  260  PRO PHE VAL MET LYS SER PRO PHE ASN ASN ARG TRP TYR
SEQRES  18 H  260  GLN MET GLY ILE VAL SER TRP GLY GLU GLY CYS ASP ARG
SEQRES  19 H  260  ASP GLY LYS TYR GLY PHE TYR THR HIS VAL PHE ARG LEU
SEQRES  20 H  260  LYS LYS TRP ILE GLN LYS VAL ILE ASP GLN PHE GLY NME
SEQRES   1 L   30  ACE GLU ALA ASP CYS GLY LEU ARG PRO LEU PHE GLU LYS
SEQRES   2 L   30  LYS SER LEU GLU ASP LYS THR GLU ARG GLU LEU LEU GLU
SEQRES   3 L   30  SER TYR ILE NME
FORMUL   3  HOH   *3(H2 0)
HELIX    1   1 ARG H  126  ARG H  126  1
HELIX    2   2 GLU H  127  GLU H  127  1
HELIX    3   3 THR H  128  THR H  128  1
HELIX    4   4 ALA H  129  ALA H  129  1
HELIX    5   5 ALA H  129A ALA H  129A 1
HELIX    6   6 SER H  129B SER H  129B 1
HELIX    7   7 LEU H  129C LEU H  129C 1
HELIX    8   8 ARG H  165  ARG H  165  1
HELIX    9   9 PRO H  166  PRO H  166  1
HELIX   10  10 VAL H  167  VAL H  167  1
HELIX   11  11 CYS H  168  CYS H  168  1
HELIX   12  12 LYS H  235  LYS H  235  1
HELIX   13  13 LYS H  236  LYS H  236  1
HELIX   14  14 TRP H  237  TRP H  237  1
HELIX   15  15 ILE H  238  ILE H  238  1
HELIX   16  16 GLN H  239  GLN H  239  1
HELIX   17  17 LYS H  240  LYS H  240  1
HELIX   18  18 VAL H  241  VAL H  241  1
HELIX   19  19 ILE H  242  ILE H  242  1
HELIX   20  20 ASP H  243  ASP H  243  1
HELIX   21  21 GLN H  244  GLN H  244  1
HELIX   22  22 PHE H  245  PHE H  245  1
HELIX   23  23 GLU L   14C GLU L   14C 1
HELIX   24  24 ARG L   14D ARG L   14D 1
HELIX   25  25 GLU L   14E GLU L   14E 1
HELIX   26  26 LEU L   14F LEU L   14F 1
HELIX   27  27 LEU L   14G LEU L   14G 1
HELIX   28  28 GLU L   14H GLU L   14H 1
HELIX   29  29 SER L   14I SER L   14I 1
TURN     1   1 ILE H  16  ILE H  16
TURN     2   2 VAL H  17  VAL H  17
TURN     3   3 GLU H  18  GLU H  18
TURN     4   4 GLY H  19  GLY H  19
TURN     5   5 SER H  20  SER H  20
TURN     6   6 ASP H  21  ASP H  21
TURN     7   7 ALA H  22  ALA H  22
TURN     8   8 GLU H  23  GLU H  23
TURN     9   9 ILE H  24  ILE H  24
TURN    10  10 GLY H  25  GLY H  25
TURN    11  11 MET H  26  MET H  26
TURN    12  12 SER H  27  SER H  27
TURN    13  13 PRO H  28  PRO H  28
TURN    14  14 TRP H  29  TRP H  29
TURN    15  15 LYS H  36  LYS H  36
TURN    16  16 SER H  36A SER H  36A
TURN    17  17 PRO H  37  PRO H  37
TURN    18  18 GLN H  38  GLN H  38
TURN    19  19 ILE H  47  ILE H  47
TURN    20  20 SER H  48  SER H  48
TURN    21  21 ASP H  49  ASP H  49
TURN    22  22 ARG H  50  ARG H  50
TURN    23  23 ALA H  55  ALA H  55
TURN    24  24 ALA H  56  ALA H  56
TURN    25  25 HIS H  57  HIS H  57
TURN    26  26 CYS H  58  CYS H  58
TURN    27  27 LEU H  59  LEU H  59
TURN    28  28 PRO H  60B PRO H  60B
TURN    29  29 PRO H  60C PRO H  60C
TURN    30  30 TRP H  60D TRP H  60D
TURN    31  31 ASP H  60E ASP H  60E
TURN    32  32 PHE H  60H PHE H  60H
TURN    33  33 THR H  60I THR H  60I
TURN    34  34 GLU H  61  GLU H  61
TURN    35  35 ASN H  62  ASN H  62
TURN    36  36 ASP H  63  ASP H  63
TURN    37  37 GLY H  69  GLY H  69
TURN    38  38 LYS H  70  LYS H  70
TURN    39  39 HIS H  71  HIS H  71
TURN    40  40 SER H  72  SER H  72
TURN    41  41 ARG H  73  ARG H  73
TURN    42  42 THR H  74  THR H  74
TURN    43  43 ARG H  75  ARG H  75
TURN    44  44 ARG H  75  TYR H  76
TURN    45  45 GLU H  77  GLU H  77
TURN    46  46 ARG H  77A ARG H  77A
TURN    47  47 ASN H  78  ASN H  78
TURN    48  48 ILE H  79  ILE H  79
TURN    49  49 GLU H  80  GLU H  80
TURN    50  50 HIS H  91  HIS H  91
TURN    51  51 PRO H  92  PRO H  92
TURN    52  52 ARG H  93  ARG H  93
TURN    53  53 TYR H  94  TYR H  94
TURN    54  54 ASN H  95  ASN H  95
TURN    55  55 TRP H  96  TRP H  96
TURN    56  56 ARG H  97  ARG H  97
TURN    57  57 GLU H  97A GLU H  97A
TURN    58  58 ASN H  98  ASN H  98
TURN    59  59 LEU H  99  LEU H  99
TURN    60  60 ASP H 100  ASP H 100
TURN    61  61 ARG H 101  ARG H 101
TURN    62  62 ASP H 102  ASP H 102
TURN    63  63 ILE H 103  ILE H 103
TURN    64  64 LYS H 109  LYS H 109
TURN    65  65 LYS H 110  LYS H 110
TURN    66  66 PRO H 111  PRO H 111
TURN    67  67 VAL H 112  VAL H 112
TURN    68  68 ALA H 113  ALA H 113
TURN    69  69 PHE H 114  PHE H 114
TURN    70  70 SER H 115  SER H 115
TURN    71  71 ASP H 116  ASP H 116
TURN    72  72 TYR H 117  TYR H 117
TURN    73  73 ILE H 118  ILE H 118
TURN    74  74 HIS H 119  HIS H 119
TURN    75  75 PRO H 120  PRO H 120
TURN    76  76 VAL H 121  VAL H 121
TURN    77  77 CYS H 122  CYS H 122
TURN    78  78 LEU H 123  LEU H 123
TURN    79  79 PRO H 124  PRO H 124
TURN    80  80 ASP H 125  ASP H 125
TURN    81  81 LEU H 130  LEU H 130
TURN    82  82 GLN H 131  GLN H 131
TURN    83  83 ALA H 132  ALA H 132
TURN    84  84 GLY H 133  GLY H 133
TURN    85  85 TYR H 134  TYR H 134
TURN    86  86 LYS H 135  LYS H 135
TURN    87  87 GLY H 136  GLY H 136
TURN    88  88 ARG H 137  ARG H 137
TURN    89  89 VAL H 138  VAL H 138
TURN    90  90 THR H 139  THR H 139
TURN    91  91 GLY H 140  GLY H 140
TURN    92  92 TRP H 141  TRP H 141
TURN    93  93 GLY H 142  GLY H 142
TURN    94  94 ASN H 143  ASN H 143
TURN    95  95 LEU H 144  LEU H 144
TURN    96  96 LYS H 145  LYS H 145
TURN    97  97 GLU H 146  GLU H 146
TURN    98  98 THR H 147  THR H 147
TURN    99  99 TRP H 148  TRP H 148
TURN   100 100 THR H 148A THR H 148A
TURN   101 101 ALA H 148B ALA H 148B
TURN   102 102 ASN H 148C ASN H 148C
TURN   103 103 VAL H 148D VAL H 148D
TURN   104 104 GLY H 148E GLY H 148E
TURN   105 105 LYS H 149  LYS H 149
TURN   106 106 GLY H 150  GLY H 150
TURN   107 107 GLN H 151  GLN H 151
TURN   108 108 PRO H 152  PRO H 152
TURN   109 109 SER H 153  SER H 153
TURN   110 110 VAL H 154  VAL H 154
TURN   111 111 LEU H 155  LEU H 155
TURN   112 112 GLN H 156  GLN H 156
TURN   113 113 VAL H 157  VAL H 157
TURN   114 114 VAL H 158  VAL H 158
TURN   115 115 ASN H 159  ASN H 159
TURN   116 116 LEU H 160  LEU H 160
TURN   117 117 PRO H 161  PRO H 161
TURN   118 118 ILE H 162  ILE H 162
TURN   119 119 VAL H 163  VAL H 163
TURN   120 120 GLU H 164  GLU H 164
TURN   121 121 LYS H 169  LYS H 169
TURN   122 122 ASP H 170  ASP H 170
TURN   123 123 SER H 171  SER H 171
TURN   124 124 THR H 172  THR H 172
TURN   125 125 ARG H 173  ARG H 173
TURN   126 126 ILE H 174  ILE H 174
TURN   127 127 ARG H 175  ARG H 175
TURN   128 128 ILE H 176  ILE H 176
TURN   129 129 THR H 177  THR H 177
TURN   130 130 ASP H 178  ASP H 178
TURN   131 131 ASN H 179  ASN H 179
TURN   132 132 GLY H 184  GLY H 184
TURN   133 133 TYR H 184A TYR H 184A
TURN   134 134 LYS H 185  LYS H 185
TURN   135 135 PRO H 186  PRO H 186
TURN   136 136 ASP H 186A ASP H 186A
TURN   137 137 GLU H 186B GLU H 186B
TURN   138 138 GLY H 186C GLY H 186C
TURN   139 139 LYS H 186D LYS H 186D
TURN   140 140 ARG H 187  ARG H 187
TURN   141 141 GLY H 188  GLY H 188
TURN   142 142 ASP H 189  ASP H 189
TURN   143 143 ALA H 190  ALA H 190
TURN   144 144 CYS H 191  CYS H 191
TURN   145 145 GLU H 192  GLU H 192
TURN   146 146 GLY H 193  GLY H 193
TURN   147 147 ASP H 194  ASP H 194
TURN   148 148 SER H 195  SER H 195
TURN   149 149 GLY H 196  GLY H 196
TURN   150 150 GLY H 197  GLY H 197
TURN   151 151 PRO H 198  PRO H 198
TURN   152 152 PHE H 199  PHE H 199
TURN   153 153 SER H 203  SER H 203
TURN   154 154 PRO H 204  PRO H 204
TURN   155 155 PHE H 204A PHE H 204A
TURN   156 156 ASN H 204B ASN H 204B
TURN   157 157 ASN H 205  ASN H 205
TURN   158 158 ARG H 206  ARG H 206
TURN   159 159 GLY H 216  GLY H 216
TURN   160 160 GLU H 217  GLU H 217
TURN   161 161 GLY H 219  GLY H 219
TURN   162 162 CYS H 220  CYS H 220
TURN   163 163 ASP H 221  ASP H 221
TURN   164 164 ARG H 221A ARG H 221A
TURN   165 165 ASP H 222  ASP H 222
TURN   166 166 GLY H 223  GLY H 223
TURN   167 167 LYS H 224  LYS H 224
TURN   168 168 TYR H 225  TYR H 225
TURN   169 169 VAL H 231  VAL H 231
TURN   170 170 PHE H 232  PHE H 232
TURN   171 171 ARG H 233  ARG H 233
TURN   172 172 LEU H 234  LEU H 234
TURN   173 173 GLY H 246  GLY H 246
TURN   174 174 GLU L   1C GLU L   1C
TURN   175 175 GLU L   1C ALA L   1B
TURN   176 176 ASP L   1A ASP L   1A
TURN   177 177 CYS L   1  CYS L   1
TURN   178 178 GLY L   2  GLY L   2
TURN   179 179 LEU L   3  LEU L   3
TURN   180 180 ARG L   4  ARG L   4
TURN   181 181 PRO L   5  PRO L   5
TURN   182 182 LEU L   6  LEU L   6
TURN   183 183 PHE L   7  PHE L   7
TURN   184 184 GLU L   8  GLU L   8
TURN   185 185 LYS L   9  LYS L   9
TURN   186 186 LYS L  10  LYS L  10
TURN   187 187 SER L  11  SER L  11
TURN   188 188 LEU L  12  LEU L  12
TURN   189 189 GLU L  13  GLU L  13
TURN   190 190 ASP L  14  ASP L  14
TURN   191 191 LYS L  14A LYS L  14A
TURN   192 192 THR L  14B THR L  14B
TURN   193 193 TYR L  14J TYR L  14J
TURN   194 194 ILE L  14K ILE L  14K
SHEET    1   1 1 GLN H  30  GLN H  30  0
SHEET    1   2 1 VAL H  31  VAL H  31  0
SHEET    1   3 1 MET H  32  MET H  32  0
SHEET    1   4 1 LEU H  33  LEU H  33  0
SHEET    1   5 1 PHE H  34  PHE H  34  0
SHEET    1   6 1 ARG H  35  ARG H  35  0
SHEET    1   7 1 GLU H  39  GLU H  39  0
SHEET    1   8 1 LEU H  40  LEU H  40  0
SHEET    1   9 1 LEU H  41  LEU H  41  0
SHEET    1  10 1 CYS H  42  CYS H  42  0
SHEET    1  11 1 GLY H  43  GLY H  43  0
SHEET    1  12 1 ALA H  44  ALA H  44  0
SHEET    1  13 1 SER H  45  SER H  45  0
SHEET    1  14 1 LEU H  46  LEU H  46  0
SHEET    1  15 1 TRP H  51  TRP H  51  0
SHEET    1  16 1 VAL H  52  VAL H  52  0
SHEET    1  17 1 LEU H  53  LEU H  53  0
SHEET    1  18 1 THR H  54  THR H  54  0
SHEET    1  19 1 LEU H  60  LEU H  60  0
SHEET    1  20 1 TYR H  60A TYR H  60A 0
SHEET    1  21 1 LYS H  60F LYS H  60F 0
SHEET    1  22 1 ASN H  60G ASN H  60G 0
SHEET    1  23 1 LEU H  64  LEU H  64  0
SHEET    1  24 1 LEU H  65  LEU H  65  0
SHEET    1  25 1 VAL H  66  VAL H  66  0
SHEET    1  26 1 ARG H  67  ARG H  67  0
SHEET    1  27 1 ILE H  68  ILE H  68  0
SHEET    1  28 1 LYS H  81  LYS H  81  0
SHEET    1  29 1 ILE H  82  ILE H  82  0
SHEET    1  30 1 SER H  83  SER H  83  0
SHEET    1  31 1 MET H  84  MET H  84  0
SHEET    1  32 1 LEU H  85  LEU H  85  0
SHEET    1  33 1 GLU H  86  GLU H  86  0
SHEET    1  34 1 LYS H  87  LYS H  87  0
SHEET    1  35 1 ILE H  88  ILE H  88  0
SHEET    1  36 1 TYR H  89  TYR H  89  0
SHEET    1  37 1 ILE H  90  ILE H  90  0
SHEET    1  38 1 ALA H 104  ALA H 104  0
SHEET    1  39 1 LEU H 105  LEU H 105  0
SHEET    1  40 1 MET H 106  MET H 106  0
SHEET    1  41 1 LYS H 107  LYS H 107  0
SHEET    1  42 1 LEU H 108  LEU H 108  0
SHEET    1  43 1 MET H 180  MET H 180  0
SHEET    1  44 1 PHE H 181  PHE H 181  0
SHEET    1  45 1 CYS H 182  CYS H 182  0
SHEET    1  46 1 ALA H 183  ALA H 183  0
SHEET    1  47 1 VAL H 200  VAL H 200  0
SHEET    1  48 1 MET H 201  MET H 201  0
SHEET    1  49 1 LYS H 202  LYS H 202  0
SHEET    1  50 1 TRP H 207  TRP H 207  0
SHEET    1  51 1 TYR H 208  TYR H 208  0
SHEET    1  52 1 GLN H 209  GLN H 209  0
SHEET    1  53 1 MET H 210  MET H 210  0
SHEET    1  54 1 GLY H 211  GLY H 211  0
SHEET    1  55 1 ILE H 212  ILE H 212  0
SHEET    1  56 1 VAL H 213  VAL H 213  0
SHEET    1  57 1 SER H 214  SER H 214  0
SHEET    1  58 1 TRP H 215  TRP H 215  0
SHEET    1  59 1 GLY H 226  GLY H 226  0
SHEET    1  60 1 PHE H 227  PHE H 227  0
SHEET    1  61 1 TYR H 228  TYR H 228  0
SHEET    1  62 1 THR H 229  THR H 229  0
SHEET    1  63 1 HIS H 230  HIS H 230  0
SSBOND   1 CYS H   42    CYS H   58                          1555   1555  2.03
SSBOND   2 CYS H  122    CYS L    1                          1555   1555  2.05
SSBOND   3 CYS H  168    CYS H  182                          1555   1555  2.03
SSBOND   4 CYS H  191    CYS H  220                          1555   1555  2.03
CRYST1   70.100   71.500   72.500  90.00 100.30  90.00 C 1 2 1       4
HETATM    1  CH3 ACE H  15       4.831  -7.726  15.518  1.00  0.00           C  
HETATM    2  C   ACE H  15       4.031  -8.076  16.728  1.00  0.00           C  
HETATM    3  O   ACE H  15       2.829  -8.237  16.600  1.00  0.00           O  
HETATM    4  H1  ACE H  15       4.475  -8.304  14.674  1.00  0.00           H  
HETATM    5  H2  ACE H  15       4.737  -6.667  15.291  1.00  0.00           H  
HETATM    6  H3  ACE H  15       5.863  -7.964  15.733  1.00  0.00           H  
ATOM      7  N   ILE H  16       4.710  -8.132  17.881  1.00 15.91           N  
ATOM      8  CA  ILE H  16       4.170  -7.972  19.225  1.00 14.62           C  
ATOM      9  C   ILE H  16       3.100  -9.022  19.585  1.00 17.37           C  
ATOM     10  O   ILE H  16       2.040  -9.074  18.966  1.00 19.53           O  
ATOM     11  CB  ILE H  16       3.563  -6.542  19.390  1.00 16.05           C  
ATOM     12  CG1 ILE H  16       4.552  -5.399  19.035  1.00 14.52           C  
ATOM     13  CG2 ILE H  16       2.915  -6.286  20.756  1.00 16.45           C  
ATOM     14  CD1 ILE H  16       5.687  -5.180  20.042  1.00 16.16           C  
ATOM     15  H   ILE H  16       5.719  -8.041  17.843  1.00 15.91           H  
ATOM     16  HA  ILE H  16       5.011  -8.089  19.908  1.00 14.62           H  
ATOM     17  HB  ILE H  16       2.748  -6.457  18.674  1.00 16.05           H  
ATOM     18 HG13 ILE H  16       3.987  -4.470  18.959  1.00 14.52           H  
ATOM     19 HG12 ILE H  16       4.979  -5.543  18.043  1.00 14.52           H  
ATOM     20 HG21 ILE H  16       2.577  -5.253  20.823  1.00 16.45           H  
ATOM     21 HG22 ILE H  16       2.045  -6.916  20.934  1.00 16.45           H  
ATOM     22 HG23 ILE H  16       3.626  -6.474  21.558  1.00 16.45           H  
ATOM     23 HD11 ILE H  16       6.596  -4.859  19.533  1.00 16.16           H  
ATOM     24 HD12 ILE H  16       5.417  -4.409  20.763  1.00 16.16           H  
ATOM     25 HD13 ILE H  16       5.923  -6.082  20.603  1.00 16.16           H  
ATOM     26  N   VAL H  17       3.346  -9.817  20.629  1.00 18.44           N  
ATOM     27  CA  VAL H  17       2.331 -10.743  21.115  0.94 21.00           C  
ATOM     28  C   VAL H  17       1.297  -9.975  21.961  1.00 23.34           C  
ATOM     29  O   VAL H  17       1.694  -9.154  22.786  1.00 20.53           O  
ATOM     30  CB  VAL H  17       2.934 -11.894  21.953  0.94 21.72           C  
ATOM     31  CG1 VAL H  17       1.900 -13.005  22.212  0.94 22.31           C  
ATOM     32  CG2 VAL H  17       4.185 -12.504  21.300  0.94 27.91           C  
ATOM     33  H   VAL H  17       4.193  -9.715  21.172  1.00 18.44           H  
ATOM     34  HA  VAL H  17       1.813 -11.182  20.266  0.94 21.00           H  
ATOM     35  HB  VAL H  17       3.244 -11.491  22.917  0.94 21.72           H  
ATOM     36 HG11 VAL H  17       2.350 -13.880  22.677  0.94 22.31           H  
ATOM     37 HG12 VAL H  17       1.110 -12.661  22.874  0.94 22.31           H  
ATOM     38 HG13 VAL H  17       1.435 -13.343  21.286  0.94 22.31           H  
ATOM     39 HG21 VAL H  17       4.517 -13.389  21.842  0.94 27.91           H  
ATOM     40 HG22 VAL H  17       3.997 -12.795  20.267  0.94 27.91           H  
ATOM     41 HG23 VAL H  17       5.014 -11.797  21.301  0.94 27.91           H  
ATOM     42  N   GLU H  18       0.002 -10.235  21.702  1.00 23.09           N  
ATOM     43  CA  GLU H  18      -1.163  -9.700  22.423  1.00 26.30           C  
ATOM     44  C   GLU H  18      -1.238  -8.158  22.469  1.00 23.97           C  
ATOM     45  O   GLU H  18      -1.694  -7.584  23.458  1.00 26.00           O  
ATOM     46  CB  GLU H  18      -1.302 -10.399  23.799  1.00 31.57           C  
ATOM     47  CG  GLU H  18      -1.644 -11.906  23.673  1.00 39.31           C  
ATOM     48  CD  GLU H  18      -3.122 -12.248  23.431  1.00 46.64           C  
ATOM     49  OE1 GLU H  18      -3.355 -13.371  22.931  1.00 60.34           O  
ATOM     50  OE2 GLU H  18      -4.002 -11.416  23.748  1.00 50.94           O1-
ATOM     51  H   GLU H  18      -0.221 -10.885  20.959  1.00 23.09           H  
ATOM     52  HA  GLU H  18      -2.029  -9.988  21.826  1.00 26.30           H  
ATOM     53  HB3 GLU H  18      -2.020  -9.889  24.442  1.00 31.57           H  
ATOM     54  HB2 GLU H  18      -0.360 -10.318  24.337  1.00 31.57           H  
ATOM     55  HG3 GLU H  18      -1.339 -12.424  24.579  1.00 39.31           H  
ATOM     56  HG2 GLU H  18      -1.057 -12.357  22.875  1.00 39.31           H  
ATOM     57  N   GLY H  19      -0.809  -7.528  21.365  1.00 21.54           N  
ATOM     58  CA  GLY H  19      -0.931  -6.098  21.121  1.00 21.82           C  
ATOM     59  C   GLY H  19      -2.176  -5.829  20.268  1.00 21.14           C  
ATOM     60  O   GLY H  19      -3.047  -6.683  20.096  1.00 24.87           O  
ATOM     61  H   GLY H  19      -0.466  -8.081  20.591  1.00 21.54           H  
ATOM     62  HA3 GLY H  19      -0.045  -5.764  20.581  1.00 21.82           H  
ATOM     63  HA2 GLY H  19      -0.982  -5.527  22.050  1.00 21.82           H  
ATOM     64  N   SER H  20      -2.240  -4.605  19.735  1.00 21.07           N  
ATOM     65  CA  SER H  20      -3.296  -4.113  18.855  0.54 22.01           C  
ATOM     66  C   SER H  20      -2.648  -3.390  17.672  1.00 19.49           C  
ATOM     67  O   SER H  20      -1.513  -2.930  17.796  1.00 20.38           O  
ATOM     68  CB  SER H  20      -4.174  -3.118  19.641  0.54 23.02           C  
ATOM     69  OG  SER H  20      -4.880  -3.770  20.677  0.54 30.70           O  
ATOM     70  H   SER H  20      -1.489  -3.952  19.917  1.00 21.07           H  
ATOM     71  HA  SER H  20      -3.904  -4.931  18.465  0.54 22.01           H  
ATOM     72  HB3 SER H  20      -4.907  -2.647  18.984  0.54 23.02           H  
ATOM     73  HB2 SER H  20      -3.572  -2.314  20.067  0.54 23.02           H  
ATOM     74  HG  SER H  20      -5.485  -4.405  20.285  0.54 30.70           H  
ATOM     75  N   ASP H  21      -3.406  -3.233  16.572  1.00 21.81           N  
ATOM     76  CA  ASP H  21      -3.042  -2.363  15.447  1.00 21.52           C  
ATOM     77  C   ASP H  21      -2.828  -0.919  15.924  1.00 21.63           C  
ATOM     78  O   ASP H  21      -3.663  -0.391  16.661  1.00 20.54           O  
ATOM     79  CB  ASP H  21      -4.088  -2.338  14.299  1.00 20.92           C  
ATOM     80  CG  ASP H  21      -4.461  -3.671  13.625  1.00 26.94           C  
ATOM     81  OD1 ASP H  21      -3.794  -4.698  13.873  1.00 29.82           O  
ATOM     82  OD2 ASP H  21      -5.381  -3.621  12.779  1.00 33.81           O1-
ATOM     83  H   ASP H  21      -4.322  -3.655  16.526  1.00 21.81           H  
ATOM     84  HA  ASP H  21      -2.098  -2.734  15.043  1.00 21.52           H  
ATOM     85  HB3 ASP H  21      -3.742  -1.662  13.515  1.00 20.92           H  
ATOM     86  HB2 ASP H  21      -5.018  -1.913  14.682  1.00 20.92           H  
ATOM     87  N   ALA H  22      -1.724  -0.310  15.470  1.00 19.01           N  
ATOM     88  CA  ALA H  22      -1.427   1.101  15.678  1.00 15.92           C  
ATOM     89  C   ALA H  22      -2.465   1.990  14.987  1.00 15.91           C  
ATOM     90  O   ALA H  22      -2.992   1.629  13.935  1.00 18.23           O  
ATOM     91  CB  ALA H  22      -0.024   1.414  15.125  1.00 20.98           C  
ATOM     92  H   ALA H  22      -1.068  -0.824  14.894  1.00 19.01           H  
ATOM     93  HA  ALA H  22      -1.447   1.295  16.750  1.00 15.92           H  
ATOM     94  HB1 ALA H  22       0.263   2.444  15.341  1.00 20.98           H  
ATOM     95  HB2 ALA H  22       0.736   0.769  15.560  1.00 20.98           H  
ATOM     96  HB3 ALA H  22       0.019   1.280  14.043  1.00 20.98           H  
ATOM     97  N   GLU H  23      -2.697   3.170  15.568  1.00 16.19           N  
ATOM     98  CA  GLU H  23      -3.356   4.265  14.868  1.00 14.95           C  
ATOM     99  C   GLU H  23      -2.358   4.921  13.902  1.00 15.16           C  
ATOM    100  O   GLU H  23      -1.144   4.781  14.071  1.00 14.85           O  
ATOM    101  CB  GLU H  23      -3.926   5.254  15.898  1.00 15.20           C  
ATOM    102  CG  GLU H  23      -5.083   4.641  16.708  1.00 18.34           C  
ATOM    103  CD  GLU H  23      -5.389   5.450  17.966  1.00 19.44           C  
ATOM    104  OE1 GLU H  23      -5.841   6.607  17.824  1.00 22.92           O  
ATOM    105  OE2 GLU H  23      -5.161   4.891  19.059  1.00 22.07           O1-
ATOM    106  H   GLU H  23      -2.254   3.399  16.446  1.00 16.19           H  
ATOM    107  HA  GLU H  23      -4.189   3.876  14.277  1.00 14.95           H  
ATOM    108  HB3 GLU H  23      -4.274   6.158  15.395  1.00 15.20           H  
ATOM    109  HB2 GLU H  23      -3.144   5.575  16.584  1.00 15.20           H  
ATOM    110  HG3 GLU H  23      -4.854   3.612  16.989  1.00 18.34           H  
ATOM    111  HG2 GLU H  23      -5.981   4.585  16.092  1.00 18.34           H  
ATOM    112  N   ILE H  24      -2.887   5.616  12.889  1.00 15.96           N  
ATOM    113  CA  ILE H  24      -2.080   6.339  11.910  1.00 16.50           C  
ATOM    114  C   ILE H  24      -1.346   7.514  12.589  1.00 14.90           C  
ATOM    115  O   ILE H  24      -1.990   8.325  13.255  1.00 18.22           O  
ATOM    116  CB  ILE H  24      -2.962   6.860  10.739  1.00 16.45           C  
ATOM    117  CG1 ILE H  24      -3.668   5.706   9.986  1.00 19.94           C  
ATOM    118  CG2 ILE H  24      -2.213   7.769   9.745  1.00 19.38           C  
ATOM    119  CD1 ILE H  24      -2.731   4.633   9.410  1.00 21.53           C  
ATOM    120  H   ILE H  24      -3.889   5.695  12.795  1.00 15.96           H  
ATOM    121  HA  ILE H  24      -1.331   5.653  11.511  1.00 16.50           H  
ATOM    122  HB  ILE H  24      -3.757   7.470  11.172  1.00 16.45           H  
ATOM    123 HG13 ILE H  24      -4.285   6.114   9.185  1.00 19.94           H  
ATOM    124 HG12 ILE H  24      -4.372   5.215  10.660  1.00 19.94           H  
ATOM    125 HG21 ILE H  24      -2.851   8.040   8.904  1.00 19.38           H  
ATOM    126 HG22 ILE H  24      -1.899   8.702  10.210  1.00 19.38           H  
ATOM    127 HG23 ILE H  24      -1.323   7.283   9.345  1.00 19.38           H  
ATOM    128 HD11 ILE H  24      -3.253   4.022   8.673  1.00 21.53           H  
ATOM    129 HD12 ILE H  24      -1.859   5.064   8.920  1.00 21.53           H  
ATOM    130 HD13 ILE H  24      -2.379   3.967  10.197  1.00 21.53           H  
ATOM    131  N   GLY H  25      -0.011   7.545  12.435  1.00 14.14           N  
ATOM    132  CA  GLY H  25       0.869   8.547  13.039  1.00 15.72           C  
ATOM    133  C   GLY H  25       1.045   8.368  14.560  1.00 12.81           C  
ATOM    134  O   GLY H  25       1.457   9.320  15.218  1.00 12.78           O  
ATOM    135  H   GLY H  25       0.436   6.824  11.885  1.00 14.14           H  
ATOM    136  HA3 GLY H  25       0.489   9.548  12.834  1.00 15.72           H  
ATOM    137  HA2 GLY H  25       1.849   8.481  12.566  1.00 15.72           H  
ATOM    138  N   MET H  26       0.715   7.191  15.127  1.00 13.79           N  
ATOM    139  CA  MET H  26       0.804   6.895  16.564  1.00 11.94           C  
ATOM    140  C   MET H  26       2.247   6.720  17.066  1.00 11.13           C  
ATOM    141  O   MET H  26       2.514   7.003  18.230  1.00 12.00           O  
ATOM    142  CB  MET H  26      -0.039   5.643  16.858  1.00 15.48           C  
ATOM    143  CG  MET H  26      -0.299   5.295  18.334  1.00 18.84           C  
ATOM    144  SD  MET H  26      -1.089   3.674  18.484  1.00 18.65           S  
ATOM    145  CE  MET H  26      -1.769   3.724  20.155  1.00 20.65           C  
ATOM    146  H   MET H  26       0.345   6.451  14.545  1.00 13.79           H  
ATOM    147  HA  MET H  26       0.360   7.735  17.098  1.00 11.94           H  
ATOM    148  HB3 MET H  26       0.399   4.779  16.354  1.00 15.48           H  
ATOM    149  HB2 MET H  26      -1.010   5.796  16.398  1.00 15.48           H  
ATOM    150  HG3 MET H  26      -0.950   6.047  18.782  1.00 18.84           H  
ATOM    151  HG2 MET H  26       0.621   5.273  18.916  1.00 18.84           H  
ATOM    152  HE1 MET H  26      -2.188   2.754  20.419  1.00 20.65           H  
ATOM    153  HE2 MET H  26      -1.000   3.978  20.881  1.00 20.65           H  
ATOM    154  HE3 MET H  26      -2.568   4.461  20.200  1.00 20.65           H  
ATOM    155  N   SER H  27       3.152   6.279  16.184  1.00 12.40           N  
ATOM    156  CA  SER H  27       4.568   6.108  16.479  0.67 12.03           C  
ATOM    157  C   SER H  27       5.351   6.625  15.259  1.00 11.20           C  
ATOM    158  O   SER H  27       5.857   5.811  14.488  1.00 12.07           O  
ATOM    159  CB  SER H  27       4.830   4.629  16.853  0.67 11.50           C  
ATOM    160  OG  SER H  27       6.159   4.419  17.284  0.67 10.18           O  
ATOM    161  H   SER H  27       2.865   6.070  15.239  1.00 12.40           H  
ATOM    162  HA  SER H  27       4.859   6.713  17.340  0.67 12.03           H  
ATOM    163  HB3 SER H  27       4.623   3.969  16.010  0.67 11.50           H  
ATOM    164  HB2 SER H  27       4.166   4.322  17.661  0.67 11.50           H  
ATOM    165  HG  SER H  27       6.286   3.481  17.453  0.67 10.18           H  
ATOM    166  N   PRO H  28       5.383   7.965  15.048  1.00 10.54           N  
ATOM    167  CA  PRO H  28       5.983   8.551  13.837  1.00 11.07           C  
ATOM    168  C   PRO H  28       7.522   8.497  13.810  1.00  9.76           C  
ATOM    169  O   PRO H  28       8.117   8.697  12.754  1.00 11.08           O  
ATOM    170  CB  PRO H  28       5.441   9.985  13.828  1.00 11.84           C  
ATOM    171  CG  PRO H  28       5.305  10.333  15.298  1.00 11.13           C  
ATOM    172  CD  PRO H  28       4.878   9.013  15.939  1.00 11.39           C  
ATOM    173  HA  PRO H  28       5.615   8.018  12.961  1.00 11.07           H  
ATOM    174  HB3 PRO H  28       4.458   9.997  13.354  1.00 11.84           H  
ATOM    175  HB2 PRO H  28       6.068  10.693  13.286  1.00 11.84           H  
ATOM    176  HG3 PRO H  28       4.609  11.153  15.470  1.00 11.13           H  
ATOM    177  HG2 PRO H  28       6.278  10.624  15.693  1.00 11.13           H  
ATOM    178  HD2 PRO H  28       5.266   8.924  16.953  1.00 11.39           H  
ATOM    179  HD3 PRO H  28       3.795   8.957  15.987  1.00 11.39           H  
ATOM    180  N   TRP H  29       8.133   8.175  14.959  1.00  9.55           N  
ATOM    181  CA  TRP H  29       9.545   7.847  15.093  1.00 10.29           C  
ATOM    182  C   TRP H  29       9.880   6.418  14.673  1.00 11.95           C  
ATOM    183  O   TRP H  29      11.062   6.159  14.508  1.00 11.58           O  
ATOM    184  CB  TRP H  29      10.019   8.085  16.538  1.00  9.32           C  
ATOM    185  CG  TRP H  29       9.026   7.757  17.608  1.00  9.72           C  
ATOM    186  CD1 TRP H  29       8.764   6.534  18.122  1.00 11.16           C  
ATOM    187  CD2 TRP H  29       8.092   8.673  18.243  1.00 10.79           C  
ATOM    188  NE1 TRP H  29       7.738   6.636  19.039  1.00 11.16           N  
ATOM    189  CE2 TRP H  29       7.281   7.933  19.152  1.00 11.19           C  
ATOM    190  CE3 TRP H  29       7.852  10.063  18.134  1.00 10.59           C  
ATOM    191  CZ2 TRP H  29       6.270   8.543  19.913  1.00 12.32           C  
ATOM    192  CZ3 TRP H  29       6.846  10.687  18.891  1.00 10.48           C  
ATOM    193  CH2 TRP H  29       6.054   9.925  19.768  1.00 12.93           C  
ATOM    194  H   TRP H  29       7.577   8.051  15.792  1.00  9.55           H  
ATOM    195  HA  TRP H  29      10.130   8.490  14.434  1.00 10.29           H  
ATOM    196  HB3 TRP H  29      10.240   9.144  16.641  1.00  9.32           H  
ATOM    197  HB2 TRP H  29      10.963   7.581  16.750  1.00  9.32           H  
ATOM    198  HD1 TRP H  29       9.275   5.627  17.835  1.00 11.16           H  
ATOM    199  HE1 TRP H  29       7.375   5.833  19.533  1.00 11.16           H  
ATOM    200  HE3 TRP H  29       8.447  10.655  17.457  1.00 10.59           H  
ATOM    201  HZ2 TRP H  29       5.664   7.964  20.593  1.00 12.32           H  
ATOM    202  HZ3 TRP H  29       6.673  11.748  18.789  1.00 10.48           H  
ATOM    203  HH2 TRP H  29       5.273  10.406  20.330  1.00 12.93           H  
ATOM    204  N   GLN H  30       8.894   5.517  14.512  1.00 10.90           N  
ATOM    205  CA  GLN H  30       9.144   4.117  14.169  1.00 10.99           C  
ATOM    206  C   GLN H  30       9.901   3.987  12.838  1.00 11.77           C  
ATOM    207  O   GLN H  30       9.533   4.637  11.860  1.00 13.90           O  
ATOM    208  CB  GLN H  30       7.811   3.341  14.108  1.00 13.39           C  
ATOM    209  CG  GLN H  30       7.984   1.811  14.020  1.00 13.66           C  
ATOM    210  CD  GLN H  30       8.534   1.176  15.298  1.00 18.76           C  
ATOM    211  OE1 GLN H  30       8.524   1.789  16.361  1.00 31.49           O  
ATOM    212  NE2 GLN H  30       9.010  -0.066  15.202  1.00 30.19           N  
ATOM    213  H   GLN H  30       7.927   5.786  14.642  1.00 10.90           H  
ATOM    214  HA  GLN H  30       9.765   3.710  14.969  1.00 10.99           H  
ATOM    215  HB3 GLN H  30       7.228   3.683  13.251  1.00 13.39           H  
ATOM    216  HB2 GLN H  30       7.202   3.577  14.981  1.00 13.39           H  
ATOM    217  HG3 GLN H  30       8.652   1.561  13.199  1.00 13.66           H  
ATOM    218  HG2 GLN H  30       7.029   1.349  13.784  1.00 13.66           H  
ATOM    219 HE22 GLN H  30       9.379  -0.535  16.017  1.00 30.19           H  
ATOM    220 HE21 GLN H  30       9.007  -0.548  14.315  1.00 30.19           H  
ATOM    221  N   VAL H  31      10.942   3.150  12.840  1.00 11.85           N  
ATOM    222  CA  VAL H  31      11.738   2.847  11.662  1.00 12.27           C  
ATOM    223  C   VAL H  31      11.792   1.323  11.499  1.00 11.33           C  
ATOM    224  O   VAL H  31      11.960   0.605  12.482  1.00 13.87           O  
ATOM    225  CB  VAL H  31      13.183   3.407  11.788  1.00 11.96           C  
ATOM    226  CG1 VAL H  31      14.119   2.960  10.652  1.00 15.89           C  
ATOM    227  CG2 VAL H  31      13.191   4.938  11.909  1.00 15.65           C  
ATOM    228  H   VAL H  31      11.202   2.663  13.689  1.00 11.85           H  
ATOM    229  HA  VAL H  31      11.283   3.270  10.765  1.00 12.27           H  
ATOM    230  HB  VAL H  31      13.619   3.043  12.713  1.00 11.96           H  
ATOM    231 HG11 VAL H  31      15.042   3.537  10.653  1.00 15.89           H  
ATOM    232 HG12 VAL H  31      14.403   1.912  10.738  1.00 15.89           H  
ATOM    233 HG13 VAL H  31      13.635   3.089   9.685  1.00 15.89           H  
ATOM    234 HG21 VAL H  31      14.203   5.345  11.900  1.00 15.65           H  
ATOM    235 HG22 VAL H  31      12.632   5.399  11.100  1.00 15.65           H  
ATOM    236 HG23 VAL H  31      12.732   5.256  12.841  1.00 15.65           H  
ATOM    237  N   MET H  32      11.667   0.872  10.245  1.00 12.56           N  
ATOM    238  CA  MET H  32      11.914  -0.503   9.837  1.00 14.78           C  
ATOM    239  C   MET H  32      13.323  -0.572   9.243  1.00 14.83           C  
ATOM    240  O   MET H  32      13.604   0.135   8.276  1.00 17.41           O  
ATOM    241  CB  MET H  32      10.839  -0.929   8.813  1.00 14.30           C  
ATOM    242  CG  MET H  32      11.088  -2.295   8.148  1.00 18.55           C  
ATOM    243  SD  MET H  32       9.810  -2.855   6.993  1.00 19.65           S  
ATOM    244  CE  MET H  32       8.400  -3.025   8.118  1.00 19.15           C  
ATOM    245  H   MET H  32      11.520   1.532   9.492  1.00 12.56           H  
ATOM    246  HA  MET H  32      11.851  -1.181  10.691  1.00 14.78           H  
ATOM    247  HB3 MET H  32      10.751  -0.172   8.038  1.00 14.30           H  
ATOM    248  HB2 MET H  32       9.870  -0.944   9.304  1.00 14.30           H  
ATOM    249  HG3 MET H  32      11.213  -3.052   8.918  1.00 18.55           H  
ATOM    250  HG2 MET H  32      12.019  -2.280   7.582  1.00 18.55           H  
ATOM    251  HE1 MET H  32       7.590  -3.557   7.626  1.00 19.15           H  
ATOM    252  HE2 MET H  32       8.682  -3.589   9.007  1.00 19.15           H  
ATOM    253  HE3 MET H  32       8.028  -2.048   8.426  1.00 19.15           H  
ATOM    254  N   LEU H  33      14.154  -1.466   9.795  1.00 14.61           N  
ATOM    255  CA  LEU H  33      15.392  -1.902   9.161  0.55 15.81           C  
ATOM    256  C   LEU H  33      15.048  -3.028   8.192  1.00 16.62           C  
ATOM    257  O   LEU H  33      14.413  -4.008   8.585  1.00 20.36           O  
ATOM    258  CB  LEU H  33      16.420  -2.372  10.204  0.55 16.70           C  
ATOM    259  CG  LEU H  33      16.763  -1.357  11.313  0.55 16.19           C  
ATOM    260  CD1 LEU H  33      17.897  -1.905  12.199  0.55 21.46           C  
ATOM    261  CD2 LEU H  33      17.074   0.058  10.785  0.55 21.13           C  
ATOM    262  H   LEU H  33      13.848  -2.020  10.586  1.00 14.61           H  
ATOM    263  HA  LEU H  33      15.826  -1.086   8.582  0.55 15.81           H  
ATOM    264  HB3 LEU H  33      17.336  -2.634   9.673  0.55 16.70           H  
ATOM    265  HB2 LEU H  33      16.075  -3.294  10.673  0.55 16.70           H  
ATOM    266  HG  LEU H  33      15.877  -1.265  11.942  0.55 16.19           H  
ATOM    267 HD11 LEU H  33      17.525  -2.117  13.199  0.55 21.46           H  
ATOM    268 HD12 LEU H  33      18.312  -2.837  11.814  0.55 21.46           H  
ATOM    269 HD13 LEU H  33      18.728  -1.209  12.294  0.55 21.46           H  
ATOM    270 HD21 LEU H  33      16.955   0.798  11.573  0.55 21.13           H  
ATOM    271 HD22 LEU H  33      18.093   0.130  10.404  0.55 21.13           H  
ATOM    272 HD23 LEU H  33      16.405   0.382   9.993  0.55 21.13           H  
ATOM    273  N   PHE H  34      15.439  -2.817   6.934  1.00 21.88           N  
ATOM    274  CA  PHE H  34      15.021  -3.622   5.806  1.00 20.70           C  
ATOM    275  C   PHE H  34      16.269  -4.061   5.044  1.00 22.35           C  
ATOM    276  O   PHE H  34      17.091  -3.225   4.677  1.00 26.55           O  
ATOM    277  CB  PHE H  34      14.084  -2.756   4.948  1.00 24.46           C  
ATOM    278  CG  PHE H  34      13.341  -3.513   3.871  1.00 26.19           C  
ATOM    279  CD1 PHE H  34      13.756  -3.451   2.525  1.00 29.53           C  
ATOM    280  CD2 PHE H  34      12.285  -4.374   4.235  1.00 31.45           C  
ATOM    281  CE1 PHE H  34      13.064  -4.171   1.562  1.00 32.38           C  
ATOM    282  CE2 PHE H  34      11.621  -5.101   3.259  1.00 31.63           C  
ATOM    283  CZ  PHE H  34      11.994  -4.979   1.928  1.00 32.57           C  
ATOM    284  H   PHE H  34      15.966  -1.983   6.705  1.00 21.88           H  
ATOM    285  HA  PHE H  34      14.477  -4.504   6.148  1.00 20.70           H  
ATOM    286  HB3 PHE H  34      14.626  -1.922   4.500  1.00 24.46           H  
ATOM    287  HB2 PHE H  34      13.332  -2.298   5.593  1.00 24.46           H  
ATOM    288  HD1 PHE H  34      14.594  -2.833   2.238  1.00 29.53           H  
ATOM    289  HD2 PHE H  34      11.989  -4.467   5.270  1.00 31.45           H  
ATOM    290  HE1 PHE H  34      13.359  -4.100   0.527  1.00 32.38           H  
ATOM    291  HE2 PHE H  34      10.802  -5.750   3.534  1.00 31.63           H  
ATOM    292  HZ  PHE H  34      11.438  -5.514   1.176  1.00 32.57           H  
ATOM    293  N   ARG H  35      16.372  -5.373   4.810  1.00 21.45           N  
ATOM    294  CA  ARG H  35      17.425  -5.986   4.009  1.00 24.56           C  
ATOM    295  C   ARG H  35      17.180  -5.702   2.522  1.00 29.79           C  
ATOM    296  O   ARG H  35      16.028  -5.739   2.092  1.00 33.93           O  
ATOM    297  CB  ARG H  35      17.403  -7.490   4.305  1.00 27.46           C  
ATOM    298  CG  ARG H  35      18.636  -8.259   3.822  1.00 34.79           C  
ATOM    299  CD  ARG H  35      18.605  -9.713   4.311  1.00 41.61           C  
ATOM    300  NE  ARG H  35      19.909 -10.370   4.155  1.00 41.83           N  
ATOM    301  CZ  ARG H  35      20.321 -11.494   4.771  1.00 49.07           C  
ATOM    302  NH1 ARG H  35      19.530 -12.191   5.602  1.00 54.91           N  
ATOM    303  NH2 ARG H  35      21.567 -11.928   4.546  1.00 52.73           N1+
ATOM    304  H   ARG H  35      15.638  -5.994   5.128  1.00 21.45           H  
ATOM    305  HA  ARG H  35      18.386  -5.568   4.318  1.00 24.56           H  
ATOM    306  HB3 ARG H  35      16.492  -7.928   3.902  1.00 27.46           H  
ATOM    307  HB2 ARG H  35      17.338  -7.634   5.378  1.00 27.46           H  
ATOM    308  HG3 ARG H  35      19.566  -7.758   4.098  1.00 34.79           H  
ATOM    309  HG2 ARG H  35      18.597  -8.265   2.732  1.00 34.79           H  
ATOM    310  HD3 ARG H  35      17.944 -10.281   3.658  1.00 41.61           H  
ATOM    311  HD2 ARG H  35      18.191  -9.798   5.314  1.00 41.61           H  
ATOM    312  HE  ARG H  35      20.543  -9.918   3.511  1.00 41.83           H  
ATOM    313 HH12 ARG H  35      19.861 -13.032   6.051  1.00 54.91           H  
ATOM    314 HH11 ARG H  35      18.569 -11.902   5.751  1.00 54.91           H  
ATOM    315 HH22 ARG H  35      21.905 -12.768   4.993  1.00 52.73           H  
ATOM    316 HH21 ARG H  35      22.181 -11.420   3.927  1.00 52.73           H  
ATOM    317  N   LYS H  36      18.251  -5.428   1.763  1.00 33.97           N  
ATOM    318  CA  LYS H  36      18.153  -5.156   0.328  1.00 35.83           C  
ATOM    319  C   LYS H  36      17.880  -6.408  -0.521  1.00 40.01           C  
ATOM    320  O   LYS H  36      17.130  -6.303  -1.490  1.00 50.34           O  
ATOM    321  CB  LYS H  36      19.418  -4.442  -0.174  1.00 38.56           C  
ATOM    322  CG  LYS H  36      19.546  -2.995   0.318  1.00 38.79           C  
ATOM    323  CD  LYS H  36      20.653  -2.245  -0.434  1.00 42.89           C  
ATOM    324  CE  LYS H  36      20.977  -0.881   0.189  1.00 43.52           C  
ATOM    325  NZ  LYS H  36      22.057  -0.187  -0.530  1.00 49.41           N1+
ATOM    326  H   LYS H  36      19.174  -5.394   2.174  1.00 33.97           H  
ATOM    327  HA  LYS H  36      17.310  -4.479   0.173  1.00 35.83           H  
ATOM    328  HB3 LYS H  36      19.391  -4.413  -1.265  1.00 38.56           H  
ATOM    329  HB2 LYS H  36      20.312  -5.011   0.087  1.00 38.56           H  
ATOM    330  HG3 LYS H  36      19.743  -2.983   1.390  1.00 38.79           H  
ATOM    331  HG2 LYS H  36      18.600  -2.475   0.176  1.00 38.79           H  
ATOM    332  HD3 LYS H  36      20.336  -2.103  -1.468  1.00 42.89           H  
ATOM    333  HD2 LYS H  36      21.542  -2.872  -0.479  1.00 42.89           H  
ATOM    334  HE3 LYS H  36      21.284  -1.009   1.226  1.00 43.52           H  
ATOM    335  HE2 LYS H  36      20.095  -0.244   0.180  1.00 43.52           H  
ATOM    336  HZ1 LYS H  36      21.785  -0.030  -1.489  1.00 49.41           H  
ATOM    337  HZ2 LYS H  36      22.243   0.699  -0.079  1.00 49.41           H  
ATOM    338  HZ3 LYS H  36      22.889  -0.760  -0.502  1.00 49.41           H  
ATOM    339  N   SER H  36A     18.492  -7.549  -0.164  1.00 44.79           N  
ATOM    340  CA  SER H  36A     18.365  -8.806  -0.900  1.00 48.34           C  
ATOM    341  C   SER H  36A     18.856  -9.960   0.002  1.00 47.07           C  
ATOM    342  O   SER H  36A     20.042  -9.966   0.337  1.00 50.34           O  
ATOM    343  CB  SER H  36A     19.172  -8.720  -2.217  1.00 56.28           C  
ATOM    344  OG  SER H  36A     18.983  -9.884  -2.997  1.00 69.26           O  
ATOM    345  H   SER H  36A     19.114  -7.559   0.633  1.00 44.79           H  
ATOM    346  HA  SER H  36A     17.323  -8.927  -1.186  1.00 48.34           H  
ATOM    347  HB3 SER H  36A     20.237  -8.588  -2.019  1.00 56.28           H  
ATOM    348  HB2 SER H  36A     18.857  -7.866  -2.818  1.00 56.28           H  
ATOM    349  HG  SER H  36A     19.492 -10.600  -2.611  1.00 69.26           H  
ATOM    350  N   PRO H  37      17.978 -10.924   0.375  1.00 46.36           N  
ATOM    351  CA  PRO H  37      16.521 -10.962   0.127  1.00 44.14           C  
ATOM    352  C   PRO H  37      15.769  -9.828   0.843  1.00 40.55           C  
ATOM    353  O   PRO H  37      16.091  -9.521   1.988  1.00 45.34           O  
ATOM    354  CB  PRO H  37      16.097 -12.341   0.665  1.00 48.16           C  
ATOM    355  CG  PRO H  37      17.136 -12.691   1.716  1.00 49.52           C  
ATOM    356  CD  PRO H  37      18.410 -12.105   1.126  1.00 48.92           C  
ATOM    357  HA  PRO H  37      16.317 -10.921  -0.944  1.00 44.14           H  
ATOM    358  HB3 PRO H  37      16.139 -13.070  -0.145  1.00 48.16           H  
ATOM    359  HB2 PRO H  37      15.082 -12.365   1.066  1.00 48.16           H  
ATOM    360  HG3 PRO H  37      17.204 -13.760   1.921  1.00 49.52           H  
ATOM    361  HG2 PRO H  37      16.893 -12.186   2.652  1.00 49.52           H  
ATOM    362  HD2 PRO H  37      19.144 -11.886   1.901  1.00 48.92           H  
ATOM    363  HD3 PRO H  37      18.865 -12.809   0.427  1.00 48.92           H  
ATOM    364  N   GLN H  38      14.802  -9.217   0.139  1.00 42.52           N  
ATOM    365  CA  GLN H  38      13.946  -8.153   0.662  1.00 41.61           C  
ATOM    366  C   GLN H  38      13.047  -8.628   1.814  1.00 40.09           C  
ATOM    367  O   GLN H  38      12.078  -9.345   1.564  1.00 51.15           O  
ATOM    368  CB  GLN H  38      13.145  -7.508  -0.490  1.00 48.28           C  
ATOM    369  CG  GLN H  38      13.989  -6.511  -1.310  1.00 51.57           C  
ATOM    370  CD  GLN H  38      13.168  -5.473  -2.080  1.00 59.88           C  
ATOM    371  OE1 GLN H  38      11.980  -5.654  -2.337  1.00 78.48           O  
ATOM    372  NE2 GLN H  38      13.814  -4.368  -2.458  1.00 64.02           N  
ATOM    373  H   GLN H  38      14.601  -9.522  -0.802  1.00 42.52           H  
ATOM    374  HA  GLN H  38      14.603  -7.393   1.073  1.00 41.61           H  
ATOM    375  HB3 GLN H  38      12.283  -6.993  -0.075  1.00 48.28           H  
ATOM    376  HB2 GLN H  38      12.731  -8.274  -1.146  1.00 48.28           H  
ATOM    377  HG3 GLN H  38      14.631  -7.052  -2.006  1.00 51.57           H  
ATOM    378  HG2 GLN H  38      14.645  -5.955  -0.640  1.00 51.57           H  
ATOM    379 HE22 GLN H  38      13.327  -3.650  -2.973  1.00 64.02           H  
ATOM    380 HE21 GLN H  38      14.795  -4.253  -2.248  1.00 64.02           H  
ATOM    381  N   GLU H  39      13.404  -8.238   3.050  1.00 38.19           N  
ATOM    382  CA  GLU H  39      12.742  -8.690   4.275  1.00 38.25           C  
ATOM    383  C   GLU H  39      12.993  -7.699   5.421  1.00 32.81           C  
ATOM    384  O   GLU H  39      13.991  -6.976   5.410  1.00 25.80           O  
ATOM    385  CB  GLU H  39      13.225 -10.123   4.631  1.00 46.12           C  
ATOM    386  CG  GLU H  39      14.676 -10.228   5.174  1.00 49.01           C  
ATOM    387  CD  GLU H  39      15.210 -11.652   5.407  1.00 52.03           C  
ATOM    388  OE1 GLU H  39      14.553 -12.629   4.984  1.00 46.60           O  
ATOM    389  OE2 GLU H  39      16.304 -11.740   6.008  1.00 66.03           O1-
ATOM    390  H   GLU H  39      14.211  -7.642   3.178  1.00 38.19           H  
ATOM    391  HA  GLU H  39      11.666  -8.714   4.091  1.00 38.25           H  
ATOM    392  HB3 GLU H  39      13.120 -10.756   3.749  1.00 46.12           H  
ATOM    393  HB2 GLU H  39      12.543 -10.547   5.368  1.00 46.12           H  
ATOM    394  HG3 GLU H  39      14.760  -9.687   6.117  1.00 49.01           H  
ATOM    395  HG2 GLU H  39      15.355  -9.741   4.480  1.00 49.01           H  
ATOM    396  N   LEU H  40      12.103  -7.748   6.427  1.00 29.92           N  
ATOM    397  CA  LEU H  40      12.281  -7.128   7.742  0.60 26.66           C  
ATOM    398  C   LEU H  40      13.467  -7.779   8.473  1.00 27.26           C  
ATOM    399  O   LEU H  40      13.503  -9.004   8.588  1.00 35.94           O  
ATOM    400  CB  LEU H  40      10.962  -7.281   8.547  0.60 27.63           C  
ATOM    401  CG  LEU H  40      11.006  -6.947  10.064  0.60 24.55           C  
ATOM    402  CD1 LEU H  40      11.272  -5.459  10.331  0.60 18.00           C  
ATOM    403  CD2 LEU H  40       9.731  -7.409  10.790  0.60 24.38           C  
ATOM    404  H   LEU H  40      11.320  -8.381   6.351  1.00 29.92           H  
ATOM    405  HA  LEU H  40      12.487  -6.066   7.593  0.60 26.66           H  
ATOM    406  HB3 LEU H  40      10.636  -8.319   8.456  0.60 27.63           H  
ATOM    407  HB2 LEU H  40      10.182  -6.686   8.071  0.60 27.63           H  
ATOM    408  HG  LEU H  40      11.820  -7.502  10.530  0.60 24.55           H  
ATOM    409 HD11 LEU H  40      11.557  -5.309  11.371  0.60 18.00           H  
ATOM    410 HD12 LEU H  40      12.079  -5.071   9.712  0.60 18.00           H  
ATOM    411 HD13 LEU H  40      10.381  -4.859  10.147  0.60 18.00           H  
ATOM    412 HD21 LEU H  40       9.350  -6.643  11.464  0.60 24.38           H  
ATOM    413 HD22 LEU H  40       8.929  -7.662  10.096  0.60 24.38           H  
ATOM    414 HD23 LEU H  40       9.928  -8.293  11.396  0.60 24.38           H  
ATOM    415  N   LEU H  41      14.376  -6.941   8.986  1.00 21.10           N  
ATOM    416  CA  LEU H  41      15.478  -7.372   9.842  1.00 21.68           C  
ATOM    417  C   LEU H  41      15.184  -7.049  11.305  1.00 19.88           C  
ATOM    418  O   LEU H  41      15.427  -7.900  12.159  1.00 28.78           O  
ATOM    419  CB  LEU H  41      16.782  -6.673   9.412  1.00 23.90           C  
ATOM    420  CG  LEU H  41      17.281  -7.110   8.028  1.00 31.25           C  
ATOM    421  CD1 LEU H  41      18.491  -6.261   7.617  1.00 34.98           C  
ATOM    422  CD2 LEU H  41      17.591  -8.620   7.967  1.00 35.86           C  
ATOM    423  H   LEU H  41      14.287  -5.945   8.833  1.00 21.10           H  
ATOM    424  HA  LEU H  41      15.615  -8.452   9.779  1.00 21.68           H  
ATOM    425  HB3 LEU H  41      17.567  -6.867  10.142  1.00 23.90           H  
ATOM    426  HB2 LEU H  41      16.635  -5.591   9.416  1.00 23.90           H  
ATOM    427  HG  LEU H  41      16.488  -6.906   7.308  1.00 31.25           H  
ATOM    428 HD11 LEU H  41      19.159  -6.779   6.928  1.00 34.98           H  
ATOM    429 HD12 LEU H  41      18.153  -5.353   7.120  1.00 34.98           H  
ATOM    430 HD13 LEU H  41      19.081  -5.960   8.484  1.00 34.98           H  
ATOM    431 HD21 LEU H  41      18.510  -8.835   7.427  1.00 35.86           H  
ATOM    432 HD22 LEU H  41      17.698  -9.060   8.959  1.00 35.86           H  
ATOM    433 HD23 LEU H  41      16.790  -9.156   7.456  1.00 35.86           H  
ATOM    434  N   CYS H  42      14.700  -5.825  11.559  1.00 18.33           N  
ATOM    435  CA  CYS H  42      14.570  -5.249  12.890  1.00 17.66           C  
ATOM    436  C   CYS H  42      13.692  -3.996  12.848  1.00 15.31           C  
ATOM    437  O   CYS H  42      13.488  -3.399  11.791  1.00 16.35           O  
ATOM    438  CB  CYS H  42      15.973  -4.888  13.436  1.00 19.49           C  
ATOM    439  SG  CYS H  42      16.792  -6.164  14.419  1.00 18.93           S  
ATOM    440  H   CYS H  42      14.494  -5.198  10.794  1.00 18.33           H  
ATOM    441  HA  CYS H  42      14.085  -5.974  13.547  1.00 17.66           H  
ATOM    442  HB3 CYS H  42      15.915  -4.024  14.094  1.00 19.49           H  
ATOM    443  HB2 CYS H  42      16.643  -4.585  12.632  1.00 19.49           H  
ATOM    444  N   GLY H  43      13.252  -3.593  14.044  1.00 13.20           N  
ATOM    445  CA  GLY H  43      12.758  -2.258  14.325  1.00 12.58           C  
ATOM    446  C   GLY H  43      13.932  -1.328  14.654  1.00 11.22           C  
ATOM    447  O   GLY H  43      15.090  -1.733  14.767  1.00 12.48           O  
ATOM    448  H   GLY H  43      13.492  -4.149  14.855  1.00 13.20           H  
ATOM    449  HA3 GLY H  43      12.116  -2.300  15.197  1.00 12.58           H  
ATOM    450  HA2 GLY H  43      12.164  -1.868  13.497  1.00 12.58           H  
ATOM    451  N   ALA H  44      13.586  -0.054  14.830  1.00 11.02           N  
ATOM    452  CA  ALA H  44      14.481   1.068  15.066  1.00 10.36           C  
ATOM    453  C   ALA H  44      13.627   2.310  15.354  1.00 11.99           C  
ATOM    454  O   ALA H  44      12.396   2.234  15.321  1.00 10.95           O  
ATOM    455  CB  ALA H  44      15.424   1.245  13.863  1.00 12.97           C  
ATOM    456  H   ALA H  44      12.614   0.207  14.726  1.00 11.02           H  
ATOM    457  HA  ALA H  44      15.085   0.878  15.949  1.00 10.36           H  
ATOM    458  HB1 ALA H  44      15.957   2.190  13.905  1.00 12.97           H  
ATOM    459  HB2 ALA H  44      16.179   0.461  13.837  1.00 12.97           H  
ATOM    460  HB3 ALA H  44      14.884   1.196  12.919  1.00 12.97           H  
ATOM    461  N   SER H  45      14.293   3.435  15.640  1.00  9.71           N  
ATOM    462  CA  SER H  45      13.640   4.695  15.973  1.00 10.10           C  
ATOM    463  C   SER H  45      14.426   5.888  15.425  1.00  9.77           C  
ATOM    464  O   SER H  45      15.649   5.899  15.491  1.00 13.34           O  
ATOM    465  CB  SER H  45      13.447   4.781  17.496  1.00 10.11           C  
ATOM    466  OG  SER H  45      14.691   4.957  18.136  1.00 11.36           O  
ATOM    467  H   SER H  45      15.305   3.436  15.672  1.00  9.71           H  
ATOM    468  HA  SER H  45      12.656   4.694  15.514  1.00 10.10           H  
ATOM    469  HB3 SER H  45      12.967   3.880  17.873  1.00 10.11           H  
ATOM    470  HB2 SER H  45      12.801   5.621  17.753  1.00 10.11           H  
ATOM    471  HG  SER H  45      14.538   5.134  19.073  1.00 11.36           H  
ATOM    472  N   LEU H  46      13.690   6.896  14.948  1.00 10.10           N  
ATOM    473  CA  LEU H  46      14.196   8.190  14.517  1.00 10.74           C  
ATOM    474  C   LEU H  46      14.403   9.075  15.758  1.00 11.26           C  
ATOM    475  O   LEU H  46      13.458   9.244  16.529  1.00 11.30           O  
ATOM    476  CB  LEU H  46      13.152   8.793  13.548  1.00 12.45           C  
ATOM    477  CG  LEU H  46      13.664   9.983  12.720  1.00 11.82           C  
ATOM    478  CD1 LEU H  46      14.730   9.528  11.701  1.00 15.84           C  
ATOM    479  CD2 LEU H  46      12.500  10.740  12.047  1.00 15.53           C  
ATOM    480  H   LEU H  46      12.683   6.790  14.916  1.00 10.10           H  
ATOM    481  HA  LEU H  46      15.145   8.043  13.998  1.00 10.74           H  
ATOM    482  HB3 LEU H  46      12.280   9.104  14.124  1.00 12.45           H  
ATOM    483  HB2 LEU H  46      12.788   8.024  12.863  1.00 12.45           H  
ATOM    484  HG  LEU H  46      14.128  10.690  13.407  1.00 11.82           H  
ATOM    485 HD11 LEU H  46      14.801  10.203  10.850  1.00 15.84           H  
ATOM    486 HD12 LEU H  46      15.718   9.495  12.157  1.00 15.84           H  
ATOM    487 HD13 LEU H  46      14.522   8.528  11.318  1.00 15.84           H  
ATOM    488 HD21 LEU H  46      12.586  10.757  10.962  1.00 15.53           H  
ATOM    489 HD22 LEU H  46      11.529  10.298  12.277  1.00 15.53           H  
ATOM    490 HD23 LEU H  46      12.465  11.775  12.385  1.00 15.53           H  
ATOM    491  N   ILE H  47      15.621   9.611  15.927  1.00 12.13           N  
ATOM    492  CA  ILE H  47      15.986  10.486  17.050  1.00 12.02           C  
ATOM    493  C   ILE H  47      16.416  11.900  16.591  1.00 14.64           C  
ATOM    494  O   ILE H  47      16.476  12.806  17.421  1.00 15.50           O  
ATOM    495  CB  ILE H  47      17.095   9.844  17.937  1.00 12.15           C  
ATOM    496  CG1 ILE H  47      18.411   9.519  17.200  1.00 14.58           C  
ATOM    497  CG2 ILE H  47      16.558   8.615  18.698  1.00 12.29           C  
ATOM    498  CD1 ILE H  47      19.613   9.359  18.142  1.00 16.48           C  
ATOM    499  H   ILE H  47      16.354   9.408  15.261  1.00 12.13           H  
ATOM    500  HA  ILE H  47      15.116  10.654  17.688  1.00 12.02           H  
ATOM    501  HB  ILE H  47      17.360  10.574  18.700  1.00 12.15           H  
ATOM    502 HG13 ILE H  47      18.641  10.319  16.502  1.00 14.58           H  
ATOM    503 HG12 ILE H  47      18.292   8.618  16.597  1.00 14.58           H  
ATOM    504 HG21 ILE H  47      17.289   8.234  19.411  1.00 12.29           H  
ATOM    505 HG22 ILE H  47      15.661   8.866  19.264  1.00 12.29           H  
ATOM    506 HG23 ILE H  47      16.304   7.800  18.019  1.00 12.29           H  
ATOM    507 HD11 ILE H  47      20.541   9.272  17.580  1.00 16.48           H  
ATOM    508 HD12 ILE H  47      19.718  10.223  18.797  1.00 16.48           H  
ATOM    509 HD13 ILE H  47      19.523   8.469  18.765  1.00 16.48           H  
ATOM    510  N   SER H  48      16.634  12.078  15.279  1.00 13.68           N  
ATOM    511  CA  SER H  48      16.800  13.352  14.574  1.00 16.74           C  
ATOM    512  C   SER H  48      16.549  13.108  13.073  1.00 18.14           C  
ATOM    513  O   SER H  48      16.214  11.987  12.694  1.00 21.08           O  
ATOM    514  CB  SER H  48      18.173  13.999  14.886  1.00 20.11           C  
ATOM    515  OG  SER H  48      19.235  13.408  14.164  1.00 20.87           O  
ATOM    516  H   SER H  48      16.563  11.279  14.663  1.00 13.68           H  
ATOM    517  HA  SER H  48      16.013  14.022  14.925  1.00 16.74           H  
ATOM    518  HB3 SER H  48      18.400  13.967  15.952  1.00 20.11           H  
ATOM    519  HB2 SER H  48      18.145  15.056  14.618  1.00 20.11           H  
ATOM    520  HG  SER H  48      20.033  13.914  14.339  1.00 20.87           H  
ATOM    521  N   ASP H  49      16.731  14.134  12.224  1.00 21.33           N  
ATOM    522  CA  ASP H  49      16.596  14.002  10.764  1.00 24.21           C  
ATOM    523  C   ASP H  49      17.637  13.065  10.111  1.00 24.56           C  
ATOM    524  O   ASP H  49      17.355  12.541   9.035  1.00 24.83           O  
ATOM    525  CB  ASP H  49      16.509  15.355  10.005  1.00 28.91           C  
ATOM    526  CG  ASP H  49      17.617  16.407  10.219  1.00 32.38           C  
ATOM    527  OD1 ASP H  49      18.607  16.134  10.935  1.00 33.55           O  
ATOM    528  OD2 ASP H  49      17.463  17.490   9.614  1.00 42.36           O1-
ATOM    529  H   ASP H  49      17.040  15.035  12.562  1.00 21.33           H  
ATOM    530  HA  ASP H  49      15.638  13.511  10.597  1.00 24.21           H  
ATOM    531  HB3 ASP H  49      15.569  15.832  10.283  1.00 28.91           H  
ATOM    532  HB2 ASP H  49      16.420  15.164   8.934  1.00 28.91           H  
ATOM    533  N   ARG H  50      18.796  12.859  10.760  1.00 21.10           N  
ATOM    534  CA  ARG H  50      19.905  12.065  10.227  1.00 23.13           C  
ATOM    535  C   ARG H  50      20.337  10.900  11.122  1.00 20.79           C  
ATOM    536  O   ARG H  50      21.151  10.111  10.650  1.00 20.85           O  
ATOM    537  CB  ARG H  50      21.112  12.978   9.948  1.00 31.78           C  
ATOM    538  CG  ARG H  50      20.845  13.984   8.816  1.00 43.76           C  
ATOM    539  CD  ARG H  50      22.111  14.633   8.247  1.00 55.64           C  
ATOM    540  NE  ARG H  50      22.911  13.671   7.465  1.00 64.62           N  
ATOM    541  CZ  ARG H  50      23.874  13.946   6.570  1.00 68.53           C  
ATOM    542  NH1 ARG H  50      24.233  15.199   6.260  1.00 81.88           N  
ATOM    543  NH2 ARG H  50      24.495  12.930   5.971  1.00 78.51           N1+
ATOM    544  H   ARG H  50      18.958  13.333  11.638  1.00 21.10           H  
ATOM    545  HA  ARG H  50      19.614  11.596   9.286  1.00 23.13           H  
ATOM    546  HB3 ARG H  50      21.970  12.362   9.675  1.00 31.78           H  
ATOM    547  HB2 ARG H  50      21.405  13.508  10.855  1.00 31.78           H  
ATOM    548  HG3 ARG H  50      20.107  14.739   9.083  1.00 43.76           H  
ATOM    549  HG2 ARG H  50      20.389  13.407   8.011  1.00 43.76           H  
ATOM    550  HD3 ARG H  50      22.757  14.917   9.078  1.00 55.64           H  
ATOM    551  HD2 ARG H  50      21.872  15.551   7.709  1.00 55.64           H  
ATOM    552  HE  ARG H  50      22.693  12.697   7.627  1.00 64.62           H  
ATOM    553 HH12 ARG H  50      24.953  15.374   5.574  1.00 81.88           H  
ATOM    554 HH11 ARG H  50      23.772  15.980   6.705  1.00 81.88           H  
ATOM    555 HH22 ARG H  50      25.233  13.084   5.298  1.00 78.51           H  
ATOM    556 HH21 ARG H  50      24.232  11.974   6.184  1.00 78.51           H  
ATOM    557  N   TRP H  51      19.826  10.785  12.356  1.00 17.35           N  
ATOM    558  CA  TRP H  51      20.185   9.690  13.256  1.00 14.88           C  
ATOM    559  C   TRP H  51      18.997   8.766  13.515  1.00 12.50           C  
ATOM    560  O   TRP H  51      17.894   9.235  13.804  1.00 13.23           O  
ATOM    561  CB  TRP H  51      20.729  10.233  14.581  1.00 15.38           C  
ATOM    562  CG  TRP H  51      22.116  10.786  14.546  1.00 18.54           C  
ATOM    563  CD1 TRP H  51      22.457  12.086  14.681  1.00 20.15           C  
ATOM    564  CD2 TRP H  51      23.365  10.056  14.363  1.00 20.79           C  
ATOM    565  NE1 TRP H  51      23.830  12.201  14.655  1.00 22.77           N  
ATOM    566  CE2 TRP H  51      24.446  10.982  14.457  1.00 22.91           C  
ATOM    567  CE3 TRP H  51      23.701   8.700  14.142  1.00 19.60           C  
ATOM    568  CZ2 TRP H  51      25.790  10.586  14.346  1.00 21.71           C  
ATOM    569  CZ3 TRP H  51      25.044   8.294  14.025  1.00 19.89           C  
ATOM    570  CH2 TRP H  51      26.088   9.233  14.124  1.00 20.71           C  
ATOM    571  H   TRP H  51      19.156  11.458  12.703  1.00 17.35           H  
ATOM    572  HA  TRP H  51      20.975   9.070  12.828  1.00 14.88           H  
ATOM    573  HB3 TRP H  51      20.761   9.425  15.312  1.00 15.38           H  
ATOM    574  HB2 TRP H  51      20.055  10.989  14.981  1.00 15.38           H  
ATOM    575  HD1 TRP H  51      21.759  12.894  14.833  1.00 20.15           H  
ATOM    576  HE1 TRP H  51      24.301  13.089  14.760  1.00 22.77           H  
ATOM    577  HE3 TRP H  51      22.915   7.963  14.066  1.00 19.60           H  
ATOM    578  HZ2 TRP H  51      26.588  11.309  14.430  1.00 21.71           H  
ATOM    579  HZ3 TRP H  51      25.265   7.252  13.857  1.00 19.89           H  
ATOM    580  HH2 TRP H  51      27.117   8.919  14.043  1.00 20.71           H  
ATOM    581  N   VAL H  52      19.297   7.462  13.457  1.00 14.00           N  
ATOM    582  CA  VAL H  52      18.386   6.377  13.782  1.00 13.91           C  
ATOM    583  C   VAL H  52      19.072   5.468  14.816  1.00 13.68           C  
ATOM    584  O   VAL H  52      20.208   5.049  14.602  1.00 17.18           O  
ATOM    585  CB  VAL H  52      18.019   5.552  12.519  1.00 14.69           C  
ATOM    586  CG1 VAL H  52      17.171   4.299  12.807  1.00 15.14           C  
ATOM    587  CG2 VAL H  52      17.283   6.423  11.487  1.00 16.24           C  
ATOM    588  H   VAL H  52      20.232   7.177  13.195  1.00 14.00           H  
ATOM    589  HA  VAL H  52      17.479   6.792  14.212  1.00 13.91           H  
ATOM    590  HB  VAL H  52      18.943   5.212  12.050  1.00 14.69           H  
ATOM    591 HG11 VAL H  52      16.969   3.747  11.890  1.00 15.14           H  
ATOM    592 HG12 VAL H  52      17.670   3.609  13.485  1.00 15.14           H  
ATOM    593 HG13 VAL H  52      16.211   4.563  13.249  1.00 15.14           H  
ATOM    594 HG21 VAL H  52      16.992   5.831  10.623  1.00 16.24           H  
ATOM    595 HG22 VAL H  52      16.379   6.860  11.912  1.00 16.24           H  
ATOM    596 HG23 VAL H  52      17.910   7.237  11.122  1.00 16.24           H  
ATOM    597  N   LEU H  53      18.354   5.181  15.909  1.00 12.04           N  
ATOM    598  CA  LEU H  53      18.779   4.331  17.016  1.00 10.96           C  
ATOM    599  C   LEU H  53      18.166   2.929  16.858  1.00 10.35           C  
ATOM    600  O   LEU H  53      17.023   2.808  16.422  1.00 12.45           O  
ATOM    601  CB  LEU H  53      18.327   5.030  18.321  1.00 12.81           C  
ATOM    602  CG  LEU H  53      18.712   4.333  19.645  1.00 13.39           C  
ATOM    603  CD1 LEU H  53      20.240   4.208  19.801  1.00 17.08           C  
ATOM    604  CD2 LEU H  53      18.050   5.032  20.851  1.00 14.07           C  
ATOM    605  H   LEU H  53      17.409   5.540  15.976  1.00 12.04           H  
ATOM    606  HA  LEU H  53      19.865   4.242  17.010  1.00 10.96           H  
ATOM    607  HB3 LEU H  53      17.246   5.152  18.290  1.00 12.81           H  
ATOM    608  HB2 LEU H  53      18.732   6.044  18.337  1.00 12.81           H  
ATOM    609  HG  LEU H  53      18.300   3.323  19.624  1.00 13.39           H  
ATOM    610 HD11 LEU H  53      20.601   4.565  20.763  1.00 17.08           H  
ATOM    611 HD12 LEU H  53      20.546   3.168  19.699  1.00 17.08           H  
ATOM    612 HD13 LEU H  53      20.782   4.770  19.043  1.00 17.08           H  
ATOM    613 HD21 LEU H  53      17.515   4.312  21.471  1.00 14.07           H  
ATOM    614 HD22 LEU H  53      18.768   5.540  21.494  1.00 14.07           H  
ATOM    615 HD23 LEU H  53      17.323   5.782  20.537  1.00 14.07           H  
ATOM    616  N   THR H  54      18.931   1.898  17.239  1.00 10.00           N  
ATOM    617  CA  THR H  54      18.527   0.494  17.177  1.00 11.78           C  
ATOM    618  C   THR H  54      19.364  -0.338  18.175  1.00 12.10           C  
ATOM    619  O   THR H  54      20.232   0.213  18.854  1.00 12.12           O  
ATOM    620  CB  THR H  54      18.659  -0.059  15.722  1.00 12.60           C  
ATOM    621  OG1 THR H  54      18.054  -1.331  15.588  1.00 13.35           O  
ATOM    622  CG2 THR H  54      20.106  -0.185  15.207  1.00 14.42           C  
ATOM    623  H   THR H  54      19.868   2.066  17.585  1.00 10.00           H  
ATOM    624  HA  THR H  54      17.488   0.418  17.499  1.00 11.78           H  
ATOM    625  HB  THR H  54      18.124   0.610  15.050  1.00 12.60           H  
ATOM    626  HG1 THR H  54      17.097  -1.224  15.590  1.00 13.35           H  
ATOM    627 HG21 THR H  54      20.125  -0.539  14.176  1.00 14.42           H  
ATOM    628 HG22 THR H  54      20.621   0.775  15.233  1.00 14.42           H  
ATOM    629 HG23 THR H  54      20.693  -0.889  15.792  1.00 14.42           H  
ATOM    630  N   ALA H  55      19.091  -1.649  18.257  1.00 11.52           N  
ATOM    631  CA  ALA H  55      19.898  -2.617  18.993  1.00 11.01           C  
ATOM    632  C   ALA H  55      21.124  -3.026  18.165  1.00 10.73           C  
ATOM    633  O   ALA H  55      21.014  -3.181  16.950  1.00 13.56           O  
ATOM    634  CB  ALA H  55      19.034  -3.845  19.313  1.00 11.63           C  
ATOM    635  H   ALA H  55      18.386  -2.036  17.645  1.00 11.52           H  
ATOM    636  HA  ALA H  55      20.234  -2.175  19.931  1.00 11.01           H  
ATOM    637  HB1 ALA H  55      19.636  -4.647  19.728  1.00 11.63           H  
ATOM    638  HB2 ALA H  55      18.270  -3.610  20.052  1.00 11.63           H  
ATOM    639  HB3 ALA H  55      18.538  -4.237  18.426  1.00 11.63           H  
ATOM    640  N   ALA H  56      22.265  -3.231  18.837  1.00 12.16           N  
ATOM    641  CA  ALA H  56      23.503  -3.714  18.223  1.00 12.49           C  
ATOM    642  C   ALA H  56      23.408  -5.125  17.616  1.00 13.94           C  
ATOM    643  O   ALA H  56      24.079  -5.373  16.617  1.00 14.43           O  
ATOM    644  CB  ALA H  56      24.634  -3.656  19.250  1.00 15.00           C  
ATOM    645  H   ALA H  56      22.277  -3.129  19.842  1.00 12.16           H  
ATOM    646  HA  ALA H  56      23.753  -3.038  17.405  1.00 12.49           H  
ATOM    647  HB1 ALA H  56      25.554  -4.063  18.835  1.00 15.00           H  
ATOM    648  HB2 ALA H  56      24.840  -2.634  19.556  1.00 15.00           H  
ATOM    649  HB3 ALA H  56      24.388  -4.226  20.144  1.00 15.00           H  
ATOM    650  N   HIS H  57      22.563  -6.001  18.191  1.00 13.89           N  
ATOM    651  CA  HIS H  57      22.323  -7.365  17.713  1.00 14.85           C  
ATOM    652  C   HIS H  57      21.578  -7.439  16.371  1.00 13.82           C  
ATOM    653  O   HIS H  57      21.619  -8.496  15.750  1.00 16.92           O  
ATOM    654  CB  HIS H  57      21.657  -8.234  18.802  1.00 14.53           C  
ATOM    655  CG  HIS H  57      20.154  -8.165  18.864  1.00 14.97           C  
ATOM    656  ND1 HIS H  57      19.473  -7.322  19.716  1.00 15.13           N  
ATOM    657  CD2 HIS H  57      19.184  -8.863  18.181  1.00 15.06           C  
ATOM    658  CE1 HIS H  57      18.172  -7.522  19.519  1.00 17.79           C  
ATOM    659  NE2 HIS H  57      17.925  -8.463  18.618  1.00 16.81           N  
ATOM    660  H   HIS H  57      22.083  -5.736  19.044  1.00 13.89           H  
ATOM    661  HA  HIS H  57      23.300  -7.797  17.537  1.00 14.85           H  
ATOM    662  HB3 HIS H  57      22.060  -7.990  19.786  1.00 14.53           H  
ATOM    663  HB2 HIS H  57      21.922  -9.278  18.634  1.00 14.53           H  
ATOM    664  HD1 HIS H  57      19.881  -6.697  20.407  1.00 15.13           H  
ATOM    665  HD2 HIS H  57      19.296  -9.628  17.428  1.00 15.06           H  
ATOM    666  HE1 HIS H  57      17.398  -6.989  20.052  1.00 17.79           H  
ATOM    667  N   CYS H  58      20.929  -6.340  15.946  1.00 13.63           N  
ATOM    668  CA  CYS H  58      20.331  -6.186  14.616  1.00 14.38           C  
ATOM    669  C   CYS H  58      21.367  -6.073  13.493  1.00 16.22           C  
ATOM    670  O   CYS H  58      21.014  -6.310  12.339  1.00 19.01           O  
ATOM    671  CB  CYS H  58      19.457  -4.923  14.598  1.00 16.98           C  
ATOM    672  SG  CYS H  58      17.993  -5.066  15.629  1.00 17.48           S  
ATOM    673  H   CYS H  58      20.920  -5.515  16.531  1.00 13.63           H  
ATOM    674  HA  CYS H  58      19.708  -7.058  14.414  1.00 14.38           H  
ATOM    675  HB3 CYS H  58      19.115  -4.704  13.585  1.00 16.98           H  
ATOM    676  HB2 CYS H  58      20.028  -4.049  14.900  1.00 16.98           H  
ATOM    677  N   LEU H  59      22.597  -5.683  13.854  1.00 15.94           N  
ATOM    678  CA  LEU H  59      23.685  -5.369  12.937  1.00 17.20           C  
ATOM    679  C   LEU H  59      24.846  -6.356  13.100  1.00 18.14           C  
ATOM    680  O   LEU H  59      25.479  -6.681  12.100  1.00 25.19           O  
ATOM    681  CB  LEU H  59      24.150  -3.920  13.211  1.00 19.62           C  
ATOM    682  CG  LEU H  59      23.055  -2.851  12.977  1.00 20.95           C  
ATOM    683  CD1 LEU H  59      23.496  -1.467  13.485  1.00 22.24           C  
ATOM    684  CD2 LEU H  59      22.588  -2.814  11.511  1.00 25.66           C  
ATOM    685  H   LEU H  59      22.787  -5.510  14.832  1.00 15.94           H  
ATOM    686  HA  LEU H  59      23.346  -5.440  11.904  1.00 17.20           H  
ATOM    687  HB3 LEU H  59      25.015  -3.686  12.587  1.00 19.62           H  
ATOM    688  HB2 LEU H  59      24.500  -3.852  14.242  1.00 19.62           H  
ATOM    689  HG  LEU H  59      22.188  -3.116  13.583  1.00 20.95           H  
ATOM    690 HD11 LEU H  59      22.755  -1.053  14.168  1.00 22.24           H  
ATOM    691 HD12 LEU H  59      24.439  -1.516  14.030  1.00 22.24           H  
ATOM    692 HD13 LEU H  59      23.627  -0.743  12.681  1.00 22.24           H  
ATOM    693 HD21 LEU H  59      22.470  -1.800  11.130  1.00 25.66           H  
ATOM    694 HD22 LEU H  59      23.294  -3.322  10.852  1.00 25.66           H  
ATOM    695 HD23 LEU H  59      21.623  -3.309  11.404  1.00 25.66           H  
ATOM    696  N   LEU H  60      25.104  -6.815  14.335  1.00 18.43           N  
ATOM    697  CA  LEU H  60      26.234  -7.664  14.688  1.00 17.79           C  
ATOM    698  C   LEU H  60      25.777  -8.704  15.712  1.00 16.34           C  
ATOM    699  O   LEU H  60      25.527  -8.352  16.861  1.00 18.09           O  
ATOM    700  CB  LEU H  60      27.374  -6.773  15.239  1.00 21.44           C  
ATOM    701  CG  LEU H  60      28.655  -7.518  15.679  1.00 21.47           C  
ATOM    702  CD1 LEU H  60      29.312  -8.258  14.498  1.00 21.38           C  
ATOM    703  CD2 LEU H  60      29.636  -6.569  16.399  1.00 24.37           C  
ATOM    704  H   LEU H  60      24.543  -6.494  15.114  1.00 18.43           H  
ATOM    705  HA  LEU H  60      26.593  -8.188  13.802  1.00 17.79           H  
ATOM    706  HB3 LEU H  60      26.989  -6.211  16.092  1.00 21.44           H  
ATOM    707  HB2 LEU H  60      27.643  -6.035  14.483  1.00 21.44           H  
ATOM    708  HG  LEU H  60      28.379  -8.259  16.427  1.00 21.47           H  
ATOM    709 HD11 LEU H  60      30.401  -8.229  14.535  1.00 21.38           H  
ATOM    710 HD12 LEU H  60      29.019  -9.307  14.484  1.00 21.38           H  
ATOM    711 HD13 LEU H  60      29.010  -7.832  13.541  1.00 21.38           H  
ATOM    712 HD21 LEU H  60      29.942  -6.986  17.359  1.00 24.37           H  
ATOM    713 HD22 LEU H  60      30.540  -6.386  15.819  1.00 24.37           H  
ATOM    714 HD23 LEU H  60      29.189  -5.596  16.604  1.00 24.37           H  
ATOM    715  N   TYR H  60A     25.738  -9.976  15.303  1.00 15.62           N  
ATOM    716  CA  TYR H  60A     25.546 -11.096  16.214  1.00 15.74           C  
ATOM    717  C   TYR H  60A     26.248 -12.333  15.625  1.00 16.40           C  
ATOM    718  O   TYR H  60A     25.597 -13.116  14.930  1.00 17.90           O  
ATOM    719  CB  TYR H  60A     24.050 -11.292  16.549  1.00 17.15           C  
ATOM    720  CG  TYR H  60A     23.822 -12.237  17.714  1.00 17.19           C  
ATOM    721  CD1 TYR H  60A     24.228 -11.866  19.014  1.00 16.22           C  
ATOM    722  CD2 TYR H  60A     23.240 -13.501  17.501  1.00 18.60           C  
ATOM    723  CE1 TYR H  60A     24.071 -12.762  20.089  1.00 18.47           C  
ATOM    724  CE2 TYR H  60A     23.068 -14.389  18.579  1.00 19.84           C  
ATOM    725  CZ  TYR H  60A     23.487 -14.024  19.872  1.00 19.42           C  
ATOM    726  OH  TYR H  60A     23.330 -14.901  20.904  1.00 20.30           O  
ATOM    727  H   TYR H  60A     25.977 -10.207  14.346  1.00 15.62           H  
ATOM    728  HA  TYR H  60A     26.029 -10.859  17.163  1.00 15.74           H  
ATOM    729  HB3 TYR H  60A     23.492 -11.624  15.672  1.00 17.15           H  
ATOM    730  HB2 TYR H  60A     23.605 -10.339  16.835  1.00 17.15           H  
ATOM    731  HD1 TYR H  60A     24.678 -10.901  19.190  1.00 16.22           H  
ATOM    732  HD2 TYR H  60A     22.938 -13.793  16.509  1.00 18.60           H  
ATOM    733  HE1 TYR H  60A     24.400 -12.478  21.078  1.00 18.47           H  
ATOM    734  HE2 TYR H  60A     22.628 -15.361  18.412  1.00 19.84           H  
ATOM    735  HH  TYR H  60A     23.826 -14.663  21.694  1.00 20.30           H  
ATOM    736  N   PRO H  60B     27.571 -12.478  15.893  1.00 17.12           N  
ATOM    737  CA  PRO H  60B     28.394 -13.590  15.379  1.00 18.76           C  
ATOM    738  C   PRO H  60B     27.961 -15.052  15.636  1.00 18.55           C  
ATOM    739  O   PRO H  60B     28.279 -15.868  14.771  1.00 22.10           O  
ATOM    740  CB  PRO H  60B     29.797 -13.326  15.950  1.00 20.42           C  
ATOM    741  CG  PRO H  60B     29.833 -11.829  16.177  1.00 22.09           C  
ATOM    742  CD  PRO H  60B     28.411 -11.522  16.619  1.00 17.41           C  
ATOM    743  HA  PRO H  60B     28.434 -13.443  14.297  1.00 18.76           H  
ATOM    744  HB3 PRO H  60B     30.593 -13.660  15.283  1.00 20.42           H  
ATOM    745  HB2 PRO H  60B     29.930 -13.841  16.902  1.00 20.42           H  
ATOM    746  HG3 PRO H  60B     30.037 -11.330  15.229  1.00 22.09           H  
ATOM    747  HG2 PRO H  60B     30.592 -11.512  16.890  1.00 22.09           H  
ATOM    748  HD2 PRO H  60B     28.285 -11.694  17.687  1.00 17.41           H  
ATOM    749  HD3 PRO H  60B     28.171 -10.482  16.414  1.00 17.41           H  
ATOM    750  N   PRO H  60C     27.217 -15.387  16.722  1.00 20.31           N  
ATOM    751  CA  PRO H  60C     26.645 -16.741  16.882  1.00 21.20           C  
ATOM    752  C   PRO H  60C     25.666 -17.191  15.779  1.00 24.86           C  
ATOM    753  O   PRO H  60C     25.564 -18.393  15.543  1.00 34.71           O  
ATOM    754  CB  PRO H  60C     25.979 -16.711  18.268  1.00 21.47           C  
ATOM    755  CG  PRO H  60C     26.748 -15.646  19.030  1.00 20.69           C  
ATOM    756  CD  PRO H  60C     27.040 -14.612  17.953  1.00 19.40           C  
ATOM    757  HA  PRO H  60C     27.482 -17.442  16.912  1.00 21.20           H  
ATOM    758  HB3 PRO H  60C     26.009 -17.679  18.769  1.00 21.47           H  
ATOM    759  HB2 PRO H  60C     24.932 -16.419  18.184  1.00 21.47           H  
ATOM    760  HG3 PRO H  60C     27.686 -16.067  19.395  1.00 20.69           H  
ATOM    761  HG2 PRO H  60C     26.206 -15.242  19.885  1.00 20.69           H  
ATOM    762  HD2 PRO H  60C     26.181 -13.953  17.848  1.00 19.40           H  
ATOM    763  HD3 PRO H  60C     27.911 -14.014  18.211  1.00 19.40           H  
ATOM    764  N   TRP H  60D     24.997 -16.229  15.117  1.00 24.96           N  
ATOM    765  CA  TRP H  60D     24.095 -16.462  13.983  1.00 28.05           C  
ATOM    766  C   TRP H  60D     24.699 -16.004  12.640  1.00 27.71           C  
ATOM    767  O   TRP H  60D     23.960 -15.943  11.657  1.00 30.51           O  
ATOM    768  CB  TRP H  60D     22.744 -15.758  14.247  1.00 33.40           C  
ATOM    769  CG  TRP H  60D     21.936 -16.189  15.440  1.00 39.83           C  
ATOM    770  CD1 TRP H  60D     22.098 -17.323  16.163  1.00 41.57           C  
ATOM    771  CD2 TRP H  60D     20.766 -15.525  16.008  1.00 41.89           C  
ATOM    772  NE1 TRP H  60D     21.138 -17.388  17.150  1.00 44.25           N  
ATOM    773  CE2 TRP H  60D     20.281 -16.310  17.098  1.00 44.16           C  
ATOM    774  CE3 TRP H  60D     20.061 -14.333  15.712  1.00 42.47           C  
ATOM    775  CZ2 TRP H  60D     19.156 -15.936  17.852  1.00 44.84           C  
ATOM    776  CZ3 TRP H  60D     18.933 -13.945  16.464  1.00 45.58           C  
ATOM    777  CH2 TRP H  60D     18.478 -14.746  17.529  1.00 46.93           C  
ATOM    778  H   TRP H  60D     25.142 -15.262  15.369  1.00 24.96           H  
ATOM    779  HA  TRP H  60D     23.899 -17.529  13.867  1.00 28.05           H  
ATOM    780  HB3 TRP H  60D     22.085 -15.893  13.389  1.00 33.40           H  
ATOM    781  HB2 TRP H  60D     22.906 -14.682  14.327  1.00 33.40           H  
ATOM    782  HD1 TRP H  60D     22.863 -18.064  15.987  1.00 41.57           H  
ATOM    783  HE1 TRP H  60D     21.082 -18.156  17.804  1.00 44.25           H  
ATOM    784  HE3 TRP H  60D     20.398 -13.712  14.897  1.00 42.47           H  
ATOM    785  HZ2 TRP H  60D     18.812 -16.555  18.667  1.00 44.84           H  
ATOM    786  HZ3 TRP H  60D     18.412 -13.031  16.221  1.00 45.58           H  
ATOM    787  HH2 TRP H  60D     17.613 -14.444  18.101  1.00 46.93           H  
ATOM    788  N   ASP H  60E     26.007 -15.681  12.608  1.00 26.36           N  
ATOM    789  CA  ASP H  60E     26.747 -15.203  11.426  1.00 27.19           C  
ATOM    790  C   ASP H  60E     26.208 -13.873  10.861  1.00 26.01           C  
ATOM    791  O   ASP H  60E     26.285 -13.638   9.654  1.00 30.15           O  
ATOM    792  CB  ASP H  60E     26.913 -16.284  10.319  1.00 34.71           C  
ATOM    793  CG  ASP H  60E     27.603 -17.578  10.779  1.00 46.13           C  
ATOM    794  OD1 ASP H  60E     28.612 -17.475  11.513  1.00 56.14           O  
ATOM    795  OD2 ASP H  60E     27.193 -18.650  10.283  1.00 67.19           O1-
ATOM    796  H   ASP H  60E     26.560 -15.792  13.447  1.00 26.36           H  
ATOM    797  HA  ASP H  60E     27.741 -14.948  11.796  1.00 27.19           H  
ATOM    798  HB3 ASP H  60E     27.511 -15.894   9.494  1.00 34.71           H  
ATOM    799  HB2 ASP H  60E     25.934 -16.534   9.904  1.00 34.71           H  
ATOM    800  N   LYS H  60F     25.674 -13.023  11.750  1.00 21.98           N  
ATOM    801  CA  LYS H  60F     25.134 -11.718  11.401  1.00 21.82           C  
ATOM    802  C   LYS H  60F     26.236 -10.664  11.570  1.00 21.87           C  
ATOM    803  O   LYS H  60F     26.794 -10.534  12.659  1.00 22.11           O  
ATOM    804  CB  LYS H  60F     23.916 -11.439  12.294  1.00 24.62           C  
ATOM    805  CG  LYS H  60F     23.092 -10.227  11.834  1.00 30.92           C  
ATOM    806  CD  LYS H  60F     22.012  -9.817  12.839  1.00 34.82           C  
ATOM    807  CE  LYS H  60F     20.957 -10.903  13.119  1.00 44.09           C  
ATOM    808  NZ  LYS H  60F     19.908 -10.423  14.034  1.00 46.88           N1+
ATOM    809  H   LYS H  60F     25.651 -13.272  12.729  1.00 21.98           H  
ATOM    810  HA  LYS H  60F     24.791 -11.721  10.364  1.00 21.82           H  
ATOM    811  HB3 LYS H  60F     24.233 -11.308  13.329  1.00 24.62           H  
ATOM    812  HB2 LYS H  60F     23.269 -12.317  12.287  1.00 24.62           H  
ATOM    813  HG3 LYS H  60F     22.633 -10.458  10.873  1.00 30.92           H  
ATOM    814  HG2 LYS H  60F     23.742  -9.368  11.661  1.00 30.92           H  
ATOM    815  HD3 LYS H  60F     21.528  -8.909  12.483  1.00 34.82           H  
ATOM    816  HD2 LYS H  60F     22.526  -9.550  13.759  1.00 34.82           H  
ATOM    817  HE3 LYS H  60F     21.421 -11.780  13.571  1.00 44.09           H  
ATOM    818  HE2 LYS H  60F     20.487 -11.225  12.189  1.00 44.09           H  
ATOM    819  HZ1 LYS H  60F     19.414  -9.659  13.588  1.00 46.88           H  
ATOM    820  HZ2 LYS H  60F     19.256 -11.169  14.233  1.00 46.88           H  
ATOM    821  HZ3 LYS H  60F     20.330 -10.092  14.891  1.00 46.88           H  
ATOM    822  N   ASN H  60G     26.516  -9.935  10.483  1.00 23.61           N  
ATOM    823  CA  ASN H  60G     27.489  -8.850  10.434  1.00 24.30           C  
ATOM    824  C   ASN H  60G     27.144  -8.002   9.202  1.00 24.85           C  
ATOM    825  O   ASN H  60G     27.827  -8.091   8.181  1.00 35.02           O  
ATOM    826  CB  ASN H  60G     28.949  -9.391  10.423  1.00 29.70           C  
ATOM    827  CG  ASN H  60G     30.037  -8.381  10.830  1.00 36.88           C  
ATOM    828  OD1 ASN H  60G     31.111  -8.790  11.263  1.00 54.57           O  
ATOM    829  ND2 ASN H  60G     29.800  -7.072  10.698  1.00 33.74           N  
ATOM    830  H   ASN H  60G     26.019 -10.114   9.621  1.00 23.61           H  
ATOM    831  HA  ASN H  60G     27.367  -8.191  11.295  1.00 24.30           H  
ATOM    832  HB3 ASN H  60G     29.205  -9.846   9.465  1.00 29.70           H  
ATOM    833  HB2 ASN H  60G     29.030 -10.197  11.153  1.00 29.70           H  
ATOM    834 HD22 ASN H  60G     30.510  -6.405  10.960  1.00 33.74           H  
ATOM    835 HD21 ASN H  60G     28.926  -6.738  10.318  1.00 33.74           H  
ATOM    836  N   PHE H  60H     26.071  -7.206   9.319  1.00 24.91           N  
ATOM    837  CA  PHE H  60H     25.619  -6.296   8.272  1.00 28.92           C  
ATOM    838  C   PHE H  60H     26.518  -5.057   8.164  1.00 31.82           C  
ATOM    839  O   PHE H  60H     26.802  -4.422   9.181  1.00 35.79           O  
ATOM    840  CB  PHE H  60H     24.158  -5.874   8.522  1.00 25.44           C  
ATOM    841  CG  PHE H  60H     23.130  -6.979   8.357  1.00 26.43           C  
ATOM    842  CD1 PHE H  60H     22.905  -7.556   7.090  1.00 30.48           C  
ATOM    843  CD2 PHE H  60H     22.419  -7.474   9.470  1.00 29.50           C  
ATOM    844  CE1 PHE H  60H     21.979  -8.578   6.944  1.00 30.34           C  
ATOM    845  CE2 PHE H  60H     21.481  -8.482   9.299  1.00 30.46           C  
ATOM    846  CZ  PHE H  60H     21.269  -9.039   8.045  1.00 28.82           C  
ATOM    847  H   PHE H  60H     25.571  -7.165  10.198  1.00 24.91           H  
ATOM    848  HA  PHE H  60H     25.659  -6.834   7.325  1.00 28.92           H  
ATOM    849  HB3 PHE H  60H     23.889  -5.085   7.818  1.00 25.44           H  
ATOM    850  HB2 PHE H  60H     24.059  -5.433   9.515  1.00 25.44           H  
ATOM    851  HD1 PHE H  60H     23.451  -7.204   6.229  1.00 30.48           H  
ATOM    852  HD2 PHE H  60H     22.595  -7.065  10.452  1.00 29.50           H  
ATOM    853  HE1 PHE H  60H     21.810  -9.014   5.971  1.00 30.34           H  
ATOM    854  HE2 PHE H  60H     20.920  -8.845  10.147  1.00 30.46           H  
ATOM    855  HZ  PHE H  60H     20.551  -9.836   7.925  1.00 28.82           H  
ATOM    856  N   THR H  60I     26.891  -4.721   6.920  1.00 30.55           N  
ATOM    857  CA  THR H  60I     27.498  -3.441   6.557  1.00 30.40           C  
ATOM    858  C   THR H  60I     26.393  -2.471   6.074  1.00 27.03           C  
ATOM    859  O   THR H  60I     25.258  -2.898   5.855  1.00 27.38           O  
ATOM    860  CB  THR H  60I     28.594  -3.639   5.465  1.00 34.52           C  
ATOM    861  OG1 THR H  60I     29.338  -2.456   5.265  1.00 49.91           O  
ATOM    862  CG2 THR H  60I     28.105  -4.084   4.075  1.00 49.00           C  
ATOM    863  H   THR H  60I     26.609  -5.310   6.146  1.00 30.55           H  
ATOM    864  HA  THR H  60I     27.971  -2.993   7.433  1.00 30.40           H  
ATOM    865  HB  THR H  60I     29.303  -4.384   5.827  1.00 34.52           H  
ATOM    866  HG1 THR H  60I     29.966  -2.601   4.554  1.00 49.91           H  
ATOM    867 HG21 THR H  60I     28.921  -4.088   3.353  1.00 49.00           H  
ATOM    868 HG22 THR H  60I     27.731  -5.103   4.119  1.00 49.00           H  
ATOM    869 HG23 THR H  60I     27.316  -3.448   3.674  1.00 49.00           H  
ATOM    870  N   GLU H  61      26.733  -1.180   5.928  1.00 29.25           N  
ATOM    871  CA  GLU H  61      25.835  -0.091   5.524  1.00 28.61           C  
ATOM    872  C   GLU H  61      25.080  -0.349   4.209  1.00 28.46           C  
ATOM    873  O   GLU H  61      23.880  -0.082   4.138  1.00 28.80           O  
ATOM    874  CB  GLU H  61      26.616   1.237   5.411  1.00 32.10           C  
ATOM    875  CG  GLU H  61      27.256   1.748   6.721  1.00 30.98           C  
ATOM    876  CD  GLU H  61      28.580   1.099   7.168  1.00 33.08           C  
ATOM    877  OE1 GLU H  61      28.880   1.200   8.376  1.00 28.98           O  
ATOM    878  OE2 GLU H  61      29.291   0.523   6.317  1.00 37.45           O1-
ATOM    879  H   GLU H  61      27.694  -0.907   6.103  1.00 29.25           H  
ATOM    880  HA  GLU H  61      25.087   0.017   6.309  1.00 28.61           H  
ATOM    881  HB3 GLU H  61      25.930   2.010   5.063  1.00 32.10           H  
ATOM    882  HB2 GLU H  61      27.368   1.165   4.623  1.00 32.10           H  
ATOM    883  HG3 GLU H  61      26.525   1.701   7.527  1.00 30.98           H  
ATOM    884  HG2 GLU H  61      27.467   2.803   6.570  1.00 30.98           H  
ATOM    885  N   ASN H  62      25.801  -0.884   3.209  1.00 31.35           N  
ATOM    886  CA  ASN H  62      25.298  -1.176   1.863  1.00 33.01           C  
ATOM    887  C   ASN H  62      24.357  -2.395   1.794  1.00 32.33           C  
ATOM    888  O   ASN H  62      23.721  -2.562   0.756  1.00 34.25           O  
ATOM    889  CB  ASN H  62      26.490  -1.362   0.893  1.00 42.68           C  
ATOM    890  CG  ASN H  62      27.367  -0.117   0.694  1.00 48.29           C  
ATOM    891  OD1 ASN H  62      26.955   1.010   0.960  1.00 55.56           O  
ATOM    892  ND2 ASN H  62      28.588  -0.316   0.199  1.00 52.68           N  
ATOM    893  H   ASN H  62      26.777  -1.086   3.371  1.00 31.35           H  
ATOM    894  HA  ASN H  62      24.720  -0.307   1.542  1.00 33.01           H  
ATOM    895  HB3 ASN H  62      26.122  -1.639  -0.096  1.00 42.68           H  
ATOM    896  HB2 ASN H  62      27.114  -2.191   1.232  1.00 42.68           H  
ATOM    897 HD22 ASN H  62      29.204   0.469   0.043  1.00 52.68           H  
ATOM    898 HD21 ASN H  62      28.909  -1.248  -0.019  1.00 52.68           H  
ATOM    899  N   ASP H  63      24.251  -3.203   2.863  1.00 32.45           N  
ATOM    900  CA  ASP H  63      23.293  -4.314   2.962  1.00 30.55           C  
ATOM    901  C   ASP H  63      21.872  -3.858   3.335  1.00 30.69           C  
ATOM    902  O   ASP H  63      20.945  -4.654   3.174  1.00 30.64           O  
ATOM    903  CB  ASP H  63      23.737  -5.402   3.976  1.00 32.47           C  
ATOM    904  CG  ASP H  63      25.085  -6.084   3.705  1.00 34.87           C  
ATOM    905  OD1 ASP H  63      25.504  -6.141   2.527  1.00 41.04           O  
ATOM    906  OD2 ASP H  63      25.622  -6.664   4.673  1.00 31.59           O1-
ATOM    907  H   ASP H  63      24.805  -3.019   3.689  1.00 32.45           H  
ATOM    908  HA  ASP H  63      23.211  -4.786   1.980  1.00 30.55           H  
ATOM    909  HB3 ASP H  63      22.989  -6.196   4.021  1.00 32.47           H  
ATOM    910  HB2 ASP H  63      23.785  -4.963   4.974  1.00 32.47           H  
ATOM    911  N   LEU H  64      21.730  -2.635   3.873  1.00 28.58           N  
ATOM    912  CA  LEU H  64      20.554  -2.219   4.634  1.00 31.23           C  
ATOM    913  C   LEU H  64      19.921  -0.950   4.062  1.00 26.54           C  
ATOM    914  O   LEU H  64      20.626  -0.077   3.564  1.00 30.01           O  
ATOM    915  CB  LEU H  64      20.979  -1.946   6.098  1.00 32.63           C  
ATOM    916  CG  LEU H  64      21.793  -3.069   6.780  1.00 33.94           C  
ATOM    917  CD1 LEU H  64      22.212  -2.659   8.202  1.00 35.41           C  
ATOM    918  CD2 LEU H  64      21.079  -4.433   6.748  1.00 41.37           C  
ATOM    919  H   LEU H  64      22.533  -2.024   3.937  1.00 28.58           H  
ATOM    920  HA  LEU H  64      19.794  -3.002   4.621  1.00 31.23           H  
ATOM    921  HB3 LEU H  64      20.088  -1.739   6.694  1.00 32.63           H  
ATOM    922  HB2 LEU H  64      21.578  -1.033   6.129  1.00 32.63           H  
ATOM    923  HG  LEU H  64      22.721  -3.187   6.225  1.00 33.94           H  
ATOM    924 HD11 LEU H  64      21.842  -3.353   8.954  1.00 35.41           H  
ATOM    925 HD12 LEU H  64      23.299  -2.632   8.293  1.00 35.41           H  
ATOM    926 HD13 LEU H  64      21.839  -1.673   8.477  1.00 35.41           H  
ATOM    927 HD21 LEU H  64      21.580  -5.118   6.064  1.00 41.37           H  
ATOM    928 HD22 LEU H  64      21.057  -4.926   7.718  1.00 41.37           H  
ATOM    929 HD23 LEU H  64      20.050  -4.337   6.409  1.00 41.37           H  
ATOM    930  N   LEU H  65      18.600  -0.853   4.242  1.00 23.97           N  
ATOM    931  CA  LEU H  65      17.797   0.348   4.066  1.00 23.87           C  
ATOM    932  C   LEU H  65      17.042   0.615   5.372  1.00 22.92           C  
ATOM    933  O   LEU H  65      16.642  -0.320   6.066  1.00 24.56           O  
ATOM    934  CB  LEU H  65      16.783   0.135   2.920  1.00 24.37           C  
ATOM    935  CG  LEU H  65      17.406   0.167   1.510  1.00 26.83           C  
ATOM    936  CD1 LEU H  65      16.378  -0.262   0.441  1.00 28.60           C  
ATOM    937  CD2 LEU H  65      18.043   1.535   1.188  1.00 33.42           C  
ATOM    938  H   LEU H  65      18.105  -1.639   4.648  1.00 23.97           H  
ATOM    939  HA  LEU H  65      18.433   1.211   3.861  1.00 23.87           H  
ATOM    940  HB3 LEU H  65      16.005   0.899   2.967  1.00 24.37           H  
ATOM    941  HB2 LEU H  65      16.271  -0.817   3.073  1.00 24.37           H  
ATOM    942  HG  LEU H  65      18.199  -0.578   1.497  1.00 26.83           H  
ATOM    943 HD11 LEU H  65      16.789  -1.034  -0.209  1.00 28.60           H  
ATOM    944 HD12 LEU H  65      15.468  -0.668   0.885  1.00 28.60           H  
ATOM    945 HD13 LEU H  65      16.072   0.567  -0.197  1.00 28.60           H  
ATOM    946 HD21 LEU H  65      17.887   1.838   0.153  1.00 33.42           H  
ATOM    947 HD22 LEU H  65      17.638   2.327   1.818  1.00 33.42           H  
ATOM    948 HD23 LEU H  65      19.119   1.512   1.359  1.00 33.42           H  
ATOM    949  N   VAL H  66      16.824   1.904   5.643  1.00 21.26           N  
ATOM    950  CA  VAL H  66      15.948   2.406   6.692  0.92 20.24           C  
ATOM    951  C   VAL H  66      14.664   2.907   6.012  1.00 17.12           C  
ATOM    952  O   VAL H  66      14.756   3.707   5.086  1.00 25.17           O  
ATOM    953  CB  VAL H  66      16.668   3.552   7.469  0.92 24.66           C  
ATOM    954  CG1 VAL H  66      15.787   4.718   7.946  0.92 34.45           C  
ATOM    955  CG2 VAL H  66      17.469   2.981   8.651  0.92 25.32           C  
ATOM    956  H   VAL H  66      17.189   2.608   5.014  1.00 21.26           H  
ATOM    957  HA  VAL H  66      15.688   1.610   7.393  0.92 20.24           H  
ATOM    958  HB  VAL H  66      17.406   3.999   6.800  0.92 24.66           H  
ATOM    959 HG11 VAL H  66      16.324   5.380   8.617  0.92 34.45           H  
ATOM    960 HG12 VAL H  66      15.451   5.329   7.110  0.92 34.45           H  
ATOM    961 HG13 VAL H  66      14.906   4.368   8.471  0.92 34.45           H  
ATOM    962 HG21 VAL H  66      18.093   3.746   9.114  0.92 25.32           H  
ATOM    963 HG22 VAL H  66      16.807   2.588   9.420  0.92 25.32           H  
ATOM    964 HG23 VAL H  66      18.123   2.170   8.333  0.92 25.32           H  
ATOM    965  N   ARG H  67      13.504   2.430   6.481  1.00 17.01           N  
ATOM    966  CA  ARG H  67      12.189   2.805   5.965  1.00 15.97           C  
ATOM    967  C   ARG H  67      11.409   3.463   7.107  1.00 15.54           C  
ATOM    968  O   ARG H  67      11.156   2.811   8.119  1.00 16.44           O  
ATOM    969  CB  ARG H  67      11.465   1.565   5.409  1.00 16.62           C  
ATOM    970  CG  ARG H  67      12.254   0.774   4.346  1.00 19.52           C  
ATOM    971  CD  ARG H  67      11.552  -0.502   3.848  1.00 21.50           C  
ATOM    972  NE  ARG H  67      10.318  -0.238   3.092  1.00 20.00           N  
ATOM    973  CZ  ARG H  67       9.523  -1.143   2.492  1.00 22.06           C  
ATOM    974  NH1 ARG H  67       9.776  -2.455   2.526  1.00 24.22           N  
ATOM    975  NH2 ARG H  67       8.438  -0.730   1.833  1.00 22.06           N1+
ATOM    976  H   ARG H  67      13.507   1.760   7.240  1.00 17.01           H  
ATOM    977  HA  ARG H  67      12.283   3.522   5.147  1.00 15.97           H  
ATOM    978  HB3 ARG H  67      10.523   1.904   4.985  1.00 16.62           H  
ATOM    979  HB2 ARG H  67      11.217   0.884   6.219  1.00 16.62           H  
ATOM    980  HG3 ARG H  67      13.240   0.492   4.715  1.00 19.52           H  
ATOM    981  HG2 ARG H  67      12.448   1.430   3.499  1.00 19.52           H  
ATOM    982  HD3 ARG H  67      11.277  -1.115   4.707  1.00 21.50           H  
ATOM    983  HD2 ARG H  67      12.242  -1.088   3.244  1.00 21.50           H  
ATOM    984  HE  ARG H  67      10.045   0.738   3.024  1.00 20.00           H  
ATOM    985 HH12 ARG H  67       9.171  -3.100   2.034  1.00 24.22           H  
ATOM    986 HH11 ARG H  67      10.592  -2.806   3.007  1.00 24.22           H  
ATOM    987 HH22 ARG H  67       7.860  -1.397   1.339  1.00 22.06           H  
ATOM    988 HH21 ARG H  67       8.185   0.253   1.832  1.00 22.06           H  
ATOM    989  N   ILE H  68      11.091   4.754   6.936  1.00 15.96           N  
ATOM    990  CA  ILE H  68      10.564   5.638   7.977  1.00 16.24           C  
ATOM    991  C   ILE H  68       9.187   6.145   7.514  1.00 16.63           C  
ATOM    992  O   ILE H  68       9.035   6.458   6.336  1.00 19.52           O  
ATOM    993  CB  ILE H  68      11.474   6.894   8.184  1.00 18.85           C  
ATOM    994  CG1 ILE H  68      12.982   6.537   8.194  1.00 17.96           C  
ATOM    995  CG2 ILE H  68      11.087   7.647   9.478  1.00 19.50           C  
ATOM    996  CD1 ILE H  68      13.949   7.729   8.206  1.00 24.39           C  
ATOM    997  H   ILE H  68      11.311   5.206   6.057  1.00 15.96           H  
ATOM    998  HA  ILE H  68      10.466   5.114   8.928  1.00 16.24           H  
ATOM    999  HB  ILE H  68      11.325   7.582   7.349  1.00 18.85           H  
ATOM   1000 HG13 ILE H  68      13.232   5.969   7.299  1.00 17.96           H  
ATOM   1001 HG12 ILE H  68      13.203   5.880   9.032  1.00 17.96           H  
ATOM   1002 HG21 ILE H  68      11.680   8.547   9.620  1.00 19.50           H  
ATOM   1003 HG22 ILE H  68      10.046   7.963   9.480  1.00 19.50           H  
ATOM   1004 HG23 ILE H  68      11.227   7.023  10.359  1.00 19.50           H  
ATOM   1005 HD11 ILE H  68      14.976   7.392   8.337  1.00 24.39           H  
ATOM   1006 HD12 ILE H  68      13.908   8.274   7.265  1.00 24.39           H  
ATOM   1007 HD13 ILE H  68      13.750   8.423   9.018  1.00 24.39           H  
ATOM   1008  N   GLY H  69       8.222   6.242   8.439  1.00 15.00           N  
ATOM   1009  CA  GLY H  69       6.873   6.733   8.152  1.00 15.44           C  
ATOM   1010  C   GLY H  69       5.882   5.604   7.854  1.00 15.22           C  
ATOM   1011  O   GLY H  69       4.759   5.901   7.450  1.00 17.48           O  
ATOM   1012  H   GLY H  69       8.407   5.972   9.396  1.00 15.00           H  
ATOM   1013  HA3 GLY H  69       6.868   7.445   7.325  1.00 15.44           H  
ATOM   1014  HA2 GLY H  69       6.513   7.270   9.022  1.00 15.44           H  
ATOM   1015  N   LYS H  70       6.276   4.331   8.028  1.00 14.65           N  
ATOM   1016  CA  LYS H  70       5.451   3.172   7.699  1.00 16.16           C  
ATOM   1017  C   LYS H  70       4.354   2.887   8.733  1.00 14.22           C  
ATOM   1018  O   LYS H  70       4.520   3.171   9.920  1.00 16.83           O  
ATOM   1019  CB  LYS H  70       6.339   1.925   7.518  1.00 16.28           C  
ATOM   1020  CG  LYS H  70       7.266   2.020   6.297  1.00 18.33           C  
ATOM   1021  CD  LYS H  70       8.028   0.719   5.980  1.00 18.51           C  
ATOM   1022  CE  LYS H  70       7.181  -0.539   5.729  1.00 22.62           C  
ATOM   1023  NZ  LYS H  70       6.168  -0.334   4.684  1.00 22.52           N1+
ATOM   1024  H   LYS H  70       7.194   4.134   8.405  1.00 14.65           H  
ATOM   1025  HA  LYS H  70       4.967   3.389   6.746  1.00 16.16           H  
ATOM   1026  HB3 LYS H  70       5.689   1.058   7.392  1.00 16.28           H  
ATOM   1027  HB2 LYS H  70       6.922   1.727   8.415  1.00 16.28           H  
ATOM   1028  HG3 LYS H  70       7.995   2.815   6.460  1.00 18.33           H  
ATOM   1029  HG2 LYS H  70       6.688   2.331   5.427  1.00 18.33           H  
ATOM   1030  HD3 LYS H  70       8.737   0.518   6.784  1.00 18.51           H  
ATOM   1031  HD2 LYS H  70       8.626   0.891   5.090  1.00 18.51           H  
ATOM   1032  HE3 LYS H  70       6.697  -0.869   6.647  1.00 22.62           H  
ATOM   1033  HE2 LYS H  70       7.830  -1.353   5.409  1.00 22.62           H  
ATOM   1034  HZ1 LYS H  70       6.600   0.000   3.833  1.00 22.52           H  
ATOM   1035  HZ2 LYS H  70       5.683  -1.201   4.502  1.00 22.52           H  
ATOM   1036  HZ3 LYS H  70       5.493   0.354   4.996  1.00 22.52           H  
ATOM   1037  N   HIS H  71       3.281   2.259   8.234  1.00 18.29           N  
ATOM   1038  CA  HIS H  71       2.209   1.660   9.013  1.00 18.26           C  
ATOM   1039  C   HIS H  71       2.068   0.185   8.609  1.00 21.04           C  
ATOM   1040  O   HIS H  71       2.302  -0.667   9.457  1.00 20.07           O  
ATOM   1041  CB  HIS H  71       0.909   2.468   8.850  1.00 18.40           C  
ATOM   1042  CG  HIS H  71      -0.265   1.874   9.581  1.00 17.87           C  
ATOM   1043  ND1 HIS H  71      -0.225   1.608  10.952  1.00 16.82           N  
ATOM   1044  CD2 HIS H  71      -1.484   1.469   9.078  1.00 20.05           C  
ATOM   1045  CE1 HIS H  71      -1.398   1.055  11.220  1.00 19.15           C  
ATOM   1046  NE2 HIS H  71      -2.192   0.964  10.154  1.00 20.64           N  
ATOM   1047  H   HIS H  71       3.249   2.075   7.237  1.00 18.29           H  
ATOM   1048  HA  HIS H  71       2.478   1.672  10.072  1.00 18.26           H  
ATOM   1049  HB3 HIS H  71       0.644   2.571   7.799  1.00 18.40           H  
ATOM   1050  HB2 HIS H  71       1.058   3.481   9.225  1.00 18.40           H  
ATOM   1051  HD2 HIS H  71      -1.887   1.495   8.077  1.00 20.05           H  
ATOM   1052  HE1 HIS H  71      -1.657   0.664  12.189  1.00 19.15           H  
ATOM   1053  HE2 HIS H  71      -3.121   0.567  10.133  1.00 20.64           H  
ATOM   1054  N   SER H  72       1.752  -0.102   7.333  1.00 20.45           N  
ATOM   1055  CA  SER H  72       1.763  -1.453   6.756  1.00 22.62           C  
ATOM   1056  C   SER H  72       3.168  -2.078   6.812  1.00 23.40           C  
ATOM   1057  O   SER H  72       4.152  -1.360   6.659  1.00 24.49           O  
ATOM   1058  CB  SER H  72       1.228  -1.407   5.309  1.00 26.49           C  
ATOM   1059  OG  SER H  72       1.113  -2.701   4.745  1.00 30.50           O  
ATOM   1060  H   SER H  72       1.603   0.659   6.680  1.00 20.45           H  
ATOM   1061  HA  SER H  72       1.083  -2.062   7.343  1.00 22.62           H  
ATOM   1062  HB3 SER H  72       1.892  -0.823   4.673  1.00 26.49           H  
ATOM   1063  HB2 SER H  72       0.250  -0.926   5.278  1.00 26.49           H  
ATOM   1064  HG  SER H  72       0.388  -3.159   5.179  1.00 30.50           H  
ATOM   1065  N   ARG H  73       3.239  -3.399   7.030  1.00 21.81           N  
ATOM   1066  CA  ARG H  73       4.497  -4.142   7.060  1.00 22.22           C  
ATOM   1067  C   ARG H  73       5.111  -4.299   5.655  1.00 23.64           C  
ATOM   1068  O   ARG H  73       6.239  -3.859   5.436  1.00 26.56           O  
ATOM   1069  CB  ARG H  73       4.273  -5.497   7.766  1.00 23.32           C  
ATOM   1070  CG  ARG H  73       5.546  -6.363   7.904  1.00 22.00           C  
ATOM   1071  CD  ARG H  73       5.341  -7.637   8.743  1.00 25.48           C  
ATOM   1072  NE  ARG H  73       4.438  -8.594   8.083  1.00 24.86           N  
ATOM   1073  CZ  ARG H  73       4.745  -9.579   7.223  1.00 26.93           C  
ATOM   1074  NH1 ARG H  73       3.749 -10.294   6.685  1.00 30.15           N  
ATOM   1075  NH2 ARG H  73       6.013  -9.862   6.890  1.00 29.63           N1+
ATOM   1076  H   ARG H  73       2.391  -3.932   7.166  1.00 21.81           H  
ATOM   1077  HA  ARG H  73       5.204  -3.574   7.669  1.00 22.22           H  
ATOM   1078  HB3 ARG H  73       3.512  -6.061   7.227  1.00 23.32           H  
ATOM   1079  HB2 ARG H  73       3.850  -5.323   8.753  1.00 23.32           H  
ATOM   1080  HG3 ARG H  73       6.397  -5.794   8.280  1.00 22.00           H  
ATOM   1081  HG2 ARG H  73       5.830  -6.672   6.898  1.00 22.00           H  
ATOM   1082  HD3 ARG H  73       4.808  -7.363   9.653  1.00 25.48           H  
ATOM   1083  HD2 ARG H  73       6.283  -8.075   9.074  1.00 25.48           H  
ATOM   1084  HE  ARG H  73       3.458  -8.436   8.288  1.00 24.86           H  
ATOM   1085 HH12 ARG H  73       3.953 -11.058   6.056  1.00 30.15           H  
ATOM   1086 HH11 ARG H  73       2.789 -10.094   6.925  1.00 30.15           H  
ATOM   1087 HH22 ARG H  73       6.224 -10.641   6.284  1.00 29.63           H  
ATOM   1088 HH21 ARG H  73       6.770  -9.334   7.300  1.00 29.63           H  
ATOM   1089  N   THR H  74       4.365  -4.953   4.750  1.00 26.50           N  
ATOM   1090  CA  THR H  74       4.887  -5.461   3.478  1.00 27.83           C  
ATOM   1091  C   THR H  74       4.640  -4.537   2.269  1.00 27.53           C  
ATOM   1092  O   THR H  74       5.355  -4.686   1.278  1.00 31.18           O  
ATOM   1093  CB  THR H  74       4.269  -6.845   3.138  1.00 29.79           C  
ATOM   1094  OG1 THR H  74       2.898  -6.769   2.786  1.00 27.93           O  
ATOM   1095  CG2 THR H  74       4.440  -7.877   4.261  1.00 32.07           C  
ATOM   1096  H   THR H  74       3.432  -5.254   4.996  1.00 26.50           H  
ATOM   1097  HA  THR H  74       5.967  -5.597   3.561  1.00 27.83           H  
ATOM   1098  HB  THR H  74       4.785  -7.242   2.262  1.00 29.79           H  
ATOM   1099  HG1 THR H  74       2.392  -6.552   3.576  1.00 27.93           H  
ATOM   1100 HG21 THR H  74       4.069  -8.854   3.951  1.00 32.07           H  
ATOM   1101 HG22 THR H  74       5.492  -7.992   4.524  1.00 32.07           H  
ATOM   1102 HG23 THR H  74       3.900  -7.590   5.163  1.00 32.07           H  
ATOM   1103  N   ARG H  75       3.659  -3.622   2.340  1.00 25.80           N  
ATOM   1104  CA  ARG H  75       3.323  -2.718   1.236  1.00 29.92           C  
ATOM   1105  C   ARG H  75       4.354  -1.585   1.114  1.00 27.69           C  
ATOM   1106  O   ARG H  75       4.785  -1.066   2.141  1.00 26.79           O  
ATOM   1107  CB  ARG H  75       1.903  -2.162   1.476  1.00  0.00           C  
ATOM   1108  CG  ARG H  75       1.348  -1.281   0.337  1.00  0.00           C  
ATOM   1109  CD  ARG H  75      -0.061  -0.728   0.610  1.00  0.00           C  
ATOM   1110  NE  ARG H  75      -1.099  -1.774   0.572  1.00  0.00           N  
ATOM   1111  CZ  ARG H  75      -2.397  -1.639   0.903  1.00  0.00           C  
ATOM   1112  NH1 ARG H  75      -2.913  -0.469   1.311  1.00  0.00           N  
ATOM   1113  NH2 ARG H  75      -3.198  -2.708   0.823  1.00  0.00           N1+
ATOM   1114  H   ARG H  75       3.107  -3.534   3.182  1.00 25.80           H  
ATOM   1115  HA  ARG H  75       3.314  -3.292   0.307  1.00 29.92           H  
ATOM   1116  HB2 ARG H  75       1.224  -2.998   1.649  1.00  0.00           H  
ATOM   1117  HB3 ARG H  75       1.902  -1.577   2.396  1.00  0.00           H  
ATOM   1118  HG2 ARG H  75       2.004  -0.452   0.086  1.00  0.00           H  
ATOM   1119  HG3 ARG H  75       1.313  -1.909  -0.555  1.00  0.00           H  
ATOM   1120  HD2 ARG H  75      -0.075  -0.348   1.632  1.00  0.00           H  
ATOM   1121  HD3 ARG H  75      -0.292   0.120  -0.036  1.00  0.00           H  
ATOM   1122  HE  ARG H  75      -0.780  -2.684   0.271  1.00  0.00           H  
ATOM   1123 HH12 ARG H  75      -3.890  -0.391   1.553  1.00  0.00           H  
ATOM   1124 HH11 ARG H  75      -2.320   0.346   1.379  1.00  0.00           H  
ATOM   1125 HH22 ARG H  75      -4.176  -2.634   1.064  1.00  0.00           H  
ATOM   1126 HH21 ARG H  75      -2.835  -3.600   0.518  1.00  0.00           H  
ATOM   1127  N   TYR H  76       4.678  -1.172  -0.125  1.00 27.63           N  
ATOM   1128  CA  TYR H  76       5.348   0.106  -0.364  1.00 27.63           C  
ATOM   1129  C   TYR H  76       4.308   1.235  -0.295  1.00 27.15           C  
ATOM   1130  O   TYR H  76       3.470   1.351  -1.190  1.00 31.99           O  
ATOM   1131  CB  TYR H  76       6.134   0.105  -1.691  1.00 27.27           C  
ATOM   1132  CG  TYR H  76       6.789   1.447  -1.982  1.00 28.57           C  
ATOM   1133  CD1 TYR H  76       7.824   1.916  -1.145  1.00 30.68           C  
ATOM   1134  CD2 TYR H  76       6.317   2.265  -3.031  1.00 27.47           C  
ATOM   1135  CE1 TYR H  76       8.367   3.200  -1.338  1.00 26.02           C  
ATOM   1136  CE2 TYR H  76       6.867   3.547  -3.230  1.00 32.01           C  
ATOM   1137  CZ  TYR H  76       7.888   4.015  -2.381  1.00 31.27           C  
ATOM   1138  OH  TYR H  76       8.415   5.260  -2.564  1.00 32.36           O  
ATOM   1139  H   TYR H  76       4.300  -1.643  -0.935  1.00 27.63           H  
ATOM   1140  HA  TYR H  76       6.081   0.264   0.427  1.00 27.63           H  
ATOM   1141  HB3 TYR H  76       5.475  -0.162  -2.519  1.00 27.27           H  
ATOM   1142  HB2 TYR H  76       6.911  -0.659  -1.660  1.00 27.27           H  
ATOM   1143  HD1 TYR H  76       8.186   1.306  -0.332  1.00 30.68           H  
ATOM   1144  HD2 TYR H  76       5.515   1.924  -3.669  1.00 27.47           H  
ATOM   1145  HE1 TYR H  76       9.141   3.560  -0.678  1.00 26.02           H  
ATOM   1146  HE2 TYR H  76       6.495   4.173  -4.027  1.00 32.01           H  
ATOM   1147  HH  TYR H  76       9.127   5.454  -1.950  1.00 32.36           H  
ATOM   1148  N   GLU H  77       4.376   2.017   0.790  1.00 22.88           N  
ATOM   1149  CA  GLU H  77       3.427   3.072   1.127  1.00 23.65           C  
ATOM   1150  C   GLU H  77       3.837   4.392   0.476  1.00 25.38           C  
ATOM   1151  O   GLU H  77       4.330   5.305   1.137  1.00 23.04           O  
ATOM   1152  CB  GLU H  77       3.292   3.150   2.651  1.00 21.74           C  
ATOM   1153  CG  GLU H  77       2.645   1.872   3.208  1.00 23.01           C  
ATOM   1154  CD  GLU H  77       2.612   1.895   4.726  1.00 21.15           C  
ATOM   1155  OE1 GLU H  77       3.670   1.591   5.313  1.00 22.71           O  
ATOM   1156  OE2 GLU H  77       1.525   2.172   5.276  1.00 19.01           O1-
ATOM   1157  H   GLU H  77       5.119   1.868   1.463  1.00 22.88           H  
ATOM   1158  HA  GLU H  77       2.442   2.814   0.730  1.00 23.65           H  
ATOM   1159  HB3 GLU H  77       2.688   4.014   2.931  1.00 21.74           H  
ATOM   1160  HB2 GLU H  77       4.275   3.302   3.102  1.00 21.74           H  
ATOM   1161  HG3 GLU H  77       3.188   0.983   2.890  1.00 23.01           H  
ATOM   1162  HG2 GLU H  77       1.634   1.762   2.811  1.00 23.01           H  
ATOM   1163  N   ARG H  77A      3.612   4.428  -0.842  1.00 24.15           N  
ATOM   1164  CA  ARG H  77A      3.847   5.534  -1.755  1.00 25.73           C  
ATOM   1165  C   ARG H  77A      3.209   6.849  -1.267  1.00 24.54           C  
ATOM   1166  O   ARG H  77A      2.041   6.856  -0.880  1.00 25.22           O  
ATOM   1167  CB  ARG H  77A      3.330   5.059  -3.126  1.00 25.35           C  
ATOM   1168  CG  ARG H  77A      3.372   6.082  -4.274  1.00 29.29           C  
ATOM   1169  CD  ARG H  77A      3.141   5.429  -5.652  1.00 29.02           C  
ATOM   1170  NE  ARG H  77A      1.794   4.839  -5.789  1.00 25.66           N  
ATOM   1171  CZ  ARG H  77A      0.660   5.445  -6.188  1.00 22.15           C  
ATOM   1172  NH1 ARG H  77A      0.627   6.733  -6.558  1.00 20.88           N  
ATOM   1173  NH2 ARG H  77A     -0.474   4.734  -6.214  1.00 20.98           N1+
ATOM   1174  H   ARG H  77A      3.225   3.598  -1.269  1.00 24.15           H  
ATOM   1175  HA  ARG H  77A      4.927   5.673  -1.822  1.00 25.73           H  
ATOM   1176  HB3 ARG H  77A      2.298   4.723  -3.011  1.00 25.35           H  
ATOM   1177  HB2 ARG H  77A      3.897   4.174  -3.416  1.00 25.35           H  
ATOM   1178  HG3 ARG H  77A      4.300   6.655  -4.282  1.00 29.29           H  
ATOM   1179  HG2 ARG H  77A      2.578   6.809  -4.091  1.00 29.29           H  
ATOM   1180  HD3 ARG H  77A      3.825   4.586  -5.749  1.00 29.02           H  
ATOM   1181  HD2 ARG H  77A      3.397   6.100  -6.471  1.00 29.02           H  
ATOM   1182  HE  ARG H  77A      1.728   3.874  -5.500  1.00 25.66           H  
ATOM   1183 HH12 ARG H  77A     -0.236   7.163  -6.858  1.00 20.88           H  
ATOM   1184 HH11 ARG H  77A      1.474   7.289  -6.538  1.00 20.88           H  
ATOM   1185 HH22 ARG H  77A     -1.339   5.163  -6.510  1.00 20.98           H  
ATOM   1186 HH21 ARG H  77A     -0.476   3.761  -5.944  1.00 20.98           H  
ATOM   1187  N   ASN H  78       4.024   7.919  -1.279  1.00 24.03           N  
ATOM   1188  CA  ASN H  78       3.727   9.289  -0.828  1.00 24.33           C  
ATOM   1189  C   ASN H  78       3.655   9.458   0.707  1.00 22.14           C  
ATOM   1190  O   ASN H  78       3.384  10.573   1.153  1.00 20.73           O  
ATOM   1191  CB  ASN H  78       2.456   9.884  -1.501  1.00 21.50           C  
ATOM   1192  CG  ASN H  78       2.443   9.865  -3.034  1.00 20.94           C  
ATOM   1193  OD1 ASN H  78       3.454   9.607  -3.686  1.00 28.80           O  
ATOM   1194  ND2 ASN H  78       1.282  10.159  -3.622  1.00 19.17           N  
ATOM   1195  H   ASN H  78       4.962   7.793  -1.639  1.00 24.03           H  
ATOM   1196  HA  ASN H  78       4.580   9.895  -1.136  1.00 24.33           H  
ATOM   1197  HB3 ASN H  78       2.343  10.929  -1.208  1.00 21.50           H  
ATOM   1198  HB2 ASN H  78       1.561   9.378  -1.138  1.00 21.50           H  
ATOM   1199 HD22 ASN H  78       1.212  10.175  -4.629  1.00 19.17           H  
ATOM   1200 HD21 ASN H  78       0.467  10.371  -3.065  1.00 19.17           H  
ATOM   1201  N   ILE H  79       3.898   8.390   1.487  1.00 20.29           N  
ATOM   1202  CA  ILE H  79       3.786   8.388   2.948  1.00 19.83           C  
ATOM   1203  C   ILE H  79       5.149   8.066   3.581  1.00 21.57           C  
ATOM   1204  O   ILE H  79       5.678   8.907   4.309  1.00 18.68           O  
ATOM   1205  CB  ILE H  79       2.695   7.388   3.440  1.00 17.99           C  
ATOM   1206  CG1 ILE H  79       1.293   7.854   2.982  1.00 20.16           C  
ATOM   1207  CG2 ILE H  79       2.699   7.132   4.964  1.00 18.98           C  
ATOM   1208  CD1 ILE H  79       0.188   6.807   3.185  1.00 24.23           C  
ATOM   1209  H   ILE H  79       4.122   7.501   1.060  1.00 20.29           H  
ATOM   1210  HA  ILE H  79       3.503   9.379   3.310  1.00 19.83           H  
ATOM   1211  HB  ILE H  79       2.882   6.429   2.959  1.00 17.99           H  
ATOM   1212 HG13 ILE H  79       1.306   8.118   1.925  1.00 20.16           H  
ATOM   1213 HG12 ILE H  79       1.025   8.768   3.513  1.00 20.16           H  
ATOM   1214 HG21 ILE H  79       1.895   6.460   5.264  1.00 18.98           H  
ATOM   1215 HG22 ILE H  79       3.621   6.658   5.292  1.00 18.98           H  
ATOM   1216 HG23 ILE H  79       2.579   8.059   5.520  1.00 18.98           H  
ATOM   1217 HD11 ILE H  79      -0.603   6.930   2.445  1.00 24.23           H  
ATOM   1218 HD12 ILE H  79       0.572   5.790   3.089  1.00 24.23           H  
ATOM   1219 HD13 ILE H  79      -0.266   6.902   4.172  1.00 24.23           H  
ATOM   1220  N   GLU H  80       5.700   6.876   3.282  1.00 19.02           N  
ATOM   1221  CA  GLU H  80       7.013   6.465   3.773  1.00 19.02           C  
ATOM   1222  C   GLU H  80       8.139   7.116   2.951  1.00 20.67           C  
ATOM   1223  O   GLU H  80       7.935   7.483   1.792  1.00 22.40           O  
ATOM   1224  CB  GLU H  80       7.120   4.924   3.782  1.00 19.10           C  
ATOM   1225  CG  GLU H  80       7.387   4.247   2.417  1.00 20.10           C  
ATOM   1226  CD  GLU H  80       7.763   2.783   2.590  1.00 21.68           C  
ATOM   1227  OE1 GLU H  80       8.967   2.529   2.799  1.00 21.98           O  
ATOM   1228  OE2 GLU H  80       6.853   1.932   2.507  1.00 21.21           O1-
ATOM   1229  H   GLU H  80       5.225   6.233   2.662  1.00 19.02           H  
ATOM   1230  HA  GLU H  80       7.089   6.807   4.806  1.00 19.02           H  
ATOM   1231  HB3 GLU H  80       6.206   4.508   4.209  1.00 19.10           H  
ATOM   1232  HB2 GLU H  80       7.908   4.647   4.486  1.00 19.10           H  
ATOM   1233  HG3 GLU H  80       8.204   4.722   1.874  1.00 20.10           H  
ATOM   1234  HG2 GLU H  80       6.520   4.331   1.769  1.00 20.10           H  
ATOM   1235  N   LYS H  81       9.322   7.187   3.574  1.00 18.72           N  
ATOM   1236  CA  LYS H  81      10.575   7.607   2.960  1.00 21.56           C  
ATOM   1237  C   LYS H  81      11.636   6.547   3.265  1.00 21.84           C  
ATOM   1238  O   LYS H  81      11.751   6.112   4.412  1.00 21.76           O  
ATOM   1239  CB  LYS H  81      11.000   8.987   3.508  1.00 20.09           C  
ATOM   1240  CG  LYS H  81       9.990  10.123   3.254  1.00 23.91           C  
ATOM   1241  CD  LYS H  81       9.725  10.429   1.771  1.00 26.61           C  
ATOM   1242  CE  LYS H  81       8.544  11.395   1.590  1.00 26.91           C  
ATOM   1243  NZ  LYS H  81       8.215  11.596   0.169  1.00 46.38           N1+
ATOM   1244  H   LYS H  81       9.392   6.860   4.530  1.00 18.72           H  
ATOM   1245  HA  LYS H  81      10.470   7.655   1.875  1.00 21.56           H  
ATOM   1246  HB3 LYS H  81      11.961   9.270   3.077  1.00 20.09           H  
ATOM   1247  HB2 LYS H  81      11.166   8.910   4.584  1.00 20.09           H  
ATOM   1248  HG3 LYS H  81      10.345  11.028   3.748  1.00 23.91           H  
ATOM   1249  HG2 LYS H  81       9.045   9.879   3.737  1.00 23.91           H  
ATOM   1250  HD3 LYS H  81       9.527   9.513   1.216  1.00 26.61           H  
ATOM   1251  HD2 LYS H  81      10.626  10.860   1.332  1.00 26.61           H  
ATOM   1252  HE3 LYS H  81       8.769  12.360   2.047  1.00 26.91           H  
ATOM   1253  HE2 LYS H  81       7.658  11.001   2.090  1.00 26.91           H  
ATOM   1254  HZ1 LYS H  81       7.970  10.709  -0.248  1.00 46.38           H  
ATOM   1255  HZ2 LYS H  81       7.432  12.230   0.092  1.00 46.38           H  
ATOM   1256  HZ3 LYS H  81       9.013  11.986  -0.312  1.00 46.38           H  
ATOM   1257  N   ILE H  82      12.392   6.164   2.226  1.00 22.96           N  
ATOM   1258  CA  ILE H  82      13.441   5.154   2.306  1.00 23.07           C  
ATOM   1259  C   ILE H  82      14.804   5.862   2.207  1.00 22.54           C  
ATOM   1260  O   ILE H  82      15.045   6.592   1.245  1.00 28.38           O  
ATOM   1261  CB  ILE H  82      13.306   4.080   1.187  1.00 26.34           C  
ATOM   1262  CG1 ILE H  82      11.899   3.429   1.256  1.00 26.18           C  
ATOM   1263  CG2 ILE H  82      14.423   3.012   1.274  1.00 30.52           C  
ATOM   1264  CD1 ILE H  82      11.672   2.237   0.316  1.00 26.07           C  
ATOM   1265  H   ILE H  82      12.252   6.585   1.318  1.00 22.96           H  
ATOM   1266  HA  ILE H  82      13.378   4.634   3.260  1.00 23.07           H  
ATOM   1267  HB  ILE H  82      13.394   4.570   0.216  1.00 26.34           H  
ATOM   1268 HG13 ILE H  82      11.133   4.175   1.041  1.00 26.18           H  
ATOM   1269 HG12 ILE H  82      11.704   3.109   2.278  1.00 26.18           H  
ATOM   1270 HG21 ILE H  82      14.340   2.271   0.479  1.00 30.52           H  
ATOM   1271 HG22 ILE H  82      15.419   3.441   1.176  1.00 30.52           H  
ATOM   1272 HG23 ILE H  82      14.383   2.484   2.226  1.00 30.52           H  
ATOM   1273 HD11 ILE H  82      10.613   1.990   0.256  1.00 26.07           H  
ATOM   1274 HD12 ILE H  82      12.024   2.452  -0.693  1.00 26.07           H  
ATOM   1275 HD13 ILE H  82      12.184   1.344   0.675  1.00 26.07           H  
ATOM   1276  N   SER H  83      15.650   5.635   3.222  1.00 23.41           N  
ATOM   1277  CA  SER H  83      16.958   6.261   3.392  1.00 25.84           C  
ATOM   1278  C   SER H  83      18.059   5.193   3.371  1.00 24.89           C  
ATOM   1279  O   SER H  83      17.874   4.103   3.914  1.00 24.65           O  
ATOM   1280  CB  SER H  83      16.987   7.001   4.744  1.00 26.56           C  
ATOM   1281  OG  SER H  83      16.132   8.124   4.716  1.00 29.04           O  
ATOM   1282  H   SER H  83      15.376   4.990   3.955  1.00 23.41           H  
ATOM   1283  HA  SER H  83      17.155   6.978   2.592  1.00 25.84           H  
ATOM   1284  HB3 SER H  83      17.993   7.359   4.967  1.00 26.56           H  
ATOM   1285  HB2 SER H  83      16.700   6.343   5.563  1.00 26.56           H  
ATOM   1286  HG  SER H  83      15.227   7.815   4.634  1.00 29.04           H  
ATOM   1287  N   MET H  84      19.203   5.563   2.779  1.00 28.24           N  
ATOM   1288  CA  MET H  84      20.435   4.777   2.787  1.00 28.32           C  
ATOM   1289  C   MET H  84      21.305   5.166   3.993  1.00 28.87           C  
ATOM   1290  O   MET H  84      21.246   6.308   4.450  1.00 26.82           O  
ATOM   1291  CB  MET H  84      21.194   5.002   1.462  1.00 29.64           C  
ATOM   1292  CG  MET H  84      20.361   4.638   0.220  1.00 34.81           C  
ATOM   1293  SD  MET H  84      21.294   4.439  -1.322  1.00 45.26           S  
ATOM   1294  CE  MET H  84      22.032   6.083  -1.479  1.00 57.86           C  
ATOM   1295  H   MET H  84      19.273   6.483   2.368  1.00 28.24           H  
ATOM   1296  HA  MET H  84      20.187   3.717   2.866  1.00 28.32           H  
ATOM   1297  HB3 MET H  84      22.118   4.424   1.459  1.00 29.64           H  
ATOM   1298  HB2 MET H  84      21.496   6.048   1.394  1.00 29.64           H  
ATOM   1299  HG3 MET H  84      19.588   5.389   0.053  1.00 34.81           H  
ATOM   1300  HG2 MET H  84      19.838   3.699   0.395  1.00 34.81           H  
ATOM   1301  HE1 MET H  84      22.539   6.177  -2.439  1.00 57.86           H  
ATOM   1302  HE2 MET H  84      21.271   6.860  -1.405  1.00 57.86           H  
ATOM   1303  HE3 MET H  84      22.763   6.227  -0.690  1.00 57.86           H  
ATOM   1304  N   LEU H  85      22.105   4.202   4.469  1.00 27.44           N  
ATOM   1305  CA  LEU H  85      23.007   4.351   5.611  1.00 26.90           C  
ATOM   1306  C   LEU H  85      24.361   4.902   5.146  1.00 28.71           C  
ATOM   1307  O   LEU H  85      24.946   4.365   4.207  1.00 31.39           O  
ATOM   1308  CB  LEU H  85      23.204   2.978   6.296  1.00 28.43           C  
ATOM   1309  CG  LEU H  85      22.119   2.609   7.329  1.00 31.48           C  
ATOM   1310  CD1 LEU H  85      20.705   2.487   6.720  1.00 39.51           C  
ATOM   1311  CD2 LEU H  85      22.525   1.335   8.098  1.00 29.62           C  
ATOM   1312  H   LEU H  85      22.106   3.296   4.021  1.00 27.44           H  
ATOM   1313  HA  LEU H  85      22.575   5.047   6.334  1.00 26.90           H  
ATOM   1314  HB3 LEU H  85      24.155   2.989   6.833  1.00 28.43           H  
ATOM   1315  HB2 LEU H  85      23.302   2.190   5.547  1.00 28.43           H  
ATOM   1316  HG  LEU H  85      22.078   3.417   8.061  1.00 31.48           H  
ATOM   1317 HD11 LEU H  85      20.118   1.691   7.176  1.00 39.51           H  
ATOM   1318 HD12 LEU H  85      20.142   3.412   6.855  1.00 39.51           H  
ATOM   1319 HD13 LEU H  85      20.736   2.270   5.653  1.00 39.51           H  
ATOM   1320 HD21 LEU H  85      21.731   0.591   8.133  1.00 29.62           H  
ATOM   1321 HD22 LEU H  85      23.394   0.848   7.658  1.00 29.62           H  
ATOM   1322 HD23 LEU H  85      22.784   1.575   9.128  1.00 29.62           H  
ATOM   1323  N   GLU H  86      24.852   5.934   5.844  1.00 27.98           N  
ATOM   1324  CA  GLU H  86      26.194   6.477   5.662  1.00 27.93           C  
ATOM   1325  C   GLU H  86      27.217   5.727   6.521  1.00 32.81           C  
ATOM   1326  O   GLU H  86      28.286   5.394   6.009  1.00 29.10           O  
ATOM   1327  CB  GLU H  86      26.201   7.982   5.981  1.00 30.73           C  
ATOM   1328  CG  GLU H  86      27.540   8.669   5.635  1.00 42.27           C  
ATOM   1329  CD  GLU H  86      27.338  10.073   5.062  1.00 48.00           C  
ATOM   1330  OE1 GLU H  86      27.515  10.230   3.835  1.00 62.52           O  
ATOM   1331  OE2 GLU H  86      26.987  10.971   5.852  1.00 61.67           O1-
ATOM   1332  H   GLU H  86      24.321   6.314   6.618  1.00 27.98           H  
ATOM   1333  HA  GLU H  86      26.483   6.360   4.615  1.00 27.93           H  
ATOM   1334  HB3 GLU H  86      25.996   8.129   7.041  1.00 30.73           H  
ATOM   1335  HB2 GLU H  86      25.370   8.459   5.470  1.00 30.73           H  
ATOM   1336  HG3 GLU H  86      28.099   8.074   4.911  1.00 42.27           H  
ATOM   1337  HG2 GLU H  86      28.172   8.724   6.523  1.00 42.27           H  
ATOM   1338  N   LYS H  87      26.876   5.480   7.798  1.00 27.90           N  
ATOM   1339  CA  LYS H  87      27.773   4.826   8.744  1.00 25.86           C  
ATOM   1340  C   LYS H  87      26.989   4.236   9.924  1.00 24.87           C  
ATOM   1341  O   LYS H  87      26.171   4.934  10.523  1.00 24.47           O  
ATOM   1342  CB  LYS H  87      28.873   5.819   9.198  1.00 28.37           C  
ATOM   1343  CG  LYS H  87      30.030   5.197  10.002  1.00 30.44           C  
ATOM   1344  CD  LYS H  87      30.863   4.186   9.204  1.00 36.04           C  
ATOM   1345  CE  LYS H  87      32.002   3.576  10.029  1.00 39.83           C  
ATOM   1346  NZ  LYS H  87      32.674   2.493   9.290  1.00 50.78           N1+
ATOM   1347  H   LYS H  87      25.975   5.767   8.153  1.00 27.90           H  
ATOM   1348  HA  LYS H  87      28.248   4.001   8.221  1.00 25.86           H  
ATOM   1349  HB3 LYS H  87      28.413   6.623   9.773  1.00 28.37           H  
ATOM   1350  HB2 LYS H  87      29.316   6.308   8.329  1.00 28.37           H  
ATOM   1351  HG3 LYS H  87      29.647   4.730  10.909  1.00 30.44           H  
ATOM   1352  HG2 LYS H  87      30.697   5.992  10.331  1.00 30.44           H  
ATOM   1353  HD3 LYS H  87      31.269   4.675   8.317  1.00 36.04           H  
ATOM   1354  HD2 LYS H  87      30.224   3.387   8.843  1.00 36.04           H  
ATOM   1355  HE3 LYS H  87      31.610   3.161  10.959  1.00 39.83           H  
ATOM   1356  HE2 LYS H  87      32.732   4.340  10.299  1.00 39.83           H  
ATOM   1357  HZ1 LYS H  87      33.062   2.858   8.432  1.00 50.78           H  
ATOM   1358  HZ2 LYS H  87      33.412   2.100   9.857  1.00 50.78           H  
ATOM   1359  HZ3 LYS H  87      31.998   1.773   9.070  1.00 50.78           H  
ATOM   1360  N   ILE H  88      27.305   2.974  10.252  1.00 22.30           N  
ATOM   1361  CA  ILE H  88      26.874   2.263  11.454  1.00 21.41           C  
ATOM   1362  C   ILE H  88      27.933   2.460  12.556  1.00 19.82           C  
ATOM   1363  O   ILE H  88      29.130   2.351  12.284  1.00 23.05           O  
ATOM   1364  CB  ILE H  88      26.719   0.732  11.176  1.00 21.31           C  
ATOM   1365  CG1 ILE H  88      25.535   0.446  10.222  1.00 25.81           C  
ATOM   1366  CG2 ILE H  88      26.600  -0.152  12.438  1.00 23.99           C  
ATOM   1367  CD1 ILE H  88      25.646  -0.888   9.469  1.00 29.10           C  
ATOM   1368  H   ILE H  88      27.972   2.470   9.679  1.00 22.30           H  
ATOM   1369  HA  ILE H  88      25.914   2.659  11.792  1.00 21.41           H  
ATOM   1370  HB  ILE H  88      27.626   0.407  10.666  1.00 21.31           H  
ATOM   1371 HG13 ILE H  88      25.431   1.243   9.488  1.00 25.81           H  
ATOM   1372 HG12 ILE H  88      24.605   0.448  10.787  1.00 25.81           H  
ATOM   1373 HG21 ILE H  88      26.361  -1.185  12.187  1.00 23.99           H  
ATOM   1374 HG22 ILE H  88      27.532  -0.184  13.001  1.00 23.99           H  
ATOM   1375 HG23 ILE H  88      25.821   0.220  13.104  1.00 23.99           H  
ATOM   1376 HD11 ILE H  88      25.015  -0.883   8.582  1.00 29.10           H  
ATOM   1377 HD12 ILE H  88      26.667  -1.085   9.140  1.00 29.10           H  
ATOM   1378 HD13 ILE H  88      25.327  -1.725  10.091  1.00 29.10           H  
ATOM   1379  N   TYR H  89      27.455   2.710  13.782  1.00 18.73           N  
ATOM   1380  CA  TYR H  89      28.253   2.831  14.997  1.00 18.33           C  
ATOM   1381  C   TYR H  89      27.627   1.901  16.031  1.00 14.92           C  
ATOM   1382  O   TYR H  89      26.516   2.168  16.478  1.00 19.37           O  
ATOM   1383  CB  TYR H  89      28.234   4.285  15.517  1.00 19.24           C  
ATOM   1384  CG  TYR H  89      28.679   5.317  14.507  1.00 23.08           C  
ATOM   1385  CD1 TYR H  89      27.729   5.889  13.638  1.00 26.78           C  
ATOM   1386  CD2 TYR H  89      30.035   5.687  14.410  1.00 26.95           C  
ATOM   1387  CE1 TYR H  89      28.128   6.833  12.677  1.00 31.77           C  
ATOM   1388  CE2 TYR H  89      30.434   6.627  13.442  1.00 32.24           C  
ATOM   1389  CZ  TYR H  89      29.480   7.208  12.584  1.00 35.91           C  
ATOM   1390  OH  TYR H  89      29.868   8.115  11.644  1.00 43.48           O  
ATOM   1391  H   TYR H  89      26.454   2.805  13.911  1.00 18.73           H  
ATOM   1392  HA  TYR H  89      29.287   2.529  14.820  1.00 18.33           H  
ATOM   1393  HB3 TYR H  89      28.861   4.370  16.407  1.00 19.24           H  
ATOM   1394  HB2 TYR H  89      27.230   4.563  15.838  1.00 19.24           H  
ATOM   1395  HD1 TYR H  89      26.695   5.585  13.694  1.00 26.78           H  
ATOM   1396  HD2 TYR H  89      30.770   5.245  15.066  1.00 26.95           H  
ATOM   1397  HE1 TYR H  89      27.394   7.259  12.009  1.00 31.77           H  
ATOM   1398  HE2 TYR H  89      31.475   6.901  13.357  1.00 32.24           H  
ATOM   1399  HH  TYR H  89      29.145   8.419  11.091  1.00 43.48           H  
ATOM   1400  N   ILE H  90      28.347   0.837  16.397  1.00 17.02           N  
ATOM   1401  CA  ILE H  90      27.959  -0.079  17.468  1.00 18.70           C  
ATOM   1402  C   ILE H  90      28.780   0.275  18.718  1.00 14.94           C  
ATOM   1403  O   ILE H  90      29.933   0.689  18.579  1.00 18.38           O  
ATOM   1404  CB  ILE H  90      28.210  -1.553  17.033  1.00 18.83           C  
ATOM   1405  CG1 ILE H  90      27.238  -1.924  15.887  1.00 24.97           C  
ATOM   1406  CG2 ILE H  90      28.103  -2.584  18.177  1.00 17.17           C  
ATOM   1407  CD1 ILE H  90      27.557  -3.238  15.167  1.00 31.78           C  
ATOM   1408  H   ILE H  90      29.256   0.679  15.988  1.00 17.02           H  
ATOM   1409  HA  ILE H  90      26.900   0.031  17.714  1.00 18.70           H  
ATOM   1410  HB  ILE H  90      29.224  -1.619  16.633  1.00 18.83           H  
ATOM   1411 HG13 ILE H  90      27.205  -1.133  15.140  1.00 24.97           H  
ATOM   1412 HG12 ILE H  90      26.225  -1.985  16.286  1.00 24.97           H  
ATOM   1413 HG21 ILE H  90      28.118  -3.608  17.805  1.00 17.17           H  
ATOM   1414 HG22 ILE H  90      28.934  -2.501  18.875  1.00 17.17           H  
ATOM   1415 HG23 ILE H  90      27.182  -2.448  18.740  1.00 17.17           H  
ATOM   1416 HD11 ILE H  90      27.410  -3.141  14.091  1.00 31.78           H  
ATOM   1417 HD12 ILE H  90      28.583  -3.564  15.334  1.00 31.78           H  
ATOM   1418 HD13 ILE H  90      26.886  -4.020  15.517  1.00 31.78           H  
ATOM   1419  N   HIS H  91      28.174   0.122  19.912  1.00 15.04           N  
ATOM   1420  CA  HIS H  91      28.833   0.372  21.200  1.00 15.84           C  
ATOM   1421  C   HIS H  91      30.099  -0.501  21.339  1.00 17.37           C  
ATOM   1422  O   HIS H  91      29.994  -1.712  21.147  1.00 18.91           O  
ATOM   1423  CB  HIS H  91      27.840   0.082  22.345  1.00 15.52           C  
ATOM   1424  CG  HIS H  91      28.222   0.737  23.652  1.00 18.77           C  
ATOM   1425  ND1 HIS H  91      29.312   0.311  24.422  1.00 22.63           N  
ATOM   1426  CD2 HIS H  91      27.641   1.821  24.277  1.00 16.64           C  
ATOM   1427  CE1 HIS H  91      29.376   1.169  25.430  1.00 20.79           C  
ATOM   1428  NE2 HIS H  91      28.405   2.081  25.400  1.00 20.39           N  
ATOM   1429  H   HIS H  91      27.219  -0.205  19.955  1.00 15.04           H  
ATOM   1430  HA  HIS H  91      29.057   1.435  21.199  1.00 15.84           H  
ATOM   1431  HB3 HIS H  91      27.719  -0.988  22.510  1.00 15.52           H  
ATOM   1432  HB2 HIS H  91      26.857   0.455  22.067  1.00 15.52           H  
ATOM   1433  HD2 HIS H  91      26.788   2.425  24.005  1.00 16.64           H  
ATOM   1434  HE1 HIS H  91      30.129   1.124  26.203  1.00 20.79           H  
ATOM   1435  HE2 HIS H  91      28.257   2.822  26.069  1.00 20.39           H  
ATOM   1436  N   PRO H  92      31.272   0.110  21.627  1.00 20.47           N  
ATOM   1437  CA  PRO H  92      32.557  -0.617  21.663  1.00 21.15           C  
ATOM   1438  C   PRO H  92      32.675  -1.704  22.751  1.00 19.61           C  
ATOM   1439  O   PRO H  92      33.577  -2.535  22.657  1.00 23.54           O  
ATOM   1440  CB  PRO H  92      33.601   0.497  21.848  1.00 25.99           C  
ATOM   1441  CG  PRO H  92      32.850   1.612  22.556  1.00 24.43           C  
ATOM   1442  CD  PRO H  92      31.464   1.528  21.933  1.00 21.54           C  
ATOM   1443  HA  PRO H  92      32.721  -1.106  20.700  1.00 21.15           H  
ATOM   1444  HB3 PRO H  92      33.931   0.845  20.867  1.00 25.99           H  
ATOM   1445  HB2 PRO H  92      34.491   0.184  22.395  1.00 25.99           H  
ATOM   1446  HG3 PRO H  92      33.316   2.591  22.446  1.00 24.43           H  
ATOM   1447  HG2 PRO H  92      32.784   1.386  23.622  1.00 24.43           H  
ATOM   1448  HD2 PRO H  92      30.715   1.932  22.615  1.00 21.54           H  
ATOM   1449  HD3 PRO H  92      31.429   2.091  20.999  1.00 21.54           H  
ATOM   1450  N   ARG H  93      31.758  -1.692  23.732  1.00 19.14           N  
ATOM   1451  CA  ARG H  93      31.655  -2.673  24.807  1.00 17.40           C  
ATOM   1452  C   ARG H  93      30.330  -3.461  24.745  1.00 14.97           C  
ATOM   1453  O   ARG H  93      29.918  -4.017  25.762  1.00 19.89           O  
ATOM   1454  CB  ARG H  93      31.852  -1.961  26.157  1.00 20.86           C  
ATOM   1455  CG  ARG H  93      33.222  -1.281  26.326  1.00 25.05           C  
ATOM   1456  CD  ARG H  93      33.453  -0.764  27.757  1.00 27.68           C  
ATOM   1457  NE  ARG H  93      33.635  -1.866  28.723  1.00 30.64           N  
ATOM   1458  CZ  ARG H  93      33.593  -1.798  30.067  1.00 30.10           C  
ATOM   1459  NH1 ARG H  93      33.378  -0.645  30.718  1.00 34.88           N  
ATOM   1460  NH2 ARG H  93      33.779  -2.920  30.774  1.00 34.42           N1+
ATOM   1461  H   ARG H  93      31.044  -0.976  23.728  1.00 19.14           H  
ATOM   1462  HA  ARG H  93      32.440  -3.425  24.709  1.00 17.40           H  
ATOM   1463  HB3 ARG H  93      31.719  -2.684  26.961  1.00 20.86           H  
ATOM   1464  HB2 ARG H  93      31.084  -1.203  26.288  1.00 20.86           H  
ATOM   1465  HG3 ARG H  93      33.388  -0.483  25.602  1.00 25.05           H  
ATOM   1466  HG2 ARG H  93      33.976  -2.038  26.102  1.00 25.05           H  
ATOM   1467  HD3 ARG H  93      32.544  -0.250  28.071  1.00 27.68           H  
ATOM   1468  HD2 ARG H  93      34.256  -0.027  27.800  1.00 27.68           H  
ATOM   1469  HE  ARG H  93      33.824  -2.766  28.306  1.00 30.64           H  
ATOM   1470 HH12 ARG H  93      33.375  -0.613  31.727  1.00 34.88           H  
ATOM   1471 HH11 ARG H  93      33.257   0.210  30.195  1.00 34.88           H  
ATOM   1472 HH22 ARG H  93      33.780  -2.895  31.784  1.00 34.42           H  
ATOM   1473 HH21 ARG H  93      33.964  -3.796  30.307  1.00 34.42           H  
ATOM   1474  N   TYR H  94      29.702  -3.546  23.559  1.00 16.10           N  
ATOM   1475  CA  TYR H  94      28.584  -4.448  23.283  1.00 15.57           C  
ATOM   1476  C   TYR H  94      28.994  -5.926  23.472  1.00 15.56           C  
ATOM   1477  O   TYR H  94      29.895  -6.401  22.778  1.00 20.54           O  
ATOM   1478  CB  TYR H  94      28.028  -4.148  21.876  1.00 15.37           C  
ATOM   1479  CG  TYR H  94      27.116  -5.203  21.280  1.00 14.23           C  
ATOM   1480  CD1 TYR H  94      25.987  -5.667  21.989  1.00 15.25           C  
ATOM   1481  CD2 TYR H  94      27.427  -5.748  20.019  1.00 16.55           C  
ATOM   1482  CE1 TYR H  94      25.183  -6.685  21.444  1.00 15.33           C  
ATOM   1483  CE2 TYR H  94      26.614  -6.749  19.468  1.00 14.02           C  
ATOM   1484  CZ  TYR H  94      25.498  -7.226  20.183  1.00 15.95           C  
ATOM   1485  OH  TYR H  94      24.749  -8.239  19.667  1.00 16.90           O  
ATOM   1486  H   TYR H  94      30.080  -3.054  22.760  1.00 16.10           H  
ATOM   1487  HA  TYR H  94      27.796  -4.204  23.994  1.00 15.57           H  
ATOM   1488  HB3 TYR H  94      28.868  -4.032  21.190  1.00 15.37           H  
ATOM   1489  HB2 TYR H  94      27.503  -3.193  21.871  1.00 15.37           H  
ATOM   1490  HD1 TYR H  94      25.748  -5.259  22.960  1.00 15.25           H  
ATOM   1491  HD2 TYR H  94      28.294  -5.410  19.471  1.00 16.55           H  
ATOM   1492  HE1 TYR H  94      24.330  -7.048  21.997  1.00 15.33           H  
ATOM   1493  HE2 TYR H  94      26.881  -7.164  18.510  1.00 14.02           H  
ATOM   1494  HH  TYR H  94      25.008  -8.455  18.765  1.00 16.90           H  
ATOM   1495  N   ASN H  95      28.326  -6.603  24.418  1.00 17.48           N  
ATOM   1496  CA  ASN H  95      28.608  -7.979  24.816  1.00 17.04           C  
ATOM   1497  C   ASN H  95      27.653  -8.947  24.097  1.00 16.54           C  
ATOM   1498  O   ASN H  95      26.694  -9.429  24.701  1.00 20.08           O  
ATOM   1499  CB  ASN H  95      28.529  -8.096  26.359  1.00 16.56           C  
ATOM   1500  CG  ASN H  95      29.167  -9.368  26.940  1.00 21.13           C  
ATOM   1501  OD1 ASN H  95      29.472 -10.320  26.224  1.00 24.29           O  
ATOM   1502  ND2 ASN H  95      29.355  -9.398  28.260  1.00 21.46           N  
ATOM   1503  H   ASN H  95      27.595  -6.132  24.939  1.00 17.48           H  
ATOM   1504  HA  ASN H  95      29.614  -8.269  24.516  1.00 17.04           H  
ATOM   1505  HB3 ASN H  95      27.496  -8.030  26.696  1.00 16.56           H  
ATOM   1506  HB2 ASN H  95      29.053  -7.248  26.805  1.00 16.56           H  
ATOM   1507 HD22 ASN H  95      29.727 -10.227  28.702  1.00 21.46           H  
ATOM   1508 HD21 ASN H  95      29.124  -8.598  28.835  1.00 21.46           H  
ATOM   1509  N   TRP H  96      27.964  -9.253  22.827  1.00 16.88           N  
ATOM   1510  CA  TRP H  96      27.291 -10.301  22.054  1.00 16.78           C  
ATOM   1511  C   TRP H  96      27.630 -11.728  22.521  1.00 17.93           C  
ATOM   1512  O   TRP H  96      26.862 -12.637  22.211  1.00 21.16           O  
ATOM   1513  CB  TRP H  96      27.611 -10.150  20.555  1.00 18.37           C  
ATOM   1514  CG  TRP H  96      29.055 -10.126  20.158  1.00 17.36           C  
ATOM   1515  CD1 TRP H  96      29.806  -9.012  20.007  1.00 18.85           C  
ATOM   1516  CD2 TRP H  96      29.950 -11.252  19.914  1.00 18.67           C  
ATOM   1517  NE1 TRP H  96      31.092  -9.367  19.657  1.00 20.83           N  
ATOM   1518  CE2 TRP H  96      31.241 -10.737  19.585  1.00 18.67           C  
ATOM   1519  CE3 TRP H  96      29.803 -12.659  19.925  1.00 20.20           C  
ATOM   1520  CZ2 TRP H  96      32.325 -11.576  19.274  1.00 19.29           C  
ATOM   1521  CZ3 TRP H  96      30.879 -13.511  19.608  1.00 20.07           C  
ATOM   1522  CH2 TRP H  96      32.138 -12.971  19.280  1.00 21.42           C  
ATOM   1523  H   TRP H  96      28.757  -8.808  22.386  1.00 16.88           H  
ATOM   1524  HA  TRP H  96      26.215 -10.176  22.176  1.00 16.78           H  
ATOM   1525  HB3 TRP H  96      27.169  -9.234  20.185  1.00 18.37           H  
ATOM   1526  HB2 TRP H  96      27.124 -10.946  19.990  1.00 18.37           H  
ATOM   1527  HD1 TRP H  96      29.439  -8.004  20.137  1.00 18.85           H  
ATOM   1528  HE1 TRP H  96      31.816  -8.685  19.481  1.00 20.83           H  
ATOM   1529  HE3 TRP H  96      28.844 -13.089  20.173  1.00 20.20           H  
ATOM   1530  HZ2 TRP H  96      33.288 -11.156  19.026  1.00 19.29           H  
ATOM   1531  HZ3 TRP H  96      30.736 -14.581  19.615  1.00 20.07           H  
ATOM   1532  HH2 TRP H  96      32.959 -13.628  19.035  1.00 21.42           H  
ATOM   1533  N   ARG H  97      28.768 -11.912  23.215  1.00 19.21           N  
ATOM   1534  CA  ARG H  97      29.255 -13.216  23.673  1.00 21.86           C  
ATOM   1535  C   ARG H  97      28.394 -13.843  24.778  1.00 22.30           C  
ATOM   1536  O   ARG H  97      28.289 -15.069  24.802  1.00 26.20           O  
ATOM   1537  CB  ARG H  97      30.713 -13.095  24.159  1.00 23.72           C  
ATOM   1538  CG  ARG H  97      31.713 -12.858  23.023  1.00 25.15           C  
ATOM   1539  CD  ARG H  97      33.153 -12.690  23.531  1.00 31.82           C  
ATOM   1540  NE  ARG H  97      34.130 -12.719  22.430  1.00 34.38           N  
ATOM   1541  CZ  ARG H  97      34.615 -13.813  21.809  1.00 42.18           C  
ATOM   1542  NH1 ARG H  97      34.249 -15.057  22.156  1.00 40.26           N  
ATOM   1543  NH2 ARG H  97      35.494 -13.655  20.811  1.00 50.68           N1+
ATOM   1544  H   ARG H  97      29.355 -11.117  23.425  1.00 19.21           H  
ATOM   1545  HA  ARG H  97      29.233 -13.904  22.825  1.00 21.86           H  
ATOM   1546  HB3 ARG H  97      31.004 -14.020  24.660  1.00 23.72           H  
ATOM   1547  HB2 ARG H  97      30.798 -12.308  24.910  1.00 23.72           H  
ATOM   1548  HG3 ARG H  97      31.418 -11.932  22.530  1.00 25.15           H  
ATOM   1549  HG2 ARG H  97      31.643 -13.634  22.261  1.00 25.15           H  
ATOM   1550  HD3 ARG H  97      33.399 -13.368  24.349  1.00 31.82           H  
ATOM   1551  HD2 ARG H  97      33.247 -11.683  23.937  1.00 31.82           H  
ATOM   1552  HE  ARG H  97      34.418 -11.813  22.090  1.00 34.38           H  
ATOM   1553 HH12 ARG H  97      34.628 -15.862  21.679  1.00 40.26           H  
ATOM   1554 HH11 ARG H  97      33.590 -15.193  22.910  1.00 40.26           H  
ATOM   1555 HH22 ARG H  97      35.875 -14.458  20.332  1.00 50.68           H  
ATOM   1556 HH21 ARG H  97      35.792 -12.731  20.533  1.00 50.68           H  
ATOM   1557  N   GLU H  97A     27.818 -13.015  25.665  1.00 22.09           N  
ATOM   1558  CA  GLU H  97A     27.167 -13.483  26.883  1.00 24.71           C  
ATOM   1559  C   GLU H  97A     25.669 -13.141  26.902  1.00 23.40           C  
ATOM   1560  O   GLU H  97A     24.851 -14.050  26.765  1.00 25.43           O  
ATOM   1561  CB  GLU H  97A     27.931 -12.923  28.102  1.00 25.70           C  
ATOM   1562  CG  GLU H  97A     27.422 -13.474  29.453  1.00 29.43           C  
ATOM   1563  CD  GLU H  97A     27.975 -12.783  30.705  1.00 31.13           C  
ATOM   1564  OE1 GLU H  97A     28.863 -11.909  30.587  1.00 36.99           O  
ATOM   1565  OE2 GLU H  97A     27.470 -13.141  31.791  1.00 35.91           O1-
ATOM   1566  H   GLU H  97A     27.943 -12.016  25.574  1.00 22.09           H  
ATOM   1567  HA  GLU H  97A     27.231 -14.571  26.954  1.00 24.71           H  
ATOM   1568  HB3 GLU H  97A     27.867 -11.835  28.095  1.00 25.70           H  
ATOM   1569  HB2 GLU H  97A     28.992 -13.158  28.000  1.00 25.70           H  
ATOM   1570  HG3 GLU H  97A     27.658 -14.537  29.515  1.00 29.43           H  
ATOM   1571  HG2 GLU H  97A     26.338 -13.406  29.502  1.00 29.43           H  
ATOM   1572  N   ASN H  98      25.348 -11.863  27.160  1.00 19.71           N  
ATOM   1573  CA  ASN H  98      24.061 -11.439  27.725  1.00 18.39           C  
ATOM   1574  C   ASN H  98      23.408 -10.247  27.007  1.00 17.24           C  
ATOM   1575  O   ASN H  98      22.361  -9.803  27.476  1.00 17.18           O  
ATOM   1576  CB  ASN H  98      24.228 -11.169  29.247  1.00 19.18           C  
ATOM   1577  CG  ASN H  98      25.251 -10.089  29.643  1.00 18.44           C  
ATOM   1578  OD1 ASN H  98      26.053  -9.623  28.836  1.00 17.41           O  
ATOM   1579  ND2 ASN H  98      25.229  -9.695  30.916  1.00 19.03           N  
ATOM   1580  H   ASN H  98      26.090 -11.181  27.236  1.00 19.71           H  
ATOM   1581  HA  ASN H  98      23.340 -12.253  27.627  1.00 18.39           H  
ATOM   1582  HB3 ASN H  98      24.527 -12.092  29.743  1.00 19.18           H  
ATOM   1583  HB2 ASN H  98      23.263 -10.914  29.687  1.00 19.18           H  
ATOM   1584 HD22 ASN H  98      25.882  -9.000  31.243  1.00 19.03           H  
ATOM   1585 HD21 ASN H  98      24.541 -10.075  31.555  1.00 19.03           H  
ATOM   1586  N   LEU H  99      24.001  -9.747  25.907  1.00 15.15           N  
ATOM   1587  CA  LEU H  99      23.548  -8.557  25.165  1.00 14.41           C  
ATOM   1588  C   LEU H  99      23.639  -7.284  26.042  1.00 14.35           C  
ATOM   1589  O   LEU H  99      22.748  -6.437  26.009  1.00 15.91           O  
ATOM   1590  CB  LEU H  99      22.150  -8.799  24.505  1.00 17.04           C  
ATOM   1591  CG  LEU H  99      22.161  -9.251  23.026  1.00 22.02           C  
ATOM   1592  CD1 LEU H  99      23.099 -10.431  22.703  1.00 18.09           C  
ATOM   1593  CD2 LEU H  99      20.722  -9.525  22.550  1.00 19.47           C  
ATOM   1594  H   LEU H  99      24.863 -10.161  25.579  1.00 15.15           H  
ATOM   1595  HA  LEU H  99      24.268  -8.391  24.363  1.00 14.41           H  
ATOM   1596  HB3 LEU H  99      21.544  -7.894  24.532  1.00 17.04           H  
ATOM   1597  HB2 LEU H  99      21.571  -9.521  25.078  1.00 17.04           H  
ATOM   1598  HG  LEU H  99      22.518  -8.397  22.451  1.00 22.02           H  
ATOM   1599 HD11 LEU H  99      22.573 -11.250  22.214  1.00 18.09           H  
ATOM   1600 HD12 LEU H  99      23.889 -10.112  22.024  1.00 18.09           H  
ATOM   1601 HD13 LEU H  99      23.577 -10.852  23.584  1.00 18.09           H  
ATOM   1602 HD21 LEU H  99      20.606  -9.276  21.497  1.00 19.47           H  
ATOM   1603 HD22 LEU H  99      20.441 -10.571  22.678  1.00 19.47           H  
ATOM   1604 HD23 LEU H  99      19.994  -8.928  23.099  1.00 19.47           H  
ATOM   1605  N   ASP H 100      24.724  -7.170  26.832  1.00 13.75           N  
ATOM   1606  CA  ASP H 100      25.023  -5.982  27.634  1.00 15.51           C  
ATOM   1607  C   ASP H 100      25.492  -4.850  26.702  1.00 12.98           C  
ATOM   1608  O   ASP H 100      26.385  -5.076  25.889  1.00 16.24           O  
ATOM   1609  CB  ASP H 100      26.053  -6.289  28.754  1.00 15.76           C  
ATOM   1610  CG  ASP H 100      26.376  -5.158  29.742  1.00 15.52           C  
ATOM   1611  OD1 ASP H 100      25.530  -4.258  29.911  1.00 16.76           O  
ATOM   1612  OD2 ASP H 100      27.396  -5.291  30.450  1.00 22.70           O1-
ATOM   1613  H   ASP H 100      25.414  -7.907  26.842  1.00 13.75           H  
ATOM   1614  HA  ASP H 100      24.092  -5.671  28.112  1.00 15.51           H  
ATOM   1615  HB3 ASP H 100      26.984  -6.652  28.322  1.00 15.76           H  
ATOM   1616  HB2 ASP H 100      25.668  -7.116  29.349  1.00 15.76           H  
ATOM   1617  N   ARG H 101      24.873  -3.667  26.846  1.00 13.92           N  
ATOM   1618  CA  ARG H 101      25.091  -2.463  26.036  1.00 12.67           C  
ATOM   1619  C   ARG H 101      24.685  -2.678  24.569  1.00 12.21           C  
ATOM   1620  O   ARG H 101      25.447  -2.354  23.657  1.00 13.81           O  
ATOM   1621  CB  ARG H 101      26.530  -1.914  26.179  1.00 15.64           C  
ATOM   1622  CG  ARG H 101      27.013  -1.801  27.629  1.00 18.30           C  
ATOM   1623  CD  ARG H 101      28.440  -1.257  27.711  1.00 22.26           C  
ATOM   1624  NE  ARG H 101      29.035  -1.467  29.040  1.00 27.66           N  
ATOM   1625  CZ  ARG H 101      29.589  -2.605  29.503  1.00 30.82           C  
ATOM   1626  NH1 ARG H 101      29.730  -3.703  28.746  1.00 27.10           N  
ATOM   1627  NH2 ARG H 101      30.012  -2.646  30.771  1.00 35.32           N1+
ATOM   1628  H   ARG H 101      24.135  -3.595  27.534  1.00 13.92           H  
ATOM   1629  HA  ARG H 101      24.407  -1.722  26.448  1.00 12.67           H  
ATOM   1630  HB3 ARG H 101      26.597  -0.938  25.696  1.00 15.64           H  
ATOM   1631  HB2 ARG H 101      27.225  -2.558  25.640  1.00 15.64           H  
ATOM   1632  HG3 ARG H 101      26.928  -2.736  28.177  1.00 18.30           H  
ATOM   1633  HG2 ARG H 101      26.342  -1.097  28.122  1.00 18.30           H  
ATOM   1634  HD3 ARG H 101      28.383  -0.172  27.628  1.00 22.26           H  
ATOM   1635  HD2 ARG H 101      29.057  -1.600  26.886  1.00 22.26           H  
ATOM   1636  HE  ARG H 101      28.939  -0.692  29.680  1.00 27.66           H  
ATOM   1637 HH12 ARG H 101      30.091  -4.561  29.138  1.00 27.10           H  
ATOM   1638 HH11 ARG H 101      29.438  -3.695  27.776  1.00 27.10           H  
ATOM   1639 HH22 ARG H 101      30.395  -3.500  31.149  1.00 35.32           H  
ATOM   1640 HH21 ARG H 101      29.915  -1.841  31.371  1.00 35.32           H  
ATOM   1641  N   ASP H 102      23.494  -3.266  24.387  1.00 13.72           N  
ATOM   1642  CA  ASP H 102      22.929  -3.650  23.100  1.00 11.44           C  
ATOM   1643  C   ASP H 102      22.297  -2.422  22.416  1.00 10.49           C  
ATOM   1644  O   ASP H 102      21.078  -2.251  22.445  1.00 11.81           O  
ATOM   1645  CB  ASP H 102      21.973  -4.846  23.302  1.00 12.50           C  
ATOM   1646  CG  ASP H 102      21.292  -5.409  22.056  1.00 11.73           C  
ATOM   1647  OD1 ASP H 102      21.926  -5.390  20.984  1.00 13.39           O  
ATOM   1648  OD2 ASP H 102      20.214  -6.009  22.225  1.00 14.13           O1-
ATOM   1649  H   ASP H 102      22.943  -3.515  25.198  1.00 13.72           H  
ATOM   1650  HA  ASP H 102      23.747  -3.988  22.462  1.00 11.44           H  
ATOM   1651  HB3 ASP H 102      21.239  -4.625  24.077  1.00 12.50           H  
ATOM   1652  HB2 ASP H 102      22.567  -5.670  23.691  1.00 12.50           H  
ATOM   1653  N   ILE H 103      23.164  -1.567  21.857  1.00 12.66           N  
ATOM   1654  CA  ILE H 103      22.798  -0.273  21.300  1.00 11.66           C  
ATOM   1655  C   ILE H 103      23.719   0.063  20.119  1.00 12.55           C  
ATOM   1656  O   ILE H 103      24.928  -0.172  20.180  1.00 13.05           O  
ATOM   1657  CB  ILE H 103      22.870   0.848  22.384  1.00 11.49           C  
ATOM   1658  CG1 ILE H 103      22.160   2.143  21.947  1.00 13.74           C  
ATOM   1659  CG2 ILE H 103      24.287   1.163  22.905  1.00 14.18           C  
ATOM   1660  CD1 ILE H 103      21.813   3.074  23.120  1.00 14.09           C  
ATOM   1661  H   ILE H 103      24.154  -1.771  21.885  1.00 12.66           H  
ATOM   1662  HA  ILE H 103      21.776  -0.336  20.922  1.00 11.66           H  
ATOM   1663  HB  ILE H 103      22.312   0.470  23.238  1.00 11.49           H  
ATOM   1664 HG13 ILE H 103      21.241   1.886  21.428  1.00 13.74           H  
ATOM   1665 HG12 ILE H 103      22.767   2.681  21.221  1.00 13.74           H  
ATOM   1666 HG21 ILE H 103      24.254   1.843  23.755  1.00 14.18           H  
ATOM   1667 HG22 ILE H 103      24.797   0.260  23.239  1.00 14.18           H  
ATOM   1668 HG23 ILE H 103      24.901   1.644  22.146  1.00 14.18           H  
ATOM   1669 HD11 ILE H 103      21.040   3.788  22.841  1.00 14.09           H  
ATOM   1670 HD12 ILE H 103      21.434   2.518  23.977  1.00 14.09           H  
ATOM   1671 HD13 ILE H 103      22.685   3.643  23.445  1.00 14.09           H  
ATOM   1672  N   ALA H 104      23.108   0.617  19.067  1.00 13.20           N  
ATOM   1673  CA  ALA H 104      23.783   1.070  17.864  1.00 13.95           C  
ATOM   1674  C   ALA H 104      23.058   2.285  17.283  1.00 11.98           C  
ATOM   1675  O   ALA H 104      21.837   2.393  17.392  1.00 13.90           O  
ATOM   1676  CB  ALA H 104      23.868  -0.079  16.851  1.00 16.74           C  
ATOM   1677  H   ALA H 104      22.104   0.752  19.081  1.00 13.20           H  
ATOM   1678  HA  ALA H 104      24.793   1.376  18.134  1.00 13.95           H  
ATOM   1679  HB1 ALA H 104      24.337   0.244  15.921  1.00 16.74           H  
ATOM   1680  HB2 ALA H 104      24.471  -0.890  17.254  1.00 16.74           H  
ATOM   1681  HB3 ALA H 104      22.883  -0.482  16.615  1.00 16.74           H  
ATOM   1682  N   LEU H 105      23.844   3.162  16.652  1.00 14.77           N  
ATOM   1683  CA  LEU H 105      23.391   4.336  15.920  1.00 14.03           C  
ATOM   1684  C   LEU H 105      23.734   4.155  14.440  1.00 16.02           C  
ATOM   1685  O   LEU H 105      24.758   3.561  14.108  1.00 18.18           O  
ATOM   1686  CB  LEU H 105      24.102   5.588  16.472  1.00 18.02           C  
ATOM   1687  CG  LEU H 105      23.562   6.111  17.818  1.00 19.10           C  
ATOM   1688  CD1 LEU H 105      24.557   7.096  18.452  1.00 21.11           C  
ATOM   1689  CD2 LEU H 105      22.186   6.780  17.656  1.00 16.81           C  
ATOM   1690  H   LEU H 105      24.836   2.966  16.586  1.00 14.77           H  
ATOM   1691  HA  LEU H 105      22.311   4.447  16.007  1.00 14.03           H  
ATOM   1692  HB3 LEU H 105      24.030   6.401  15.752  1.00 18.02           H  
ATOM   1693  HB2 LEU H 105      25.167   5.374  16.567  1.00 18.02           H  
ATOM   1694  HG  LEU H 105      23.448   5.268  18.501  1.00 19.10           H  
ATOM   1695 HD11 LEU H 105      24.058   7.935  18.935  1.00 21.11           H  
ATOM   1696 HD12 LEU H 105      25.173   6.600  19.202  1.00 21.11           H  
ATOM   1697 HD13 LEU H 105      25.225   7.523  17.708  1.00 21.11           H  
ATOM   1698 HD21 LEU H 105      21.759   7.031  18.628  1.00 16.81           H  
ATOM   1699 HD22 LEU H 105      22.269   7.704  17.083  1.00 16.81           H  
ATOM   1700 HD23 LEU H 105      21.467   6.144  17.144  1.00 16.81           H  
ATOM   1701  N   MET H 106      22.863   4.695  13.581  1.00 18.37           N  
ATOM   1702  CA  MET H 106      22.990   4.666  12.132  1.00 20.67           C  
ATOM   1703  C   MET H 106      22.765   6.087  11.620  1.00 19.16           C  
ATOM   1704  O   MET H 106      21.657   6.611  11.741  1.00 21.01           O  
ATOM   1705  CB  MET H 106      21.967   3.679  11.536  1.00 23.77           C  
ATOM   1706  CG  MET H 106      22.203   2.223  11.972  1.00 24.94           C  
ATOM   1707  SD  MET H 106      20.914   1.048  11.492  1.00 27.35           S  
ATOM   1708  CE  MET H 106      19.539   1.781  12.413  1.00 26.68           C  
ATOM   1709  H   MET H 106      22.024   5.137  13.937  1.00 18.37           H  
ATOM   1710  HA  MET H 106      23.990   4.342  11.838  1.00 20.67           H  
ATOM   1711  HB3 MET H 106      22.011   3.729  10.448  1.00 23.77           H  
ATOM   1712  HB2 MET H 106      20.960   3.991  11.808  1.00 23.77           H  
ATOM   1713  HG3 MET H 106      22.294   2.149  13.055  1.00 24.94           H  
ATOM   1714  HG2 MET H 106      23.153   1.881  11.569  1.00 24.94           H  
ATOM   1715  HE1 MET H 106      18.832   1.019  12.726  1.00 26.68           H  
ATOM   1716  HE2 MET H 106      19.889   2.291  13.311  1.00 26.68           H  
ATOM   1717  HE3 MET H 106      19.024   2.501  11.779  1.00 26.68           H  
ATOM   1718  N   LYS H 107      23.831   6.676  11.059  1.00 21.11           N  
ATOM   1719  CA  LYS H 107      23.780   7.948  10.350  1.00 22.33           C  
ATOM   1720  C   LYS H 107      23.238   7.708   8.934  1.00 23.78           C  
ATOM   1721  O   LYS H 107      23.755   6.835   8.241  1.00 22.43           O  
ATOM   1722  CB  LYS H 107      25.187   8.585  10.349  1.00 25.36           C  
ATOM   1723  CG  LYS H 107      25.287   9.916   9.581  1.00 28.98           C  
ATOM   1724  CD  LYS H 107      26.598  10.674   9.859  1.00 32.48           C  
ATOM   1725  CE  LYS H 107      26.824  11.837   8.871  1.00 39.78           C  
ATOM   1726  NZ  LYS H 107      27.178  13.120   9.497  1.00 56.79           N1+
ATOM   1727  H   LYS H 107      24.705   6.170  11.000  1.00 21.11           H  
ATOM   1728  HA  LYS H 107      23.118   8.618  10.896  1.00 22.33           H  
ATOM   1729  HB3 LYS H 107      25.916   7.884   9.937  1.00 25.36           H  
ATOM   1730  HB2 LYS H 107      25.487   8.759  11.380  1.00 25.36           H  
ATOM   1731  HG3 LYS H 107      24.435  10.550   9.825  1.00 28.98           H  
ATOM   1732  HG2 LYS H 107      25.215   9.716   8.512  1.00 28.98           H  
ATOM   1733  HD3 LYS H 107      27.432   9.975   9.776  1.00 32.48           H  
ATOM   1734  HD2 LYS H 107      26.616  11.011  10.895  1.00 32.48           H  
ATOM   1735  HE3 LYS H 107      25.940  12.003   8.257  1.00 39.78           H  
ATOM   1736  HE2 LYS H 107      27.649  11.576   8.213  1.00 39.78           H  
ATOM   1737  HZ1 LYS H 107      28.013  13.008  10.059  1.00 56.79           H  
ATOM   1738  HZ2 LYS H 107      27.349  13.809   8.778  1.00 56.79           H  
ATOM   1739  HZ3 LYS H 107      26.423  13.430  10.091  1.00 56.79           H  
ATOM   1740  N   LEU H 108      22.224   8.489   8.534  1.00 22.25           N  
ATOM   1741  CA  LEU H 108      21.658   8.485   7.184  1.00 21.60           C  
ATOM   1742  C   LEU H 108      22.529   9.332   6.241  1.00 23.00           C  
ATOM   1743  O   LEU H 108      23.131  10.305   6.695  1.00 24.22           O  
ATOM   1744  CB  LEU H 108      20.218   9.052   7.228  1.00 20.14           C  
ATOM   1745  CG  LEU H 108      19.242   8.327   8.184  1.00 23.29           C  
ATOM   1746  CD1 LEU H 108      17.855   9.007   8.170  1.00 22.18           C  
ATOM   1747  CD2 LEU H 108      19.160   6.810   7.917  1.00 26.20           C  
ATOM   1748  H   LEU H 108      21.836   9.166   9.178  1.00 22.25           H  
ATOM   1749  HA  LEU H 108      21.639   7.461   6.809  1.00 21.60           H  
ATOM   1750  HB3 LEU H 108      19.799   9.027   6.220  1.00 20.14           H  
ATOM   1751  HB2 LEU H 108      20.260  10.107   7.504  1.00 20.14           H  
ATOM   1752  HG  LEU H 108      19.624   8.445   9.198  1.00 23.29           H  
ATOM   1753 HD11 LEU H 108      17.519   9.226   9.185  1.00 22.18           H  
ATOM   1754 HD12 LEU H 108      17.870   9.954   7.629  1.00 22.18           H  
ATOM   1755 HD13 LEU H 108      17.092   8.390   7.697  1.00 22.18           H  
ATOM   1756 HD21 LEU H 108      18.138   6.443   7.936  1.00 26.20           H  
ATOM   1757 HD22 LEU H 108      19.568   6.537   6.943  1.00 26.20           H  
ATOM   1758 HD23 LEU H 108      19.714   6.253   8.673  1.00 26.20           H  
ATOM   1759  N   LYS H 109      22.556   8.973   4.944  1.00 24.04           N  
ATOM   1760  CA  LYS H 109      23.270   9.725   3.899  1.00 27.21           C  
ATOM   1761  C   LYS H 109      22.680  11.110   3.596  1.00 26.99           C  
ATOM   1762  O   LYS H 109      23.420  11.978   3.133  1.00 33.28           O  
ATOM   1763  CB  LYS H 109      23.347   8.916   2.591  1.00 32.46           C  
ATOM   1764  CG  LYS H 109      24.232   7.667   2.676  1.00 39.48           C  
ATOM   1765  CD  LYS H 109      24.799   7.262   1.311  1.00 44.99           C  
ATOM   1766  CE  LYS H 109      25.343   5.827   1.306  1.00 45.42           C  
ATOM   1767  NZ  LYS H 109      25.891   5.448  -0.007  1.00 55.41           N1+
ATOM   1768  H   LYS H 109      22.049   8.150   4.642  1.00 24.04           H  
ATOM   1769  HA  LYS H 109      24.287   9.908   4.246  1.00 27.21           H  
ATOM   1770  HB3 LYS H 109      23.773   9.563   1.821  1.00 32.46           H  
ATOM   1771  HB2 LYS H 109      22.351   8.648   2.236  1.00 32.46           H  
ATOM   1772  HG3 LYS H 109      23.653   6.850   3.102  1.00 39.48           H  
ATOM   1773  HG2 LYS H 109      25.069   7.843   3.348  1.00 39.48           H  
ATOM   1774  HD3 LYS H 109      25.606   7.952   1.057  1.00 44.99           H  
ATOM   1775  HD2 LYS H 109      24.039   7.401   0.546  1.00 44.99           H  
ATOM   1776  HE3 LYS H 109      24.543   5.131   1.559  1.00 45.42           H  
ATOM   1777  HE2 LYS H 109      26.123   5.714   2.059  1.00 45.42           H  
ATOM   1778  HZ1 LYS H 109      26.229   4.497   0.035  1.00 55.41           H  
ATOM   1779  HZ2 LYS H 109      25.170   5.516  -0.711  1.00 55.41           H  
ATOM   1780  HZ3 LYS H 109      26.655   6.065  -0.245  1.00 55.41           H  
ATOM   1781  N   LYS H 110      21.376  11.288   3.850  1.00 26.13           N  
ATOM   1782  CA  LYS H 110      20.646  12.536   3.648  1.00 27.33           C  
ATOM   1783  C   LYS H 110      19.613  12.684   4.780  1.00 24.33           C  
ATOM   1784  O   LYS H 110      19.149  11.667   5.300  1.00 28.19           O  
ATOM   1785  CB  LYS H 110      19.957  12.513   2.262  1.00 32.84           C  
ATOM   1786  CG  LYS H 110      20.936  12.530   1.073  1.00 39.35           C  
ATOM   1787  CD  LYS H 110      20.239  12.671  -0.286  1.00 45.60           C  
ATOM   1788  CE  LYS H 110      21.242  12.677  -1.451  1.00 49.71           C  
ATOM   1789  NZ  LYS H 110      20.573  12.870  -2.750  1.00 64.55           N1+
ATOM   1790  H   LYS H 110      20.838  10.530   4.246  1.00 26.13           H  
ATOM   1791  HA  LYS H 110      21.355  13.363   3.697  1.00 27.33           H  
ATOM   1792  HB3 LYS H 110      19.306  13.384   2.174  1.00 32.84           H  
ATOM   1793  HB2 LYS H 110      19.300  11.644   2.185  1.00 32.84           H  
ATOM   1794  HG3 LYS H 110      21.521  11.611   1.064  1.00 39.35           H  
ATOM   1795  HG2 LYS H 110      21.648  13.347   1.203  1.00 39.35           H  
ATOM   1796  HD3 LYS H 110      19.652  13.591  -0.293  1.00 45.60           H  
ATOM   1797  HD2 LYS H 110      19.528  11.851  -0.410  1.00 45.60           H  
ATOM   1798  HE3 LYS H 110      21.797  11.738  -1.478  1.00 49.71           H  
ATOM   1799  HE2 LYS H 110      21.971  13.477  -1.317  1.00 49.71           H  
ATOM   1800  HZ1 LYS H 110      20.084  13.754  -2.749  1.00 64.55           H  
ATOM   1801  HZ2 LYS H 110      21.262  12.870  -3.489  1.00 64.55           H  
ATOM   1802  HZ3 LYS H 110      19.914  12.121  -2.906  1.00 64.55           H  
ATOM   1803  N   PRO H 111      19.247  13.939   5.136  1.00 26.87           N  
ATOM   1804  CA  PRO H 111      18.175  14.191   6.112  1.00 29.90           C  
ATOM   1805  C   PRO H 111      16.798  13.764   5.578  1.00 27.37           C  
ATOM   1806  O   PRO H 111      16.445  14.133   4.457  1.00 36.10           O  
ATOM   1807  CB  PRO H 111      18.257  15.707   6.357  1.00 34.02           C  
ATOM   1808  CG  PRO H 111      18.825  16.278   5.068  1.00 34.44           C  
ATOM   1809  CD  PRO H 111      19.795  15.193   4.610  1.00 29.51           C  
ATOM   1810  HA  PRO H 111      18.379  13.663   7.040  1.00 29.90           H  
ATOM   1811  HB3 PRO H 111      18.946  15.902   7.179  1.00 34.02           H  
ATOM   1812  HB2 PRO H 111      17.302  16.160   6.628  1.00 34.02           H  
ATOM   1813  HG3 PRO H 111      19.296  17.253   5.197  1.00 34.44           H  
ATOM   1814  HG2 PRO H 111      18.025  16.388   4.335  1.00 34.44           H  
ATOM   1815  HD2 PRO H 111      19.901  15.204   3.525  1.00 29.51           H  
ATOM   1816  HD3 PRO H 111      20.779  15.353   5.054  1.00 29.51           H  
ATOM   1817  N   VAL H 112      16.050  12.995   6.388  1.00 25.20           N  
ATOM   1818  CA  VAL H 112      14.652  12.682   6.098  1.00 25.14           C  
ATOM   1819  C   VAL H 112      13.772  13.911   6.395  1.00 26.46           C  
ATOM   1820  O   VAL H 112      13.941  14.557   7.433  1.00 26.53           O  
ATOM   1821  CB  VAL H 112      14.132  11.443   6.889  1.00 25.22           C  
ATOM   1822  CG1 VAL H 112      13.931  11.652   8.403  1.00 23.95           C  
ATOM   1823  CG2 VAL H 112      12.833  10.885   6.274  1.00 33.46           C  
ATOM   1824  H   VAL H 112      16.401  12.718   7.296  1.00 25.20           H  
ATOM   1825  HA  VAL H 112      14.576  12.446   5.034  1.00 25.14           H  
ATOM   1826  HB  VAL H 112      14.889  10.664   6.784  1.00 25.22           H  
ATOM   1827 HG11 VAL H 112      13.685  10.709   8.884  1.00 23.95           H  
ATOM   1828 HG12 VAL H 112      14.830  12.036   8.879  1.00 23.95           H  
ATOM   1829 HG13 VAL H 112      13.114  12.338   8.625  1.00 23.95           H  
ATOM   1830 HG21 VAL H 112      12.478  10.008   6.815  1.00 33.46           H  
ATOM   1831 HG22 VAL H 112      12.025  11.615   6.290  1.00 33.46           H  
ATOM   1832 HG23 VAL H 112      12.989  10.587   5.237  1.00 33.46           H  
ATOM   1833  N   ALA H 113      12.849  14.203   5.467  1.00 29.46           N  
ATOM   1834  CA  ALA H 113      11.840  15.241   5.629  1.00 29.13           C  
ATOM   1835  C   ALA H 113      10.775  14.782   6.630  1.00 23.60           C  
ATOM   1836  O   ALA H 113      10.168  13.728   6.427  1.00 24.76           O  
ATOM   1837  CB  ALA H 113      11.212  15.549   4.261  1.00 34.41           C  
ATOM   1838  H   ALA H 113      12.777  13.635   4.636  1.00 29.46           H  
ATOM   1839  HA  ALA H 113      12.321  16.150   5.997  1.00 29.13           H  
ATOM   1840  HB1 ALA H 113      10.447  16.322   4.345  1.00 34.41           H  
ATOM   1841  HB2 ALA H 113      11.964  15.909   3.558  1.00 34.41           H  
ATOM   1842  HB3 ALA H 113      10.745  14.666   3.824  1.00 34.41           H  
ATOM   1843  N   PHE H 114      10.566  15.588   7.683  1.00 20.15           N  
ATOM   1844  CA  PHE H 114       9.509  15.355   8.664  1.00 16.80           C  
ATOM   1845  C   PHE H 114       8.132  15.650   8.043  1.00 18.14           C  
ATOM   1846  O   PHE H 114       8.004  16.540   7.200  1.00 22.30           O  
ATOM   1847  CB  PHE H 114       9.750  16.197   9.936  1.00 19.42           C  
ATOM   1848  CG  PHE H 114      11.058  15.988  10.693  1.00 18.72           C  
ATOM   1849  CD1 PHE H 114      11.811  14.796  10.585  1.00 18.08           C  
ATOM   1850  CD2 PHE H 114      11.454  16.949  11.648  1.00 20.94           C  
ATOM   1851  CE1 PHE H 114      12.958  14.623  11.345  1.00 20.34           C  
ATOM   1852  CE2 PHE H 114      12.603  16.756  12.403  1.00 23.60           C  
ATOM   1853  CZ  PHE H 114      13.360  15.604  12.242  1.00 21.31           C  
ATOM   1854  H   PHE H 114      11.111  16.430   7.797  1.00 20.15           H  
ATOM   1855  HA  PHE H 114       9.528  14.300   8.938  1.00 16.80           H  
ATOM   1856  HB3 PHE H 114       8.951  15.988  10.647  1.00 19.42           H  
ATOM   1857  HB2 PHE H 114       9.666  17.257   9.693  1.00 19.42           H  
ATOM   1858  HD1 PHE H 114      11.524  14.016   9.898  1.00 18.08           H  
ATOM   1859  HD2 PHE H 114      10.867  17.845  11.790  1.00 20.94           H  
ATOM   1860  HE1 PHE H 114      13.530  13.714  11.247  1.00 20.34           H  
ATOM   1861  HE2 PHE H 114      12.908  17.504  13.120  1.00 23.60           H  
ATOM   1862  HZ  PHE H 114      14.251  15.459  12.834  1.00 21.31           H  
ATOM   1863  N   SER H 115       7.139  14.867   8.470  1.00 15.20           N  
ATOM   1864  CA  SER H 115       5.762  14.893   7.986  1.00 15.24           C  
ATOM   1865  C   SER H 115       4.822  14.499   9.133  1.00 14.43           C  
ATOM   1866  O   SER H 115       5.285  14.301  10.256  1.00 15.31           O  
ATOM   1867  CB  SER H 115       5.643  13.971   6.747  1.00 14.46           C  
ATOM   1868  OG  SER H 115       5.727  12.596   7.081  1.00 14.74           O  
ATOM   1869  H   SER H 115       7.325  14.198   9.207  1.00 15.20           H  
ATOM   1870  HA  SER H 115       5.504  15.914   7.697  1.00 15.24           H  
ATOM   1871  HB3 SER H 115       6.415  14.207   6.013  1.00 14.46           H  
ATOM   1872  HB2 SER H 115       4.688  14.137   6.248  1.00 14.46           H  
ATOM   1873  HG  SER H 115       6.652  12.373   7.215  1.00 14.74           H  
ATOM   1874  N   ASP H 116       3.524  14.338   8.826  1.00 15.79           N  
ATOM   1875  CA  ASP H 116       2.526  13.789   9.755  1.00 14.56           C  
ATOM   1876  C   ASP H 116       2.836  12.366  10.259  1.00 13.71           C  
ATOM   1877  O   ASP H 116       2.337  11.980  11.315  1.00 15.14           O  
ATOM   1878  CB  ASP H 116       1.082  13.839   9.194  1.00 17.02           C  
ATOM   1879  CG  ASP H 116       0.493  15.235   8.927  1.00 19.65           C  
ATOM   1880  OD1 ASP H 116       1.019  16.233   9.467  1.00 21.59           O  
ATOM   1881  OD2 ASP H 116      -0.565  15.268   8.260  1.00 21.86           O1-
ATOM   1882  H   ASP H 116       3.197  14.540   7.893  1.00 15.79           H  
ATOM   1883  HA  ASP H 116       2.575  14.430  10.626  1.00 14.56           H  
ATOM   1884  HB3 ASP H 116       0.399  13.323   9.868  1.00 17.02           H  
ATOM   1885  HB2 ASP H 116       1.055  13.284   8.254  1.00 17.02           H  
ATOM   1886  N   TYR H 117       3.654  11.626   9.498  1.00 14.16           N  
ATOM   1887  CA  TYR H 117       3.989  10.224   9.726  1.00 14.42           C  
ATOM   1888  C   TYR H 117       5.449  10.047  10.169  1.00 13.57           C  
ATOM   1889  O   TYR H 117       5.789   8.957  10.618  1.00 14.19           O  
ATOM   1890  CB  TYR H 117       3.714   9.448   8.417  1.00 15.88           C  
ATOM   1891  CG  TYR H 117       2.390   9.823   7.769  1.00 16.76           C  
ATOM   1892  CD1 TYR H 117       1.175   9.450   8.380  1.00 19.21           C  
ATOM   1893  CD2 TYR H 117       2.373  10.630   6.610  1.00 20.09           C  
ATOM   1894  CE1 TYR H 117      -0.046   9.899   7.843  1.00 20.59           C  
ATOM   1895  CE2 TYR H 117       1.149  11.070   6.072  1.00 20.79           C  
ATOM   1896  CZ  TYR H 117      -0.062  10.709   6.694  1.00 20.41           C  
ATOM   1897  OH  TYR H 117      -1.251  11.149   6.192  1.00 23.96           O  
ATOM   1898  H   TYR H 117       4.023  12.029   8.647  1.00 14.16           H  
ATOM   1899  HA  TYR H 117       3.360   9.803  10.513  1.00 14.42           H  
ATOM   1900  HB3 TYR H 117       3.737   8.372   8.600  1.00 15.88           H  
ATOM   1901  HB2 TYR H 117       4.508   9.645   7.694  1.00 15.88           H  
ATOM   1902  HD1 TYR H 117       1.178   8.849   9.278  1.00 19.21           H  
ATOM   1903  HD2 TYR H 117       3.300  10.931   6.143  1.00 20.09           H  
ATOM   1904  HE1 TYR H 117      -0.977   9.640   8.319  1.00 20.59           H  
ATOM   1905  HE2 TYR H 117       1.147  11.694   5.191  1.00 20.79           H  
ATOM   1906  HH  TYR H 117      -1.149  11.730   5.435  1.00 23.96           H  
ATOM   1907  N   ILE H 118       6.283  11.093  10.028  1.00 13.83           N  
ATOM   1908  CA  ILE H 118       7.724  11.052  10.271  1.00 12.85           C  
ATOM   1909  C   ILE H 118       8.090  12.186  11.240  1.00 12.31           C  
ATOM   1910  O   ILE H 118       7.991  13.354  10.867  1.00 14.39           O  
ATOM   1911  CB  ILE H 118       8.534  11.203   8.945  1.00 13.94           C  
ATOM   1912  CG1 ILE H 118       8.188  10.047   7.976  1.00 17.23           C  
ATOM   1913  CG2 ILE H 118      10.059  11.278   9.183  1.00 16.02           C  
ATOM   1914  CD1 ILE H 118       8.882  10.101   6.612  1.00 17.44           C  
ATOM   1915  H   ILE H 118       5.917  11.975   9.698  1.00 13.83           H  
ATOM   1916  HA  ILE H 118       8.012  10.104  10.722  1.00 12.85           H  
ATOM   1917  HB  ILE H 118       8.235  12.132   8.459  1.00 13.94           H  
ATOM   1918 HG13 ILE H 118       7.115  10.015   7.791  1.00 17.23           H  
ATOM   1919 HG12 ILE H 118       8.429   9.101   8.455  1.00 17.23           H  
ATOM   1920 HG21 ILE H 118      10.613  11.360   8.249  1.00 16.02           H  
ATOM   1921 HG22 ILE H 118      10.344  12.141   9.780  1.00 16.02           H  
ATOM   1922 HG23 ILE H 118      10.413  10.395   9.709  1.00 16.02           H  
ATOM   1923 HD11 ILE H 118       8.326   9.506   5.887  1.00 17.44           H  
ATOM   1924 HD12 ILE H 118       8.946  11.121   6.232  1.00 17.44           H  
ATOM   1925 HD13 ILE H 118       9.890   9.691   6.665  1.00 17.44           H  
ATOM   1926  N   HIS H 119       8.499  11.827  12.466  1.00 13.24           N  
ATOM   1927  CA  HIS H 119       8.831  12.786  13.521  1.00 12.66           C  
ATOM   1928  C   HIS H 119       9.686  12.088  14.596  1.00 12.31           C  
ATOM   1929  O   HIS H 119       9.317  10.991  15.006  1.00 12.92           O  
ATOM   1930  CB  HIS H 119       7.523  13.331  14.138  1.00 13.84           C  
ATOM   1931  CG  HIS H 119       7.746  14.621  14.874  1.00 15.07           C  
ATOM   1932  ND1 HIS H 119       7.780  15.852  14.214  1.00 17.84           N  
ATOM   1933  CD2 HIS H 119       8.014  14.818  16.211  1.00 15.23           C  
ATOM   1934  CE1 HIS H 119       8.079  16.733  15.156  1.00 20.01           C  
ATOM   1935  NE2 HIS H 119       8.230  16.175  16.357  1.00 17.14           N  
ATOM   1936  H   HIS H 119       8.559  10.848  12.716  1.00 13.24           H  
ATOM   1937  HA  HIS H 119       9.377  13.599  13.041  1.00 12.66           H  
ATOM   1938  HB3 HIS H 119       7.072  12.611  14.819  1.00 13.84           H  
ATOM   1939  HB2 HIS H 119       6.774  13.524  13.369  1.00 13.84           H  
ATOM   1940  HD2 HIS H 119       8.088  14.125  17.036  1.00 15.23           H  
ATOM   1941  HE1 HIS H 119       8.196  17.790  14.968  1.00 20.01           H  
ATOM   1942  HE2 HIS H 119       8.461  16.661  17.216  1.00 17.14           H  
ATOM   1943  N   PRO H 120      10.800  12.712  15.046  1.00 11.29           N  
ATOM   1944  CA  PRO H 120      11.708  12.090  16.025  1.00 11.07           C  
ATOM   1945  C   PRO H 120      11.130  12.027  17.451  1.00  9.87           C  
ATOM   1946  O   PRO H 120      10.437  12.952  17.875  1.00 11.32           O  
ATOM   1947  CB  PRO H 120      12.960  12.979  15.961  1.00 12.27           C  
ATOM   1948  CG  PRO H 120      12.432  14.354  15.590  1.00 17.76           C  
ATOM   1949  CD  PRO H 120      11.291  14.027  14.634  1.00 16.99           C  
ATOM   1950  HA  PRO H 120      11.954  11.082  15.692  1.00 11.07           H  
ATOM   1951  HB3 PRO H 120      13.619  12.613  15.171  1.00 12.27           H  
ATOM   1952  HB2 PRO H 120      13.538  12.991  16.886  1.00 12.27           H  
ATOM   1953  HG3 PRO H 120      13.190  15.007  15.159  1.00 17.76           H  
ATOM   1954  HG2 PRO H 120      12.035  14.844  16.480  1.00 17.76           H  
ATOM   1955  HD2 PRO H 120      10.530  14.806  14.656  1.00 16.99           H  
ATOM   1956  HD3 PRO H 120      11.660  13.936  13.615  1.00 16.99           H  
ATOM   1957  N   VAL H 121      11.460  10.942  18.168  1.00 10.10           N  
ATOM   1958  CA  VAL H 121      11.233  10.794  19.608  1.00 10.12           C  
ATOM   1959  C   VAL H 121      12.342  11.534  20.378  1.00 10.83           C  
ATOM   1960  O   VAL H 121      13.443  11.677  19.846  1.00 13.18           O  
ATOM   1961  CB  VAL H 121      11.255   9.286  20.011  1.00 10.36           C  
ATOM   1962  CG1 VAL H 121      12.638   8.598  19.993  1.00 10.54           C  
ATOM   1963  CG2 VAL H 121      10.537   9.015  21.345  1.00 10.16           C  
ATOM   1964  H   VAL H 121      12.038  10.230  17.740  1.00 10.10           H  
ATOM   1965  HA  VAL H 121      10.266  11.226  19.868  1.00 10.12           H  
ATOM   1966  HB  VAL H 121      10.678   8.766  19.257  1.00 10.36           H  
ATOM   1967 HG11 VAL H 121      12.533   7.517  20.074  1.00 10.54           H  
ATOM   1968 HG12 VAL H 121      13.170   8.795  19.064  1.00 10.54           H  
ATOM   1969 HG13 VAL H 121      13.275   8.923  20.816  1.00 10.54           H  
ATOM   1970 HG21 VAL H 121      10.471   7.945  21.543  1.00 10.16           H  
ATOM   1971 HG22 VAL H 121      11.055   9.469  22.187  1.00 10.16           H  
ATOM   1972 HG23 VAL H 121       9.518   9.404  21.330  1.00 10.16           H  
ATOM   1973  N   CYS H 122      12.061  11.969  21.617  1.00 10.29           N  
ATOM   1974  CA  CYS H 122      13.099  12.478  22.517  1.00 10.06           C  
ATOM   1975  C   CYS H 122      13.909  11.321  23.121  1.00 10.57           C  
ATOM   1976  O   CYS H 122      13.390  10.212  23.256  1.00 11.65           O  
ATOM   1977  CB  CYS H 122      12.474  13.289  23.664  1.00 11.38           C  
ATOM   1978  SG  CYS H 122      11.498  14.749  23.242  1.00 14.61           S  
ATOM   1979  H   CYS H 122      11.143  11.829  22.018  1.00 10.29           H  
ATOM   1980  HA  CYS H 122      13.779  13.128  21.962  1.00 10.06           H  
ATOM   1981  HB3 CYS H 122      13.265  13.633  24.331  1.00 11.38           H  
ATOM   1982  HB2 CYS H 122      11.829  12.646  24.262  1.00 11.38           H  
ATOM   1983  N   LEU H 123      15.149  11.623  23.531  1.00 12.09           N  
ATOM   1984  CA  LEU H 123      15.934  10.758  24.408  1.00 12.31           C  
ATOM   1985  C   LEU H 123      15.993  11.421  25.797  1.00 12.73           C  
ATOM   1986  O   LEU H 123      16.156  12.642  25.868  1.00 14.61           O  
ATOM   1987  CB  LEU H 123      17.354  10.572  23.839  1.00 15.85           C  
ATOM   1988  CG  LEU H 123      17.439   9.767  22.523  1.00 19.01           C  
ATOM   1989  CD1 LEU H 123      18.903   9.637  22.061  1.00 30.55           C  
ATOM   1990  CD2 LEU H 123      16.711   8.407  22.560  1.00 21.38           C  
ATOM   1991  H   LEU H 123      15.519  12.550  23.376  1.00 12.09           H  
ATOM   1992  HA  LEU H 123      15.442   9.793  24.479  1.00 12.31           H  
ATOM   1993  HB3 LEU H 123      17.967  10.066  24.587  1.00 15.85           H  
ATOM   1994  HB2 LEU H 123      17.806  11.552  23.684  1.00 15.85           H  
ATOM   1995  HG  LEU H 123      16.930  10.350  21.764  1.00 19.01           H  
ATOM   1996 HD11 LEU H 123      19.018  10.009  21.044  1.00 30.55           H  
ATOM   1997 HD12 LEU H 123      19.585  10.208  22.691  1.00 30.55           H  
ATOM   1998 HD13 LEU H 123      19.252   8.604  22.071  1.00 30.55           H  
ATOM   1999 HD21 LEU H 123      17.311   7.595  22.153  1.00 21.38           H  
ATOM   2000 HD22 LEU H 123      16.430   8.113  23.568  1.00 21.38           H  
ATOM   2001 HD23 LEU H 123      15.795   8.446  21.969  1.00 21.38           H  
ATOM   2002  N   PRO H 124      15.812  10.622  26.872  1.00 14.43           N  
ATOM   2003  CA  PRO H 124      15.688  11.144  28.241  1.00 14.58           C  
ATOM   2004  C   PRO H 124      16.973  11.780  28.779  1.00 16.84           C  
ATOM   2005  O   PRO H 124      18.062  11.244  28.573  1.00 21.06           O  
ATOM   2006  CB  PRO H 124      15.300   9.906  29.062  1.00 18.13           C  
ATOM   2007  CG  PRO H 124      15.887   8.735  28.293  1.00 17.57           C  
ATOM   2008  CD  PRO H 124      15.682   9.165  26.854  1.00 14.49           C  
ATOM   2009  HA  PRO H 124      14.885  11.880  28.296  1.00 14.58           H  
ATOM   2010  HB3 PRO H 124      14.212   9.835  29.079  1.00 18.13           H  
ATOM   2011  HB2 PRO H 124      15.637   9.937  30.098  1.00 18.13           H  
ATOM   2012  HG3 PRO H 124      15.431   7.773  28.527  1.00 17.57           H  
ATOM   2013  HG2 PRO H 124      16.956   8.661  28.488  1.00 17.57           H  
ATOM   2014  HD2 PRO H 124      16.397   8.671  26.196  1.00 14.49           H  
ATOM   2015  HD3 PRO H 124      14.669   8.923  26.529  1.00 14.49           H  
ATOM   2016  N   ASP H 125      16.786  12.885  29.515  1.00 19.76           N  
ATOM   2017  CA  ASP H 125      17.751  13.393  30.490  1.00 28.13           C  
ATOM   2018  C   ASP H 125      17.622  12.587  31.802  1.00 22.61           C  
ATOM   2019  O   ASP H 125      16.732  11.741  31.929  1.00 19.94           O  
ATOM   2020  CB  ASP H 125      17.636  14.932  30.696  1.00 36.61           C  
ATOM   2021  CG  ASP H 125      16.227  15.527  30.891  1.00 43.25           C  
ATOM   2022  OD1 ASP H 125      15.372  14.861  31.515  1.00 48.99           O  
ATOM   2023  OD2 ASP H 125      16.058  16.707  30.514  1.00 58.19           O1-
ATOM   2024  H   ASP H 125      15.854  13.265  29.603  1.00 19.76           H  
ATOM   2025  HA  ASP H 125      18.755  13.203  30.107  1.00 28.13           H  
ATOM   2026  HB3 ASP H 125      18.087  15.413  29.826  1.00 36.61           H  
ATOM   2027  HB2 ASP H 125      18.246  15.250  31.543  1.00 36.61           H  
ATOM   2028  N   ARG H 126      18.525  12.858  32.754  1.00 24.28           N  
ATOM   2029  CA  ARG H 126      18.607  12.168  34.044  1.00 23.58           C  
ATOM   2030  C   ARG H 126      17.325  12.242  34.888  1.00 24.47           C  
ATOM   2031  O   ARG H 126      16.970  11.252  35.524  1.00 23.83           O  
ATOM   2032  CB  ARG H 126      19.821  12.722  34.812  1.00 26.71           C  
ATOM   2033  CG  ARG H 126      20.088  12.032  36.166  1.00 33.51           C  
ATOM   2034  CD  ARG H 126      21.360  12.525  36.876  1.00 46.49           C  
ATOM   2035  NE  ARG H 126      22.594  12.161  36.156  1.00 55.56           N  
ATOM   2036  CZ  ARG H 126      23.186  10.953  36.098  1.00 59.66           C  
ATOM   2037  NH1 ARG H 126      22.708   9.886  36.757  1.00 69.74           N  
ATOM   2038  NH2 ARG H 126      24.292  10.815  35.356  1.00 75.55           N1+
ATOM   2039  H   ARG H 126      19.208  13.585  32.597  1.00 24.28           H  
ATOM   2040  HA  ARG H 126      18.780  11.112  33.834  1.00 23.58           H  
ATOM   2041  HB3 ARG H 126      19.682  13.789  34.985  1.00 26.71           H  
ATOM   2042  HB2 ARG H 126      20.702  12.644  34.176  1.00 26.71           H  
ATOM   2043  HG3 ARG H 126      20.194  10.969  35.946  1.00 33.51           H  
ATOM   2044  HG2 ARG H 126      19.246  12.103  36.854  1.00 33.51           H  
ATOM   2045  HD3 ARG H 126      21.380  12.242  37.929  1.00 46.49           H  
ATOM   2046  HD2 ARG H 126      21.351  13.616  36.864  1.00 46.49           H  
ATOM   2047  HE  ARG H 126      23.001  12.911  35.616  1.00 55.56           H  
ATOM   2048 HH12 ARG H 126      23.180   8.995  36.711  1.00 69.74           H  
ATOM   2049 HH11 ARG H 126      21.881   9.981  37.329  1.00 69.74           H  
ATOM   2050 HH22 ARG H 126      24.764   9.924  35.302  1.00 75.55           H  
ATOM   2051 HH21 ARG H 126      24.675  11.606  34.858  1.00 75.55           H  
ATOM   2052  N   GLU H 127      16.671  13.410  34.871  1.00 23.54           N  
ATOM   2053  CA  GLU H 127      15.504  13.730  35.683  1.00 24.40           C  
ATOM   2054  C   GLU H 127      14.230  13.039  35.173  1.00 21.14           C  
ATOM   2055  O   GLU H 127      13.461  12.541  35.995  1.00 22.08           O  
ATOM   2056  CB  GLU H 127      15.343  15.264  35.784  1.00 29.33           C  
ATOM   2057  CG  GLU H 127      16.474  15.982  36.571  1.00 36.34           C  
ATOM   2058  CD  GLU H 127      17.852  16.072  35.886  1.00 42.25           C  
ATOM   2059  OE1 GLU H 127      17.893  16.246  34.647  1.00 39.14           O  
ATOM   2060  OE2 GLU H 127      18.858  15.950  36.620  1.00 45.20           O1-
ATOM   2061  H   GLU H 127      17.045  14.177  34.327  1.00 23.54           H  
ATOM   2062  HA  GLU H 127      15.685  13.352  36.691  1.00 24.40           H  
ATOM   2063  HB3 GLU H 127      14.394  15.490  36.273  1.00 29.33           H  
ATOM   2064  HB2 GLU H 127      15.252  15.694  34.785  1.00 29.33           H  
ATOM   2065  HG3 GLU H 127      16.580  15.509  37.549  1.00 36.34           H  
ATOM   2066  HG2 GLU H 127      16.157  17.006  36.773  1.00 36.34           H  
ATOM   2067  N   THR H 128      14.061  12.961  33.840  1.00 19.92           N  
ATOM   2068  CA  THR H 128      12.990  12.191  33.198  1.00 19.06           C  
ATOM   2069  C   THR H 128      13.175  10.674  33.397  1.00 20.24           C  
ATOM   2070  O   THR H 128      12.190   9.988  33.666  1.00 19.64           O  
ATOM   2071  CB  THR H 128      12.900  12.474  31.675  1.00 23.46           C  
ATOM   2072  OG1 THR H 128      12.637  13.847  31.473  1.00 24.79           O  
ATOM   2073  CG2 THR H 128      11.809  11.698  30.917  1.00 21.24           C  
ATOM   2074  H   THR H 128      14.732  13.401  33.223  1.00 19.92           H  
ATOM   2075  HA  THR H 128      12.043  12.480  33.660  1.00 19.06           H  
ATOM   2076  HB  THR H 128      13.864  12.260  31.209  1.00 23.46           H  
ATOM   2077  HG1 THR H 128      13.452  14.336  31.644  1.00 24.79           H  
ATOM   2078 HG21 THR H 128      11.774  12.014  29.877  1.00 21.24           H  
ATOM   2079 HG22 THR H 128      11.986  10.623  30.913  1.00 21.24           H  
ATOM   2080 HG23 THR H 128      10.829  11.884  31.353  1.00 21.24           H  
ATOM   2081  N   ALA H 129      14.430  10.194  33.314  1.00 19.91           N  
ATOM   2082  CA  ALA H 129      14.810   8.805  33.568  1.00 17.52           C  
ATOM   2083  C   ALA H 129      14.558   8.360  35.012  1.00 17.91           C  
ATOM   2084  O   ALA H 129      13.933   7.321  35.207  1.00 19.72           O  
ATOM   2085  CB  ALA H 129      16.268   8.577  33.147  1.00 19.97           C  
ATOM   2086  H   ALA H 129      15.187  10.827  33.089  1.00 19.91           H  
ATOM   2087  HA  ALA H 129      14.179   8.170  32.954  1.00 17.52           H  
ATOM   2088  HB1 ALA H 129      16.586   7.552  33.342  1.00 19.97           H  
ATOM   2089  HB2 ALA H 129      16.395   8.759  32.080  1.00 19.97           H  
ATOM   2090  HB3 ALA H 129      16.952   9.240  33.675  1.00 19.97           H  
ATOM   2091  N   ALA H 129A     14.991   9.173  35.989  1.00 18.57           N  
ATOM   2092  CA  ALA H 129A     14.780   8.940  37.418  1.00 20.78           C  
ATOM   2093  C   ALA H 129A     13.298   8.937  37.829  1.00 20.70           C  
ATOM   2094  O   ALA H 129A     12.925   8.155  38.702  1.00 26.38           O  
ATOM   2095  CB  ALA H 129A     15.560   9.992  38.219  1.00 20.93           C  
ATOM   2096  H   ALA H 129A     15.505  10.012  35.747  1.00 18.57           H  
ATOM   2097  HA  ALA H 129A     15.191   7.957  37.657  1.00 20.78           H  
ATOM   2098  HB1 ALA H 129A     15.429   9.852  39.292  1.00 20.93           H  
ATOM   2099  HB2 ALA H 129A     16.628   9.928  38.010  1.00 20.93           H  
ATOM   2100  HB3 ALA H 129A     15.234  11.005  37.973  1.00 20.93           H  
ATOM   2101  N   SER H 129B     12.485   9.790  37.182  1.00 18.88           N  
ATOM   2102  CA  SER H 129B     11.058   9.907  37.460  1.00 20.26           C  
ATOM   2103  C   SER H 129B     10.221   8.779  36.831  1.00 20.19           C  
ATOM   2104  O   SER H 129B      9.276   8.335  37.479  1.00 26.39           O  
ATOM   2105  CB  SER H 129B     10.561  11.295  37.019  1.00 22.83           C  
ATOM   2106  OG  SER H 129B      9.226  11.494  37.434  1.00 36.73           O  
ATOM   2107  H   SER H 129B     12.864  10.414  36.482  1.00 18.88           H  
ATOM   2108  HA  SER H 129B     10.925   9.848  38.543  1.00 20.26           H  
ATOM   2109  HB3 SER H 129B     10.626  11.412  35.935  1.00 22.83           H  
ATOM   2110  HB2 SER H 129B     11.173  12.080  37.464  1.00 22.83           H  
ATOM   2111  HG  SER H 129B      8.667  10.849  36.993  1.00 36.73           H  
ATOM   2112  N   LEU H 129C     10.546   8.359  35.595  1.00 15.19           N  
ATOM   2113  CA  LEU H 129C      9.711   7.429  34.828  1.00 15.53           C  
ATOM   2114  C   LEU H 129C     10.133   5.956  34.945  1.00 14.48           C  
ATOM   2115  O   LEU H 129C      9.254   5.104  34.836  1.00 15.25           O  
ATOM   2116  CB  LEU H 129C      9.635   7.864  33.346  1.00 16.07           C  
ATOM   2117  CG  LEU H 129C      8.860   9.178  33.088  1.00 23.20           C  
ATOM   2118  CD1 LEU H 129C      8.874   9.531  31.588  1.00 26.27           C  
ATOM   2119  CD2 LEU H 129C      7.417   9.153  33.635  1.00 32.51           C  
ATOM   2120  H   LEU H 129C     11.333   8.769  35.109  1.00 15.19           H  
ATOM   2121  HA  LEU H 129C      8.700   7.465  35.228  1.00 15.53           H  
ATOM   2122  HB3 LEU H 129C      9.146   7.080  32.769  1.00 16.07           H  
ATOM   2123  HB2 LEU H 129C     10.645   7.937  32.939  1.00 16.07           H  
ATOM   2124  HG  LEU H 129C      9.392   9.978  33.605  1.00 23.20           H  
ATOM   2125 HD11 LEU H 129C      8.947  10.608  31.444  1.00 26.27           H  
ATOM   2126 HD12 LEU H 129C      9.716   9.074  31.067  1.00 26.27           H  
ATOM   2127 HD13 LEU H 129C      7.968   9.198  31.079  1.00 26.27           H  
ATOM   2128 HD21 LEU H 129C      6.708   9.603  32.940  1.00 32.51           H  
ATOM   2129 HD22 LEU H 129C      7.064   8.138  33.819  1.00 32.51           H  
ATOM   2130 HD23 LEU H 129C      7.344   9.705  34.572  1.00 32.51           H  
ATOM   2131  N   LEU H 130      11.424   5.652  35.175  1.00 15.87           N  
ATOM   2132  CA  LEU H 130      11.916   4.271  35.285  1.00 17.43           C  
ATOM   2133  C   LEU H 130      11.712   3.721  36.706  1.00 19.11           C  
ATOM   2134  O   LEU H 130      12.677   3.492  37.435  1.00 24.92           O  
ATOM   2135  CB  LEU H 130      13.381   4.169  34.803  1.00 20.62           C  
ATOM   2136  CG  LEU H 130      13.560   4.459  33.295  1.00 23.29           C  
ATOM   2137  CD1 LEU H 130      15.038   4.720  32.947  1.00 32.86           C  
ATOM   2138  CD2 LEU H 130      12.939   3.352  32.413  1.00 29.51           C  
ATOM   2139  H   LEU H 130      12.114   6.386  35.273  1.00 15.87           H  
ATOM   2140  HA  LEU H 130      11.323   3.638  34.627  1.00 17.43           H  
ATOM   2141  HB3 LEU H 130      13.773   3.172  35.008  1.00 20.62           H  
ATOM   2142  HB2 LEU H 130      13.995   4.844  35.399  1.00 20.62           H  
ATOM   2143  HG  LEU H 130      13.032   5.386  33.071  1.00 23.29           H  
ATOM   2144 HD11 LEU H 130      15.160   5.703  32.493  1.00 32.86           H  
ATOM   2145 HD12 LEU H 130      15.673   4.701  33.832  1.00 32.86           H  
ATOM   2146 HD13 LEU H 130      15.442   3.990  32.247  1.00 32.86           H  
ATOM   2147 HD21 LEU H 130      13.584   3.052  31.588  1.00 29.51           H  
ATOM   2148 HD22 LEU H 130      12.728   2.448  32.983  1.00 29.51           H  
ATOM   2149 HD23 LEU H 130      11.999   3.690  31.975  1.00 29.51           H  
ATOM   2150  N   GLN H 131      10.434   3.520  37.053  1.00 17.58           N  
ATOM   2151  CA  GLN H 131       9.968   2.929  38.300  1.00 20.06           C  
ATOM   2152  C   GLN H 131       9.136   1.690  37.966  1.00 18.67           C  
ATOM   2153  O   GLN H 131       8.496   1.646  36.914  1.00 17.86           O  
ATOM   2154  CB  GLN H 131       9.103   3.954  39.060  1.00 21.50           C  
ATOM   2155  CG  GLN H 131       9.859   5.243  39.436  1.00 30.60           C  
ATOM   2156  CD  GLN H 131       9.098   6.082  40.465  1.00 37.25           C  
ATOM   2157  OE1 GLN H 131       8.705   5.578  41.514  1.00 34.46           O  
ATOM   2158  NE2 GLN H 131       8.913   7.372  40.190  1.00 44.96           N  
ATOM   2159  H   GLN H 131       9.709   3.747  36.385  1.00 17.58           H  
ATOM   2160  HA  GLN H 131      10.809   2.627  38.928  1.00 20.06           H  
ATOM   2161  HB3 GLN H 131       8.719   3.475  39.962  1.00 21.50           H  
ATOM   2162  HB2 GLN H 131       8.228   4.219  38.465  1.00 21.50           H  
ATOM   2163  HG3 GLN H 131      10.067   5.835  38.544  1.00 30.60           H  
ATOM   2164  HG2 GLN H 131      10.826   4.989  39.872  1.00 30.60           H  
ATOM   2165 HE22 GLN H 131       8.416   7.962  40.840  1.00 44.96           H  
ATOM   2166 HE21 GLN H 131       9.218   7.758  39.305  1.00 44.96           H  
ATOM   2167  N   ALA H 132       9.126   0.713  38.885  1.00 19.83           N  
ATOM   2168  CA  ALA H 132       8.301  -0.485  38.762  1.00 19.48           C  
ATOM   2169  C   ALA H 132       6.800  -0.153  38.838  1.00 17.46           C  
ATOM   2170  O   ALA H 132       6.386   0.636  39.687  1.00 21.67           O  
ATOM   2171  CB  ALA H 132       8.707  -1.491  39.838  1.00 22.27           C  
ATOM   2172  H   ALA H 132       9.656   0.813  39.739  1.00 19.83           H  
ATOM   2173  HA  ALA H 132       8.522  -0.929  37.792  1.00 19.48           H  
ATOM   2174  HB1 ALA H 132       8.159  -2.423  39.706  1.00 22.27           H  
ATOM   2175  HB2 ALA H 132       9.770  -1.727  39.774  1.00 22.27           H  
ATOM   2176  HB3 ALA H 132       8.504  -1.118  40.843  1.00 22.27           H  
ATOM   2177  N   GLY H 133       6.030  -0.755  37.922  1.00 18.46           N  
ATOM   2178  CA  GLY H 133       4.595  -0.548  37.756  1.00 18.23           C  
ATOM   2179  C   GLY H 133       4.284   0.542  36.717  1.00 16.52           C  
ATOM   2180  O   GLY H 133       3.181   0.524  36.172  1.00 18.36           O  
ATOM   2181  H   GLY H 133       6.468  -1.395  37.269  1.00 18.46           H  
ATOM   2182  HA3 GLY H 133       4.119  -0.292  38.703  1.00 18.23           H  
ATOM   2183  HA2 GLY H 133       4.153  -1.489  37.426  1.00 18.23           H  
ATOM   2184  N   TYR H 134       5.226   1.459  36.413  1.00 15.83           N  
ATOM   2185  CA  TYR H 134       5.063   2.488  35.380  1.00 13.53           C  
ATOM   2186  C   TYR H 134       5.158   1.844  33.989  1.00 14.66           C  
ATOM   2187  O   TYR H 134       6.122   1.132  33.714  1.00 14.63           O  
ATOM   2188  CB  TYR H 134       6.137   3.588  35.505  1.00 12.43           C  
ATOM   2189  CG  TYR H 134       6.003   4.641  36.596  1.00 13.70           C  
ATOM   2190  CD1 TYR H 134       5.449   4.367  37.867  1.00 17.14           C  
ATOM   2191  CD2 TYR H 134       6.455   5.946  36.311  1.00 17.24           C  
ATOM   2192  CE1 TYR H 134       5.343   5.392  38.829  1.00 18.22           C  
ATOM   2193  CE2 TYR H 134       6.348   6.969  37.266  1.00 19.44           C  
ATOM   2194  CZ  TYR H 134       5.793   6.694  38.526  1.00 20.88           C  
ATOM   2195  OH  TYR H 134       5.688   7.701  39.437  1.00 28.49           O  
ATOM   2196  H   TYR H 134       6.125   1.425  36.873  1.00 15.83           H  
ATOM   2197  HA  TYR H 134       4.082   2.952  35.501  1.00 13.53           H  
ATOM   2198  HB3 TYR H 134       6.097   4.159  34.579  1.00 12.43           H  
ATOM   2199  HB2 TYR H 134       7.138   3.165  35.530  1.00 12.43           H  
ATOM   2200  HD1 TYR H 134       5.097   3.380  38.121  1.00 17.14           H  
ATOM   2201  HD2 TYR H 134       6.867   6.172  35.340  1.00 17.24           H  
ATOM   2202  HE1 TYR H 134       4.913   5.178  39.796  1.00 18.22           H  
ATOM   2203  HE2 TYR H 134       6.684   7.967  37.025  1.00 19.44           H  
ATOM   2204  HH  TYR H 134       5.141   7.485  40.199  1.00 28.49           H  
ATOM   2205  N   LYS H 135       4.152   2.111  33.148  1.00 13.48           N  
ATOM   2206  CA  LYS H 135       4.005   1.508  31.830  1.00 11.45           C  
ATOM   2207  C   LYS H 135       4.642   2.368  30.743  1.00 10.83           C  
ATOM   2208  O   LYS H 135       4.392   3.571  30.681  1.00 13.16           O  
ATOM   2209  CB  LYS H 135       2.512   1.272  31.532  1.00 12.41           C  
ATOM   2210  CG  LYS H 135       1.866   0.239  32.458  1.00 14.75           C  
ATOM   2211  CD  LYS H 135       0.365   0.078  32.217  1.00 15.85           C  
ATOM   2212  CE  LYS H 135      -0.232  -0.960  33.175  1.00 17.60           C  
ATOM   2213  NZ  LYS H 135      -1.686  -1.087  33.005  1.00 19.73           N1+
ATOM   2214  H   LYS H 135       3.395   2.716  33.445  1.00 13.48           H  
ATOM   2215  HA  LYS H 135       4.506   0.547  31.819  1.00 11.45           H  
ATOM   2216  HB3 LYS H 135       2.397   0.921  30.505  1.00 12.41           H  
ATOM   2217  HB2 LYS H 135       1.967   2.212  31.604  1.00 12.41           H  
ATOM   2218  HG3 LYS H 135       2.038   0.506  33.501  1.00 14.75           H  
ATOM   2219  HG2 LYS H 135       2.344  -0.724  32.304  1.00 14.75           H  
ATOM   2220  HD3 LYS H 135       0.194  -0.224  31.182  1.00 15.85           H  
ATOM   2221  HD2 LYS H 135      -0.128   1.043  32.347  1.00 15.85           H  
ATOM   2222  HE3 LYS H 135      -0.031  -0.679  34.210  1.00 17.60           H  
ATOM   2223  HE2 LYS H 135       0.231  -1.934  33.012  1.00 17.60           H  
ATOM   2224  HZ1 LYS H 135      -1.888  -1.343  32.046  1.00 19.73           H  
ATOM   2225  HZ2 LYS H 135      -2.034  -1.798  33.632  1.00 19.73           H  
ATOM   2226  HZ3 LYS H 135      -2.125  -0.200  33.218  1.00 19.73           H  
ATOM   2227  N   GLY H 136       5.402   1.699  29.870  1.00 11.52           N  
ATOM   2228  CA  GLY H 136       5.807   2.233  28.580  1.00  9.83           C  
ATOM   2229  C   GLY H 136       5.138   1.402  27.489  1.00 10.50           C  
ATOM   2230  O   GLY H 136       4.354   0.494  27.760  1.00 13.46           O  
ATOM   2231  H   GLY H 136       5.540   0.706  30.004  1.00 11.52           H  
ATOM   2232  HA3 GLY H 136       6.887   2.195  28.471  1.00  9.83           H  
ATOM   2233  HA2 GLY H 136       5.500   3.272  28.449  1.00  9.83           H  
ATOM   2234  N   ARG H 137       5.451   1.759  26.243  1.00  9.93           N  
ATOM   2235  CA  ARG H 137       4.842   1.239  25.034  1.00 10.41           C  
ATOM   2236  C   ARG H 137       5.923   0.708  24.100  1.00  9.90           C  
ATOM   2237  O   ARG H 137       6.880   1.424  23.822  1.00 10.12           O  
ATOM   2238  CB  ARG H 137       4.067   2.384  24.374  1.00 11.10           C  
ATOM   2239  CG  ARG H 137       3.479   2.032  22.994  1.00 11.36           C  
ATOM   2240  CD  ARG H 137       2.734   3.207  22.367  1.00 11.19           C  
ATOM   2241  NE  ARG H 137       1.507   3.501  23.110  1.00 11.19           N  
ATOM   2242  CZ  ARG H 137       0.745   4.593  22.997  1.00 10.84           C  
ATOM   2243  NH1 ARG H 137       0.994   5.554  22.096  1.00 11.10           N  
ATOM   2244  NH2 ARG H 137      -0.289   4.713  23.826  1.00 11.74           N1+
ATOM   2245  H   ARG H 137       6.104   2.522  26.106  1.00  9.93           H  
ATOM   2246  HA  ARG H 137       4.145   0.438  25.268  1.00 10.41           H  
ATOM   2247  HB3 ARG H 137       4.724   3.245  24.261  1.00 11.10           H  
ATOM   2248  HB2 ARG H 137       3.279   2.705  25.056  1.00 11.10           H  
ATOM   2249  HG3 ARG H 137       2.784   1.206  23.160  1.00 11.36           H  
ATOM   2250  HG2 ARG H 137       4.213   1.659  22.283  1.00 11.36           H  
ATOM   2251  HD3 ARG H 137       2.578   3.084  21.295  1.00 11.19           H  
ATOM   2252  HD2 ARG H 137       3.358   4.091  22.493  1.00 11.19           H  
ATOM   2253  HE  ARG H 137       1.249   2.811  23.805  1.00 11.19           H  
ATOM   2254 HH12 ARG H 137       0.382   6.360  22.040  1.00 11.10           H  
ATOM   2255 HH11 ARG H 137       1.815   5.502  21.506  1.00 11.10           H  
ATOM   2256 HH22 ARG H 137      -0.947   5.475  23.702  1.00 11.74           H  
ATOM   2257 HH21 ARG H 137      -0.495   3.991  24.502  1.00 11.74           H  
ATOM   2258  N   VAL H 138       5.696  -0.501  23.576  1.00 10.96           N  
ATOM   2259  CA  VAL H 138       6.569  -1.164  22.616  1.00 11.02           C  
ATOM   2260  C   VAL H 138       5.791  -1.359  21.310  1.00 11.19           C  
ATOM   2261  O   VAL H 138       4.604  -1.685  21.356  1.00 12.45           O  
ATOM   2262  CB  VAL H 138       6.999  -2.559  23.133  1.00 11.94           C  
ATOM   2263  CG1 VAL H 138       8.007  -3.262  22.203  1.00 14.52           C  
ATOM   2264  CG2 VAL H 138       7.617  -2.450  24.531  1.00 15.15           C  
ATOM   2265  H   VAL H 138       4.852  -1.003  23.826  1.00 10.96           H  
ATOM   2266  HA  VAL H 138       7.458  -0.568  22.417  1.00 11.02           H  
ATOM   2267  HB  VAL H 138       6.117  -3.197  23.218  1.00 11.94           H  
ATOM   2268 HG11 VAL H 138       8.330  -4.210  22.630  1.00 14.52           H  
ATOM   2269 HG12 VAL H 138       7.593  -3.480  21.221  1.00 14.52           H  
ATOM   2270 HG13 VAL H 138       8.893  -2.646  22.054  1.00 14.52           H  
ATOM   2271 HG21 VAL H 138       7.876  -3.432  24.910  1.00 15.15           H  
ATOM   2272 HG22 VAL H 138       8.521  -1.843  24.490  1.00 15.15           H  
ATOM   2273 HG23 VAL H 138       6.938  -2.011  25.262  1.00 15.15           H  
ATOM   2274  N   THR H 139       6.478  -1.147  20.178  1.00 12.23           N  
ATOM   2275  CA  THR H 139       5.889  -1.206  18.842  1.00 10.97           C  
ATOM   2276  C   THR H 139       6.845  -1.888  17.847  1.00 11.45           C  
ATOM   2277  O   THR H 139       8.060  -1.741  17.982  1.00 12.98           O  
ATOM   2278  CB  THR H 139       5.570   0.226  18.320  1.00 11.82           C  
ATOM   2279  OG1 THR H 139       6.711   1.063  18.343  1.00 13.86           O  
ATOM   2280  CG2 THR H 139       4.490   0.949  19.129  1.00 13.58           C  
ATOM   2281  H   THR H 139       7.453  -0.887  20.218  1.00 12.23           H  
ATOM   2282  HA  THR H 139       4.988  -1.809  18.895  1.00 10.97           H  
ATOM   2283  HB  THR H 139       5.224   0.161  17.288  1.00 11.82           H  
ATOM   2284  HG1 THR H 139       7.340   0.760  17.681  1.00 13.86           H  
ATOM   2285 HG21 THR H 139       4.176   1.873  18.643  1.00 13.58           H  
ATOM   2286 HG22 THR H 139       3.619   0.314  19.243  1.00 13.58           H  
ATOM   2287 HG23 THR H 139       4.829   1.198  20.131  1.00 13.58           H  
ATOM   2288  N   GLY H 140       6.273  -2.600  16.854  1.00 13.36           N  
ATOM   2289  CA  GLY H 140       7.041  -3.246  15.788  1.00 14.36           C  
ATOM   2290  C   GLY H 140       6.167  -4.088  14.841  1.00 13.17           C  
ATOM   2291  O   GLY H 140       4.941  -4.114  14.961  1.00 15.55           O  
ATOM   2292  H   GLY H 140       5.266  -2.689  16.810  1.00 13.36           H  
ATOM   2293  HA3 GLY H 140       7.795  -3.893  16.229  1.00 14.36           H  
ATOM   2294  HA2 GLY H 140       7.559  -2.487  15.201  1.00 14.36           H  
ATOM   2295  N   TRP H 141       6.841  -4.760  13.886  1.00 14.62           N  
ATOM   2296  CA  TRP H 141       6.277  -5.592  12.809  1.00 14.66           C  
ATOM   2297  C   TRP H 141       6.773  -7.054  12.808  1.00 14.77           C  
ATOM   2298  O   TRP H 141       6.557  -7.741  11.809  1.00 19.36           O  
ATOM   2299  CB  TRP H 141       6.623  -4.980  11.436  1.00 17.11           C  
ATOM   2300  CG  TRP H 141       6.072  -3.640  11.107  1.00 17.15           C  
ATOM   2301  CD1 TRP H 141       4.814  -3.389  10.686  1.00 17.16           C  
ATOM   2302  CD2 TRP H 141       6.746  -2.354  11.164  1.00 19.32           C  
ATOM   2303  NE1 TRP H 141       4.689  -2.049  10.400  1.00 19.08           N  
ATOM   2304  CE2 TRP H 141       5.844  -1.358  10.689  1.00 19.63           C  
ATOM   2305  CE3 TRP H 141       8.036  -1.930  11.554  1.00 18.25           C  
ATOM   2306  CZ2 TRP H 141       6.200  -0.005  10.606  1.00 19.74           C  
ATOM   2307  CZ3 TRP H 141       8.401  -0.573  11.485  1.00 20.02           C  
ATOM   2308  CH2 TRP H 141       7.488   0.386  11.006  1.00 21.29           C  
ATOM   2309  H   TRP H 141       7.850  -4.671  13.866  1.00 14.62           H  
ATOM   2310  HA  TRP H 141       5.191  -5.636  12.905  1.00 14.66           H  
ATOM   2311  HB3 TRP H 141       6.283  -5.624  10.627  1.00 17.11           H  
ATOM   2312  HB2 TRP H 141       7.707  -4.921  11.329  1.00 17.11           H  
ATOM   2313  HD1 TRP H 141       4.043  -4.136  10.576  1.00 17.16           H  
ATOM   2314  HE1 TRP H 141       3.830  -1.638  10.050  1.00 19.08           H  
ATOM   2315  HE3 TRP H 141       8.751  -2.655  11.912  1.00 18.25           H  
ATOM   2316  HZ2 TRP H 141       5.488   0.724  10.254  1.00 19.74           H  
ATOM   2317  HZ3 TRP H 141       9.389  -0.271  11.797  1.00 20.02           H  
ATOM   2318  HH2 TRP H 141       7.768   1.425  10.968  1.00 21.29           H  
ATOM   2319  N   GLY H 142       7.425  -7.516  13.885  1.00 16.26           N  
ATOM   2320  CA  GLY H 142       7.868  -8.898  14.120  1.00 19.60           C  
ATOM   2321  C   GLY H 142       6.742  -9.960  14.119  1.00 18.55           C  
ATOM   2322  O   GLY H 142       5.785  -9.880  13.355  1.00 20.31           O  
ATOM   2323  H   GLY H 142       7.553  -6.887  14.669  1.00 16.26           H  
ATOM   2324  HA3 GLY H 142       8.365  -8.900  15.089  1.00 19.60           H  
ATOM   2325  HA2 GLY H 142       8.604  -9.175  13.367  1.00 19.60           H  
ATOM   2326  N   ASN H 143       6.864 -10.997  14.961  1.00 19.76           N  
ATOM   2327  CA  ASN H 143       5.882 -12.088  15.025  1.00 22.70           C  
ATOM   2328  C   ASN H 143       4.778 -11.779  16.049  1.00 22.30           C  
ATOM   2329  O   ASN H 143       5.067 -11.275  17.134  1.00 20.52           O  
ATOM   2330  CB  ASN H 143       6.577 -13.416  15.382  1.00 28.78           C  
ATOM   2331  CG  ASN H 143       7.604 -13.915  14.361  1.00 35.20           C  
ATOM   2332  OD1 ASN H 143       7.688 -13.423  13.237  1.00 40.61           O  
ATOM   2333  ND2 ASN H 143       8.383 -14.922  14.756  1.00 42.89           N  
ATOM   2334  H   ASN H 143       7.676 -11.070  15.558  1.00 19.76           H  
ATOM   2335  HA  ASN H 143       5.413 -12.221  14.047  1.00 22.70           H  
ATOM   2336  HB3 ASN H 143       5.820 -14.195  15.454  1.00 28.78           H  
ATOM   2337  HB2 ASN H 143       7.055 -13.339  16.358  1.00 28.78           H  
ATOM   2338 HD22 ASN H 143       9.116 -15.270  14.151  1.00 42.89           H  
ATOM   2339 HD21 ASN H 143       8.286 -15.310  15.683  1.00 42.89           H  
ATOM   2340  N   LEU H 144       3.537 -12.150  15.691  1.00 24.92           N  
ATOM   2341  CA  LEU H 144       2.352 -12.079  16.553  1.00 24.57           C  
ATOM   2342  C   LEU H 144       2.355 -13.127  17.683  1.00 27.49           C  
ATOM   2343  O   LEU H 144       1.593 -12.972  18.632  1.00 29.82           O  
ATOM   2344  CB  LEU H 144       1.082 -12.273  15.691  1.00 26.11           C  
ATOM   2345  CG  LEU H 144       0.775 -11.123  14.712  1.00 24.47           C  
ATOM   2346  CD1 LEU H 144      -0.296 -11.540  13.696  1.00 23.97           C  
ATOM   2347  CD2 LEU H 144       0.350  -9.837  15.441  1.00 23.95           C  
ATOM   2348  H   LEU H 144       3.392 -12.568  14.781  1.00 24.92           H  
ATOM   2349  HA  LEU H 144       2.330 -11.096  17.026  1.00 24.57           H  
ATOM   2350  HB3 LEU H 144       0.209 -12.408  16.333  1.00 26.11           H  
ATOM   2351  HB2 LEU H 144       1.178 -13.207  15.135  1.00 26.11           H  
ATOM   2352  HG  LEU H 144       1.680 -10.909  14.146  1.00 24.47           H  
ATOM   2353 HD11 LEU H 144      -0.540 -10.721  13.020  1.00 23.97           H  
ATOM   2354 HD12 LEU H 144       0.038 -12.379  13.087  1.00 23.97           H  
ATOM   2355 HD13 LEU H 144      -1.213 -11.834  14.203  1.00 23.97           H  
ATOM   2356 HD21 LEU H 144       1.007  -9.020  15.165  1.00 23.95           H  
ATOM   2357 HD22 LEU H 144      -0.664  -9.529  15.186  1.00 23.95           H  
ATOM   2358 HD23 LEU H 144       0.388  -9.940  16.526  1.00 23.95           H  
ATOM   2359  N   LYS H 145       3.180 -14.175  17.556  1.00 29.50           N  
ATOM   2360  CA  LYS H 145       3.314 -15.286  18.494  1.00 29.95           C  
ATOM   2361  C   LYS H 145       4.737 -15.843  18.396  1.00 29.35           C  
ATOM   2362  O   LYS H 145       5.340 -15.803  17.322  1.00 29.30           O  
ATOM   2363  CB  LYS H 145       2.276 -16.383  18.149  1.00 39.26           C  
ATOM   2364  CG  LYS H 145       0.927 -16.268  18.884  1.00 44.38           C  
ATOM   2365  CD  LYS H 145      -0.162 -17.091  18.187  1.00 50.24           C  
ATOM   2366  CE  LYS H 145      -1.470 -17.241  18.968  1.00 52.12           C  
ATOM   2367  NZ  LYS H 145      -2.464 -18.008  18.192  1.00 56.96           N1+
ATOM   2368  H   LYS H 145       3.786 -14.224  16.749  1.00 29.50           H  
ATOM   2369  HA  LYS H 145       3.156 -14.928  19.514  1.00 29.95           H  
ATOM   2370  HB3 LYS H 145       2.673 -17.369  18.399  1.00 39.26           H  
ATOM   2371  HB2 LYS H 145       2.131 -16.408  17.068  1.00 39.26           H  
ATOM   2372  HG3 LYS H 145       0.598 -15.233  18.942  1.00 44.38           H  
ATOM   2373  HG2 LYS H 145       1.049 -16.605  19.914  1.00 44.38           H  
ATOM   2374  HD3 LYS H 145       0.232 -18.068  17.898  1.00 50.24           H  
ATOM   2375  HD2 LYS H 145      -0.407 -16.562  17.277  1.00 50.24           H  
ATOM   2376  HE3 LYS H 145      -1.885 -16.262  19.209  1.00 52.12           H  
ATOM   2377  HE2 LYS H 145      -1.286 -17.757  19.911  1.00 52.12           H  
ATOM   2378  HZ1 LYS H 145      -2.669 -17.525  17.329  1.00 56.96           H  
ATOM   2379  HZ2 LYS H 145      -2.094 -18.925  17.980  1.00 56.96           H  
ATOM   2380  HZ3 LYS H 145      -3.311 -18.105  18.734  1.00 56.96           H  
ATOM   2381  N   GLU H 146       5.214 -16.440  19.501  1.00 27.73           N  
ATOM   2382  CA  GLU H 146       6.385 -17.318  19.499  1.00 34.18           C  
ATOM   2383  C   GLU H 146       6.108 -18.554  18.627  1.00 45.16           C  
ATOM   2384  O   GLU H 146       5.030 -19.131  18.770  1.00 56.71           O  
ATOM   2385  CB  GLU H 146       6.685 -17.747  20.948  1.00 37.36           C  
ATOM   2386  CG  GLU H 146       7.926 -18.655  21.085  1.00 35.77           C  
ATOM   2387  CD  GLU H 146       8.158 -19.228  22.486  1.00 37.54           C  
ATOM   2388  OE1 GLU H 146       7.549 -18.740  23.466  1.00 29.45           O  
ATOM   2389  OE2 GLU H 146       8.979 -20.166  22.556  1.00 41.16           O1-
ATOM   2390  H   GLU H 146       4.666 -16.436  20.349  1.00 27.73           H  
ATOM   2391  HA  GLU H 146       7.239 -16.767  19.101  1.00 34.18           H  
ATOM   2392  HB3 GLU H 146       5.811 -18.256  21.360  1.00 37.36           H  
ATOM   2393  HB2 GLU H 146       6.830 -16.867  21.567  1.00 37.36           H  
ATOM   2394  HG3 GLU H 146       8.815 -18.096  20.791  1.00 35.77           H  
ATOM   2395  HG2 GLU H 146       7.859 -19.505  20.406  1.00 35.77           H  
ATOM   2396  N   THR H 147       7.074 -18.942  17.775  1.00 57.28           N  
ATOM   2397  CA  THR H 147       6.970 -20.143  16.942  1.00 65.30           C  
ATOM   2398  C   THR H 147       8.241 -21.024  17.106  1.00 67.76           C  
ATOM   2399  O   THR H 147       8.286 -21.691  18.138  1.00 69.18           O  
ATOM   2400  CB  THR H 147       6.428 -19.873  15.507  1.00 71.40           C  
ATOM   2401  OG1 THR H 147       5.331 -18.979  15.560  1.00 74.77           O  
ATOM   2402  CG2 THR H 147       5.895 -21.124  14.788  1.00 78.51           C  
ATOM   2403  H   THR H 147       7.943 -18.430  17.725  1.00 57.28           H  
ATOM   2404  HA  THR H 147       6.213 -20.784  17.389  1.00 65.30           H  
ATOM   2405  HB  THR H 147       7.171 -19.373  14.895  1.00 71.40           H  
ATOM   2406  HG1 THR H 147       5.622 -18.160  15.972  1.00 74.77           H  
ATOM   2407 HG21 THR H 147       5.982 -21.019  13.707  1.00 78.51           H  
ATOM   2408 HG22 THR H 147       6.424 -22.022  15.095  1.00 78.51           H  
ATOM   2409 HG23 THR H 147       4.842 -21.301  14.992  1.00 78.51           H  
ATOM   2410  N   TRP H 148       9.301 -21.080  16.271  1.00  5.42           N  
ATOM   2411  CA  TRP H 148       9.613 -20.507  14.959  1.00  5.32           C  
ATOM   2412  C   TRP H 148       8.968 -21.290  13.795  1.00  4.74           C  
ATOM   2413  O   TRP H 148       8.620 -20.676  12.787  1.00  6.39           O  
ATOM   2414  CB  TRP H 148      11.155 -20.467  14.828  1.00  0.00           C  
ATOM   2415  CG  TRP H 148      11.731 -20.133  13.481  1.00  0.00           C  
ATOM   2416  CD1 TRP H 148      11.736 -18.908  12.910  1.00  0.00           C  
ATOM   2417  CD2 TRP H 148      12.323 -21.035  12.495  1.00  0.00           C  
ATOM   2418  NE1 TRP H 148      12.290 -18.985  11.650  1.00  0.00           N  
ATOM   2419  CE2 TRP H 148      12.662 -20.276  11.334  1.00  0.00           C  
ATOM   2420  CE3 TRP H 148      12.599 -22.423  12.458  1.00  0.00           C  
ATOM   2421  CZ2 TRP H 148      13.236 -20.863  10.193  1.00  0.00           C  
ATOM   2422  CZ3 TRP H 148      13.171 -23.024  11.318  1.00  0.00           C  
ATOM   2423  CH2 TRP H 148      13.489 -22.247  10.186  1.00  0.00           C  
ATOM   2424  HB2 TRP H 148      11.561 -19.758  15.550  1.00  0.00           H  
ATOM   2425  HB3 TRP H 148      11.565 -21.439  15.107  1.00  0.00           H  
ATOM   2426  HD1 TRP H 148      11.346 -18.018  13.379  1.00  0.00           H  
ATOM   2427  HE1 TRP H 148      12.392 -18.176  11.054  1.00  0.00           H  
ATOM   2428  HE3 TRP H 148      12.352 -23.036  13.311  1.00  0.00           H  
ATOM   2429  HZ2 TRP H 148      13.478 -20.260   9.330  1.00  0.00           H  
ATOM   2430  HZ3 TRP H 148      13.363 -24.087  11.311  1.00  0.00           H  
ATOM   2431  HH2 TRP H 148      13.926 -22.713   9.315  1.00  0.00           H  
ATOM   2432  H   TRP H 148      10.044 -21.680  16.599  1.00  5.42           H  
ATOM   2433  HA  TRP H 148       9.273 -19.474  14.916  1.00  5.32           H  
ATOM   2434  N   THR H 148A      8.765 -22.605  13.982  1.00  5.58           N  
ATOM   2435  CA  THR H 148A      7.963 -23.480  13.121  1.00  6.93           C  
ATOM   2436  C   THR H 148A      7.218 -24.514  13.997  1.00  8.66           C  
ATOM   2437  O   THR H 148A      7.609 -24.738  15.144  1.00 10.13           O  
ATOM   2438  CB  THR H 148A      8.836 -24.249  12.087  1.00  0.00           C  
ATOM   2439  OG1 THR H 148A      9.869 -24.990  12.714  1.00  0.00           O  
ATOM   2440  CG2 THR H 148A      9.450 -23.346  11.007  1.00  0.00           C  
ATOM   2441  HB  THR H 148A      8.212 -24.976  11.567  1.00  0.00           H  
ATOM   2442  HG1 THR H 148A      9.473 -25.634  13.305  1.00  0.00           H  
ATOM   2443 HG21 THR H 148A     10.043 -23.924  10.299  1.00  0.00           H  
ATOM   2444 HG22 THR H 148A      8.671 -22.833  10.443  1.00  0.00           H  
ATOM   2445 HG23 THR H 148A     10.097 -22.583  11.433  1.00  0.00           H  
ATOM   2446  H   THR H 148A      9.081 -23.032  14.841  1.00  5.58           H  
ATOM   2447  HA  THR H 148A      7.212 -22.889  12.593  1.00  6.93           H  
ATOM   2448  N   ALA H 148B      6.164 -25.114  13.410  1.00 10.08           N  
ATOM   2449  CA  ALA H 148B      5.286 -26.168  13.942  1.00 12.98           C  
ATOM   2450  C   ALA H 148B      3.904 -25.659  14.415  1.00 13.49           C  
ATOM   2451  O   ALA H 148B      3.362 -24.733  13.812  1.00 15.15           O  
ATOM   2452  CB  ALA H 148B      5.994 -27.168  14.888  1.00  0.00           C  
ATOM   2453  HB1 ALA H 148B      6.167 -26.744  15.878  1.00  0.00           H  
ATOM   2454  HB2 ALA H 148B      5.402 -28.075  15.022  1.00  0.00           H  
ATOM   2455  HB3 ALA H 148B      6.957 -27.481  14.483  1.00  0.00           H  
ATOM   2456  H   ALA H 148B      5.923 -24.821  12.474  1.00 10.08           H  
ATOM   2457  HA  ALA H 148B      5.046 -26.751  13.052  1.00 12.98           H  
ATOM   2458  N   ASN H 148C      3.323 -26.357  15.408  0.60 13.23           N  
ATOM   2459  CA  ASN H 148C      1.887 -26.465  15.705  0.60 11.63           C  
ATOM   2460  C   ASN H 148C      1.114 -25.182  16.093  0.60 12.19           C  
ATOM   2461  O   ASN H 148C     -0.113 -25.195  16.005  0.60 11.47           O  
ATOM   2462  CB  ASN H 148C      1.712 -27.526  16.822  1.00  0.00           C  
ATOM   2463  CG  ASN H 148C      0.402 -28.315  16.726  1.00  0.00           C  
ATOM   2464  OD1 ASN H 148C      0.183 -29.047  15.765  1.00  0.00           O  
ATOM   2465  ND2 ASN H 148C     -0.468 -28.179  17.730  1.00  0.00           N  
ATOM   2466  HB2 ASN H 148C      2.493 -28.283  16.728  1.00  0.00           H  
ATOM   2467  HB3 ASN H 148C      1.848 -27.091  17.814  1.00  0.00           H  
ATOM   2468 HD22 ASN H 148C     -1.342 -28.684  17.708  1.00  0.00           H  
ATOM   2469 HD21 ASN H 148C     -0.266 -27.568  18.507  1.00  0.00           H  
ATOM   2470  H   ASN H 148C      3.886 -27.065  15.857  1.00 13.23           H  
ATOM   2471  HA  ASN H 148C      1.376 -26.803  14.801  1.00 11.63           H  
ATOM   2472  N   VAL H 148D      1.802 -24.124  16.550  1.00 13.32           N  
ATOM   2473  CA  VAL H 148D      1.185 -22.951  17.195  1.00 13.44           C  
ATOM   2474  C   VAL H 148D      0.446 -21.943  16.267  1.00 12.47           C  
ATOM   2475  O   VAL H 148D     -0.202 -21.037  16.794  1.00 15.16           O  
ATOM   2476  CB  VAL H 148D      2.226 -22.202  18.063  1.00  0.00           C  
ATOM   2477  CG1 VAL H 148D      2.724 -23.071  19.234  1.00  0.00           C  
ATOM   2478  CG2 VAL H 148D      3.409 -21.667  17.252  1.00  0.00           C  
ATOM   2479  HB  VAL H 148D      1.741 -21.340  18.523  1.00  0.00           H  
ATOM   2480 HG11 VAL H 148D      3.399 -22.509  19.880  1.00  0.00           H  
ATOM   2481 HG12 VAL H 148D      1.893 -23.413  19.851  1.00  0.00           H  
ATOM   2482 HG13 VAL H 148D      3.263 -23.951  18.883  1.00  0.00           H  
ATOM   2483 HG21 VAL H 148D      4.143 -21.237  17.924  1.00  0.00           H  
ATOM   2484 HG22 VAL H 148D      3.911 -22.463  16.703  1.00  0.00           H  
ATOM   2485 HG23 VAL H 148D      3.106 -20.893  16.548  1.00  0.00           H  
ATOM   2486  H   VAL H 148D      2.811 -24.163  16.575  1.00 13.32           H  
ATOM   2487  HA  VAL H 148D      0.419 -23.331  17.873  1.00 13.44           H  
ATOM   2488  N   GLY H 148E      0.496 -22.168  14.938  1.00 10.59           N  
ATOM   2489  CA  GLY H 148E     -0.321 -21.588  13.854  0.70  9.34           C  
ATOM   2490  C   GLY H 148E     -0.673 -20.091  13.958  1.00  7.85           C  
ATOM   2491  O   GLY H 148E     -1.782 -19.752  14.369  1.00  8.37           O  
ATOM   2492  HA3 GLY H 148E     -1.249 -22.158  13.796  1.00  9.34           H  
ATOM   2493  H   GLY H 148E      1.086 -22.934  14.647  1.00 10.59           H  
ATOM   2494  HA2 GLY H 148E      0.198 -21.764  12.911  1.00  9.34           H  
ATOM   2495  N   LYS H 149       0.270 -19.238  13.518  1.00  5.85           N  
ATOM   2496  CA  LYS H 149       0.308 -17.761  13.432  0.60  4.69           C  
ATOM   2497  C   LYS H 149       1.823 -17.443  13.280  1.00  3.53           C  
ATOM   2498  O   LYS H 149       2.640 -18.226  13.763  1.00  4.77           O  
ATOM   2499  CB  LYS H 149      -0.218 -17.082  14.735  1.00  0.00           C  
ATOM   2500  CG  LYS H 149      -0.832 -15.662  14.639  1.00  0.00           C  
ATOM   2501  CD  LYS H 149      -2.323 -15.641  14.246  1.00  0.00           C  
ATOM   2502  CE  LYS H 149      -2.927 -14.223  14.298  1.00  0.00           C  
ATOM   2503  NZ  LYS H 149      -4.399 -14.235  14.216  1.00  0.00           N1+
ATOM   2504  HB2 LYS H 149      -0.963 -17.686  15.241  1.00  0.00           H  
ATOM   2505  HB3 LYS H 149       0.612 -17.056  15.440  1.00  0.00           H  
ATOM   2506  HG2 LYS H 149      -0.744 -15.186  15.615  1.00  0.00           H  
ATOM   2507  HG3 LYS H 149      -0.254 -15.010  13.995  1.00  0.00           H  
ATOM   2508  HD2 LYS H 149      -2.439 -16.060  13.245  1.00  0.00           H  
ATOM   2509  HD3 LYS H 149      -2.872 -16.302  14.919  1.00  0.00           H  
ATOM   2510  HE2 LYS H 149      -2.649 -13.725  15.228  1.00  0.00           H  
ATOM   2511  HE3 LYS H 149      -2.532 -13.623  13.478  1.00  0.00           H  
ATOM   2512  HZ1 LYS H 149      -4.778 -14.748  14.999  1.00  0.00           H  
ATOM   2513  HZ2 LYS H 149      -4.748 -13.287  14.238  1.00  0.00           H  
ATOM   2514  HZ3 LYS H 149      -4.687 -14.677  13.354  1.00  0.00           H  
ATOM   2515  H   LYS H 149       1.141 -19.656  13.223  1.00  5.85           H  
ATOM   2516  HA  LYS H 149      -0.252 -17.438  12.555  1.00  4.69           H  
ATOM   2517  N   GLY H 150       2.275 -16.338  12.672  1.00 57.65           N  
ATOM   2518  CA  GLY H 150       1.573 -15.335  11.889  1.00 44.28           C  
ATOM   2519  C   GLY H 150       2.298 -13.997  12.089  1.00 39.70           C  
ATOM   2520  O   GLY H 150       2.937 -13.748  13.115  1.00 34.20           O  
ATOM   2521  HA3 GLY H 150       0.513 -15.249  12.107  1.00 44.28           H  
ATOM   2522  HA2 GLY H 150       1.643 -15.628  10.841  1.00 44.28           H  
ATOM   2523  H   GLY H 150       3.275 -16.200  12.703  1.00 57.65           H  
ATOM   2524  N   GLN H 151       2.195 -13.149  11.059  1.00 42.47           N  
ATOM   2525  CA  GLN H 151       2.914 -11.886  10.898  1.00 43.44           C  
ATOM   2526  C   GLN H 151       1.858 -10.806  10.595  1.00 36.05           C  
ATOM   2527  O   GLN H 151       0.928 -11.089   9.836  1.00 46.20           O  
ATOM   2528  CB  GLN H 151       3.886 -12.061   9.709  1.00 48.68           C  
ATOM   2529  CG  GLN H 151       4.873 -13.232   9.904  1.00 55.29           C  
ATOM   2530  CD  GLN H 151       5.980 -13.304   8.854  1.00 60.15           C  
ATOM   2531  OE1 GLN H 151       5.780 -12.974   7.686  1.00 73.30           O  
ATOM   2532  NE2 GLN H 151       7.156 -13.777   9.269  1.00 72.83           N  
ATOM   2533  H   GLN H 151       1.622 -13.409  10.269  1.00 42.47           H  
ATOM   2534  HA  GLN H 151       3.477 -11.653  11.802  1.00 43.44           H  
ATOM   2535  HB3 GLN H 151       4.451 -11.137   9.585  1.00 48.68           H  
ATOM   2536  HB2 GLN H 151       3.327 -12.214   8.785  1.00 48.68           H  
ATOM   2537  HG3 GLN H 151       4.349 -14.187   9.895  1.00 55.29           H  
ATOM   2538  HG2 GLN H 151       5.336 -13.141  10.889  1.00 55.29           H  
ATOM   2539 HE22 GLN H 151       7.923 -13.866   8.618  1.00 72.83           H  
ATOM   2540 HE21 GLN H 151       7.295 -14.034  10.236  1.00 72.83           H  
ATOM   2541  N   PRO H 152       1.964  -9.609  11.215  1.00 27.51           N  
ATOM   2542  CA  PRO H 152       0.888  -8.608  11.145  1.00 25.80           C  
ATOM   2543  C   PRO H 152       0.818  -7.879   9.794  1.00 23.91           C  
ATOM   2544  O   PRO H 152       1.844  -7.684   9.143  1.00 29.61           O  
ATOM   2545  CB  PRO H 152       1.255  -7.645  12.271  1.00 22.95           C  
ATOM   2546  CG  PRO H 152       2.773  -7.649  12.291  1.00 23.20           C  
ATOM   2547  CD  PRO H 152       3.096  -9.115  12.005  1.00 24.32           C  
ATOM   2548  HA  PRO H 152      -0.081  -9.065  11.353  1.00 25.80           H  
ATOM   2549  HB3 PRO H 152       0.866  -8.027  13.211  1.00 22.95           H  
ATOM   2550  HB2 PRO H 152       0.823  -6.660  12.137  1.00 22.95           H  
ATOM   2551  HG3 PRO H 152       3.183  -7.270  13.225  1.00 23.20           H  
ATOM   2552  HG2 PRO H 152       3.155  -7.019  11.487  1.00 23.20           H  
ATOM   2553  HD2 PRO H 152       4.043  -9.218  11.474  1.00 24.32           H  
ATOM   2554  HD3 PRO H 152       3.155  -9.672  12.940  1.00 24.32           H  
ATOM   2555  N   SER H 153      -0.394  -7.447   9.422  1.00 22.73           N  
ATOM   2556  CA  SER H 153      -0.625  -6.567   8.277  1.00 22.88           C  
ATOM   2557  C   SER H 153      -0.015  -5.166   8.484  1.00 22.02           C  
ATOM   2558  O   SER H 153       0.515  -4.601   7.527  1.00 22.91           O  
ATOM   2559  CB  SER H 153      -2.139  -6.494   7.995  1.00 30.72           C  
ATOM   2560  OG  SER H 153      -2.430  -5.691   6.867  1.00 33.56           O  
ATOM   2561  H   SER H 153      -1.193  -7.619  10.017  1.00 22.73           H  
ATOM   2562  HA  SER H 153      -0.142  -7.017   7.408  1.00 22.88           H  
ATOM   2563  HB3 SER H 153      -2.675  -6.089   8.855  1.00 30.72           H  
ATOM   2564  HB2 SER H 153      -2.538  -7.493   7.815  1.00 30.72           H  
ATOM   2565  HG  SER H 153      -3.383  -5.660   6.753  1.00 33.56           H  
ATOM   2566  N   VAL H 154      -0.100  -4.644   9.719  1.00 17.80           N  
ATOM   2567  CA  VAL H 154       0.325  -3.293  10.077  1.00 18.58           C  
ATOM   2568  C   VAL H 154       1.090  -3.283  11.412  1.00 17.54           C  
ATOM   2569  O   VAL H 154       1.129  -4.295  12.107  1.00 18.98           O  
ATOM   2570  CB  VAL H 154      -0.893  -2.326  10.178  1.00 20.76           C  
ATOM   2571  CG1 VAL H 154      -1.703  -2.251   8.870  1.00 24.45           C  
ATOM   2572  CG2 VAL H 154      -1.836  -2.581  11.373  1.00 25.17           C  
ATOM   2573  H   VAL H 154      -0.527  -5.183  10.461  1.00 17.80           H  
ATOM   2574  HA  VAL H 154       1.028  -2.922   9.335  1.00 18.58           H  
ATOM   2575  HB  VAL H 154      -0.481  -1.328  10.315  1.00 20.76           H  
ATOM   2576 HG11 VAL H 154      -2.496  -1.508   8.938  1.00 24.45           H  
ATOM   2577 HG12 VAL H 154      -1.073  -1.972   8.026  1.00 24.45           H  
ATOM   2578 HG13 VAL H 154      -2.180  -3.202   8.634  1.00 24.45           H  
ATOM   2579 HG21 VAL H 154      -2.684  -1.896  11.350  1.00 25.17           H  
ATOM   2580 HG22 VAL H 154      -2.237  -3.593  11.351  1.00 25.17           H  
ATOM   2581 HG23 VAL H 154      -1.345  -2.436  12.334  1.00 25.17           H  
ATOM   2582  N   LEU H 155       1.682  -2.123  11.743  1.00 16.10           N  
ATOM   2583  CA  LEU H 155       2.418  -1.830  12.973  1.00 13.77           C  
ATOM   2584  C   LEU H 155       1.582  -2.177  14.211  1.00 15.64           C  
ATOM   2585  O   LEU H 155       0.442  -1.728  14.308  1.00 16.38           O  
ATOM   2586  CB  LEU H 155       2.824  -0.335  12.955  1.00 15.45           C  
ATOM   2587  CG  LEU H 155       3.592   0.167  14.201  1.00 12.86           C  
ATOM   2588  CD1 LEU H 155       4.911  -0.595  14.404  1.00 12.30           C  
ATOM   2589  CD2 LEU H 155       3.798   1.695  14.153  1.00 16.07           C  
ATOM   2590  H   LEU H 155       1.620  -1.353  11.090  1.00 16.10           H  
ATOM   2591  HA  LEU H 155       3.319  -2.445  12.971  1.00 13.77           H  
ATOM   2592  HB3 LEU H 155       1.922   0.268  12.836  1.00 15.45           H  
ATOM   2593  HB2 LEU H 155       3.425  -0.134  12.067  1.00 15.45           H  
ATOM   2594  HG  LEU H 155       2.984  -0.016  15.086  1.00 12.86           H  
ATOM   2595 HD11 LEU H 155       5.658  -0.004  14.932  1.00 12.30           H  
ATOM   2596 HD12 LEU H 155       4.724  -1.475  15.013  1.00 12.30           H  
ATOM   2597 HD13 LEU H 155       5.348  -0.931  13.464  1.00 12.30           H  
ATOM   2598 HD21 LEU H 155       4.847   1.984  14.198  1.00 16.07           H  
ATOM   2599 HD22 LEU H 155       3.389   2.133  13.242  1.00 16.07           H  
ATOM   2600 HD23 LEU H 155       3.294   2.175  14.992  1.00 16.07           H  
ATOM   2601  N   GLN H 156       2.165  -2.981  15.107  1.00 14.24           N  
ATOM   2602  CA  GLN H 156       1.522  -3.422  16.339  1.00 13.89           C  
ATOM   2603  C   GLN H 156       2.058  -2.624  17.526  1.00 12.43           C  
ATOM   2604  O   GLN H 156       3.143  -2.052  17.436  1.00 13.85           O  
ATOM   2605  CB  GLN H 156       1.746  -4.935  16.509  1.00 15.12           C  
ATOM   2606  CG  GLN H 156       1.123  -5.767  15.372  1.00 16.03           C  
ATOM   2607  CD  GLN H 156      -0.392  -5.636  15.300  1.00 16.46           C  
ATOM   2608  OE1 GLN H 156      -1.099  -6.010  16.233  1.00 19.42           O  
ATOM   2609  NE2 GLN H 156      -0.891  -5.111  14.186  1.00 18.22           N  
ATOM   2610  H   GLN H 156       3.109  -3.312  14.955  1.00 14.24           H  
ATOM   2611  HA  GLN H 156       0.452  -3.229  16.283  1.00 13.89           H  
ATOM   2612  HB3 GLN H 156       1.316  -5.258  17.458  1.00 15.12           H  
ATOM   2613  HB2 GLN H 156       2.814  -5.150  16.565  1.00 15.12           H  
ATOM   2614  HG3 GLN H 156       1.323  -6.819  15.507  1.00 16.03           H  
ATOM   2615  HG2 GLN H 156       1.579  -5.506  14.417  1.00 16.03           H  
ATOM   2616 HE22 GLN H 156      -1.895  -4.991  14.088  1.00 18.22           H  
ATOM   2617 HE21 GLN H 156      -0.277  -4.810  13.439  1.00 18.22           H  
ATOM   2618  N   VAL H 157       1.247  -2.564  18.591  1.00 14.44           N  
ATOM   2619  CA  VAL H 157       1.468  -1.731  19.767  0.71 13.18           C  
ATOM   2620  C   VAL H 157       0.977  -2.487  21.008  1.00 14.17           C  
ATOM   2621  O   VAL H 157      -0.122  -3.039  20.977  1.00 16.43           O  
ATOM   2622  CB  VAL H 157       0.648  -0.404  19.697  0.71 14.00           C  
ATOM   2623  CG1 VAL H 157       0.954   0.562  20.857  0.71 12.92           C  
ATOM   2624  CG2 VAL H 157       0.797   0.321  18.351  0.71 20.51           C  
ATOM   2625  H   VAL H 157       0.355  -3.040  18.558  1.00 14.44           H  
ATOM   2626  HA  VAL H 157       2.530  -1.519  19.880  0.71 13.18           H  
ATOM   2627  HB  VAL H 157      -0.414  -0.646  19.774  0.71 14.00           H  
ATOM   2628 HG11 VAL H 157       0.429   1.510  20.734  0.71 12.92           H  
ATOM   2629 HG12 VAL H 157       0.649   0.160  21.823  0.71 12.92           H  
ATOM   2630 HG13 VAL H 157       2.020   0.775  20.906  0.71 12.92           H  
ATOM   2631 HG21 VAL H 157       0.308   1.290  18.368  0.71 20.51           H  
ATOM   2632 HG22 VAL H 157       1.833   0.486  18.066  0.71 20.51           H  
ATOM   2633 HG23 VAL H 157       0.327  -0.259  17.558  0.71 20.51           H  
ATOM   2634  N   VAL H 158       1.762  -2.444  22.093  1.00 13.07           N  
ATOM   2635  CA  VAL H 158       1.362  -2.958  23.400  1.00 14.44           C  
ATOM   2636  C   VAL H 158       1.976  -2.087  24.506  1.00 13.29           C  
ATOM   2637  O   VAL H 158       3.123  -1.661  24.379  1.00 13.72           O  
ATOM   2638  CB  VAL H 158       1.776  -4.447  23.592  1.00 16.34           C  
ATOM   2639  CG1 VAL H 158       3.300  -4.688  23.636  1.00 18.61           C  
ATOM   2640  CG2 VAL H 158       1.101  -5.096  24.812  1.00 19.10           C  
ATOM   2641  H   VAL H 158       2.663  -1.985  22.051  1.00 13.07           H  
ATOM   2642  HA  VAL H 158       0.277  -2.882  23.493  1.00 14.44           H  
ATOM   2643  HB  VAL H 158       1.389  -4.991  22.732  1.00 16.34           H  
ATOM   2644 HG11 VAL H 158       3.526  -5.751  23.732  1.00 18.61           H  
ATOM   2645 HG12 VAL H 158       3.788  -4.322  22.733  1.00 18.61           H  
ATOM   2646 HG13 VAL H 158       3.772  -4.191  24.478  1.00 18.61           H  
ATOM   2647 HG21 VAL H 158       1.321  -6.161  24.849  1.00 19.10           H  
ATOM   2648 HG22 VAL H 158       1.440  -4.658  25.750  1.00 19.10           H  
ATOM   2649 HG23 VAL H 158       0.017  -4.991  24.766  1.00 19.10           H  
ATOM   2650  N   ASN H 159       1.194  -1.860  25.573  1.00 13.21           N  
ATOM   2651  CA  ASN H 159       1.610  -1.130  26.770  1.00 12.49           C  
ATOM   2652  C   ASN H 159       1.937  -2.143  27.873  1.00 12.23           C  
ATOM   2653  O   ASN H 159       1.096  -2.993  28.166  1.00 15.23           O  
ATOM   2654  CB  ASN H 159       0.479  -0.187  27.224  1.00 13.48           C  
ATOM   2655  CG  ASN H 159       0.139   0.918  26.216  1.00 15.24           C  
ATOM   2656  OD1 ASN H 159       0.977   1.359  25.431  1.00 14.68           O  
ATOM   2657  ND2 ASN H 159      -1.108   1.379  26.252  1.00 23.69           N  
ATOM   2658  H   ASN H 159       0.264  -2.253  25.598  1.00 13.21           H  
ATOM   2659  HA  ASN H 159       2.490  -0.534  26.542  1.00 12.49           H  
ATOM   2660  HB3 ASN H 159       0.757   0.291  28.163  1.00 13.48           H  
ATOM   2661  HB2 ASN H 159      -0.423  -0.765  27.433  1.00 13.48           H  
ATOM   2662 HD22 ASN H 159      -1.422   2.082  25.597  1.00 23.69           H  
ATOM   2663 HD21 ASN H 159      -1.778   0.988  26.906  1.00 23.69           H  
ATOM   2664  N   LEU H 160       3.149  -2.047  28.444  1.00 12.25           N  
ATOM   2665  CA  LEU H 160       3.712  -3.036  29.366  1.00 13.47           C  
ATOM   2666  C   LEU H 160       4.342  -2.328  30.581  1.00 12.43           C  
ATOM   2667  O   LEU H 160       5.141  -1.412  30.374  1.00 13.20           O  
ATOM   2668  CB  LEU H 160       4.812  -3.827  28.623  1.00 13.45           C  
ATOM   2669  CG  LEU H 160       4.327  -4.661  27.420  1.00 13.31           C  
ATOM   2670  CD1 LEU H 160       5.517  -5.319  26.703  1.00 17.93           C  
ATOM   2671  CD2 LEU H 160       3.256  -5.704  27.789  1.00 18.08           C  
ATOM   2672  H   LEU H 160       3.765  -1.288  28.179  1.00 12.25           H  
ATOM   2673  HA  LEU H 160       2.929  -3.724  29.671  1.00 13.47           H  
ATOM   2674  HB3 LEU H 160       5.309  -4.494  29.328  1.00 13.45           H  
ATOM   2675  HB2 LEU H 160       5.582  -3.132  28.281  1.00 13.45           H  
ATOM   2676  HG  LEU H 160       3.875  -3.974  26.707  1.00 13.31           H  
ATOM   2677 HD11 LEU H 160       5.515  -5.103  25.636  1.00 17.93           H  
ATOM   2678 HD12 LEU H 160       6.472  -4.970  27.095  1.00 17.93           H  
ATOM   2679 HD13 LEU H 160       5.496  -6.402  26.818  1.00 17.93           H  
ATOM   2680 HD21 LEU H 160       3.057  -6.361  26.945  1.00 18.08           H  
ATOM   2681 HD22 LEU H 160       3.556  -6.324  28.632  1.00 18.08           H  
ATOM   2682 HD23 LEU H 160       2.305  -5.243  28.042  1.00 18.08           H  
ATOM   2683  N   PRO H 161       4.003  -2.766  31.819  1.00 13.38           N  
ATOM   2684  CA  PRO H 161       4.602  -2.218  33.049  1.00 12.36           C  
ATOM   2685  C   PRO H 161       6.062  -2.649  33.214  1.00 14.84           C  
ATOM   2686  O   PRO H 161       6.363  -3.829  33.042  1.00 14.69           O  
ATOM   2687  CB  PRO H 161       3.711  -2.780  34.168  1.00 15.95           C  
ATOM   2688  CG  PRO H 161       3.212  -4.107  33.628  1.00 15.14           C  
ATOM   2689  CD  PRO H 161       3.059  -3.842  32.136  1.00 16.28           C  
ATOM   2690  HA  PRO H 161       4.547  -1.135  33.082  1.00 12.36           H  
ATOM   2691  HB3 PRO H 161       2.866  -2.109  34.331  1.00 15.95           H  
ATOM   2692  HB2 PRO H 161       4.224  -2.889  35.125  1.00 15.95           H  
ATOM   2693  HG3 PRO H 161       2.299  -4.457  34.108  1.00 15.14           H  
ATOM   2694  HG2 PRO H 161       3.976  -4.868  33.779  1.00 15.14           H  
ATOM   2695  HD2 PRO H 161       3.240  -4.757  31.571  1.00 16.28           H  
ATOM   2696  HD3 PRO H 161       2.054  -3.483  31.915  1.00 16.28           H  
ATOM   2697  N   ILE H 162       6.929  -1.693  33.583  1.00 13.35           N  
ATOM   2698  CA  ILE H 162       8.285  -1.957  34.068  1.00 14.51           C  
ATOM   2699  C   ILE H 162       8.214  -2.797  35.357  1.00 15.14           C  
ATOM   2700  O   ILE H 162       7.344  -2.562  36.193  1.00 16.05           O  
ATOM   2701  CB  ILE H 162       9.056  -0.635  34.355  1.00 13.84           C  
ATOM   2702  CG1 ILE H 162       9.265   0.164  33.049  1.00 14.51           C  
ATOM   2703  CG2 ILE H 162      10.410  -0.816  35.087  1.00 15.51           C  
ATOM   2704  CD1 ILE H 162       9.634   1.633  33.277  1.00 18.47           C  
ATOM   2705  H   ILE H 162       6.606  -0.738  33.682  1.00 13.35           H  
ATOM   2706  HA  ILE H 162       8.820  -2.518  33.300  1.00 14.51           H  
ATOM   2707  HB  ILE H 162       8.415  -0.035  35.001  1.00 13.84           H  
ATOM   2708 HG13 ILE H 162       8.360   0.148  32.446  1.00 14.51           H  
ATOM   2709 HG12 ILE H 162      10.032  -0.317  32.442  1.00 14.51           H  
ATOM   2710 HG21 ILE H 162      10.913   0.137  35.244  1.00 15.51           H  
ATOM   2711 HG22 ILE H 162      10.295  -1.253  36.079  1.00 15.51           H  
ATOM   2712 HG23 ILE H 162      11.084  -1.456  34.516  1.00 15.51           H  
ATOM   2713 HD11 ILE H 162       9.586   2.185  32.340  1.00 18.47           H  
ATOM   2714 HD12 ILE H 162       8.959   2.115  33.985  1.00 18.47           H  
ATOM   2715 HD13 ILE H 162      10.648   1.724  33.656  1.00 18.47           H  
ATOM   2716  N   VAL H 163       9.102  -3.787  35.460  1.00 14.64           N  
ATOM   2717  CA  VAL H 163       9.103  -4.776  36.531  1.00 14.92           C  
ATOM   2718  C   VAL H 163      10.304  -4.520  37.456  1.00 14.82           C  
ATOM   2719  O   VAL H 163      11.348  -4.062  36.988  1.00 16.00           O  
ATOM   2720  CB  VAL H 163       9.194  -6.188  35.891  1.00 17.85           C  
ATOM   2721  CG1 VAL H 163       9.506  -7.353  36.846  1.00 18.15           C  
ATOM   2722  CG2 VAL H 163       7.913  -6.516  35.114  1.00 16.60           C  
ATOM   2723  H   VAL H 163       9.795  -3.920  34.734  1.00 14.64           H  
ATOM   2724  HA  VAL H 163       8.188  -4.720  37.124  1.00 14.92           H  
ATOM   2725  HB  VAL H 163       9.992  -6.149  35.154  1.00 17.85           H  
ATOM   2726 HG11 VAL H 163       9.423  -8.309  36.329  1.00 18.15           H  
ATOM   2727 HG12 VAL H 163      10.521  -7.300  37.229  1.00 18.15           H  
ATOM   2728 HG13 VAL H 163       8.821  -7.369  37.693  1.00 18.15           H  
ATOM   2729 HG21 VAL H 163       8.032  -7.433  34.543  1.00 16.60           H  
ATOM   2730 HG22 VAL H 163       7.071  -6.651  35.790  1.00 16.60           H  
ATOM   2731 HG23 VAL H 163       7.647  -5.737  34.403  1.00 16.60           H  
ATOM   2732  N   GLU H 164      10.126  -4.824  38.754  1.00 16.70           N  
ATOM   2733  CA  GLU H 164      11.140  -4.740  39.809  1.00 21.12           C  
ATOM   2734  C   GLU H 164      12.385  -5.567  39.455  1.00 20.27           C  
ATOM   2735  O   GLU H 164      12.250  -6.690  38.972  1.00 19.89           O  
ATOM   2736  CB  GLU H 164      10.574  -5.233  41.165  1.00 25.81           C  
ATOM   2737  CG  GLU H 164       9.348  -4.479  41.734  1.00 32.47           C  
ATOM   2738  CD  GLU H 164       7.960  -4.885  41.207  1.00 39.66           C  
ATOM   2739  OE1 GLU H 164       6.987  -4.232  41.641  1.00 37.31           O  
ATOM   2740  OE2 GLU H 164       7.872  -5.827  40.390  1.00 28.96           O1-
ATOM   2741  H   GLU H 164       9.232  -5.190  39.058  1.00 16.70           H  
ATOM   2742  HA  GLU H 164      11.427  -3.692  39.907  1.00 21.12           H  
ATOM   2743  HB3 GLU H 164      11.359  -5.126  41.912  1.00 25.81           H  
ATOM   2744  HB2 GLU H 164      10.376  -6.306  41.125  1.00 25.81           H  
ATOM   2745  HG3 GLU H 164       9.490  -3.406  41.612  1.00 32.47           H  
ATOM   2746  HG2 GLU H 164       9.326  -4.645  42.812  1.00 32.47           H  
ATOM   2747  N   ARG H 165      13.573  -5.002  39.710  1.00 21.15           N  
ATOM   2748  CA  ARG H 165      14.854  -5.612  39.352  1.00 19.81           C  
ATOM   2749  C   ARG H 165      15.162  -7.005  39.960  1.00 18.33           C  
ATOM   2750  O   ARG H 165      15.723  -7.821  39.229  1.00 18.61           O  
ATOM   2751  CB  ARG H 165      15.983  -4.586  39.559  1.00 24.16           C  
ATOM   2752  CG  ARG H 165      17.354  -5.021  39.004  1.00 31.59           C  
ATOM   2753  CD  ARG H 165      18.397  -3.888  38.995  1.00 37.38           C  
ATOM   2754  NE  ARG H 165      18.058  -2.819  38.037  1.00 35.66           N  
ATOM   2755  CZ  ARG H 165      18.218  -2.837  36.703  1.00 37.11           C  
ATOM   2756  NH1 ARG H 165      18.806  -3.860  36.066  1.00 25.84           N  
ATOM   2757  NH2 ARG H 165      17.776  -1.796  35.989  1.00 35.96           N1+
ATOM   2758  H   ARG H 165      13.611  -4.080  40.121  1.00 21.15           H  
ATOM   2759  HA  ARG H 165      14.790  -5.772  38.274  1.00 19.81           H  
ATOM   2760  HB3 ARG H 165      16.092  -4.356  40.619  1.00 24.16           H  
ATOM   2761  HB2 ARG H 165      15.677  -3.653  39.083  1.00 24.16           H  
ATOM   2762  HG3 ARG H 165      17.179  -5.337  37.974  1.00 31.59           H  
ATOM   2763  HG2 ARG H 165      17.756  -5.898  39.512  1.00 31.59           H  
ATOM   2764  HD3 ARG H 165      19.415  -4.260  38.890  1.00 37.38           H  
ATOM   2765  HD2 ARG H 165      18.365  -3.394  39.966  1.00 37.38           H  
ATOM   2766  HE  ARG H 165      17.608  -2.012  38.443  1.00 35.66           H  
ATOM   2767 HH12 ARG H 165      18.932  -3.832  35.062  1.00 25.84           H  
ATOM   2768 HH11 ARG H 165      19.202  -4.625  36.594  1.00 25.84           H  
ATOM   2769 HH22 ARG H 165      17.894  -1.799  34.983  1.00 35.96           H  
ATOM   2770 HH21 ARG H 165      17.340  -1.004  36.439  1.00 35.96           H  
ATOM   2771  N   PRO H 166      14.718  -7.312  41.206  1.00 21.91           N  
ATOM   2772  CA  PRO H 166      14.751  -8.689  41.737  1.00 21.74           C  
ATOM   2773  C   PRO H 166      13.885  -9.694  40.960  1.00 22.18           C  
ATOM   2774  O   PRO H 166      14.356 -10.799  40.712  1.00 20.38           O  
ATOM   2775  CB  PRO H 166      14.295  -8.547  43.200  1.00 24.89           C  
ATOM   2776  CG  PRO H 166      14.615  -7.106  43.557  1.00 25.88           C  
ATOM   2777  CD  PRO H 166      14.324  -6.374  42.257  1.00 23.41           C  
ATOM   2778  HA  PRO H 166      15.790  -9.022  41.720  1.00 21.74           H  
ATOM   2779  HB3 PRO H 166      14.791  -9.257  43.863  1.00 24.89           H  
ATOM   2780  HB2 PRO H 166      13.219  -8.709  43.292  1.00 24.89           H  
ATOM   2781  HG3 PRO H 166      15.675  -7.016  43.799  1.00 25.88           H  
ATOM   2782  HG2 PRO H 166      14.041  -6.732  44.405  1.00 25.88           H  
ATOM   2783  HD2 PRO H 166      13.255  -6.192  42.179  1.00 23.41           H  
ATOM   2784  HD3 PRO H 166      14.846  -5.419  42.217  1.00 23.41           H  
ATOM   2785  N   VAL H 167      12.666  -9.289  40.557  1.00 17.73           N  
ATOM   2786  CA  VAL H 167      11.745 -10.115  39.768  1.00 18.97           C  
ATOM   2787  C   VAL H 167      12.272 -10.376  38.339  1.00 18.05           C  
ATOM   2788  O   VAL H 167      12.120 -11.496  37.853  1.00 17.59           O  
ATOM   2789  CB  VAL H 167      10.317  -9.494  39.703  1.00 19.07           C  
ATOM   2790  CG1 VAL H 167       9.324 -10.251  38.793  1.00 21.85           C  
ATOM   2791  CG2 VAL H 167       9.704  -9.355  41.108  1.00 22.51           C  
ATOM   2792  H   VAL H 167      12.348  -8.356  40.776  1.00 17.73           H  
ATOM   2793  HA  VAL H 167      11.667 -11.084  40.267  1.00 18.97           H  
ATOM   2794  HB  VAL H 167      10.404  -8.484  39.306  1.00 19.07           H  
ATOM   2795 HG11 VAL H 167       8.327  -9.813  38.847  1.00 21.85           H  
ATOM   2796 HG12 VAL H 167       9.620 -10.219  37.746  1.00 21.85           H  
ATOM   2797 HG13 VAL H 167       9.241 -11.298  39.085  1.00 21.85           H  
ATOM   2798 HG21 VAL H 167       8.718  -8.891  41.064  1.00 22.51           H  
ATOM   2799 HG22 VAL H 167       9.594 -10.327  41.589  1.00 22.51           H  
ATOM   2800 HG23 VAL H 167      10.319  -8.732  41.757  1.00 22.51           H  
ATOM   2801  N   CYS H 168      12.939  -9.376  37.728  1.00 17.38           N  
ATOM   2802  CA  CYS H 168      13.661  -9.512  36.459  1.00 15.66           C  
ATOM   2803  C   CYS H 168      14.816 -10.522  36.549  1.00 14.21           C  
ATOM   2804  O   CYS H 168      14.934 -11.368  35.669  1.00 15.85           O  
ATOM   2805  CB  CYS H 168      14.201  -8.146  35.985  1.00 16.70           C  
ATOM   2806  SG  CYS H 168      12.957  -6.893  35.588  1.00 17.75           S  
ATOM   2807  H   CYS H 168      13.002  -8.475  38.185  1.00 17.38           H  
ATOM   2808  HA  CYS H 168      12.955  -9.885  35.716  1.00 15.66           H  
ATOM   2809  HB3 CYS H 168      14.809  -8.280  35.090  1.00 16.70           H  
ATOM   2810  HB2 CYS H 168      14.866  -7.723  36.736  1.00 16.70           H  
ATOM   2811  N   LYS H 169      15.626 -10.443  37.617  1.00 14.62           N  
ATOM   2812  CA  LYS H 169      16.746 -11.354  37.866  1.00 15.19           C  
ATOM   2813  C   LYS H 169      16.320 -12.800  38.160  1.00 15.63           C  
ATOM   2814  O   LYS H 169      16.966 -13.718  37.660  1.00 17.04           O  
ATOM   2815  CB  LYS H 169      17.627 -10.785  38.993  1.00 17.94           C  
ATOM   2816  CG  LYS H 169      18.509  -9.628  38.507  1.00 26.47           C  
ATOM   2817  CD  LYS H 169      19.303  -8.964  39.635  1.00 34.88           C  
ATOM   2818  CE  LYS H 169      20.231  -7.863  39.102  1.00 41.08           C  
ATOM   2819  NZ  LYS H 169      20.972  -7.195  40.187  1.00 44.27           N1+
ATOM   2820  H   LYS H 169      15.470  -9.726  38.313  1.00 14.62           H  
ATOM   2821  HA  LYS H 169      17.345 -11.386  36.954  1.00 15.19           H  
ATOM   2822  HB3 LYS H 169      18.290 -11.564  39.373  1.00 17.94           H  
ATOM   2823  HB2 LYS H 169      17.009 -10.477  39.837  1.00 17.94           H  
ATOM   2824  HG3 LYS H 169      17.904  -8.880  37.994  1.00 26.47           H  
ATOM   2825  HG2 LYS H 169      19.205 -10.021  37.766  1.00 26.47           H  
ATOM   2826  HD3 LYS H 169      19.885  -9.722  40.163  1.00 34.88           H  
ATOM   2827  HD2 LYS H 169      18.605  -8.546  40.363  1.00 34.88           H  
ATOM   2828  HE3 LYS H 169      19.651  -7.114  38.562  1.00 41.08           H  
ATOM   2829  HE2 LYS H 169      20.949  -8.280  38.395  1.00 41.08           H  
ATOM   2830  HZ1 LYS H 169      21.550  -7.870  40.668  1.00 44.27           H  
ATOM   2831  HZ2 LYS H 169      21.556  -6.471  39.791  1.00 44.27           H  
ATOM   2832  HZ3 LYS H 169      20.322  -6.782  40.840  1.00 44.27           H  
ATOM   2833  N   ASP H 170      15.241 -12.983  38.936  1.00 14.61           N  
ATOM   2834  CA  ASP H 170      14.704 -14.296  39.317  1.00 15.22           C  
ATOM   2835  C   ASP H 170      13.904 -14.992  38.198  1.00 15.83           C  
ATOM   2836  O   ASP H 170      13.635 -16.186  38.328  1.00 17.58           O  
ATOM   2837  CB  ASP H 170      13.888 -14.245  40.636  1.00 16.80           C  
ATOM   2838  CG  ASP H 170      14.648 -13.766  41.891  1.00 17.70           C  
ATOM   2839  OD1 ASP H 170      15.901 -13.796  41.897  1.00 19.73           O  
ATOM   2840  OD2 ASP H 170      13.947 -13.478  42.885  1.00 23.72           O1-
ATOM   2841  H   ASP H 170      14.775 -12.180  39.340  1.00 14.61           H  
ATOM   2842  HA  ASP H 170      15.557 -14.955  39.496  1.00 15.22           H  
ATOM   2843  HB3 ASP H 170      13.485 -15.233  40.862  1.00 16.80           H  
ATOM   2844  HB2 ASP H 170      13.033 -13.581  40.494  1.00 16.80           H  
ATOM   2845  N   SER H 171      13.569 -14.272  37.112  1.00 15.57           N  
ATOM   2846  CA  SER H 171      12.890 -14.819  35.933  1.00 15.49           C  
ATOM   2847  C   SER H 171      13.813 -15.589  34.966  1.00 16.89           C  
ATOM   2848  O   SER H 171      13.292 -16.181  34.023  1.00 19.18           O  
ATOM   2849  CB  SER H 171      12.145 -13.681  35.201  1.00 16.16           C  
ATOM   2850  OG  SER H 171      12.985 -12.868  34.404  1.00 17.86           O  
ATOM   2851  H   SER H 171      13.809 -13.291  37.078  1.00 15.57           H  
ATOM   2852  HA  SER H 171      12.133 -15.522  36.283  1.00 15.49           H  
ATOM   2853  HB3 SER H 171      11.582 -13.064  35.900  1.00 16.16           H  
ATOM   2854  HB2 SER H 171      11.415 -14.106  34.517  1.00 16.16           H  
ATOM   2855  HG  SER H 171      13.578 -12.370  34.977  1.00 17.86           H  
ATOM   2856  N   THR H 172      15.141 -15.535  35.166  1.00 16.11           N  
ATOM   2857  CA  THR H 172      16.119 -15.949  34.161  1.00 14.94           C  
ATOM   2858  C   THR H 172      17.464 -16.345  34.798  1.00 15.08           C  
ATOM   2859  O   THR H 172      17.825 -15.836  35.859  1.00 16.73           O  
ATOM   2860  CB  THR H 172      16.339 -14.798  33.135  1.00 15.77           C  
ATOM   2861  OG1 THR H 172      17.222 -15.171  32.094  1.00 15.70           O  
ATOM   2862  CG2 THR H 172      16.898 -13.505  33.748  1.00 19.46           C  
ATOM   2863  H   THR H 172      15.513 -15.057  35.976  1.00 16.11           H  
ATOM   2864  HA  THR H 172      15.739 -16.828  33.636  1.00 14.94           H  
ATOM   2865  HB  THR H 172      15.382 -14.566  32.667  1.00 15.77           H  
ATOM   2866  HG1 THR H 172      16.750 -15.773  31.506  1.00 15.70           H  
ATOM   2867 HG21 THR H 172      16.802 -12.691  33.035  1.00 19.46           H  
ATOM   2868 HG22 THR H 172      16.349 -13.213  34.640  1.00 19.46           H  
ATOM   2869 HG23 THR H 172      17.947 -13.596  34.025  1.00 19.46           H  
ATOM   2870  N   ARG H 173      18.188 -17.238  34.107  1.00 16.49           N  
ATOM   2871  CA  ARG H 173      19.550 -17.659  34.435  1.00 16.71           C  
ATOM   2872  C   ARG H 173      20.623 -16.738  33.821  1.00 17.12           C  
ATOM   2873  O   ARG H 173      21.773 -16.816  34.251  1.00 20.00           O  
ATOM   2874  CB  ARG H 173      19.755 -19.108  33.954  1.00 18.69           C  
ATOM   2875  CG  ARG H 173      18.778 -20.116  34.598  1.00 20.52           C  
ATOM   2876  CD  ARG H 173      18.904 -21.546  34.046  1.00 20.33           C  
ATOM   2877  NE  ARG H 173      20.173 -22.187  34.433  1.00 22.19           N  
ATOM   2878  CZ  ARG H 173      20.568 -23.447  34.179  1.00 25.47           C  
ATOM   2879  NH1 ARG H 173      19.789 -24.323  33.525  1.00 24.95           N  
ATOM   2880  NH2 ARG H 173      21.780 -23.833  34.597  1.00 27.46           N1+
ATOM   2881  H   ARG H 173      17.802 -17.631  33.257  1.00 16.49           H  
ATOM   2882  HA  ARG H 173      19.683 -17.637  35.519  1.00 16.71           H  
ATOM   2883  HB3 ARG H 173      20.778 -19.416  34.170  1.00 18.69           H  
ATOM   2884  HB2 ARG H 173      19.654 -19.147  32.869  1.00 18.69           H  
ATOM   2885  HG3 ARG H 173      17.737 -19.798  34.541  1.00 20.52           H  
ATOM   2886  HG2 ARG H 173      19.013 -20.131  35.663  1.00 20.52           H  
ATOM   2887  HD3 ARG H 173      18.940 -21.491  32.958  1.00 20.33           H  
ATOM   2888  HD2 ARG H 173      18.030 -22.148  34.297  1.00 20.33           H  
ATOM   2889  HE  ARG H 173      20.813 -21.596  34.953  1.00 22.19           H  
ATOM   2890 HH12 ARG H 173      20.107 -25.264  33.345  1.00 24.95           H  
ATOM   2891 HH11 ARG H 173      18.874 -24.040  33.207  1.00 24.95           H  
ATOM   2892 HH22 ARG H 173      22.112 -24.771  34.424  1.00 27.46           H  
ATOM   2893 HH21 ARG H 173      22.372 -23.182  35.094  1.00 27.46           H  
ATOM   2894  N   ILE H 174      20.245 -15.893  32.843  1.00 17.69           N  
ATOM   2895  CA  ILE H 174      21.124 -14.904  32.211  1.00 17.08           C  
ATOM   2896  C   ILE H 174      21.427 -13.760  33.197  1.00 17.41           C  
ATOM   2897  O   ILE H 174      20.512 -13.283  33.869  1.00 17.14           O  
ATOM   2898  CB  ILE H 174      20.485 -14.321  30.910  1.00 19.19           C  
ATOM   2899  CG1 ILE H 174      20.347 -15.421  29.828  1.00 22.65           C  
ATOM   2900  CG2 ILE H 174      21.219 -13.091  30.320  1.00 17.62           C  
ATOM   2901  CD1 ILE H 174      19.300 -15.119  28.746  1.00 26.92           C  
ATOM   2902  H   ILE H 174      19.276 -15.867  32.555  1.00 17.69           H  
ATOM   2903  HA  ILE H 174      22.059 -15.400  31.945  1.00 17.08           H  
ATOM   2904  HB  ILE H 174      19.477 -13.993  31.166  1.00 19.19           H  
ATOM   2905 HG13 ILE H 174      20.064 -16.369  30.286  1.00 22.65           H  
ATOM   2906 HG12 ILE H 174      21.316 -15.603  29.361  1.00 22.65           H  
ATOM   2907 HG21 ILE H 174      20.774 -12.762  29.382  1.00 17.62           H  
ATOM   2908 HG22 ILE H 174      21.183 -12.228  30.985  1.00 17.62           H  
ATOM   2909 HG23 ILE H 174      22.266 -13.319  30.120  1.00 17.62           H  
ATOM   2910 HD11 ILE H 174      19.263 -15.922  28.010  1.00 26.92           H  
ATOM   2911 HD12 ILE H 174      18.306 -15.032  29.184  1.00 26.92           H  
ATOM   2912 HD13 ILE H 174      19.514 -14.195  28.211  1.00 26.92           H  
ATOM   2913  N   ARG H 175      22.704 -13.348  33.261  1.00 17.99           N  
ATOM   2914  CA  ARG H 175      23.175 -12.258  34.114  1.00 17.11           C  
ATOM   2915  C   ARG H 175      22.615 -10.907  33.640  1.00 16.67           C  
ATOM   2916  O   ARG H 175      22.907 -10.490  32.519  1.00 18.48           O  
ATOM   2917  CB  ARG H 175      24.717 -12.272  34.150  1.00 22.40           C  
ATOM   2918  CG  ARG H 175      25.337 -11.213  35.089  1.00 22.91           C  
ATOM   2919  CD  ARG H 175      26.876 -11.246  35.141  1.00 25.56           C  
ATOM   2920  NE  ARG H 175      27.492 -10.773  33.889  1.00 29.98           N  
ATOM   2921  CZ  ARG H 175      27.809  -9.513  33.543  1.00 32.86           C  
ATOM   2922  NH1 ARG H 175      27.627  -8.476  34.374  1.00 34.84           N  
ATOM   2923  NH2 ARG H 175      28.322  -9.290  32.328  1.00 37.10           N1+
ATOM   2924  H   ARG H 175      23.400 -13.789  32.671  1.00 17.99           H  
ATOM   2925  HA  ARG H 175      22.816 -12.454  35.127  1.00 17.11           H  
ATOM   2926  HB3 ARG H 175      25.100 -12.133  33.138  1.00 22.40           H  
ATOM   2927  HB2 ARG H 175      25.053 -13.261  34.465  1.00 22.40           H  
ATOM   2928  HG3 ARG H 175      24.922 -11.262  36.097  1.00 22.91           H  
ATOM   2929  HG2 ARG H 175      25.045 -10.235  34.704  1.00 22.91           H  
ATOM   2930  HD3 ARG H 175      27.188 -12.288  35.204  1.00 25.56           H  
ATOM   2931  HD2 ARG H 175      27.273 -10.767  36.036  1.00 25.56           H  
ATOM   2932  HE  ARG H 175      27.626 -11.496  33.187  1.00 29.98           H  
ATOM   2933 HH12 ARG H 175      27.877  -7.539  34.092  1.00 34.84           H  
ATOM   2934 HH11 ARG H 175      27.246  -8.634  35.296  1.00 34.84           H  
ATOM   2935 HH22 ARG H 175      28.574  -8.361  32.024  1.00 37.10           H  
ATOM   2936 HH21 ARG H 175      28.483 -10.074  31.702  1.00 37.10           H  
ATOM   2937  N   ILE H 176      21.831 -10.258  34.513  1.00 16.12           N  
ATOM   2938  CA  ILE H 176      21.219  -8.958  34.246  1.00 18.82           C  
ATOM   2939  C   ILE H 176      22.138  -7.848  34.770  1.00 20.08           C  
ATOM   2940  O   ILE H 176      22.687  -7.965  35.868  1.00 24.92           O  
ATOM   2941  CB  ILE H 176      19.836  -8.817  34.949  1.00 21.38           C  
ATOM   2942  CG1 ILE H 176      18.903 -10.004  34.624  1.00 22.78           C  
ATOM   2943  CG2 ILE H 176      19.121  -7.480  34.646  1.00 30.62           C  
ATOM   2944  CD1 ILE H 176      18.793 -10.312  33.127  1.00 26.72           C  
ATOM   2945  H   ILE H 176      21.631 -10.670  35.412  1.00 16.12           H  
ATOM   2946  HA  ILE H 176      21.086  -8.826  33.171  1.00 18.82           H  
ATOM   2947  HB  ILE H 176      20.004  -8.837  36.025  1.00 21.38           H  
ATOM   2948 HG13 ILE H 176      17.909  -9.829  35.039  1.00 22.78           H  
ATOM   2949 HG12 ILE H 176      19.268 -10.898  35.129  1.00 22.78           H  
ATOM   2950 HG21 ILE H 176      18.137  -7.448  35.115  1.00 30.62           H  
ATOM   2951 HG22 ILE H 176      19.674  -6.623  35.028  1.00 30.62           H  
ATOM   2952 HG23 ILE H 176      18.980  -7.331  33.575  1.00 30.62           H  
ATOM   2953 HD11 ILE H 176      17.852 -10.803  32.909  1.00 26.72           H  
ATOM   2954 HD12 ILE H 176      18.832  -9.406  32.524  1.00 26.72           H  
ATOM   2955 HD13 ILE H 176      19.593 -10.973  32.793  1.00 26.72           H  
ATOM   2956  N   THR H 177      22.271  -6.791  33.962  1.00 16.57           N  
ATOM   2957  CA  THR H 177      23.126  -5.641  34.228  1.00 16.73           C  
ATOM   2958  C   THR H 177      22.273  -4.367  34.360  1.00 18.55           C  
ATOM   2959  O   THR H 177      21.106  -4.358  33.965  1.00 16.05           O  
ATOM   2960  CB  THR H 177      24.142  -5.460  33.069  1.00 14.86           C  
ATOM   2961  OG1 THR H 177      23.564  -4.868  31.920  1.00 17.88           O  
ATOM   2962  CG2 THR H 177      24.845  -6.775  32.694  1.00 16.08           C  
ATOM   2963  H   THR H 177      21.775  -6.767  33.081  1.00 16.57           H  
ATOM   2964  HA  THR H 177      23.678  -5.771  35.161  1.00 16.73           H  
ATOM   2965  HB  THR H 177      24.915  -4.770  33.411  1.00 14.86           H  
ATOM   2966  HG1 THR H 177      24.239  -4.794  31.234  1.00 17.88           H  
ATOM   2967 HG21 THR H 177      25.714  -6.609  32.064  1.00 16.08           H  
ATOM   2968 HG22 THR H 177      25.187  -7.294  33.588  1.00 16.08           H  
ATOM   2969 HG23 THR H 177      24.174  -7.449  32.162  1.00 16.08           H  
ATOM   2970  N   ASP H 178      22.888  -3.306  34.905  1.00 17.48           N  
ATOM   2971  CA  ASP H 178      22.278  -1.981  35.077  1.00 19.24           C  
ATOM   2972  C   ASP H 178      21.974  -1.256  33.749  1.00 16.33           C  
ATOM   2973  O   ASP H 178      21.151  -0.343  33.757  1.00 17.83           O  
ATOM   2974  CB  ASP H 178      23.101  -1.063  36.016  1.00 20.69           C  
ATOM   2975  CG  ASP H 178      23.390  -1.609  37.428  1.00 25.04           C  
ATOM   2976  OD1 ASP H 178      22.651  -2.506  37.896  1.00 36.31           O  
ATOM   2977  OD2 ASP H 178      24.282  -1.018  38.075  1.00 39.99           O1-
ATOM   2978  H   ASP H 178      23.842  -3.392  35.223  1.00 17.48           H  
ATOM   2979  HA  ASP H 178      21.306  -2.140  35.548  1.00 19.24           H  
ATOM   2980  HB3 ASP H 178      22.589  -0.108  36.139  1.00 20.69           H  
ATOM   2981  HB2 ASP H 178      24.061  -0.849  35.545  1.00 20.69           H  
ATOM   2982  N   ASN H 179      22.587  -1.700  32.636  1.00 14.03           N  
ATOM   2983  CA  ASN H 179      22.299  -1.235  31.271  1.00 13.73           C  
ATOM   2984  C   ASN H 179      21.084  -1.949  30.641  1.00 13.20           C  
ATOM   2985  O   ASN H 179      20.821  -1.733  29.459  1.00 14.06           O  
ATOM   2986  CB  ASN H 179      23.538  -1.406  30.362  1.00 14.95           C  
ATOM   2987  CG  ASN H 179      24.807  -0.755  30.918  1.00 14.86           C  
ATOM   2988  OD1 ASN H 179      24.803   0.420  31.271  1.00 20.80           O  
ATOM   2989  ND2 ASN H 179      25.901  -1.512  31.000  1.00 20.30           N  
ATOM   2990  H   ASN H 179      23.226  -2.479  32.707  1.00 14.03           H  
ATOM   2991  HA  ASN H 179      22.044  -0.174  31.292  1.00 13.73           H  
ATOM   2992  HB3 ASN H 179      23.352  -0.963  29.382  1.00 14.95           H  
ATOM   2993  HB2 ASN H 179      23.707  -2.466  30.187  1.00 14.95           H  
ATOM   2994 HD22 ASN H 179      26.763  -1.133  31.358  1.00 20.30           H  
ATOM   2995 HD21 ASN H 179      25.872  -2.479  30.687  1.00 20.30           H  
ATOM   2996  N   MET H 180      20.369  -2.772  31.423  1.00 12.70           N  
ATOM   2997  CA  MET H 180      19.115  -3.424  31.057  1.00 12.52           C  
ATOM   2998  C   MET H 180      18.028  -3.031  32.066  1.00 12.51           C  
ATOM   2999  O   MET H 180      18.339  -2.704  33.209  1.00 16.26           O  
ATOM   3000  CB  MET H 180      19.278  -4.959  31.099  1.00 16.02           C  
ATOM   3001  CG  MET H 180      20.403  -5.530  30.229  1.00 17.43           C  
ATOM   3002  SD  MET H 180      20.688  -7.290  30.546  1.00 16.77           S  
ATOM   3003  CE  MET H 180      22.251  -7.492  29.664  1.00 18.77           C  
ATOM   3004  H   MET H 180      20.662  -2.916  32.380  1.00 12.70           H  
ATOM   3005  HA  MET H 180      18.814  -3.120  30.057  1.00 12.52           H  
ATOM   3006  HB3 MET H 180      18.342  -5.424  30.787  1.00 16.02           H  
ATOM   3007  HB2 MET H 180      19.437  -5.286  32.128  1.00 16.02           H  
ATOM   3008  HG3 MET H 180      21.338  -5.005  30.417  1.00 17.43           H  
ATOM   3009  HG2 MET H 180      20.171  -5.393  29.173  1.00 17.43           H  
ATOM   3010  HE1 MET H 180      22.616  -8.510  29.786  1.00 18.77           H  
ATOM   3011  HE2 MET H 180      22.110  -7.292  28.603  1.00 18.77           H  
ATOM   3012  HE3 MET H 180      23.007  -6.810  30.049  1.00 18.77           H  
ATOM   3013  N   PHE H 181      16.768  -3.159  31.642  1.00 11.68           N  
ATOM   3014  CA  PHE H 181      15.588  -3.240  32.502  1.00 10.64           C  
ATOM   3015  C   PHE H 181      14.605  -4.197  31.815  1.00 11.87           C  
ATOM   3016  O   PHE H 181      14.687  -4.367  30.598  1.00 13.43           O  
ATOM   3017  CB  PHE H 181      15.002  -1.830  32.761  1.00 14.39           C  
ATOM   3018  CG  PHE H 181      14.295  -1.130  31.610  1.00 14.49           C  
ATOM   3019  CD1 PHE H 181      12.921  -1.352  31.363  1.00 14.75           C  
ATOM   3020  CD2 PHE H 181      15.038  -0.348  30.703  1.00 12.05           C  
ATOM   3021  CE1 PHE H 181      12.305  -0.742  30.279  1.00 13.59           C  
ATOM   3022  CE2 PHE H 181      14.401   0.259  29.631  1.00 11.87           C  
ATOM   3023  CZ  PHE H 181      13.040   0.074  29.427  1.00 11.15           C  
ATOM   3024  H   PHE H 181      16.598  -3.388  30.670  1.00 11.68           H  
ATOM   3025  HA  PHE H 181      15.878  -3.687  33.456  1.00 10.64           H  
ATOM   3026  HB3 PHE H 181      15.793  -1.173  33.126  1.00 14.39           H  
ATOM   3027  HB2 PHE H 181      14.286  -1.892  33.579  1.00 14.39           H  
ATOM   3028  HD1 PHE H 181      12.343  -1.985  32.020  1.00 14.75           H  
ATOM   3029  HD2 PHE H 181      16.100  -0.209  30.845  1.00 12.05           H  
ATOM   3030  HE1 PHE H 181      11.252  -0.900  30.098  1.00 13.59           H  
ATOM   3031  HE2 PHE H 181      14.975   0.867  28.951  1.00 11.87           H  
ATOM   3032  HZ  PHE H 181      12.552   0.550  28.592  1.00 11.15           H  
ATOM   3033  N   CYS H 182      13.687  -4.794  32.590  1.00 12.84           N  
ATOM   3034  CA  CYS H 182      12.649  -5.667  32.041  1.00 12.97           C  
ATOM   3035  C   CYS H 182      11.257  -5.080  32.291  1.00 11.34           C  
ATOM   3036  O   CYS H 182      11.056  -4.313  33.234  1.00 13.72           O  
ATOM   3037  CB  CYS H 182      12.832  -7.119  32.541  1.00 13.16           C  
ATOM   3038  SG  CYS H 182      11.948  -7.696  34.016  1.00 17.34           S  
ATOM   3039  H   CYS H 182      13.648  -4.606  33.583  1.00 12.84           H  
ATOM   3040  HA  CYS H 182      12.750  -5.702  30.959  1.00 12.97           H  
ATOM   3041  HB3 CYS H 182      13.888  -7.318  32.695  1.00 13.16           H  
ATOM   3042  HB2 CYS H 182      12.526  -7.794  31.741  1.00 13.16           H  
ATOM   3043  N   ALA H 183      10.328  -5.468  31.410  1.00 12.26           N  
ATOM   3044  CA  ALA H 183       8.927  -5.077  31.442  1.00 13.17           C  
ATOM   3045  C   ALA H 183       8.055  -6.246  30.973  1.00 13.13           C  
ATOM   3046  O   ALA H 183       8.560  -7.199  30.378  1.00 14.35           O  
ATOM   3047  CB  ALA H 183       8.722  -3.824  30.571  1.00 12.78           C  
ATOM   3048  H   ALA H 183      10.583  -6.114  30.673  1.00 12.26           H  
ATOM   3049  HA  ALA H 183       8.650  -4.851  32.471  1.00 13.17           H  
ATOM   3050  HB1 ALA H 183       7.697  -3.458  30.637  1.00 12.78           H  
ATOM   3051  HB2 ALA H 183       9.374  -3.009  30.889  1.00 12.78           H  
ATOM   3052  HB3 ALA H 183       8.927  -4.022  29.520  1.00 12.78           H  
ATOM   3053  N   GLY H 184       6.753  -6.134  31.253  1.00 13.92           N  
ATOM   3054  CA  GLY H 184       5.756  -7.154  30.961  1.00 15.04           C  
ATOM   3055  C   GLY H 184       4.963  -7.433  32.236  1.00 16.23           C  
ATOM   3056  O   GLY H 184       5.383  -7.101  33.346  1.00 17.04           O  
ATOM   3057  H   GLY H 184       6.435  -5.328  31.777  1.00 13.92           H  
ATOM   3058  HA3 GLY H 184       6.196  -8.087  30.605  1.00 15.04           H  
ATOM   3059  HA2 GLY H 184       5.093  -6.786  30.182  1.00 15.04           H  
ATOM   3060  N   TYR H 184A      3.797  -8.064  32.059  1.00 16.96           N  
ATOM   3061  CA  TYR H 184A      2.907  -8.450  33.146  1.00 17.36           C  
ATOM   3062  C   TYR H 184A      3.339  -9.774  33.784  1.00 19.50           C  
ATOM   3063  O   TYR H 184A      3.833 -10.664  33.094  1.00 21.16           O  
ATOM   3064  CB  TYR H 184A      1.474  -8.568  32.607  1.00 19.93           C  
ATOM   3065  CG  TYR H 184A      0.858  -7.251  32.180  1.00 19.03           C  
ATOM   3066  CD1 TYR H 184A      0.297  -6.397  33.151  1.00 19.58           C  
ATOM   3067  CD2 TYR H 184A      0.836  -6.876  30.821  1.00 18.08           C  
ATOM   3068  CE1 TYR H 184A     -0.281  -5.174  32.770  1.00 19.38           C  
ATOM   3069  CE2 TYR H 184A      0.245  -5.657  30.437  1.00 21.98           C  
ATOM   3070  CZ  TYR H 184A     -0.314  -4.808  31.412  1.00 19.90           C  
ATOM   3071  OH  TYR H 184A     -0.887  -3.627  31.050  1.00 22.38           O  
ATOM   3072  H   TYR H 184A      3.523  -8.371  31.134  1.00 16.96           H  
ATOM   3073  HA  TYR H 184A      2.929  -7.662  33.898  1.00 17.36           H  
ATOM   3074  HB3 TYR H 184A      0.826  -8.992  33.376  1.00 19.93           H  
ATOM   3075  HB2 TYR H 184A      1.449  -9.273  31.776  1.00 19.93           H  
ATOM   3076  HD1 TYR H 184A      0.304  -6.678  34.192  1.00 19.58           H  
ATOM   3077  HD2 TYR H 184A      1.268  -7.521  30.070  1.00 18.08           H  
ATOM   3078  HE1 TYR H 184A     -0.707  -4.525  33.521  1.00 19.38           H  
ATOM   3079  HE2 TYR H 184A      0.224  -5.380  29.393  1.00 21.98           H  
ATOM   3080  HH  TYR H 184A     -0.961  -3.523  30.095  1.00 22.38           H  
ATOM   3081  N   LYS H 185       3.087  -9.878  35.094  1.00 24.28           N  
ATOM   3082  CA  LYS H 185       3.193 -11.099  35.890  1.00 26.42           C  
ATOM   3083  C   LYS H 185       2.021 -12.051  35.567  1.00 29.50           C  
ATOM   3084  O   LYS H 185       0.969 -11.566  35.143  1.00 30.29           O  
ATOM   3085  CB  LYS H 185       3.151 -10.700  37.378  1.00 29.98           C  
ATOM   3086  CG  LYS H 185       4.390  -9.919  37.835  1.00 33.60           C  
ATOM   3087  CD  LYS H 185       4.122  -9.042  39.067  1.00 38.17           C  
ATOM   3088  CE  LYS H 185       5.370  -8.311  39.593  1.00 39.73           C  
ATOM   3089  NZ  LYS H 185       5.949  -7.399  38.593  1.00 60.10           N1+
ATOM   3090  H   LYS H 185       2.670  -9.086  35.571  1.00 24.28           H  
ATOM   3091  HA  LYS H 185       4.155 -11.552  35.656  1.00 26.42           H  
ATOM   3092  HB3 LYS H 185       3.061 -11.585  38.007  1.00 29.98           H  
ATOM   3093  HB2 LYS H 185       2.249 -10.116  37.563  1.00 29.98           H  
ATOM   3094  HG3 LYS H 185       4.773  -9.309  37.017  1.00 33.60           H  
ATOM   3095  HG2 LYS H 185       5.176 -10.631  38.084  1.00 33.60           H  
ATOM   3096  HD3 LYS H 185       3.712  -9.663  39.865  1.00 38.17           H  
ATOM   3097  HD2 LYS H 185       3.344  -8.314  38.834  1.00 38.17           H  
ATOM   3098  HE3 LYS H 185       6.132  -9.027  39.902  1.00 39.73           H  
ATOM   3099  HE2 LYS H 185       5.107  -7.728  40.475  1.00 39.73           H  
ATOM   3100  HZ1 LYS H 185       6.711  -6.885  39.021  1.00 60.10           H  
ATOM   3101  HZ2 LYS H 185       6.289  -7.924  37.801  1.00 60.10           H  
ATOM   3102  HZ3 LYS H 185       5.246  -6.745  38.277  1.00 60.10           H  
ATOM   3103  N   PRO H 186       2.184 -13.373  35.814  1.00 31.12           N  
ATOM   3104  CA  PRO H 186       1.089 -14.359  35.667  1.00 35.93           C  
ATOM   3105  C   PRO H 186      -0.229 -14.032  36.403  1.00 38.04           C  
ATOM   3106  O   PRO H 186      -1.297 -14.316  35.862  1.00 46.92           O  
ATOM   3107  CB  PRO H 186       1.707 -15.672  36.175  1.00 38.70           C  
ATOM   3108  CG  PRO H 186       3.195 -15.506  35.933  1.00 35.76           C  
ATOM   3109  CD  PRO H 186       3.431 -14.029  36.214  1.00 32.89           C  
ATOM   3110  HA  PRO H 186       0.885 -14.452  34.599  1.00 35.93           H  
ATOM   3111  HB3 PRO H 186       1.304 -16.548  35.664  1.00 38.70           H  
ATOM   3112  HB2 PRO H 186       1.527 -15.801  37.244  1.00 38.70           H  
ATOM   3113  HG3 PRO H 186       3.400 -15.705  34.882  1.00 35.76           H  
ATOM   3114  HG2 PRO H 186       3.817 -16.171  36.532  1.00 35.76           H  
ATOM   3115  HD2 PRO H 186       3.598 -13.859  37.279  1.00 32.89           H  
ATOM   3116  HD3 PRO H 186       4.307 -13.687  35.663  1.00 32.89           H  
ATOM   3117  N   ASP H 186A     -0.127 -13.425  37.599  1.00 40.10           N  
ATOM   3118  CA  ASP H 186A     -1.254 -13.052  38.463  1.00 47.98           C  
ATOM   3119  C   ASP H 186A     -2.018 -11.793  37.997  1.00 45.07           C  
ATOM   3120  O   ASP H 186A     -3.160 -11.617  38.419  1.00 54.57           O  
ATOM   3121  CB  ASP H 186A     -0.833 -12.900  39.949  1.00 51.80           C  
ATOM   3122  CG  ASP H 186A      0.372 -11.975  40.201  1.00 58.63           C  
ATOM   3123  OD1 ASP H 186A      1.515 -12.473  40.097  1.00 69.75           O  
ATOM   3124  OD2 ASP H 186A      0.138 -10.754  40.341  1.00 57.41           O1-
ATOM   3125  H   ASP H 186A      0.789 -13.222  37.978  1.00 40.10           H  
ATOM   3126  HA  ASP H 186A     -1.969 -13.876  38.423  1.00 47.98           H  
ATOM   3127  HB3 ASP H 186A     -0.585 -13.887  40.342  1.00 51.80           H  
ATOM   3128  HB2 ASP H 186A     -1.679 -12.565  40.552  1.00 51.80           H  
ATOM   3129  N   GLU H 186B     -1.394 -10.938  37.165  1.00 43.45           N  
ATOM   3130  CA  GLU H 186B     -1.974  -9.674  36.693  1.00 40.77           C  
ATOM   3131  C   GLU H 186B     -3.044  -9.823  35.593  1.00 44.93           C  
ATOM   3132  O   GLU H 186B     -3.738  -8.845  35.314  1.00 50.64           O  
ATOM   3133  CB  GLU H 186B     -0.848  -8.699  36.288  1.00 41.65           C  
ATOM   3134  CG  GLU H 186B     -0.112  -8.119  37.518  1.00 43.84           C  
ATOM   3135  CD  GLU H 186B      1.042  -7.162  37.191  1.00 40.26           C  
ATOM   3136  OE1 GLU H 186B      1.787  -7.444  36.230  1.00 28.26           O  
ATOM   3137  OE2 GLU H 186B      1.191  -6.161  37.923  1.00 52.13           O1-
ATOM   3138  H   GLU H 186B     -0.454 -11.141  36.854  1.00 43.45           H  
ATOM   3139  HA  GLU H 186B     -2.502  -9.220  37.535  1.00 40.77           H  
ATOM   3140  HB3 GLU H 186B     -1.245  -7.879  35.688  1.00 41.65           H  
ATOM   3141  HB2 GLU H 186B     -0.140  -9.223  35.645  1.00 41.65           H  
ATOM   3142  HG3 GLU H 186B      0.293  -8.929  38.123  1.00 43.84           H  
ATOM   3143  HG2 GLU H 186B     -0.835  -7.605  38.155  1.00 43.84           H  
ATOM   3144  N   GLY H 186C     -3.186 -11.029  35.014  1.00 48.40           N  
ATOM   3145  CA  GLY H 186C     -4.223 -11.388  34.044  1.00 51.10           C  
ATOM   3146  C   GLY H 186C     -3.842 -10.930  32.631  1.00 46.67           C  
ATOM   3147  O   GLY H 186C     -3.729 -11.764  31.733  1.00 59.64           O  
ATOM   3148  H   GLY H 186C     -2.566 -11.774  35.301  1.00 48.40           H  
ATOM   3149  HA3 GLY H 186C     -5.183 -10.954  34.327  1.00 51.10           H  
ATOM   3150  HA2 GLY H 186C     -4.347 -12.471  34.057  1.00 51.10           H  
ATOM   3151  N   LYS H 186D     -3.626  -9.613  32.450  1.00 36.51           N  
ATOM   3152  CA  LYS H 186D     -3.138  -8.966  31.228  1.00 30.38           C  
ATOM   3153  C   LYS H 186D     -1.779  -9.523  30.786  1.00 25.57           C  
ATOM   3154  O   LYS H 186D     -1.039 -10.050  31.616  1.00 33.83           O  
ATOM   3155  CB  LYS H 186D     -2.986  -7.454  31.475  1.00 29.70           C  
ATOM   3156  CG  LYS H 186D     -4.277  -6.731  31.879  1.00 37.60           C  
ATOM   3157  CD  LYS H 186D     -4.077  -5.209  31.899  1.00 41.62           C  
ATOM   3158  CE  LYS H 186D     -5.302  -4.454  32.428  1.00 47.17           C  
ATOM   3159  NZ  LYS H 186D     -5.126  -2.996  32.310  1.00 53.81           N1+
ATOM   3160  H   LYS H 186D     -3.728  -9.004  33.251  1.00 36.51           H  
ATOM   3161  HA  LYS H 186D     -3.867  -9.139  30.435  1.00 30.38           H  
ATOM   3162  HB3 LYS H 186D     -2.598  -6.985  30.569  1.00 29.70           H  
ATOM   3163  HB2 LYS H 186D     -2.237  -7.285  32.249  1.00 29.70           H  
ATOM   3164  HG3 LYS H 186D     -4.596  -7.070  32.866  1.00 37.60           H  
ATOM   3165  HG2 LYS H 186D     -5.079  -6.988  31.186  1.00 37.60           H  
ATOM   3166  HD3 LYS H 186D     -3.838  -4.873  30.888  1.00 41.62           H  
ATOM   3167  HD2 LYS H 186D     -3.207  -4.969  32.512  1.00 41.62           H  
ATOM   3168  HE3 LYS H 186D     -5.485  -4.710  33.472  1.00 47.17           H  
ATOM   3169  HE2 LYS H 186D     -6.191  -4.740  31.865  1.00 47.17           H  
ATOM   3170  HZ1 LYS H 186D     -4.976  -2.753  31.340  1.00 53.81           H  
ATOM   3171  HZ2 LYS H 186D     -5.955  -2.527  32.648  1.00 53.81           H  
ATOM   3172  HZ3 LYS H 186D     -4.328  -2.708  32.855  1.00 53.81           H  
ATOM   3173  N   ARG H 187      -1.469  -9.388  29.491  1.00 24.23           N  
ATOM   3174  CA  ARG H 187      -0.265  -9.971  28.913  1.00 25.85           C  
ATOM   3175  C   ARG H 187       0.183  -9.213  27.653  1.00 22.75           C  
ATOM   3176  O   ARG H 187      -0.429  -8.215  27.269  1.00 24.13           O  
ATOM   3177  CB  ARG H 187      -0.491 -11.492  28.723  1.00 29.96           C  
ATOM   3178  CG  ARG H 187      -1.439 -11.886  27.571  1.00 35.30           C  
ATOM   3179  CD  ARG H 187      -1.839 -13.375  27.547  1.00 31.94           C  
ATOM   3180  NE  ARG H 187      -0.669 -14.269  27.574  1.00 33.16           N  
ATOM   3181  CZ  ARG H 187      -0.208 -14.989  28.613  1.00 34.00           C  
ATOM   3182  NH1 ARG H 187      -0.869 -15.099  29.773  1.00 32.84           N  
ATOM   3183  NH2 ARG H 187       0.967 -15.612  28.496  1.00 35.16           N1+
ATOM   3184  H   ARG H 187      -2.088  -8.907  28.852  1.00 24.23           H  
ATOM   3185  HA  ARG H 187       0.547  -9.843  29.629  1.00 25.85           H  
ATOM   3186  HB3 ARG H 187      -0.853 -11.935  29.652  1.00 29.96           H  
ATOM   3187  HB2 ARG H 187       0.477 -11.959  28.563  1.00 29.96           H  
ATOM   3188  HG3 ARG H 187      -1.082 -11.547  26.600  1.00 35.30           H  
ATOM   3189  HG2 ARG H 187      -2.360 -11.331  27.749  1.00 35.30           H  
ATOM   3190  HD3 ARG H 187      -2.281 -13.574  26.570  1.00 31.94           H  
ATOM   3191  HD2 ARG H 187      -2.619 -13.611  28.270  1.00 31.94           H  
ATOM   3192  HE  ARG H 187      -0.071 -14.194  26.759  1.00 33.16           H  
ATOM   3193 HH12 ARG H 187      -0.448 -15.604  30.544  1.00 32.84           H  
ATOM   3194 HH11 ARG H 187      -1.777 -14.669  29.898  1.00 32.84           H  
ATOM   3195 HH22 ARG H 187       1.340 -16.117  29.292  1.00 35.16           H  
ATOM   3196 HH21 ARG H 187       1.536 -15.511  27.664  1.00 35.16           H  
ATOM   3197  N   GLY H 188       1.271  -9.714  27.057  1.00 19.25           N  
ATOM   3198  CA  GLY H 188       1.875  -9.217  25.832  1.00 18.51           C  
ATOM   3199  C   GLY H 188       3.380  -9.021  26.027  1.00 15.16           C  
ATOM   3200  O   GLY H 188       3.878  -8.929  27.149  1.00 16.88           O  
ATOM   3201  H   GLY H 188       1.696 -10.551  27.438  1.00 19.25           H  
ATOM   3202  HA3 GLY H 188       1.410  -8.303  25.467  1.00 18.51           H  
ATOM   3203  HA2 GLY H 188       1.729  -9.996  25.087  1.00 18.51           H  
ATOM   3204  N   ASP H 189       4.107  -8.971  24.903  1.00 15.30           N  
ATOM   3205  CA  ASP H 189       5.571  -8.968  24.854  1.00 15.11           C  
ATOM   3206  C   ASP H 189       5.995  -8.549  23.435  1.00 13.43           C  
ATOM   3207  O   ASP H 189       5.210  -8.653  22.493  1.00 16.87           O  
ATOM   3208  CB  ASP H 189       6.143 -10.373  25.236  1.00 14.63           C  
ATOM   3209  CG  ASP H 189       7.636 -10.501  25.622  1.00 17.99           C  
ATOM   3210  OD1 ASP H 189       8.357  -9.482  25.679  1.00 17.91           O  
ATOM   3211  OD2 ASP H 189       8.048 -11.652  25.886  1.00 20.03           O1-
ATOM   3212  H   ASP H 189       3.642  -9.015  24.006  1.00 15.30           H  
ATOM   3213  HA  ASP H 189       5.938  -8.216  25.552  1.00 15.11           H  
ATOM   3214  HB3 ASP H 189       5.943 -11.066  24.417  1.00 14.63           H  
ATOM   3215  HB2 ASP H 189       5.573 -10.776  26.074  1.00 14.63           H  
ATOM   3216  N   ALA H 190       7.267  -8.153  23.302  1.00 14.66           N  
ATOM   3217  CA  ALA H 190       8.007  -8.182  22.046  1.00 14.41           C  
ATOM   3218  C   ALA H 190       8.313  -9.630  21.611  1.00 15.38           C  
ATOM   3219  O   ALA H 190       8.251 -10.558  22.418  1.00 17.31           O  
ATOM   3220  CB  ALA H 190       9.309  -7.390  22.234  1.00 14.91           C  
ATOM   3221  H   ALA H 190       7.840  -8.135  24.137  1.00 14.66           H  
ATOM   3222  HA  ALA H 190       7.409  -7.702  21.273  1.00 14.41           H  
ATOM   3223  HB1 ALA H 190       9.920  -7.419  21.333  1.00 14.91           H  
ATOM   3224  HB2 ALA H 190       9.104  -6.344  22.454  1.00 14.91           H  
ATOM   3225  HB3 ALA H 190       9.905  -7.789  23.055  1.00 14.91           H  
ATOM   3226  N   CYS H 191       8.657  -9.791  20.329  1.00 17.79           N  
ATOM   3227  CA  CYS H 191       9.034 -11.066  19.731  1.00 18.76           C  
ATOM   3228  C   CYS H 191      10.082 -10.842  18.631  1.00 20.92           C  
ATOM   3229  O   CYS H 191      10.587  -9.727  18.487  1.00 20.72           O  
ATOM   3230  CB  CYS H 191       7.757 -11.798  19.254  1.00 20.23           C  
ATOM   3231  SG  CYS H 191       7.871 -13.600  19.059  1.00 24.76           S  
ATOM   3232  H   CYS H 191       8.647  -8.994  19.703  1.00 17.79           H  
ATOM   3233  HA  CYS H 191       9.542 -11.653  20.494  1.00 18.76           H  
ATOM   3234  HB3 CYS H 191       7.414 -11.368  18.313  1.00 20.23           H  
ATOM   3235  HB2 CYS H 191       6.949 -11.628  19.965  1.00 20.23           H  
ATOM   3236  N   GLU H 192      10.418 -11.910  17.885  1.00 22.96           N  
ATOM   3237  CA  GLU H 192      11.342 -11.874  16.749  1.00 21.48           C  
ATOM   3238  C   GLU H 192      10.909 -10.854  15.683  1.00 23.50           C  
ATOM   3239  O   GLU H 192       9.785 -10.950  15.202  1.00 24.32           O  
ATOM   3240  CB  GLU H 192      11.489 -13.288  16.143  1.00 30.13           C  
ATOM   3241  CG  GLU H 192      12.327 -13.332  14.839  1.00 40.51           C  
ATOM   3242  CD  GLU H 192      12.522 -14.729  14.242  1.00 52.01           C  
ATOM   3243  OE1 GLU H 192      13.661 -14.997  13.800  1.00 70.02           O  
ATOM   3244  OE2 GLU H 192      11.535 -15.497  14.202  1.00 62.05           O1-
ATOM   3245  H   GLU H 192       9.974 -12.799  18.067  1.00 22.96           H  
ATOM   3246  HA  GLU H 192      12.314 -11.573  17.143  1.00 21.48           H  
ATOM   3247  HB3 GLU H 192      10.497 -13.702  15.966  1.00 30.13           H  
ATOM   3248  HB2 GLU H 192      11.957 -13.940  16.883  1.00 30.13           H  
ATOM   3249  HG3 GLU H 192      13.300 -12.875  15.024  1.00 40.51           H  
ATOM   3250  HG2 GLU H 192      11.857 -12.740  14.053  1.00 40.51           H  
ATOM   3251  N   GLY H 193      11.823  -9.939  15.330  1.00 19.77           N  
ATOM   3252  CA  GLY H 193      11.618  -8.885  14.339  1.00 19.92           C  
ATOM   3253  C   GLY H 193      11.221  -7.549  14.989  1.00 16.53           C  
ATOM   3254  O   GLY H 193      11.340  -6.520  14.325  1.00 18.99           O  
ATOM   3255  H   GLY H 193      12.743  -9.990  15.748  1.00 19.77           H  
ATOM   3256  HA3 GLY H 193      10.876  -9.171  13.595  1.00 19.92           H  
ATOM   3257  HA2 GLY H 193      12.555  -8.742  13.800  1.00 19.92           H  
ATOM   3258  N   ASP H 194      10.805  -7.540  16.271  1.00 15.27           N  
ATOM   3259  CA  ASP H 194      10.605  -6.328  17.084  1.00 13.27           C  
ATOM   3260  C   ASP H 194      11.910  -5.780  17.670  1.00 13.08           C  
ATOM   3261  O   ASP H 194      11.907  -4.639  18.131  1.00 13.68           O  
ATOM   3262  CB  ASP H 194       9.593  -6.522  18.235  1.00 15.78           C  
ATOM   3263  CG  ASP H 194       8.202  -6.959  17.778  1.00 15.81           C  
ATOM   3264  OD1 ASP H 194       7.737  -6.451  16.738  1.00 16.41           O  
ATOM   3265  OD2 ASP H 194       7.560  -7.697  18.549  1.00 17.76           O1-
ATOM   3266  H   ASP H 194      10.706  -8.418  16.764  1.00 15.27           H  
ATOM   3267  HA  ASP H 194      10.220  -5.549  16.426  1.00 13.27           H  
ATOM   3268  HB3 ASP H 194       9.469  -5.594  18.797  1.00 15.78           H  
ATOM   3269  HB2 ASP H 194       9.982  -7.261  18.936  1.00 15.78           H  
ATOM   3270  N   SER H 195      12.982  -6.587  17.615  1.00 13.55           N  
ATOM   3271  CA  SER H 195      14.377  -6.282  17.927  1.00 15.14           C  
ATOM   3272  C   SER H 195      14.807  -4.884  17.476  1.00 10.77           C  
ATOM   3273  O   SER H 195      14.578  -4.537  16.322  1.00 14.35           O  
ATOM   3274  CB  SER H 195      15.226  -7.310  17.170  1.00 18.61           C  
ATOM   3275  OG  SER H 195      15.172  -8.564  17.795  1.00 21.11           O  
ATOM   3276  H   SER H 195      12.842  -7.514  17.237  1.00 13.55           H  
ATOM   3277  HA  SER H 195      14.543  -6.380  18.999  1.00 15.14           H  
ATOM   3278  HB3 SER H 195      16.271  -7.004  17.144  1.00 18.61           H  
ATOM   3279  HB2 SER H 195      14.890  -7.418  16.137  1.00 18.61           H  
ATOM   3280  HG  SER H 195      15.945  -8.642  18.365  1.00 21.11           H  
ATOM   3281  N   GLY H 196      15.407  -4.108  18.383  1.00 10.72           N  
ATOM   3282  CA  GLY H 196      15.868  -2.758  18.089  1.00 11.21           C  
ATOM   3283  C   GLY H 196      14.750  -1.707  18.116  1.00 10.85           C  
ATOM   3284  O   GLY H 196      15.062  -0.533  17.950  1.00 11.85           O  
ATOM   3285  H   GLY H 196      15.560  -4.452  19.324  1.00 10.72           H  
ATOM   3286  HA3 GLY H 196      16.363  -2.732  17.118  1.00 11.21           H  
ATOM   3287  HA2 GLY H 196      16.615  -2.488  18.825  1.00 11.21           H  
ATOM   3288  N   GLY H 197      13.477  -2.090  18.321  1.00 10.11           N  
ATOM   3289  CA  GLY H 197      12.327  -1.186  18.375  1.00 10.07           C  
ATOM   3290  C   GLY H 197      12.305  -0.377  19.681  1.00  9.79           C  
ATOM   3291  O   GLY H 197      12.910  -0.800  20.663  1.00 11.45           O  
ATOM   3292  H   GLY H 197      13.279  -3.075  18.440  1.00 10.11           H  
ATOM   3293  HA3 GLY H 197      11.418  -1.780  18.358  1.00 10.07           H  
ATOM   3294  HA2 GLY H 197      12.329  -0.550  17.489  1.00 10.07           H  
ATOM   3295  N   PRO H 198      11.603   0.772  19.723  1.00 10.06           N  
ATOM   3296  CA  PRO H 198      11.575   1.640  20.909  1.00 10.06           C  
ATOM   3297  C   PRO H 198      10.561   1.198  21.985  1.00 10.26           C  
ATOM   3298  O   PRO H 198       9.415   0.891  21.657  1.00 11.31           O  
ATOM   3299  CB  PRO H 198      11.215   3.000  20.294  1.00 12.42           C  
ATOM   3300  CG  PRO H 198      10.307   2.672  19.118  1.00 12.11           C  
ATOM   3301  CD  PRO H 198      10.900   1.371  18.588  1.00  9.14           C  
ATOM   3302  HA  PRO H 198      12.565   1.702  21.361  1.00 10.06           H  
ATOM   3303  HB3 PRO H 198      12.124   3.472  19.926  1.00 12.42           H  
ATOM   3304  HB2 PRO H 198      10.773   3.697  21.000  1.00 12.42           H  
ATOM   3305  HG3 PRO H 198      10.266   3.460  18.366  1.00 12.11           H  
ATOM   3306  HG2 PRO H 198       9.291   2.495  19.468  1.00 12.11           H  
ATOM   3307  HD2 PRO H 198      10.135   0.708  18.183  1.00  9.14           H  
ATOM   3308  HD3 PRO H 198      11.620   1.595  17.801  1.00  9.14           H  
ATOM   3309  N   PHE H 199      11.002   1.237  23.253  1.00  9.12           N  
ATOM   3310  CA  PHE H 199      10.147   1.275  24.442  1.00  8.38           C  
ATOM   3311  C   PHE H 199      10.033   2.760  24.829  1.00  8.52           C  
ATOM   3312  O   PHE H 199      11.038   3.333  25.251  1.00  9.92           O  
ATOM   3313  CB  PHE H 199      10.779   0.415  25.563  1.00 10.75           C  
ATOM   3314  CG  PHE H 199      10.033   0.308  26.891  1.00 10.28           C  
ATOM   3315  CD1 PHE H 199      10.037   1.373  27.820  1.00 11.80           C  
ATOM   3316  CD2 PHE H 199       9.263  -0.838  27.185  1.00 11.65           C  
ATOM   3317  CE1 PHE H 199       9.330   1.265  29.010  1.00 12.97           C  
ATOM   3318  CE2 PHE H 199       8.543  -0.918  28.369  1.00 12.20           C  
ATOM   3319  CZ  PHE H 199       8.581   0.127  29.281  1.00 13.32           C  
ATOM   3320  H   PHE H 199      11.973   1.468  23.420  1.00  9.12           H  
ATOM   3321  HA  PHE H 199       9.173   0.851  24.218  1.00  8.38           H  
ATOM   3322  HB3 PHE H 199      11.762   0.809  25.791  1.00 10.75           H  
ATOM   3323  HB2 PHE H 199      10.950  -0.591  25.181  1.00 10.75           H  
ATOM   3324  HD1 PHE H 199      10.605   2.268  27.622  1.00 11.80           H  
ATOM   3325  HD2 PHE H 199       9.251  -1.675  26.509  1.00 11.65           H  
ATOM   3326  HE1 PHE H 199       9.351   2.075  29.724  1.00 12.97           H  
ATOM   3327  HE2 PHE H 199       7.957  -1.799  28.584  1.00 12.20           H  
ATOM   3328  HZ  PHE H 199       8.017   0.056  30.198  1.00 13.32           H  
ATOM   3329  N   VAL H 200       8.847   3.363  24.644  1.00  8.31           N  
ATOM   3330  CA  VAL H 200       8.611   4.793  24.871  1.00  8.93           C  
ATOM   3331  C   VAL H 200       7.635   5.039  26.032  1.00  8.06           C  
ATOM   3332  O   VAL H 200       6.744   4.231  26.270  1.00 11.78           O  
ATOM   3333  CB  VAL H 200       8.049   5.511  23.609  1.00  8.65           C  
ATOM   3334  CG1 VAL H 200       9.020   5.417  22.427  1.00 10.10           C  
ATOM   3335  CG2 VAL H 200       6.643   5.063  23.165  1.00 11.68           C  
ATOM   3336  H   VAL H 200       8.061   2.827  24.294  1.00  8.31           H  
ATOM   3337  HA  VAL H 200       9.549   5.269  25.137  1.00  8.93           H  
ATOM   3338  HB  VAL H 200       7.983   6.574  23.849  1.00  8.65           H  
ATOM   3339 HG11 VAL H 200       8.713   6.073  21.613  1.00 10.10           H  
ATOM   3340 HG12 VAL H 200      10.033   5.697  22.711  1.00 10.10           H  
ATOM   3341 HG13 VAL H 200       9.037   4.400  22.042  1.00 10.10           H  
ATOM   3342 HG21 VAL H 200       6.332   5.581  22.258  1.00 11.68           H  
ATOM   3343 HG22 VAL H 200       6.617   3.996  22.963  1.00 11.68           H  
ATOM   3344 HG23 VAL H 200       5.887   5.263  23.919  1.00 11.68           H  
ATOM   3345  N   MET H 201       7.817   6.175  26.718  1.00  9.43           N  
ATOM   3346  CA  MET H 201       6.985   6.643  27.824  1.00  9.42           C  
ATOM   3347  C   MET H 201       6.659   8.119  27.581  1.00  8.50           C  
ATOM   3348  O   MET H 201       7.574   8.893  27.298  1.00 10.39           O  
ATOM   3349  CB  MET H 201       7.739   6.461  29.162  1.00 11.27           C  
ATOM   3350  CG  MET H 201       8.116   5.000  29.454  1.00 11.59           C  
ATOM   3351  SD  MET H 201       8.900   4.679  31.052  1.00 13.19           S  
ATOM   3352  CE  MET H 201       7.458   4.722  32.126  1.00 14.97           C  
ATOM   3353  H   MET H 201       8.582   6.788  26.461  1.00  9.43           H  
ATOM   3354  HA  MET H 201       6.048   6.083  27.863  1.00  9.42           H  
ATOM   3355  HB3 MET H 201       7.131   6.845  29.981  1.00 11.27           H  
ATOM   3356  HB2 MET H 201       8.650   7.063  29.161  1.00 11.27           H  
ATOM   3357  HG3 MET H 201       8.799   4.626  28.692  1.00 11.59           H  
ATOM   3358  HG2 MET H 201       7.225   4.383  29.396  1.00 11.59           H  
ATOM   3359  HE1 MET H 201       7.719   4.303  33.092  1.00 14.97           H  
ATOM   3360  HE2 MET H 201       7.101   5.743  32.258  1.00 14.97           H  
ATOM   3361  HE3 MET H 201       6.663   4.111  31.712  1.00 14.97           H  
ATOM   3362  N   LYS H 202       5.375   8.490  27.718  1.00  9.54           N  
ATOM   3363  CA  LYS H 202       4.946   9.885  27.656  1.00 11.16           C  
ATOM   3364  C   LYS H 202       5.152  10.532  29.029  1.00 10.23           C  
ATOM   3365  O   LYS H 202       4.478  10.146  29.977  1.00 11.88           O  
ATOM   3366  CB  LYS H 202       3.479   9.989  27.189  1.00 10.66           C  
ATOM   3367  CG  LYS H 202       3.035  11.449  26.976  1.00 12.15           C  
ATOM   3368  CD  LYS H 202       1.641  11.607  26.354  1.00 10.47           C  
ATOM   3369  CE  LYS H 202       1.258  13.093  26.282  1.00 13.12           C  
ATOM   3370  NZ  LYS H 202      -0.030  13.319  25.614  1.00 11.98           N1+
ATOM   3371  H   LYS H 202       4.671   7.811  27.973  1.00  9.54           H  
ATOM   3372  HA  LYS H 202       5.553  10.415  26.923  1.00 11.16           H  
ATOM   3373  HB3 LYS H 202       2.810   9.491  27.893  1.00 10.66           H  
ATOM   3374  HB2 LYS H 202       3.374   9.456  26.249  1.00 10.66           H  
ATOM   3375  HG3 LYS H 202       3.763  11.955  26.340  1.00 12.15           H  
ATOM   3376  HG2 LYS H 202       3.050  11.977  27.930  1.00 12.15           H  
ATOM   3377  HD3 LYS H 202       0.908  11.055  26.945  1.00 10.47           H  
ATOM   3378  HD2 LYS H 202       1.633  11.166  25.357  1.00 10.47           H  
ATOM   3379  HE3 LYS H 202       2.016  13.644  25.730  1.00 13.12           H  
ATOM   3380  HE2 LYS H 202       1.210  13.515  27.286  1.00 13.12           H  
ATOM   3381  HZ1 LYS H 202       0.045  13.029  24.648  1.00 11.98           H  
ATOM   3382  HZ2 LYS H 202      -0.757  12.771  26.058  1.00 11.98           H  
ATOM   3383  HZ3 LYS H 202      -0.274  14.298  25.648  1.00 11.98           H  
ATOM   3384  N   SER H 203       6.057  11.514  29.115  1.00 11.40           N  
ATOM   3385  CA  SER H 203       6.296  12.288  30.331  1.00 10.61           C  
ATOM   3386  C   SER H 203       5.036  13.092  30.727  1.00 11.07           C  
ATOM   3387  O   SER H 203       4.577  13.884  29.907  1.00 11.54           O  
ATOM   3388  CB  SER H 203       7.482  13.226  30.055  1.00 14.01           C  
ATOM   3389  OG  SER H 203       7.687  14.124  31.126  1.00 16.70           O  
ATOM   3390  H   SER H 203       6.567  11.801  28.289  1.00 11.40           H  
ATOM   3391  HA  SER H 203       6.598  11.586  31.106  1.00 10.61           H  
ATOM   3392  HB3 SER H 203       7.309  13.797  29.143  1.00 14.01           H  
ATOM   3393  HB2 SER H 203       8.394  12.649  29.909  1.00 14.01           H  
ATOM   3394  HG  SER H 203       8.524  14.585  30.991  1.00 16.70           H  
ATOM   3395  N   PRO H 204       4.501  12.904  31.955  1.00 12.06           N  
ATOM   3396  CA  PRO H 204       3.373  13.722  32.438  1.00 12.30           C  
ATOM   3397  C   PRO H 204       3.748  15.181  32.789  1.00 13.68           C  
ATOM   3398  O   PRO H 204       2.846  15.973  33.054  1.00 15.14           O  
ATOM   3399  CB  PRO H 204       2.875  12.932  33.660  1.00 15.63           C  
ATOM   3400  CG  PRO H 204       4.126  12.276  34.221  1.00 14.95           C  
ATOM   3401  CD  PRO H 204       4.942  11.948  32.974  1.00 11.47           C  
ATOM   3402  HA  PRO H 204       2.580  13.758  31.689  1.00 12.30           H  
ATOM   3403  HB3 PRO H 204       2.176  12.162  33.328  1.00 15.63           H  
ATOM   3404  HB2 PRO H 204       2.357  13.543  34.400  1.00 15.63           H  
ATOM   3405  HG3 PRO H 204       3.920  11.404  34.843  1.00 14.95           H  
ATOM   3406  HG2 PRO H 204       4.667  13.001  34.830  1.00 14.95           H  
ATOM   3407  HD2 PRO H 204       6.009  12.017  33.189  1.00 11.47           H  
ATOM   3408  HD3 PRO H 204       4.717  10.939  32.628  1.00 11.47           H  
ATOM   3409  N   PHE H 204A      5.054  15.508  32.780  1.00 13.59           N  
ATOM   3410  CA  PHE H 204A      5.598  16.820  33.131  1.00 12.93           C  
ATOM   3411  C   PHE H 204A      5.545  17.821  31.967  1.00 12.82           C  
ATOM   3412  O   PHE H 204A      5.290  18.998  32.218  1.00 12.27           O  
ATOM   3413  CB  PHE H 204A      7.050  16.662  33.627  1.00 15.02           C  
ATOM   3414  CG  PHE H 204A      7.195  15.754  34.833  1.00 15.71           C  
ATOM   3415  CD1 PHE H 204A      6.897  16.237  36.124  1.00 18.34           C  
ATOM   3416  CD2 PHE H 204A      7.441  14.376  34.656  1.00 16.75           C  
ATOM   3417  CE1 PHE H 204A      6.902  15.368  37.207  1.00 18.96           C  
ATOM   3418  CE2 PHE H 204A      7.429  13.523  35.748  1.00 17.77           C  
ATOM   3419  CZ  PHE H 204A      7.167  14.018  37.019  1.00 17.63           C  
ATOM   3420  H   PHE H 204A      5.738  14.801  32.549  1.00 13.59           H  
ATOM   3421  HA  PHE H 204A      5.005  17.232  33.951  1.00 12.93           H  
ATOM   3422  HB3 PHE H 204A      7.454  17.641  33.889  1.00 15.02           H  
ATOM   3423  HB2 PHE H 204A      7.687  16.283  32.826  1.00 15.02           H  
ATOM   3424  HD1 PHE H 204A      6.657  17.280  36.272  1.00 18.34           H  
ATOM   3425  HD2 PHE H 204A      7.624  13.972  33.673  1.00 16.75           H  
ATOM   3426  HE1 PHE H 204A      6.682  15.741  38.197  1.00 18.96           H  
ATOM   3427  HE2 PHE H 204A      7.609  12.469  35.601  1.00 17.77           H  
ATOM   3428  HZ  PHE H 204A      7.156  13.347  37.865  1.00 17.63           H  
ATOM   3429  N   ASN H 204B      5.794  17.348  30.733  1.00 12.72           N  
ATOM   3430  CA  ASN H 204B      5.876  18.194  29.534  1.00 13.73           C  
ATOM   3431  C   ASN H 204B      5.097  17.636  28.329  1.00 13.53           C  
ATOM   3432  O   ASN H 204B      5.051  18.309  27.300  1.00 14.85           O  
ATOM   3433  CB  ASN H 204B      7.357  18.526  29.209  1.00 14.25           C  
ATOM   3434  CG  ASN H 204B      8.250  17.356  28.768  1.00 14.37           C  
ATOM   3435  OD1 ASN H 204B      7.800  16.230  28.575  1.00 20.80           O  
ATOM   3436  ND2 ASN H 204B      9.543  17.636  28.600  1.00 11.48           N  
ATOM   3437  H   ASN H 204B      6.014  16.370  30.609  1.00 12.72           H  
ATOM   3438  HA  ASN H 204B      5.377  19.145  29.727  1.00 13.73           H  
ATOM   3439  HB3 ASN H 204B      7.816  18.987  30.084  1.00 14.25           H  
ATOM   3440  HB2 ASN H 204B      7.391  19.281  28.422  1.00 14.25           H  
ATOM   3441 HD22 ASN H 204B     10.187  16.909  28.310  1.00 11.48           H  
ATOM   3442 HD21 ASN H 204B      9.895  18.567  28.768  1.00 11.48           H  
ATOM   3443  N   ASN H 205       4.501  16.438  28.471  1.00 14.85           N  
ATOM   3444  CA  ASN H 205       3.657  15.756  27.479  1.00 13.60           C  
ATOM   3445  C   ASN H 205       4.410  15.403  26.180  1.00 12.27           C  
ATOM   3446  O   ASN H 205       3.803  15.403  25.111  1.00 17.41           O  
ATOM   3447  CB  ASN H 205       2.334  16.537  27.256  1.00 23.89           C  
ATOM   3448  CG  ASN H 205       1.514  16.654  28.547  1.00 36.17           C  
ATOM   3449  OD1 ASN H 205       1.049  15.649  29.079  1.00 53.46           O  
ATOM   3450  ND2 ASN H 205       1.338  17.875  29.055  1.00 38.51           N  
ATOM   3451  H   ASN H 205       4.597  15.946  29.349  1.00 14.85           H  
ATOM   3452  HA  ASN H 205       3.391  14.795  27.916  1.00 13.60           H  
ATOM   3453  HB3 ASN H 205       1.707  16.021  26.529  1.00 23.89           H  
ATOM   3454  HB2 ASN H 205       2.527  17.525  26.837  1.00 23.89           H  
ATOM   3455 HD22 ASN H 205       0.808  17.994  29.907  1.00 38.51           H  
ATOM   3456 HD21 ASN H 205       1.733  18.684  28.599  1.00 38.51           H  
ATOM   3457  N   ARG H 206       5.707  15.075  26.307  1.00 12.03           N  
ATOM   3458  CA  ARG H 206       6.548  14.568  25.223  1.00 10.83           C  
ATOM   3459  C   ARG H 206       6.826  13.080  25.437  1.00  9.53           C  
ATOM   3460  O   ARG H 206       6.994  12.642  26.575  1.00 10.56           O  
ATOM   3461  CB  ARG H 206       7.893  15.318  25.178  1.00 12.58           C  
ATOM   3462  CG  ARG H 206       7.773  16.830  24.961  1.00 16.11           C  
ATOM   3463  CD  ARG H 206       9.149  17.505  24.931  1.00 17.64           C  
ATOM   3464  NE  ARG H 206       9.038  18.955  24.701  1.00 23.04           N  
ATOM   3465  CZ  ARG H 206       9.252  19.628  23.556  1.00 20.10           C  
ATOM   3466  NH1 ARG H 206       9.601  19.017  22.417  1.00 23.16           N  
ATOM   3467  NH2 ARG H 206       9.121  20.959  23.549  1.00 23.48           N1+
ATOM   3468  H   ARG H 206       6.139  15.108  27.220  1.00 12.03           H  
ATOM   3469  HA  ARG H 206       6.048  14.701  24.263  1.00 10.83           H  
ATOM   3470  HB3 ARG H 206       8.507  14.901  24.377  1.00 12.58           H  
ATOM   3471  HB2 ARG H 206       8.444  15.139  26.102  1.00 12.58           H  
ATOM   3472  HG3 ARG H 206       7.200  17.246  25.791  1.00 16.11           H  
ATOM   3473  HG2 ARG H 206       7.215  17.059  24.055  1.00 16.11           H  
ATOM   3474  HD3 ARG H 206       9.819  17.015  24.225  1.00 17.64           H  
ATOM   3475  HD2 ARG H 206       9.622  17.389  25.904  1.00 17.64           H  
ATOM   3476  HE  ARG H 206       8.749  19.489  25.508  1.00 23.04           H  
ATOM   3477 HH12 ARG H 206       9.809  19.562  21.593  1.00 23.16           H  
ATOM   3478 HH11 ARG H 206       9.661  18.007  22.372  1.00 23.16           H  
ATOM   3479 HH22 ARG H 206       9.310  21.481  22.704  1.00 23.48           H  
ATOM   3480 HH21 ARG H 206       8.861  21.457  24.388  1.00 23.48           H  
ATOM   3481  N   TRP H 207       6.929  12.348  24.321  1.00  9.95           N  
ATOM   3482  CA  TRP H 207       7.353  10.954  24.286  1.00  8.36           C  
ATOM   3483  C   TRP H 207       8.881  10.847  24.308  1.00  8.47           C  
ATOM   3484  O   TRP H 207       9.554  11.454  23.475  1.00  9.58           O  
ATOM   3485  CB  TRP H 207       6.760  10.273  23.050  1.00  8.47           C  
ATOM   3486  CG  TRP H 207       5.269  10.129  23.085  1.00  9.06           C  
ATOM   3487  CD1 TRP H 207       4.372  11.054  22.680  1.00  9.30           C  
ATOM   3488  CD2 TRP H 207       4.480   9.038  23.644  1.00  9.26           C  
ATOM   3489  NE1 TRP H 207       3.098  10.602  22.915  1.00  9.96           N  
ATOM   3490  CE2 TRP H 207       3.097   9.358  23.496  1.00  9.62           C  
ATOM   3491  CE3 TRP H 207       4.789   7.812  24.273  1.00 10.03           C  
ATOM   3492  CZ2 TRP H 207       2.071   8.505  23.929  1.00 11.53           C  
ATOM   3493  CZ3 TRP H 207       3.770   6.946  24.717  1.00 11.26           C  
ATOM   3494  CH2 TRP H 207       2.416   7.293  24.547  1.00 12.11           C  
ATOM   3495  H   TRP H 207       6.760  12.785  23.425  1.00  9.95           H  
ATOM   3496  HA  TRP H 207       6.961  10.435  25.161  1.00  8.36           H  
ATOM   3497  HB3 TRP H 207       7.179   9.271  22.940  1.00  8.47           H  
ATOM   3498  HB2 TRP H 207       7.045  10.822  22.153  1.00  8.47           H  
ATOM   3499  HD1 TRP H 207       4.610  12.003  22.236  1.00  9.30           H  
ATOM   3500  HE1 TRP H 207       2.282  11.169  22.713  1.00  9.96           H  
ATOM   3501  HE3 TRP H 207       5.824   7.545  24.426  1.00 10.03           H  
ATOM   3502  HZ2 TRP H 207       1.035   8.785  23.804  1.00 11.53           H  
ATOM   3503  HZ3 TRP H 207       4.033   6.014  25.196  1.00 11.26           H  
ATOM   3504  HH2 TRP H 207       1.631   6.638  24.890  1.00 12.11           H  
ATOM   3505  N   TYR H 208       9.372  10.049  25.264  1.00  8.36           N  
ATOM   3506  CA  TYR H 208      10.780   9.749  25.480  1.00  9.51           C  
ATOM   3507  C   TYR H 208      11.002   8.254  25.299  1.00  8.19           C  
ATOM   3508  O   TYR H 208      10.270   7.470  25.899  1.00 12.10           O  
ATOM   3509  CB  TYR H 208      11.162  10.127  26.919  1.00 10.53           C  
ATOM   3510  CG  TYR H 208      11.262  11.613  27.154  1.00 11.54           C  
ATOM   3511  CD1 TYR H 208      12.489  12.261  26.930  1.00 12.47           C  
ATOM   3512  CD2 TYR H 208      10.147  12.348  27.598  1.00 10.85           C  
ATOM   3513  CE1 TYR H 208      12.618  13.638  27.170  1.00 13.30           C  
ATOM   3514  CE2 TYR H 208      10.271  13.731  27.827  1.00 12.45           C  
ATOM   3515  CZ  TYR H 208      11.506  14.375  27.619  1.00 15.06           C  
ATOM   3516  OH  TYR H 208      11.629  15.711  27.853  1.00 16.20           O  
ATOM   3517  H   TYR H 208       8.732   9.597  25.905  1.00  8.36           H  
ATOM   3518  HA  TYR H 208      11.404  10.304  24.783  1.00  9.51           H  
ATOM   3519  HB3 TYR H 208      12.142   9.710  27.155  1.00 10.53           H  
ATOM   3520  HB2 TYR H 208      10.468   9.688  27.639  1.00 10.53           H  
ATOM   3521  HD1 TYR H 208      13.330  11.697  26.565  1.00 12.47           H  
ATOM   3522  HD2 TYR H 208       9.203  11.852  27.767  1.00 10.85           H  
ATOM   3523  HE1 TYR H 208      13.567  14.124  26.999  1.00 13.30           H  
ATOM   3524  HE2 TYR H 208       9.420  14.296  28.172  1.00 12.45           H  
ATOM   3525  HH  TYR H 208      12.541  16.018  27.771  1.00 16.20           H  
ATOM   3526  N   GLN H 209      12.046   7.890  24.543  1.00  9.06           N  
ATOM   3527  CA  GLN H 209      12.480   6.508  24.412  1.00  9.83           C  
ATOM   3528  C   GLN H 209      13.406   6.128  25.573  1.00  7.85           C  
ATOM   3529  O   GLN H 209      14.566   6.538  25.593  1.00 10.88           O  
ATOM   3530  CB  GLN H 209      13.150   6.295  23.055  1.00  9.96           C  
ATOM   3531  CG  GLN H 209      13.542   4.822  22.848  1.00 11.04           C  
ATOM   3532  CD  GLN H 209      14.287   4.589  21.550  1.00  8.44           C  
ATOM   3533  OE1 GLN H 209      14.473   5.504  20.755  1.00 12.26           O  
ATOM   3534  NE2 GLN H 209      14.707   3.345  21.340  1.00  9.00           N  
ATOM   3535  H   GLN H 209      12.617   8.592  24.087  1.00  9.06           H  
ATOM   3536  HA  GLN H 209      11.608   5.855  24.434  1.00  9.83           H  
ATOM   3537  HB3 GLN H 209      14.023   6.943  22.965  1.00  9.96           H  
ATOM   3538  HB2 GLN H 209      12.459   6.596  22.267  1.00  9.96           H  
ATOM   3539  HG3 GLN H 209      12.649   4.194  22.862  1.00 11.04           H  
ATOM   3540  HG2 GLN H 209      14.187   4.467  23.650  1.00 11.04           H  
ATOM   3541 HE22 GLN H 209      15.157   3.088  20.469  1.00  9.00           H  
ATOM   3542 HE21 GLN H 209      14.539   2.632  22.036  1.00  9.00           H  
ATOM   3543  N   MET H 210      12.865   5.323  26.492  1.00  8.88           N  
ATOM   3544  CA  MET H 210      13.569   4.839  27.673  1.00  7.86           C  
ATOM   3545  C   MET H 210      14.309   3.519  27.422  1.00  8.28           C  
ATOM   3546  O   MET H 210      15.308   3.277  28.101  1.00 11.12           O  
ATOM   3547  CB  MET H 210      12.570   4.686  28.837  1.00 10.28           C  
ATOM   3548  CG  MET H 210      11.626   5.883  29.042  1.00 17.30           C  
ATOM   3549  SD  MET H 210      12.379   7.525  29.105  1.00 19.25           S  
ATOM   3550  CE  MET H 210      13.407   7.311  30.571  1.00 19.72           C  
ATOM   3551  H   MET H 210      11.911   5.010  26.379  1.00  8.88           H  
ATOM   3552  HA  MET H 210      14.316   5.578  27.969  1.00  7.86           H  
ATOM   3553  HB3 MET H 210      13.118   4.494  29.759  1.00 10.28           H  
ATOM   3554  HB2 MET H 210      11.954   3.800  28.677  1.00 10.28           H  
ATOM   3555  HG3 MET H 210      11.110   5.758  29.988  1.00 17.30           H  
ATOM   3556  HG2 MET H 210      10.860   5.895  28.267  1.00 17.30           H  
ATOM   3557  HE1 MET H 210      13.911   8.248  30.793  1.00 19.72           H  
ATOM   3558  HE2 MET H 210      12.788   7.036  31.425  1.00 19.72           H  
ATOM   3559  HE3 MET H 210      14.162   6.542  30.413  1.00 19.72           H  
ATOM   3560  N   GLY H 211      13.816   2.701  26.475  1.00  9.71           N  
ATOM   3561  CA  GLY H 211      14.370   1.381  26.195  1.00  8.99           C  
ATOM   3562  C   GLY H 211      14.450   1.110  24.692  1.00  9.17           C  
ATOM   3563  O   GLY H 211      13.810   1.778  23.881  1.00  9.66           O  
ATOM   3564  H   GLY H 211      13.005   2.984  25.941  1.00  9.71           H  
ATOM   3565  HA3 GLY H 211      13.755   0.615  26.661  1.00  8.99           H  
ATOM   3566  HA2 GLY H 211      15.352   1.283  26.635  1.00  8.99           H  
ATOM   3567  N   ILE H 212      15.222   0.070  24.349  1.00  9.33           N  
ATOM   3568  CA  ILE H 212      15.317  -0.529  23.018  1.00  8.88           C  
ATOM   3569  C   ILE H 212      15.084  -2.039  23.209  1.00  9.25           C  
ATOM   3570  O   ILE H 212      15.753  -2.617  24.061  1.00 10.51           O  
ATOM   3571  CB  ILE H 212      16.741  -0.353  22.407  1.00  9.49           C  
ATOM   3572  CG1 ILE H 212      17.154   1.125  22.258  1.00 10.88           C  
ATOM   3573  CG2 ILE H 212      16.935  -1.068  21.061  1.00 12.82           C  
ATOM   3574  CD1 ILE H 212      18.663   1.328  22.076  1.00 12.77           C  
ATOM   3575  H   ILE H 212      15.738  -0.413  25.071  1.00  9.33           H  
ATOM   3576  HA  ILE H 212      14.571  -0.107  22.348  1.00  8.88           H  
ATOM   3577  HB  ILE H 212      17.443  -0.820  23.089  1.00  9.49           H  
ATOM   3578 HG13 ILE H 212      16.839   1.705  23.121  1.00 10.88           H  
ATOM   3579 HG12 ILE H 212      16.637   1.555  21.402  1.00 10.88           H  
ATOM   3580 HG21 ILE H 212      17.959  -0.963  20.710  1.00 12.82           H  
ATOM   3581 HG22 ILE H 212      16.741  -2.138  21.121  1.00 12.82           H  
ATOM   3582 HG23 ILE H 212      16.277  -0.641  20.308  1.00 12.82           H  
ATOM   3583 HD11 ILE H 212      18.958   2.328  22.393  1.00 12.77           H  
ATOM   3584 HD12 ILE H 212      19.248   0.612  22.654  1.00 12.77           H  
ATOM   3585 HD13 ILE H 212      18.944   1.225  21.028  1.00 12.77           H  
ATOM   3586  N   VAL H 213      14.188  -2.657  22.416  1.00  9.96           N  
ATOM   3587  CA  VAL H 213      13.885  -4.099  22.439  1.00 10.68           C  
ATOM   3588  C   VAL H 213      15.167  -4.933  22.218  1.00 10.54           C  
ATOM   3589  O   VAL H 213      15.772  -4.839  21.149  1.00 11.59           O  
ATOM   3590  CB  VAL H 213      12.847  -4.495  21.345  1.00 10.40           C  
ATOM   3591  CG1 VAL H 213      12.576  -6.014  21.267  1.00 13.41           C  
ATOM   3592  CG2 VAL H 213      11.495  -3.784  21.523  1.00 14.04           C  
ATOM   3593  H   VAL H 213      13.682  -2.110  21.729  1.00  9.96           H  
ATOM   3594  HA  VAL H 213      13.470  -4.341  23.418  1.00 10.68           H  
ATOM   3595  HB  VAL H 213      13.247  -4.173  20.384  1.00 10.40           H  
ATOM   3596 HG11 VAL H 213      11.784  -6.232  20.552  1.00 13.41           H  
ATOM   3597 HG12 VAL H 213      13.446  -6.584  20.948  1.00 13.41           H  
ATOM   3598 HG13 VAL H 213      12.259  -6.406  22.234  1.00 13.41           H  
ATOM   3599 HG21 VAL H 213      10.902  -3.844  20.610  1.00 14.04           H  
ATOM   3600 HG22 VAL H 213      10.912  -4.262  22.307  1.00 14.04           H  
ATOM   3601 HG23 VAL H 213      11.597  -2.731  21.777  1.00 14.04           H  
ATOM   3602  N   SER H 214      15.577  -5.674  23.259  1.00  9.71           N  
ATOM   3603  CA  SER H 214      16.902  -6.280  23.347  1.00  9.83           C  
ATOM   3604  C   SER H 214      16.822  -7.811  23.268  1.00 11.47           C  
ATOM   3605  O   SER H 214      17.327  -8.380  22.302  1.00 14.92           O  
ATOM   3606  CB  SER H 214      17.604  -5.741  24.612  1.00 10.88           C  
ATOM   3607  OG  SER H 214      18.908  -6.247  24.774  1.00 13.89           O  
ATOM   3608  H   SER H 214      15.017  -5.714  24.100  1.00  9.71           H  
ATOM   3609  HA  SER H 214      17.508  -5.960  22.499  1.00  9.83           H  
ATOM   3610  HB3 SER H 214      17.046  -5.987  25.513  1.00 10.88           H  
ATOM   3611  HB2 SER H 214      17.663  -4.655  24.567  1.00 10.88           H  
ATOM   3612  HG  SER H 214      19.417  -6.039  23.981  1.00 13.89           H  
ATOM   3613  N   TRP H 215      16.191  -8.459  24.260  1.00 12.41           N  
ATOM   3614  CA  TRP H 215      16.120  -9.920  24.318  1.00 13.95           C  
ATOM   3615  C   TRP H 215      14.952 -10.412  25.176  1.00 13.45           C  
ATOM   3616  O   TRP H 215      14.416  -9.661  25.984  1.00 14.28           O  
ATOM   3617  CB  TRP H 215      17.478 -10.510  24.761  1.00 15.81           C  
ATOM   3618  CG  TRP H 215      18.004 -10.181  26.123  1.00 15.85           C  
ATOM   3619  CD1 TRP H 215      18.853  -9.173  26.416  1.00 17.26           C  
ATOM   3620  CD2 TRP H 215      17.755 -10.876  27.381  1.00 18.00           C  
ATOM   3621  NE1 TRP H 215      19.166  -9.205  27.756  1.00 17.74           N  
ATOM   3622  CE2 TRP H 215      18.535 -10.249  28.398  1.00 19.15           C  
ATOM   3623  CE3 TRP H 215      16.981 -11.999  27.763  1.00 20.14           C  
ATOM   3624  CZ2 TRP H 215      18.565 -10.723  29.717  1.00 19.99           C  
ATOM   3625  CZ3 TRP H 215      16.995 -12.478  29.087  1.00 23.08           C  
ATOM   3626  CH2 TRP H 215      17.793 -11.848  30.060  1.00 22.83           C  
ATOM   3627  H   TRP H 215      15.764  -7.953  25.024  1.00 12.41           H  
ATOM   3628  HA  TRP H 215      15.911 -10.287  23.315  1.00 13.95           H  
ATOM   3629  HB3 TRP H 215      18.248 -10.265  24.032  1.00 15.81           H  
ATOM   3630  HB2 TRP H 215      17.413 -11.592  24.744  1.00 15.81           H  
ATOM   3631  HD1 TRP H 215      19.259  -8.492  25.687  1.00 17.26           H  
ATOM   3632  HE1 TRP H 215      19.821  -8.561  28.179  1.00 17.74           H  
ATOM   3633  HE3 TRP H 215      16.383 -12.509  27.023  1.00 20.14           H  
ATOM   3634  HZ2 TRP H 215      19.191 -10.236  30.445  1.00 19.99           H  
ATOM   3635  HZ3 TRP H 215      16.404 -13.341  29.357  1.00 23.08           H  
ATOM   3636  HH2 TRP H 215      17.816 -12.234  31.066  1.00 22.83           H  
ATOM   3637  N   GLY H 216      14.582 -11.680  24.974  1.00 14.84           N  
ATOM   3638  CA  GLY H 216      13.552 -12.354  25.750  1.00 17.33           C  
ATOM   3639  C   GLY H 216      13.652 -13.848  25.444  1.00 19.13           C  
ATOM   3640  O   GLY H 216      14.010 -14.250  24.334  1.00 24.72           O  
ATOM   3641  H   GLY H 216      15.053 -12.234  24.270  1.00 14.84           H  
ATOM   3642  HA3 GLY H 216      12.563 -11.986  25.477  1.00 17.33           H  
ATOM   3643  HA2 GLY H 216      13.697 -12.174  26.817  1.00 17.33           H  
ATOM   3644  N   GLU H 217      13.313 -14.675  26.442  1.00 17.45           N  
ATOM   3645  CA  GLU H 217      13.337 -16.133  26.354  1.00 19.74           C  
ATOM   3646  C   GLU H 217      11.952 -16.624  25.924  1.00 21.92           C  
ATOM   3647  O   GLU H 217      11.055 -16.757  26.757  1.00 23.72           O  
ATOM   3648  CB  GLU H 217      13.788 -16.705  27.706  1.00 22.04           C  
ATOM   3649  CG  GLU H 217      15.218 -16.258  28.067  1.00 24.09           C  
ATOM   3650  CD  GLU H 217      15.699 -16.888  29.371  1.00 22.93           C  
ATOM   3651  OE1 GLU H 217      16.639 -17.708  29.296  1.00 41.20           O  
ATOM   3652  OE2 GLU H 217      15.123 -16.547  30.428  1.00 30.36           O1-
ATOM   3653  H   GLU H 217      13.009 -14.290  27.325  1.00 17.45           H  
ATOM   3654  HA  GLU H 217      14.064 -16.455  25.606  1.00 19.74           H  
ATOM   3655  HB3 GLU H 217      13.740 -17.795  27.677  1.00 22.04           H  
ATOM   3656  HB2 GLU H 217      13.095 -16.391  28.490  1.00 22.04           H  
ATOM   3657  HG3 GLU H 217      15.266 -15.174  28.179  1.00 24.09           H  
ATOM   3658  HG2 GLU H 217      15.903 -16.508  27.254  1.00 24.09           H  
ATOM   3659  N   GLY H 219      11.805 -16.805  24.602  1.00 22.27           N  
ATOM   3660  CA  GLY H 219      10.516 -16.972  23.939  1.00 24.34           C  
ATOM   3661  C   GLY H 219       9.808 -15.616  23.829  1.00 23.33           C  
ATOM   3662  O   GLY H 219      10.437 -14.563  23.960  1.00 21.64           O  
ATOM   3663  H   GLY H 219      12.598 -16.648  23.999  1.00 22.27           H  
ATOM   3664  HA3 GLY H 219       9.893 -17.672  24.488  1.00 24.34           H  
ATOM   3665  HA2 GLY H 219      10.673 -17.381  22.940  1.00 24.34           H  
ATOM   3666  N   CYS H 220       8.493 -15.654  23.566  1.00 22.32           N  
ATOM   3667  CA  CYS H 220       7.653 -14.463  23.457  1.00 20.39           C  
ATOM   3668  C   CYS H 220       6.366 -14.711  24.242  1.00 23.23           C  
ATOM   3669  O   CYS H 220       5.627 -15.642  23.919  1.00 25.14           O  
ATOM   3670  CB  CYS H 220       7.332 -14.127  21.986  1.00 24.08           C  
ATOM   3671  SG  CYS H 220       8.701 -14.230  20.806  1.00 23.85           S  
ATOM   3672  H   CYS H 220       8.019 -16.545  23.479  1.00 22.32           H  
ATOM   3673  HA  CYS H 220       8.159 -13.599  23.890  1.00 20.39           H  
ATOM   3674  HB3 CYS H 220       6.961 -13.103  21.951  1.00 24.08           H  
ATOM   3675  HB2 CYS H 220       6.522 -14.741  21.598  1.00 24.08           H  
ATOM   3676  N   ASP H 221       6.129 -13.857  25.247  1.00 21.27           N  
ATOM   3677  CA  ASP H 221       4.941 -13.810  26.097  1.00 23.16           C  
ATOM   3678  C   ASP H 221       4.704 -15.128  26.868  1.00 23.12           C  
ATOM   3679  O   ASP H 221       3.573 -15.607  26.945  1.00 26.62           O  
ATOM   3680  CB  ASP H 221       3.700 -13.343  25.294  1.00 22.79           C  
ATOM   3681  CG  ASP H 221       2.475 -12.904  26.107  1.00 24.47           C  
ATOM   3682  OD1 ASP H 221       2.660 -12.421  27.245  1.00 21.57           O  
ATOM   3683  OD2 ASP H 221       1.369 -12.950  25.528  1.00 25.58           O1-
ATOM   3684  H   ASP H 221       6.812 -13.132  25.435  1.00 21.27           H  
ATOM   3685  HA  ASP H 221       5.178 -13.060  26.851  1.00 23.16           H  
ATOM   3686  HB3 ASP H 221       3.412 -14.132  24.599  1.00 22.79           H  
ATOM   3687  HB2 ASP H 221       3.997 -12.500  24.675  1.00 22.79           H  
ATOM   3688  N   ARG H 221A      5.781 -15.702  27.425  1.00 22.41           N  
ATOM   3689  CA  ARG H 221A      5.681 -16.822  28.356  1.00 25.77           C  
ATOM   3690  C   ARG H 221A      5.350 -16.296  29.762  1.00 23.78           C  
ATOM   3691  O   ARG H 221A      5.871 -15.251  30.159  1.00 23.89           O  
ATOM   3692  CB  ARG H 221A      7.005 -17.603  28.394  1.00 27.85           C  
ATOM   3693  CG  ARG H 221A      7.440 -18.267  27.077  1.00 31.31           C  
ATOM   3694  CD  ARG H 221A      8.640 -19.191  27.343  1.00 39.57           C  
ATOM   3695  NE  ARG H 221A      9.256 -19.739  26.124  1.00 39.92           N  
ATOM   3696  CZ  ARG H 221A     10.477 -20.305  26.031  1.00 43.28           C  
ATOM   3697  NH1 ARG H 221A     11.287 -20.438  27.093  1.00 46.21           N  
ATOM   3698  NH2 ARG H 221A     10.909 -20.751  24.847  1.00 39.81           N1+
ATOM   3699  H   ARG H 221A      6.695 -15.281  27.315  1.00 22.41           H  
ATOM   3700  HA  ARG H 221A      4.890 -17.504  28.035  1.00 25.77           H  
ATOM   3701  HB3 ARG H 221A      6.933 -18.374  29.162  1.00 27.85           H  
ATOM   3702  HB2 ARG H 221A      7.803 -16.937  28.712  1.00 27.85           H  
ATOM   3703  HG3 ARG H 221A      7.639 -17.549  26.278  1.00 31.31           H  
ATOM   3704  HG2 ARG H 221A      6.600 -18.879  26.743  1.00 31.31           H  
ATOM   3705  HD3 ARG H 221A      8.270 -20.074  27.865  1.00 39.57           H  
ATOM   3706  HD2 ARG H 221A      9.361 -18.722  28.011  1.00 39.57           H  
ATOM   3707  HE  ARG H 221A      8.705 -19.652  25.276  1.00 39.92           H  
ATOM   3708 HH12 ARG H 221A     12.196 -20.867  26.999  1.00 46.21           H  
ATOM   3709 HH11 ARG H 221A     10.984 -20.102  27.994  1.00 46.21           H  
ATOM   3710 HH22 ARG H 221A     11.814 -21.185  24.750  1.00 39.81           H  
ATOM   3711 HH21 ARG H 221A     10.315 -20.650  24.028  1.00 39.81           H  
ATOM   3712  N   ASP H 222       4.540 -17.066  30.510  1.00 24.84           N  
ATOM   3713  CA  ASP H 222       4.283 -16.848  31.938  1.00 26.57           C  
ATOM   3714  C   ASP H 222       5.573 -16.979  32.762  1.00 27.04           C  
ATOM   3715  O   ASP H 222       6.303 -17.959  32.608  1.00 27.34           O  
ATOM   3716  CB  ASP H 222       3.205 -17.800  32.519  1.00 28.20           C  
ATOM   3717  CG  ASP H 222       1.775 -17.619  31.986  1.00 33.67           C  
ATOM   3718  OD1 ASP H 222       1.452 -16.515  31.499  1.00 34.02           O  
ATOM   3719  OD2 ASP H 222       0.973 -18.556  32.195  1.00 56.66           O1-
ATOM   3720  H   ASP H 222       4.144 -17.906  30.114  1.00 24.84           H  
ATOM   3721  HA  ASP H 222       3.928 -15.822  32.045  1.00 26.57           H  
ATOM   3722  HB3 ASP H 222       3.162 -17.702  33.605  1.00 28.20           H  
ATOM   3723  HB2 ASP H 222       3.503 -18.830  32.316  1.00 28.20           H  
ATOM   3724  N   GLY H 223       5.815 -15.975  33.616  1.00 24.39           N  
ATOM   3725  CA  GLY H 223       6.972 -15.899  34.502  1.00 23.16           C  
ATOM   3726  C   GLY H 223       8.238 -15.396  33.790  1.00 20.94           C  
ATOM   3727  O   GLY H 223       9.276 -15.324  34.443  1.00 23.79           O  
ATOM   3728  H   GLY H 223       5.177 -15.189  33.636  1.00 24.39           H  
ATOM   3729  HA3 GLY H 223       7.170 -16.871  34.956  1.00 23.16           H  
ATOM   3730  HA2 GLY H 223       6.735 -15.212  35.315  1.00 23.16           H  
ATOM   3731  N   LYS H 224       8.164 -15.049  32.492  1.00 21.02           N  
ATOM   3732  CA  LYS H 224       9.240 -14.432  31.715  1.00 17.95           C  
ATOM   3733  C   LYS H 224       8.847 -12.996  31.346  1.00 16.17           C  
ATOM   3734  O   LYS H 224       7.662 -12.651  31.348  1.00 19.12           O  
ATOM   3735  CB  LYS H 224       9.495 -15.237  30.424  1.00 19.12           C  
ATOM   3736  CG  LYS H 224       9.904 -16.707  30.621  1.00 23.35           C  
ATOM   3737  CD  LYS H 224      11.231 -16.900  31.370  1.00 30.27           C  
ATOM   3738  CE  LYS H 224      11.635 -18.380  31.452  1.00 38.43           C  
ATOM   3739  NZ  LYS H 224      12.928 -18.556  32.136  1.00 51.20           N1+
ATOM   3740  H   LYS H 224       7.278 -15.131  32.013  1.00 21.02           H  
ATOM   3741  HA  LYS H 224      10.158 -14.384  32.300  1.00 17.95           H  
ATOM   3742  HB3 LYS H 224      10.272 -14.745  29.836  1.00 19.12           H  
ATOM   3743  HB2 LYS H 224       8.597 -15.198  29.808  1.00 19.12           H  
ATOM   3744  HG3 LYS H 224       9.994 -17.166  29.637  1.00 23.35           H  
ATOM   3745  HG2 LYS H 224       9.107 -17.248  31.132  1.00 23.35           H  
ATOM   3746  HD3 LYS H 224      11.141 -16.491  32.377  1.00 30.27           H  
ATOM   3747  HD2 LYS H 224      12.013 -16.327  30.870  1.00 30.27           H  
ATOM   3748  HE3 LYS H 224      11.714 -18.806  30.452  1.00 38.43           H  
ATOM   3749  HE2 LYS H 224      10.875 -18.948  31.988  1.00 38.43           H  
ATOM   3750  HZ1 LYS H 224      12.875 -18.154  33.063  1.00 51.20           H  
ATOM   3751  HZ2 LYS H 224      13.159 -19.537  32.200  1.00 51.20           H  
ATOM   3752  HZ3 LYS H 224      13.649 -18.072  31.616  1.00 51.20           H  
ATOM   3753  N   TYR H 225       9.871 -12.191  31.033  1.00 15.75           N  
ATOM   3754  CA  TYR H 225       9.746 -10.774  30.702  1.00 15.69           C  
ATOM   3755  C   TYR H 225      10.675 -10.448  29.532  1.00 14.32           C  
ATOM   3756  O   TYR H 225      11.749 -11.042  29.415  1.00 18.08           O  
ATOM   3757  CB  TYR H 225      10.115  -9.928  31.940  1.00 16.38           C  
ATOM   3758  CG  TYR H 225       9.277 -10.242  33.166  1.00 17.36           C  
ATOM   3759  CD1 TYR H 225       9.798 -11.079  34.173  1.00 18.30           C  
ATOM   3760  CD2 TYR H 225       7.953  -9.769  33.264  1.00 18.21           C  
ATOM   3761  CE1 TYR H 225       8.990 -11.476  35.252  1.00 21.15           C  
ATOM   3762  CE2 TYR H 225       7.150 -10.147  34.357  1.00 19.91           C  
ATOM   3763  CZ  TYR H 225       7.664 -11.015  35.341  1.00 22.46           C  
ATOM   3764  OH  TYR H 225       6.878 -11.418  36.377  1.00 30.40           O  
ATOM   3765  H   TYR H 225      10.814 -12.559  31.032  1.00 15.75           H  
ATOM   3766  HA  TYR H 225       8.723 -10.542  30.397  1.00 15.69           H  
ATOM   3767  HB3 TYR H 225      10.016  -8.866  31.719  1.00 16.38           H  
ATOM   3768  HB2 TYR H 225      11.166 -10.080  32.190  1.00 16.38           H  
ATOM   3769  HD1 TYR H 225      10.809 -11.445  34.096  1.00 18.30           H  
ATOM   3770  HD2 TYR H 225       7.546  -9.132  32.494  1.00 18.21           H  
ATOM   3771  HE1 TYR H 225       9.390 -12.137  36.007  1.00 21.15           H  
ATOM   3772  HE2 TYR H 225       6.136  -9.786  34.430  1.00 19.91           H  
ATOM   3773  HH  TYR H 225       7.324 -12.027  36.970  1.00 30.40           H  
ATOM   3774  N   GLY H 226      10.265  -9.465  28.717  1.00 14.15           N  
ATOM   3775  CA  GLY H 226      11.118  -8.876  27.691  1.00 14.38           C  
ATOM   3776  C   GLY H 226      12.111  -7.939  28.382  1.00 11.58           C  
ATOM   3777  O   GLY H 226      11.730  -7.183  29.274  1.00 13.67           O  
ATOM   3778  H   GLY H 226       9.362  -9.035  28.862  1.00 14.15           H  
ATOM   3779  HA3 GLY H 226      10.510  -8.294  26.998  1.00 14.38           H  
ATOM   3780  HA2 GLY H 226      11.627  -9.648  27.111  1.00 14.38           H  
ATOM   3781  N   PHE H 227      13.373  -7.992  27.945  1.00 12.34           N  
ATOM   3782  CA  PHE H 227      14.467  -7.135  28.388  1.00 11.64           C  
ATOM   3783  C   PHE H 227      14.737  -6.062  27.337  1.00 11.39           C  
ATOM   3784  O   PHE H 227      14.617  -6.318  26.137  1.00 12.24           O  
ATOM   3785  CB  PHE H 227      15.724  -7.977  28.675  1.00 12.55           C  
ATOM   3786  CG  PHE H 227      15.634  -8.740  29.981  1.00 13.96           C  
ATOM   3787  CD1 PHE H 227      14.858  -9.914  30.062  1.00 16.29           C  
ATOM   3788  CD2 PHE H 227      16.170  -8.185  31.161  1.00 14.20           C  
ATOM   3789  CE1 PHE H 227      14.665 -10.534  31.288  1.00 18.30           C  
ATOM   3790  CE2 PHE H 227      15.978  -8.829  32.374  1.00 15.87           C  
ATOM   3791  CZ  PHE H 227      15.226  -9.995  32.436  1.00 17.08           C  
ATOM   3792  H   PHE H 227      13.612  -8.640  27.203  1.00 12.34           H  
ATOM   3793  HA  PHE H 227      14.189  -6.632  29.315  1.00 11.64           H  
ATOM   3794  HB3 PHE H 227      16.613  -7.343  28.710  1.00 12.55           H  
ATOM   3795  HB2 PHE H 227      15.900  -8.683  27.865  1.00 12.55           H  
ATOM   3796  HD1 PHE H 227      14.405 -10.331  29.174  1.00 16.29           H  
ATOM   3797  HD2 PHE H 227      16.728  -7.261  31.126  1.00 14.20           H  
ATOM   3798  HE1 PHE H 227      14.072 -11.433  31.347  1.00 18.30           H  
ATOM   3799  HE2 PHE H 227      16.402  -8.412  33.276  1.00 15.87           H  
ATOM   3800  HZ  PHE H 227      15.070 -10.485  33.382  1.00 17.08           H  
ATOM   3801  N   TYR H 228      15.076  -4.870  27.840  1.00 10.73           N  
ATOM   3802  CA  TYR H 228      15.234  -3.644  27.078  1.00  9.40           C  
ATOM   3803  C   TYR H 228      16.538  -2.974  27.496  1.00 11.12           C  
ATOM   3804  O   TYR H 228      16.792  -2.857  28.693  1.00 11.56           O  
ATOM   3805  CB  TYR H 228      14.048  -2.697  27.363  1.00  9.46           C  
ATOM   3806  CG  TYR H 228      12.701  -3.271  26.979  1.00  9.58           C  
ATOM   3807  CD1 TYR H 228      11.981  -4.059  27.902  1.00 10.01           C  
ATOM   3808  CD2 TYR H 228      12.195  -3.074  25.680  1.00 11.07           C  
ATOM   3809  CE1 TYR H 228      10.806  -4.717  27.497  1.00 11.45           C  
ATOM   3810  CE2 TYR H 228      11.007  -3.717  25.285  1.00 11.37           C  
ATOM   3811  CZ  TYR H 228      10.338  -4.573  26.179  1.00 12.72           C  
ATOM   3812  OH  TYR H 228       9.248  -5.280  25.770  1.00 13.55           O  
ATOM   3813  H   TYR H 228      15.136  -4.759  28.846  1.00 10.73           H  
ATOM   3814  HA  TYR H 228      15.266  -3.887  26.020  1.00  9.40           H  
ATOM   3815  HB3 TYR H 228      14.188  -1.757  26.828  1.00  9.46           H  
ATOM   3816  HB2 TYR H 228      14.020  -2.442  28.424  1.00  9.46           H  
ATOM   3817  HD1 TYR H 228      12.356  -4.206  28.904  1.00 10.01           H  
ATOM   3818  HD2 TYR H 228      12.727  -2.452  24.976  1.00 11.07           H  
ATOM   3819  HE1 TYR H 228      10.280  -5.357  28.189  1.00 11.45           H  
ATOM   3820  HE2 TYR H 228      10.623  -3.566  24.291  1.00 11.37           H  
ATOM   3821  HH  TYR H 228       9.034  -5.146  24.844  1.00 13.55           H  
ATOM   3822  N   THR H 229      17.313  -2.507  26.509  1.00  9.21           N  
ATOM   3823  CA  THR H 229      18.531  -1.735  26.729  1.00  9.99           C  
ATOM   3824  C   THR H 229      18.189  -0.348  27.289  1.00  9.00           C  
ATOM   3825  O   THR H 229      17.516   0.419  26.607  1.00 11.38           O  
ATOM   3826  CB  THR H 229      19.315  -1.513  25.416  1.00 10.77           C  
ATOM   3827  OG1 THR H 229      19.565  -2.758  24.805  1.00 12.10           O  
ATOM   3828  CG2 THR H 229      20.646  -0.770  25.590  1.00 11.79           C  
ATOM   3829  H   THR H 229      17.036  -2.638  25.544  1.00  9.21           H  
ATOM   3830  HA  THR H 229      19.163  -2.277  27.434  1.00  9.99           H  
ATOM   3831  HB  THR H 229      18.714  -0.937  24.721  1.00 10.77           H  
ATOM   3832  HG1 THR H 229      20.069  -2.610  23.997  1.00 12.10           H  
ATOM   3833 HG21 THR H 229      21.224  -0.780  24.671  1.00 11.79           H  
ATOM   3834 HG22 THR H 229      20.492   0.274  25.864  1.00 11.79           H  
ATOM   3835 HG23 THR H 229      21.254  -1.236  26.363  1.00 11.79           H  
ATOM   3836  N   HIS H 230      18.662  -0.065  28.508  1.00 11.71           N  
ATOM   3837  CA  HIS H 230      18.488   1.193  29.227  1.00 10.35           C  
ATOM   3838  C   HIS H 230      19.197   2.336  28.473  1.00 10.64           C  
ATOM   3839  O   HIS H 230      20.426   2.410  28.490  1.00 12.71           O  
ATOM   3840  CB  HIS H 230      19.027   0.959  30.652  1.00 12.36           C  
ATOM   3841  CG  HIS H 230      18.595   1.932  31.718  1.00 13.37           C  
ATOM   3842  ND1 HIS H 230      18.594   3.321  31.543  1.00 16.33           N  
ATOM   3843  CD2 HIS H 230      18.205   1.644  33.009  1.00 13.57           C  
ATOM   3844  CE1 HIS H 230      18.222   3.807  32.720  1.00 15.20           C  
ATOM   3845  NE2 HIS H 230      17.977   2.860  33.626  1.00 16.72           N  
ATOM   3846  H   HIS H 230      19.232  -0.756  28.978  1.00 11.71           H  
ATOM   3847  HA  HIS H 230      17.417   1.398  29.285  1.00 10.35           H  
ATOM   3848  HB3 HIS H 230      20.113   0.913  30.649  1.00 12.36           H  
ATOM   3849  HB2 HIS H 230      18.700  -0.024  30.997  1.00 12.36           H  
ATOM   3850  HD2 HIS H 230      18.097   0.701  33.525  1.00 13.57           H  
ATOM   3851  HE1 HIS H 230      18.126   4.862  32.928  1.00 15.20           H  
ATOM   3852  HE2 HIS H 230      17.679   3.005  34.580  1.00 16.72           H  
ATOM   3853  N   VAL H 231      18.399   3.164  27.776  1.00 11.51           N  
ATOM   3854  CA  VAL H 231      18.880   4.212  26.873  1.00 11.54           C  
ATOM   3855  C   VAL H 231      19.597   5.359  27.607  1.00 13.15           C  
ATOM   3856  O   VAL H 231      20.613   5.834  27.097  1.00 14.09           O  
ATOM   3857  CB  VAL H 231      17.731   4.788  25.993  1.00 11.93           C  
ATOM   3858  CG1 VAL H 231      18.083   6.054  25.185  1.00 13.82           C  
ATOM   3859  CG2 VAL H 231      17.207   3.720  25.022  1.00 13.15           C  
ATOM   3860  H   VAL H 231      17.397   3.028  27.803  1.00 11.51           H  
ATOM   3861  HA  VAL H 231      19.613   3.751  26.206  1.00 11.54           H  
ATOM   3862  HB  VAL H 231      16.902   5.057  26.650  1.00 11.93           H  
ATOM   3863 HG11 VAL H 231      17.274   6.298  24.499  1.00 13.82           H  
ATOM   3864 HG12 VAL H 231      18.232   6.928  25.820  1.00 13.82           H  
ATOM   3865 HG13 VAL H 231      18.983   5.908  24.587  1.00 13.82           H  
ATOM   3866 HG21 VAL H 231      16.367   4.091  24.436  1.00 13.15           H  
ATOM   3867 HG22 VAL H 231      17.987   3.413  24.326  1.00 13.15           H  
ATOM   3868 HG23 VAL H 231      16.864   2.831  25.548  1.00 13.15           H  
ATOM   3869  N   PHE H 232      19.096   5.753  28.794  1.00 12.52           N  
ATOM   3870  CA  PHE H 232      19.732   6.781  29.621  1.00 13.92           C  
ATOM   3871  C   PHE H 232      21.121   6.376  30.160  1.00 14.46           C  
ATOM   3872  O   PHE H 232      22.021   7.215  30.204  1.00 17.39           O  
ATOM   3873  CB  PHE H 232      18.788   7.303  30.729  1.00 18.01           C  
ATOM   3874  CG  PHE H 232      19.465   8.320  31.630  1.00 21.47           C  
ATOM   3875  CD1 PHE H 232      19.796   9.585  31.102  1.00 20.08           C  
ATOM   3876  CD2 PHE H 232      20.015   7.930  32.870  1.00 22.05           C  
ATOM   3877  CE1 PHE H 232      20.658  10.426  31.790  1.00 25.87           C  
ATOM   3878  CE2 PHE H 232      20.864   8.792  33.552  1.00 25.30           C  
ATOM   3879  CZ  PHE H 232      21.194  10.025  33.006  1.00 26.64           C  
ATOM   3880  H   PHE H 232      18.269   5.309  29.168  1.00 12.52           H  
ATOM   3881  HA  PHE H 232      19.901   7.630  28.959  1.00 13.92           H  
ATOM   3882  HB3 PHE H 232      18.382   6.483  31.320  1.00 18.01           H  
ATOM   3883  HB2 PHE H 232      17.934   7.795  30.269  1.00 18.01           H  
ATOM   3884  HD1 PHE H 232      19.432   9.875  30.129  1.00 20.08           H  
ATOM   3885  HD2 PHE H 232      19.814   6.947  33.270  1.00 22.05           H  
ATOM   3886  HE1 PHE H 232      20.923  11.384  31.370  1.00 25.87           H  
ATOM   3887  HE2 PHE H 232      21.291   8.488  34.495  1.00 25.30           H  
ATOM   3888  HZ  PHE H 232      21.873  10.679  33.532  1.00 26.64           H  
ATOM   3889  N   ARG H 233      21.283   5.094  30.523  1.00 14.01           N  
ATOM   3890  CA  ARG H 233      22.551   4.502  30.961  1.00 15.07           C  
ATOM   3891  C   ARG H 233      23.651   4.497  29.883  1.00 15.60           C  
ATOM   3892  O   ARG H 233      24.815   4.342  30.249  1.00 20.72           O  
ATOM   3893  CB  ARG H 233      22.273   3.063  31.429  1.00 17.55           C  
ATOM   3894  CG  ARG H 233      21.724   2.970  32.867  1.00 26.55           C  
ATOM   3895  CD  ARG H 233      22.780   3.109  33.979  1.00 33.37           C  
ATOM   3896  NE  ARG H 233      23.851   2.106  33.851  1.00 35.71           N  
ATOM   3897  CZ  ARG H 233      24.987   2.008  34.562  1.00 38.43           C  
ATOM   3898  NH1 ARG H 233      25.268   2.837  35.577  1.00 49.88           N  
ATOM   3899  NH2 ARG H 233      25.864   1.050  34.239  1.00 42.13           N1+
ATOM   3900  H   ARG H 233      20.498   4.461  30.455  1.00 14.01           H  
ATOM   3901  HA  ARG H 233      22.942   5.086  31.796  1.00 15.07           H  
ATOM   3902  HB3 ARG H 233      23.168   2.451  31.338  1.00 17.55           H  
ATOM   3903  HB2 ARG H 233      21.571   2.596  30.744  1.00 17.55           H  
ATOM   3904  HG3 ARG H 233      21.139   2.066  33.013  1.00 26.55           H  
ATOM   3905  HG2 ARG H 233      21.016   3.789  32.992  1.00 26.55           H  
ATOM   3906  HD3 ARG H 233      22.295   2.897  34.933  1.00 33.37           H  
ATOM   3907  HD2 ARG H 233      23.163   4.128  34.043  1.00 33.37           H  
ATOM   3908  HE  ARG H 233      23.716   1.437  33.104  1.00 35.71           H  
ATOM   3909 HH12 ARG H 233      26.119   2.731  36.110  1.00 49.88           H  
ATOM   3910 HH11 ARG H 233      24.604   3.550  35.841  1.00 49.88           H  
ATOM   3911 HH22 ARG H 233      26.714   0.930  34.770  1.00 42.13           H  
ATOM   3912 HH21 ARG H 233      25.676   0.439  33.455  1.00 42.13           H  
ATOM   3913  N   LEU H 234      23.284   4.669  28.604  1.00 14.97           N  
ATOM   3914  CA  LEU H 234      24.196   4.687  27.458  1.00 16.18           C  
ATOM   3915  C   LEU H 234      24.163   6.038  26.716  1.00 16.89           C  
ATOM   3916  O   LEU H 234      24.727   6.134  25.626  1.00 19.11           O  
ATOM   3917  CB  LEU H 234      23.858   3.491  26.538  1.00 15.40           C  
ATOM   3918  CG  LEU H 234      24.016   2.099  27.203  1.00 18.65           C  
ATOM   3919  CD1 LEU H 234      23.380   0.991  26.353  1.00 22.22           C  
ATOM   3920  CD2 LEU H 234      25.471   1.761  27.592  1.00 29.22           C  
ATOM   3921  H   LEU H 234      22.302   4.778  28.384  1.00 14.97           H  
ATOM   3922  HA  LEU H 234      25.226   4.585  27.797  1.00 16.18           H  
ATOM   3923  HB3 LEU H 234      24.484   3.516  25.644  1.00 15.40           H  
ATOM   3924  HB2 LEU H 234      22.832   3.611  26.187  1.00 15.40           H  
ATOM   3925  HG  LEU H 234      23.437   2.115  28.126  1.00 18.65           H  
ATOM   3926 HD11 LEU H 234      22.875   0.272  26.996  1.00 22.22           H  
ATOM   3927 HD12 LEU H 234      22.640   1.385  25.659  1.00 22.22           H  
ATOM   3928 HD13 LEU H 234      24.113   0.447  25.759  1.00 22.22           H  
ATOM   3929 HD21 LEU H 234      25.520   1.409  28.624  1.00 29.22           H  
ATOM   3930 HD22 LEU H 234      25.894   0.977  26.965  1.00 29.22           H  
ATOM   3931 HD23 LEU H 234      26.143   2.613  27.507  1.00 29.22           H  
ATOM   3932  N   LYS H 235      23.550   7.065  27.335  1.00 18.89           N  
ATOM   3933  CA  LYS H 235      23.380   8.428  26.822  1.00 23.03           C  
ATOM   3934  C   LYS H 235      24.695   9.155  26.490  1.00 23.54           C  
ATOM   3935  O   LYS H 235      24.727   9.883  25.501  1.00 27.56           O  
ATOM   3936  CB  LYS H 235      22.532   9.213  27.845  1.00 30.27           C  
ATOM   3937  CG  LYS H 235      22.212  10.686  27.540  1.00 37.67           C  
ATOM   3938  CD  LYS H 235      21.418  10.909  26.244  1.00 47.68           C  
ATOM   3939  CE  LYS H 235      20.762  12.300  26.229  1.00 47.99           C  
ATOM   3940  NZ  LYS H 235      20.169  12.626  24.922  1.00 53.21           N1+
ATOM   3941  H   LYS H 235      23.114   6.891  28.230  1.00 18.89           H  
ATOM   3942  HA  LYS H 235      22.807   8.344  25.897  1.00 23.03           H  
ATOM   3943  HB3 LYS H 235      23.030   9.180  28.815  1.00 30.27           H  
ATOM   3944  HB2 LYS H 235      21.586   8.691  27.973  1.00 30.27           H  
ATOM   3945  HG3 LYS H 235      23.126  11.280  27.521  1.00 37.67           H  
ATOM   3946  HG2 LYS H 235      21.632  11.074  28.379  1.00 37.67           H  
ATOM   3947  HD3 LYS H 235      20.655  10.136  26.136  1.00 47.68           H  
ATOM   3948  HD2 LYS H 235      22.090  10.802  25.391  1.00 47.68           H  
ATOM   3949  HE3 LYS H 235      21.504  13.066  26.460  1.00 47.99           H  
ATOM   3950  HE2 LYS H 235      19.989  12.363  26.994  1.00 47.99           H  
ATOM   3951  HZ1 LYS H 235      19.470  11.938  24.683  1.00 53.21           H  
ATOM   3952  HZ2 LYS H 235      19.740  13.539  24.967  1.00 53.21           H  
ATOM   3953  HZ3 LYS H 235      20.893  12.633  24.216  1.00 53.21           H  
ATOM   3954  N   LYS H 236      25.749   8.939  27.298  1.00 24.43           N  
ATOM   3955  CA  LYS H 236      27.067   9.553  27.097  1.00 30.23           C  
ATOM   3956  C   LYS H 236      27.764   9.035  25.829  1.00 26.02           C  
ATOM   3957  O   LYS H 236      28.414   9.830  25.156  1.00 26.98           O  
ATOM   3958  CB  LYS H 236      27.990   9.341  28.316  1.00 37.37           C  
ATOM   3959  CG  LYS H 236      27.386   9.771  29.669  1.00 44.59           C  
ATOM   3960  CD  LYS H 236      27.257   8.656  30.728  1.00 53.46           C  
ATOM   3961  CE  LYS H 236      26.250   7.531  30.407  1.00 59.55           C  
ATOM   3962  NZ  LYS H 236      26.821   6.473  29.554  1.00 50.87           N1+
ATOM   3963  H   LYS H 236      25.637   8.350  28.107  1.00 24.43           H  
ATOM   3964  HA  LYS H 236      26.917  10.627  26.975  1.00 30.23           H  
ATOM   3965  HB3 LYS H 236      28.904   9.916  28.156  1.00 37.37           H  
ATOM   3966  HB2 LYS H 236      28.334   8.310  28.360  1.00 37.37           H  
ATOM   3967  HG3 LYS H 236      26.414  10.245  29.526  1.00 44.59           H  
ATOM   3968  HG2 LYS H 236      28.016  10.557  30.086  1.00 44.59           H  
ATOM   3969  HD3 LYS H 236      26.947   9.124  31.663  1.00 53.46           H  
ATOM   3970  HD2 LYS H 236      28.243   8.239  30.938  1.00 53.46           H  
ATOM   3971  HE3 LYS H 236      25.339   7.929  29.959  1.00 59.55           H  
ATOM   3972  HE2 LYS H 236      25.949   7.050  31.339  1.00 59.55           H  
ATOM   3973  HZ1 LYS H 236      27.645   6.096  30.001  1.00 50.87           H  
ATOM   3974  HZ2 LYS H 236      26.140   5.732  29.447  1.00 50.87           H  
ATOM   3975  HZ3 LYS H 236      27.071   6.849  28.651  1.00 50.87           H  
ATOM   3976  N   TRP H 237      27.590   7.737  25.510  1.00 23.25           N  
ATOM   3977  CA  TRP H 237      28.069   7.147  24.261  1.00 22.93           C  
ATOM   3978  C   TRP H 237      27.285   7.655  23.040  1.00 20.17           C  
ATOM   3979  O   TRP H 237      27.916   7.967  22.031  1.00 22.00           O  
ATOM   3980  CB  TRP H 237      28.086   5.605  24.333  1.00 23.44           C  
ATOM   3981  CG  TRP H 237      28.421   4.933  23.031  1.00 23.33           C  
ATOM   3982  CD1 TRP H 237      29.667   4.740  22.545  1.00 24.41           C  
ATOM   3983  CD2 TRP H 237      27.508   4.511  21.972  1.00 20.51           C  
ATOM   3984  NE1 TRP H 237      29.589   4.244  21.259  1.00 23.90           N  
ATOM   3985  CE2 TRP H 237      28.281   4.086  20.851  1.00 21.77           C  
ATOM   3986  CE3 TRP H 237      26.101   4.477  21.832  1.00 20.39           C  
ATOM   3987  CZ2 TRP H 237      27.689   3.648  19.654  1.00 22.87           C  
ATOM   3988  CZ3 TRP H 237      25.496   4.058  20.632  1.00 20.00           C  
ATOM   3989  CH2 TRP H 237      26.288   3.646  19.545  1.00 22.02           C  
ATOM   3990  H   TRP H 237      27.008   7.149  26.088  1.00 23.25           H  
ATOM   3991  HA  TRP H 237      29.104   7.465  24.118  1.00 22.93           H  
ATOM   3992  HB3 TRP H 237      27.111   5.235  24.653  1.00 23.44           H  
ATOM   3993  HB2 TRP H 237      28.799   5.277  25.090  1.00 23.44           H  
ATOM   3994  HD1 TRP H 237      30.573   4.978  23.081  1.00 24.41           H  
ATOM   3995  HE1 TRP H 237      30.404   4.043  20.696  1.00 23.90           H  
ATOM   3996  HE3 TRP H 237      25.482   4.793  22.658  1.00 20.39           H  
ATOM   3997  HZ2 TRP H 237      28.301   3.338  18.820  1.00 22.87           H  
ATOM   3998  HZ3 TRP H 237      24.421   4.064  20.540  1.00 20.00           H  
ATOM   3999  HH2 TRP H 237      25.817   3.342  18.625  1.00 22.02           H  
ATOM   4000  N   ILE H 238      25.946   7.742  23.160  1.00 20.22           N  
ATOM   4001  CA  ILE H 238      25.060   8.285  22.126  1.00 18.34           C  
ATOM   4002  C   ILE H 238      25.453   9.726  21.759  1.00 21.78           C  
ATOM   4003  O   ILE H 238      25.631  10.018  20.579  1.00 22.58           O  
ATOM   4004  CB  ILE H 238      23.555   8.250  22.544  1.00 18.72           C  
ATOM   4005  CG1 ILE H 238      23.035   6.801  22.673  1.00 17.38           C  
ATOM   4006  CG2 ILE H 238      22.606   9.053  21.624  1.00 24.17           C  
ATOM   4007  CD1 ILE H 238      21.698   6.684  23.427  1.00 21.08           C  
ATOM   4008  H   ILE H 238      25.502   7.453  24.021  1.00 20.22           H  
ATOM   4009  HA  ILE H 238      25.187   7.666  21.238  1.00 18.34           H  
ATOM   4010  HB  ILE H 238      23.485   8.698  23.534  1.00 18.72           H  
ATOM   4011 HG13 ILE H 238      23.766   6.185  23.192  1.00 17.38           H  
ATOM   4012 HG12 ILE H 238      22.935   6.359  21.681  1.00 17.38           H  
ATOM   4013 HG21 ILE H 238      21.571   8.945  21.936  1.00 24.17           H  
ATOM   4014 HG22 ILE H 238      22.811  10.123  21.638  1.00 24.17           H  
ATOM   4015 HG23 ILE H 238      22.667   8.704  20.595  1.00 24.17           H  
ATOM   4016 HD11 ILE H 238      21.751   5.914  24.198  1.00 21.08           H  
ATOM   4017 HD12 ILE H 238      21.419   7.613  23.925  1.00 21.08           H  
ATOM   4018 HD13 ILE H 238      20.888   6.418  22.748  1.00 21.08           H  
ATOM   4019  N   GLN H 239      25.639  10.566  22.790  1.00 24.48           N  
ATOM   4020  CA  GLN H 239      26.036  11.961  22.660  1.00 25.21           C  
ATOM   4021  C   GLN H 239      27.464  12.124  22.109  1.00 25.84           C  
ATOM   4022  O   GLN H 239      27.662  13.006  21.282  1.00 29.25           O  
ATOM   4023  CB  GLN H 239      25.856  12.665  24.023  1.00 29.62           C  
ATOM   4024  CG  GLN H 239      25.934  14.206  23.974  1.00 37.75           C  
ATOM   4025  CD  GLN H 239      24.829  14.843  23.122  1.00 47.96           C  
ATOM   4026  OE1 GLN H 239      23.723  14.314  23.021  1.00 54.29           O  
ATOM   4027  NE2 GLN H 239      25.110  15.999  22.524  1.00 66.17           N  
ATOM   4028  H   GLN H 239      25.474  10.239  23.733  1.00 24.48           H  
ATOM   4029  HA  GLN H 239      25.353  12.405  21.934  1.00 25.21           H  
ATOM   4030  HB3 GLN H 239      26.596  12.288  24.731  1.00 29.62           H  
ATOM   4031  HB2 GLN H 239      24.889  12.386  24.446  1.00 29.62           H  
ATOM   4032  HG3 GLN H 239      26.910  14.520  23.608  1.00 37.75           H  
ATOM   4033  HG2 GLN H 239      25.847  14.604  24.985  1.00 37.75           H  
ATOM   4034 HE22 GLN H 239      24.412  16.460  21.960  1.00 66.17           H  
ATOM   4035 HE21 GLN H 239      26.046  16.384  22.558  1.00 66.17           H  
ATOM   4036  N   LYS H 240      28.409  11.259  22.522  1.00 25.38           N  
ATOM   4037  CA  LYS H 240      29.791  11.239  22.027  1.00 29.35           C  
ATOM   4038  C   LYS H 240      29.877  10.944  20.518  1.00 26.79           C  
ATOM   4039  O   LYS H 240      30.607  11.645  19.820  1.00 31.16           O  
ATOM   4040  CB  LYS H 240      30.630  10.245  22.863  1.00 40.90           C  
ATOM   4041  CG  LYS H 240      32.117  10.110  22.457  1.00 50.72           C  
ATOM   4042  CD  LYS H 240      32.554   8.671  22.137  1.00 58.41           C  
ATOM   4043  CE  LYS H 240      32.577   7.755  23.373  1.00 61.55           C  
ATOM   4044  NZ  LYS H 240      33.120   6.423  23.055  1.00 63.81           N1+
ATOM   4045  H   LYS H 240      28.176  10.560  23.215  1.00 25.38           H  
ATOM   4046  HA  LYS H 240      30.202  12.238  22.189  1.00 29.35           H  
ATOM   4047  HB3 LYS H 240      30.150   9.268  22.823  1.00 40.90           H  
ATOM   4048  HB2 LYS H 240      30.594  10.546  23.910  1.00 40.90           H  
ATOM   4049  HG3 LYS H 240      32.738  10.495  23.267  1.00 50.72           H  
ATOM   4050  HG2 LYS H 240      32.357  10.748  21.607  1.00 50.72           H  
ATOM   4051  HD3 LYS H 240      33.544   8.705  21.678  1.00 58.41           H  
ATOM   4052  HD2 LYS H 240      31.886   8.257  21.379  1.00 58.41           H  
ATOM   4053  HE3 LYS H 240      31.575   7.635  23.784  1.00 61.55           H  
ATOM   4054  HE2 LYS H 240      33.194   8.197  24.157  1.00 61.55           H  
ATOM   4055  HZ1 LYS H 240      34.066   6.519  22.713  1.00 63.81           H  
ATOM   4056  HZ2 LYS H 240      33.122   5.850  23.887  1.00 63.81           H  
ATOM   4057  HZ3 LYS H 240      32.551   5.987  22.344  1.00 63.81           H  
ATOM   4058  N   VAL H 241      29.109   9.948  20.044  1.00 24.49           N  
ATOM   4059  CA  VAL H 241      29.009   9.602  18.625  1.00 25.25           C  
ATOM   4060  C   VAL H 241      28.337  10.719  17.800  1.00 25.30           C  
ATOM   4061  O   VAL H 241      28.836  11.043  16.724  1.00 28.54           O  
ATOM   4062  CB  VAL H 241      28.259   8.253  18.414  1.00 23.15           C  
ATOM   4063  CG1 VAL H 241      27.831   7.951  16.962  1.00 21.76           C  
ATOM   4064  CG2 VAL H 241      29.101   7.077  18.934  1.00 23.41           C  
ATOM   4065  H   VAL H 241      28.532   9.411  20.679  1.00 24.49           H  
ATOM   4066  HA  VAL H 241      30.027   9.487  18.248  1.00 25.25           H  
ATOM   4067  HB  VAL H 241      27.348   8.279  19.014  1.00 23.15           H  
ATOM   4068 HG11 VAL H 241      27.413   6.948  16.874  1.00 21.76           H  
ATOM   4069 HG12 VAL H 241      27.061   8.639  16.617  1.00 21.76           H  
ATOM   4070 HG13 VAL H 241      28.674   8.011  16.273  1.00 21.76           H  
ATOM   4071 HG21 VAL H 241      28.568   6.136  18.814  1.00 23.41           H  
ATOM   4072 HG22 VAL H 241      30.041   6.994  18.389  1.00 23.41           H  
ATOM   4073 HG23 VAL H 241      29.343   7.183  19.991  1.00 23.41           H  
ATOM   4074  N   ILE H 242      27.253  11.312  18.327  1.00 24.95           N  
ATOM   4075  CA  ILE H 242      26.525  12.405  17.679  1.00 26.86           C  
ATOM   4076  C   ILE H 242      27.336  13.720  17.614  1.00 32.10           C  
ATOM   4077  O   ILE H 242      27.270  14.395  16.589  1.00 34.31           O  
ATOM   4078  CB  ILE H 242      25.123  12.627  18.323  1.00 27.11           C  
ATOM   4079  CG1 ILE H 242      24.222  11.390  18.072  1.00 32.52           C  
ATOM   4080  CG2 ILE H 242      24.401  13.918  17.866  1.00 33.68           C  
ATOM   4081  CD1 ILE H 242      22.903  11.381  18.853  1.00 29.42           C  
ATOM   4082  H   ILE H 242      26.893  11.003  19.221  1.00 24.95           H  
ATOM   4083  HA  ILE H 242      26.354  12.103  16.645  1.00 26.86           H  
ATOM   4084  HB  ILE H 242      25.268  12.707  19.402  1.00 27.11           H  
ATOM   4085 HG13 ILE H 242      24.756  10.465  18.279  1.00 32.52           H  
ATOM   4086 HG12 ILE H 242      23.976  11.327  17.022  1.00 32.52           H  
ATOM   4087 HG21 ILE H 242      23.403  13.996  18.295  1.00 33.68           H  
ATOM   4088 HG22 ILE H 242      24.930  14.817  18.182  1.00 33.68           H  
ATOM   4089 HG23 ILE H 242      24.297  13.957  16.782  1.00 33.68           H  
ATOM   4090 HD11 ILE H 242      22.509  10.368  18.929  1.00 29.42           H  
ATOM   4091 HD12 ILE H 242      23.037  11.767  19.864  1.00 29.42           H  
ATOM   4092 HD13 ILE H 242      22.145  11.985  18.356  1.00 29.42           H  
ATOM   4093  N   ASP H 243      28.120  14.034  18.661  1.00 29.75           N  
ATOM   4094  CA  ASP H 243      29.043  15.177  18.701  1.00 34.46           C  
ATOM   4095  C   ASP H 243      30.247  15.010  17.765  1.00 39.65           C  
ATOM   4096  O   ASP H 243      30.612  15.979  17.101  1.00 41.68           O  
ATOM   4097  CB  ASP H 243      29.550  15.516  20.128  1.00 42.13           C  
ATOM   4098  CG  ASP H 243      28.498  16.039  21.120  1.00 43.05           C  
ATOM   4099  OD1 ASP H 243      27.445  16.542  20.670  1.00 53.10           O  
ATOM   4100  OD2 ASP H 243      28.820  16.044  22.329  1.00 58.41           O1-
ATOM   4101  H   ASP H 243      28.096  13.457  19.492  1.00 29.75           H  
ATOM   4102  HA  ASP H 243      28.496  16.042  18.320  1.00 34.46           H  
ATOM   4103  HB3 ASP H 243      30.345  16.262  20.076  1.00 42.13           H  
ATOM   4104  HB2 ASP H 243      29.996  14.620  20.564  1.00 42.13           H  
ATOM   4105  N   GLN H 244      30.843  13.805  17.729  1.00 38.17           N  
ATOM   4106  CA  GLN H 244      32.014  13.516  16.903  1.00 41.63           C  
ATOM   4107  C   GLN H 244      31.685  13.434  15.404  1.00 39.62           C  
ATOM   4108  O   GLN H 244      32.405  14.029  14.603  1.00 47.76           O  
ATOM   4109  CB  GLN H 244      32.729  12.245  17.413  1.00 49.63           C  
ATOM   4110  CG  GLN H 244      33.952  11.848  16.556  1.00 58.19           C  
ATOM   4111  CD  GLN H 244      34.828  10.764  17.179  1.00 63.37           C  
ATOM   4112  OE1 GLN H 244      34.381   9.971  18.006  1.00 73.58           O  
ATOM   4113  NE2 GLN H 244      36.090  10.707  16.751  1.00 71.40           N  
ATOM   4114  H   GLN H 244      30.505  13.056  18.319  1.00 38.17           H  
ATOM   4115  HA  GLN H 244      32.714  14.345  17.032  1.00 41.63           H  
ATOM   4116  HB3 GLN H 244      32.026  11.412  17.450  1.00 49.63           H  
ATOM   4117  HB2 GLN H 244      33.051  12.420  18.441  1.00 49.63           H  
ATOM   4118  HG3 GLN H 244      34.572  12.731  16.387  1.00 58.19           H  
ATOM   4119  HG2 GLN H 244      33.637  11.495  15.574  1.00 58.19           H  
ATOM   4120 HE22 GLN H 244      36.716  10.006  17.122  1.00 71.40           H  
ATOM   4121 HE21 GLN H 244      36.429  11.362  16.061  1.00 71.40           H  
ATOM   4122  N   PHE H 245      30.639  12.666  15.062  1.00 40.16           N  
ATOM   4123  CA  PHE H 245      30.328  12.290  13.684  1.00 43.85           C  
ATOM   4124  C   PHE H 245      29.173  13.095  13.060  1.00 45.67           C  
ATOM   4125  O   PHE H 245      29.045  13.067  11.838  1.00 51.05           O  
ATOM   4126  CB  PHE H 245      30.087  10.772  13.610  1.00 41.03           C  
ATOM   4127  CG  PHE H 245      31.299   9.931  13.987  1.00 42.70           C  
ATOM   4128  CD1 PHE H 245      31.374   9.299  15.247  1.00 43.74           C  
ATOM   4129  CD2 PHE H 245      32.412   9.862  13.124  1.00 45.08           C  
ATOM   4130  CE1 PHE H 245      32.502   8.568  15.595  1.00 45.86           C  
ATOM   4131  CE2 PHE H 245      33.536   9.135  13.493  1.00 46.46           C  
ATOM   4132  CZ  PHE H 245      33.577   8.482  14.719  1.00 48.09           C  
ATOM   4133  H   PHE H 245      30.098  12.207  15.783  1.00 40.16           H  
ATOM   4134  HA  PHE H 245      31.192  12.497  13.048  1.00 43.85           H  
ATOM   4135  HB3 PHE H 245      29.801  10.513  12.591  1.00 41.03           H  
ATOM   4136  HB2 PHE H 245      29.240  10.483  14.233  1.00 41.03           H  
ATOM   4137  HD1 PHE H 245      30.552   9.363  15.940  1.00 43.74           H  
ATOM   4138  HD2 PHE H 245      32.391  10.368  12.170  1.00 45.08           H  
ATOM   4139  HE1 PHE H 245      32.548   8.074  16.555  1.00 45.86           H  
ATOM   4140  HE2 PHE H 245      34.383   9.076  12.824  1.00 46.46           H  
ATOM   4141  HZ  PHE H 245      34.455   7.919  15.000  1.00 48.09           H  
ATOM   4142  N   GLY H 246      28.395  13.831  13.872  1.00 48.33           N  
ATOM   4143  CA  GLY H 246      27.503  14.913  13.441  1.00 46.39           C  
ATOM   4144  C   GLY H 246      26.132  14.490  12.878  1.00 51.89           C  
ATOM   4145  O   GLY H 246      25.249  15.341  12.810  1.00 68.53           O  
ATOM   4146  H   GLY H 246      28.549  13.772  14.870  1.00 48.33           H  
ATOM   4147  HA3 GLY H 246      28.007  15.514  12.683  1.00 46.39           H  
ATOM   4148  HA2 GLY H 246      27.341  15.582  14.286  1.00 46.39           H  
HETATM 4149  N   NME H 247      25.927  13.233  12.456  1.00  0.00           N  
HETATM 4150  C   NME H 247      24.688  12.817  11.795  1.00  0.00           C  
HETATM 4151  H   NME H 247      26.666  12.551  12.548  1.00  0.00           H  
HETATM 4152  H1  NME H 247      24.697  13.083  10.740  1.00  0.00           H  
HETATM 4153  H2  NME H 247      24.553  11.739  11.862  1.00  0.00           H  
HETATM 4154  H3  NME H 247      23.803  13.284  12.231  1.00  0.00           H  
TER    4155      NME H 247 
HETATM 4156  CH3 ACE L   0      16.213  15.066  20.194  1.00  0.00           C  
HETATM 4157  C   ACE L   0      16.188  16.578  20.108  1.00  0.00           C  
HETATM 4158  O   ACE L   0      16.468  17.251  21.099  1.00  0.00           O  
HETATM 4159  H1  ACE L   0      15.736  14.738  21.118  1.00  0.00           H  
HETATM 4160  H2  ACE L   0      15.675  14.621  19.356  1.00  0.00           H  
HETATM 4161  H3  ACE L   0      17.242  14.707  20.183  1.00  0.00           H  
ATOM   4162  N   GLU L   1C     15.823  17.094  18.925  1.00 60.00           N  
ATOM   4163  CA  GLU L   1C     15.623  18.518  18.652  1.00 60.53           C  
ATOM   4164  C   GLU L   1C     14.471  19.133  19.465  1.00 57.87           C  
ATOM   4165  O   GLU L   1C     13.740  18.419  20.152  1.00 50.90           O  
ATOM   4166  CB  GLU L   1C     15.425  18.713  17.128  1.00  0.00           C  
ATOM   4167  CG  GLU L   1C     16.667  18.355  16.278  1.00  0.00           C  
ATOM   4168  CD  GLU L   1C     17.912  19.211  16.570  1.00  0.00           C  
ATOM   4169  OE1 GLU L   1C     17.753  20.432  16.796  1.00  0.00           O  
ATOM   4170  OE2 GLU L   1C     19.016  18.623  16.564  1.00  0.00           O1-
ATOM   4171  H   GLU L   1C     15.619  16.471  18.159  1.00 60.00           H  
ATOM   4172  HA  GLU L   1C     16.524  19.042  18.971  1.00 60.53           H  
ATOM   4173  HB2 GLU L   1C     14.594  18.088  16.797  1.00  0.00           H  
ATOM   4174  HB3 GLU L   1C     15.116  19.734  16.902  1.00  0.00           H  
ATOM   4175  HG2 GLU L   1C     16.905  17.297  16.401  1.00  0.00           H  
ATOM   4176  HG3 GLU L   1C     16.423  18.482  15.222  1.00  0.00           H  
ATOM   4177  N   ALA L   1B     14.339  20.465  19.371  1.00 56.06           N  
ATOM   4178  CA  ALA L   1B     13.387  21.293  20.121  1.00 51.92           C  
ATOM   4179  C   ALA L   1B     11.903  20.877  20.046  1.00 42.46           C  
ATOM   4180  O   ALA L   1B     11.135  21.297  20.910  1.00 37.75           O  
ATOM   4181  CB  ALA L   1B     13.549  22.747  19.653  1.00 53.90           C  
ATOM   4182  H   ALA L   1B     14.982  20.971  18.778  1.00 56.06           H  
ATOM   4183  HA  ALA L   1B     13.679  21.237  21.171  1.00 51.92           H  
ATOM   4184  HB1 ALA L   1B     12.893  23.420  20.207  1.00 53.90           H  
ATOM   4185  HB2 ALA L   1B     14.571  23.095  19.806  1.00 53.90           H  
ATOM   4186  HB3 ALA L   1B     13.317  22.854  18.593  1.00 53.90           H  
ATOM   4187  N   ASP L   1A     11.535  20.067  19.039  1.00 34.10           N  
ATOM   4188  CA  ASP L   1A     10.169  19.639  18.757  1.00 26.90           C  
ATOM   4189  C   ASP L   1A      9.958  18.123  18.962  1.00 21.51           C  
ATOM   4190  O   ASP L   1A      8.858  17.653  18.673  1.00 18.77           O  
ATOM   4191  CB  ASP L   1A      9.788  20.054  17.310  1.00 39.37           C  
ATOM   4192  CG  ASP L   1A      8.318  20.429  17.073  1.00 46.62           C  
ATOM   4193  OD1 ASP L   1A      7.932  20.423  15.884  1.00 54.99           O  
ATOM   4194  OD2 ASP L   1A      7.623  20.818  18.038  1.00 52.03           O1-
ATOM   4195  H   ASP L   1A     12.238  19.756  18.385  1.00 34.10           H  
ATOM   4196  HA  ASP L   1A      9.510  20.113  19.484  1.00 26.90           H  
ATOM   4197  HB3 ASP L   1A     10.081  19.271  16.608  1.00 39.37           H  
ATOM   4198  HB2 ASP L   1A     10.381  20.922  17.015  1.00 39.37           H  
ATOM   4199  N   CYS L   1      10.970  17.385  19.465  1.00 16.59           N  
ATOM   4200  CA  CYS L   1      10.939  15.931  19.683  1.00 14.84           C  
ATOM   4201  C   CYS L   1       9.745  15.449  20.526  1.00 13.73           C  
ATOM   4202  O   CYS L   1       9.297  16.166  21.422  1.00 13.62           O  
ATOM   4203  CB  CYS L   1      12.281  15.464  20.300  1.00 18.05           C  
ATOM   4204  SG  CYS L   1      12.667  15.920  22.030  1.00 17.88           S  
ATOM   4205  H   CYS L   1      11.839  17.844  19.707  1.00 16.59           H  
ATOM   4206  HA  CYS L   1      10.850  15.480  18.693  1.00 14.84           H  
ATOM   4207  HB3 CYS L   1      13.097  15.828  19.678  1.00 18.05           H  
ATOM   4208  HB2 CYS L   1      12.342  14.381  20.231  1.00 18.05           H  
ATOM   4209  N   GLY L   2       9.282  14.221  20.253  1.00 11.13           N  
ATOM   4210  CA  GLY L   2       8.280  13.531  21.064  1.00 10.75           C  
ATOM   4211  C   GLY L   2       6.883  14.172  21.020  1.00 11.83           C  
ATOM   4212  O   GLY L   2       6.053  13.814  21.848  1.00 11.11           O  
ATOM   4213  H   GLY L   2       9.692  13.698  19.489  1.00 11.13           H  
ATOM   4214  HA3 GLY L   2       8.621  13.502  22.099  1.00 10.75           H  
ATOM   4215  HA2 GLY L   2       8.210  12.497  20.728  1.00 10.75           H  
ATOM   4216  N   LEU L   3       6.620  15.112  20.098  1.00 11.45           N  
ATOM   4217  CA  LEU L   3       5.321  15.750  19.904  1.00 11.11           C  
ATOM   4218  C   LEU L   3       4.829  15.320  18.522  1.00 10.05           C  
ATOM   4219  O   LEU L   3       5.348  15.800  17.517  1.00 14.78           O  
ATOM   4220  CB  LEU L   3       5.470  17.287  19.995  1.00 14.20           C  
ATOM   4221  CG  LEU L   3       5.905  17.812  21.378  1.00 15.35           C  
ATOM   4222  CD1 LEU L   3       6.178  19.324  21.311  1.00 17.49           C  
ATOM   4223  CD2 LEU L   3       4.882  17.471  22.479  1.00 17.50           C  
ATOM   4224  H   LEU L   3       7.349  15.394  19.460  1.00 11.45           H  
ATOM   4225  HA  LEU L   3       4.592  15.418  20.646  1.00 11.11           H  
ATOM   4226  HB3 LEU L   3       4.522  17.753  19.724  1.00 14.20           H  
ATOM   4227  HB2 LEU L   3       6.195  17.626  19.255  1.00 14.20           H  
ATOM   4228  HG  LEU L   3       6.848  17.340  21.649  1.00 15.35           H  
ATOM   4229 HD11 LEU L   3       6.258  19.768  22.303  1.00 17.49           H  
ATOM   4230 HD12 LEU L   3       7.115  19.523  20.791  1.00 17.49           H  
ATOM   4231 HD13 LEU L   3       5.389  19.850  20.772  1.00 17.49           H  
ATOM   4232 HD21 LEU L   3       4.745  18.285  23.192  1.00 17.50           H  
ATOM   4233 HD22 LEU L   3       3.905  17.247  22.060  1.00 17.50           H  
ATOM   4234 HD23 LEU L   3       5.196  16.593  23.042  1.00 17.50           H  
ATOM   4235  N   ARG L   4       3.874  14.383  18.491  1.00 10.04           N  
ATOM   4236  CA  ARG L   4       3.366  13.782  17.260  1.00 10.84           C  
ATOM   4237  C   ARG L   4       2.404  14.749  16.542  1.00 10.25           C  
ATOM   4238  O   ARG L   4       1.452  15.206  17.179  1.00 11.82           O  
ATOM   4239  CB  ARG L   4       2.617  12.491  17.609  1.00 10.25           C  
ATOM   4240  CG  ARG L   4       3.494  11.442  18.310  1.00  9.96           C  
ATOM   4241  CD  ARG L   4       2.720  10.185  18.719  1.00 10.73           C  
ATOM   4242  NE  ARG L   4       1.793  10.491  19.812  1.00  9.88           N  
ATOM   4243  CZ  ARG L   4       0.786   9.752  20.289  1.00  9.37           C  
ATOM   4244  NH1 ARG L   4       0.513   8.530  19.827  1.00 11.56           N  
ATOM   4245  NH2 ARG L   4       0.034  10.260  21.263  1.00 11.72           N1+
ATOM   4246  H   ARG L   4       3.472  14.040  19.356  1.00 10.04           H  
ATOM   4247  HA  ARG L   4       4.225  13.492  16.658  1.00 10.84           H  
ATOM   4248  HB3 ARG L   4       2.211  12.047  16.702  1.00 10.25           H  
ATOM   4249  HB2 ARG L   4       1.760  12.741  18.226  1.00 10.25           H  
ATOM   4250  HG3 ARG L   4       3.890  11.900  19.216  1.00  9.96           H  
ATOM   4251  HG2 ARG L   4       4.370  11.182  17.724  1.00  9.96           H  
ATOM   4252  HD3 ARG L   4       3.386   9.355  18.948  1.00 10.73           H  
ATOM   4253  HD2 ARG L   4       2.097   9.874  17.880  1.00 10.73           H  
ATOM   4254  HE  ARG L   4       1.930  11.405  20.231  1.00  9.88           H  
ATOM   4255 HH12 ARG L   4      -0.260   8.011  20.224  1.00 11.56           H  
ATOM   4256 HH11 ARG L   4       1.105   8.108  19.124  1.00 11.56           H  
ATOM   4257 HH22 ARG L   4      -0.714   9.713  21.677  1.00 11.72           H  
ATOM   4258 HH21 ARG L   4       0.233  11.178  21.643  1.00 11.72           H  
ATOM   4259  N   PRO L   5       2.655  15.034  15.244  1.00 11.33           N  
ATOM   4260  CA  PRO L   5       1.755  15.820  14.372  1.00 13.51           C  
ATOM   4261  C   PRO L   5       0.248  15.518  14.407  1.00 12.49           C  
ATOM   4262  O   PRO L   5      -0.537  16.462  14.358  1.00 15.89           O  
ATOM   4263  CB  PRO L   5       2.318  15.566  12.979  1.00 14.87           C  
ATOM   4264  CG  PRO L   5       3.806  15.418  13.209  1.00 14.81           C  
ATOM   4265  CD  PRO L   5       3.873  14.659  14.518  1.00 12.09           C  
ATOM   4266  HA  PRO L   5       1.899  16.868  14.609  1.00 13.51           H  
ATOM   4267  HB3 PRO L   5       2.078  16.357  12.267  1.00 14.87           H  
ATOM   4268  HB2 PRO L   5       1.909  14.629  12.602  1.00 14.87           H  
ATOM   4269  HG3 PRO L   5       4.256  16.405  13.331  1.00 14.81           H  
ATOM   4270  HG2 PRO L   5       4.323  14.905  12.406  1.00 14.81           H  
ATOM   4271  HD2 PRO L   5       3.875  13.585  14.332  1.00 12.09           H  
ATOM   4272  HD3 PRO L   5       4.786  14.918  15.053  1.00 12.09           H  
ATOM   4273  N   LEU L   6      -0.130  14.233  14.481  1.00 13.62           N  
ATOM   4274  CA  LEU L   6      -1.529  13.802  14.458  0.92 14.06           C  
ATOM   4275  C   LEU L   6      -2.146  13.652  15.860  1.00 13.55           C  
ATOM   4276  O   LEU L   6      -3.339  13.358  15.936  1.00 15.70           O  
ATOM   4277  CB  LEU L   6      -1.659  12.508  13.621  0.92 13.43           C  
ATOM   4278  CG  LEU L   6      -1.264  12.686  12.135  0.92 11.98           C  
ATOM   4279  CD1 LEU L   6      -1.322  11.347  11.372  0.92 16.15           C  
ATOM   4280  CD2 LEU L   6      -2.090  13.782  11.428  0.92 18.93           C  
ATOM   4281  H   LEU L   6       0.568  13.499  14.494  1.00 13.62           H  
ATOM   4282  HA  LEU L   6      -2.128  14.567  13.968  0.92 14.06           H  
ATOM   4283  HB3 LEU L   6      -2.686  12.143  13.662  0.92 13.43           H  
ATOM   4284  HB2 LEU L   6      -1.048  11.724  14.072  0.92 13.43           H  
ATOM   4285  HG  LEU L   6      -0.221  13.005  12.109  0.92 11.98           H  
ATOM   4286 HD11 LEU L   6      -2.005  11.369  10.523  0.92 16.15           H  
ATOM   4287 HD12 LEU L   6      -0.339  11.074  10.986  0.92 16.15           H  
ATOM   4288 HD13 LEU L   6      -1.653  10.536  12.016  0.92 16.15           H  
ATOM   4289 HD21 LEU L   6      -2.299  13.546  10.384  0.92 18.93           H  
ATOM   4290 HD22 LEU L   6      -3.049  13.951  11.918  0.92 18.93           H  
ATOM   4291 HD23 LEU L   6      -1.548  14.729  11.429  0.92 18.93           H  
ATOM   4292  N   PHE L   7      -1.358  13.876  16.929  1.00 13.60           N  
ATOM   4293  CA  PHE L   7      -1.805  13.753  18.315  1.00 12.25           C  
ATOM   4294  C   PHE L   7      -1.523  15.038  19.105  1.00 12.68           C  
ATOM   4295  O   PHE L   7      -2.397  15.902  19.091  1.00 13.64           O  
ATOM   4296  CB  PHE L   7      -1.310  12.440  18.954  1.00 11.89           C  
ATOM   4297  CG  PHE L   7      -1.915  11.201  18.311  1.00 12.05           C  
ATOM   4298  CD1 PHE L   7      -3.241  10.828  18.616  1.00 13.37           C  
ATOM   4299  CD2 PHE L   7      -1.249  10.541  17.256  1.00 12.10           C  
ATOM   4300  CE1 PHE L   7      -3.855   9.794  17.924  1.00 13.20           C  
ATOM   4301  CE2 PHE L   7      -1.883   9.511  16.575  1.00 13.16           C  
ATOM   4302  CZ  PHE L   7      -3.176   9.133  16.912  1.00 12.14           C  
ATOM   4303  H   PHE L   7      -0.395  14.153  16.792  1.00 13.60           H  
ATOM   4304  HA  PHE L   7      -2.891  13.681  18.325  1.00 12.25           H  
ATOM   4305  HB3 PHE L   7      -1.558  12.433  20.016  1.00 11.89           H  
ATOM   4306  HB2 PHE L   7      -0.229  12.373  18.899  1.00 11.89           H  
ATOM   4307  HD1 PHE L   7      -3.790  11.356  19.379  1.00 13.37           H  
ATOM   4308  HD2 PHE L   7      -0.255  10.846  16.963  1.00 12.10           H  
ATOM   4309  HE1 PHE L   7      -4.869   9.511  18.167  1.00 13.20           H  
ATOM   4310  HE2 PHE L   7      -1.380   9.007  15.766  1.00 13.16           H  
ATOM   4311  HZ  PHE L   7      -3.661   8.333  16.372  1.00 12.14           H  
ATOM   4312  N   GLU L   8      -0.359  15.165  19.776  1.00 11.87           N  
ATOM   4313  CA  GLU L   8      -0.024  16.311  20.646  1.00 12.78           C  
ATOM   4314  C   GLU L   8      -0.141  17.698  19.993  1.00 14.91           C  
ATOM   4315  O   GLU L   8      -0.604  18.621  20.663  1.00 16.00           O  
ATOM   4316  CB  GLU L   8       1.385  16.193  21.268  1.00 12.11           C  
ATOM   4317  CG  GLU L   8       1.534  15.136  22.381  1.00 10.84           C  
ATOM   4318  CD  GLU L   8       1.604  13.682  21.915  1.00 12.21           C  
ATOM   4319  OE1 GLU L   8       1.115  12.822  22.674  1.00 11.21           O  
ATOM   4320  OE2 GLU L   8       2.137  13.431  20.815  1.00 11.68           O1-
ATOM   4321  H   GLU L   8       0.328  14.425  19.741  1.00 11.87           H  
ATOM   4322  HA  GLU L   8      -0.750  16.296  21.462  1.00 12.78           H  
ATOM   4323  HB3 GLU L   8       1.657  17.153  21.709  1.00 12.11           H  
ATOM   4324  HB2 GLU L   8       2.123  16.033  20.481  1.00 12.11           H  
ATOM   4325  HG3 GLU L   8       0.736  15.263  23.115  1.00 10.84           H  
ATOM   4326  HG2 GLU L   8       2.463  15.332  22.914  1.00 10.84           H  
ATOM   4327  N   LYS L   9       0.259  17.822  18.715  1.00 14.61           N  
ATOM   4328  CA  LYS L   9       0.177  19.076  17.956  1.00 14.62           C  
ATOM   4329  C   LYS L   9      -1.262  19.568  17.717  1.00 14.40           C  
ATOM   4330  O   LYS L   9      -1.467  20.776  17.615  1.00 18.21           O  
ATOM   4331  CB  LYS L   9       0.866  18.912  16.591  1.00 17.59           C  
ATOM   4332  CG  LYS L   9       2.370  18.620  16.624  1.00 28.85           C  
ATOM   4333  CD  LYS L   9       3.213  19.667  17.363  1.00 40.92           C  
ATOM   4334  CE  LYS L   9       4.583  19.901  16.713  1.00 43.56           C  
ATOM   4335  NZ  LYS L   9       5.367  18.665  16.539  1.00 47.02           N1+
ATOM   4336  H   LYS L   9       0.625  17.018  18.225  1.00 14.61           H  
ATOM   4337  HA  LYS L   9       0.693  19.848  18.529  1.00 14.62           H  
ATOM   4338  HB3 LYS L   9       0.721  19.821  16.003  1.00 17.59           H  
ATOM   4339  HB2 LYS L   9       0.366  18.122  16.036  1.00 17.59           H  
ATOM   4340  HG3 LYS L   9       2.709  18.580  15.590  1.00 28.85           H  
ATOM   4341  HG2 LYS L   9       2.557  17.636  17.051  1.00 28.85           H  
ATOM   4342  HD3 LYS L   9       3.346  19.360  18.401  1.00 40.92           H  
ATOM   4343  HD2 LYS L   9       2.681  20.618  17.402  1.00 40.92           H  
ATOM   4344  HE3 LYS L   9       5.141  20.610  17.320  1.00 43.56           H  
ATOM   4345  HE2 LYS L   9       4.460  20.364  15.733  1.00 43.56           H  
ATOM   4346  HZ1 LYS L   9       4.886  18.030  15.918  1.00 47.02           H  
ATOM   4347  HZ2 LYS L   9       6.265  18.915  16.145  1.00 47.02           H  
ATOM   4348  HZ3 LYS L   9       5.512  18.219  17.433  1.00 47.02           H  
ATOM   4349  N   LYS L  10      -2.214  18.626  17.631  1.00 16.15           N  
ATOM   4350  CA  LYS L  10      -3.640  18.878  17.419  1.00 19.29           C  
ATOM   4351  C   LYS L  10      -4.452  18.824  18.727  1.00 18.66           C  
ATOM   4352  O   LYS L  10      -5.652  19.092  18.683  1.00 19.10           O  
ATOM   4353  CB  LYS L  10      -4.175  17.826  16.425  1.00 24.76           C  
ATOM   4354  CG  LYS L  10      -3.569  17.956  15.017  1.00 28.61           C  
ATOM   4355  CD  LYS L  10      -4.010  16.836  14.062  1.00 27.87           C  
ATOM   4356  CE  LYS L  10      -5.466  16.968  13.589  1.00 25.88           C  
ATOM   4357  NZ  LYS L  10      -5.835  15.878  12.669  1.00 30.63           N1+
ATOM   4358  H   LYS L  10      -1.953  17.656  17.740  1.00 16.15           H  
ATOM   4359  HA  LYS L  10      -3.787  19.869  16.986  1.00 19.29           H  
ATOM   4360  HB3 LYS L  10      -5.258  17.921  16.342  1.00 24.76           H  
ATOM   4361  HB2 LYS L  10      -3.988  16.824  16.816  1.00 24.76           H  
ATOM   4362  HG3 LYS L  10      -2.483  17.948  15.085  1.00 28.61           H  
ATOM   4363  HG2 LYS L  10      -3.830  18.925  14.592  1.00 28.61           H  
ATOM   4364  HD3 LYS L  10      -3.885  15.880  14.570  1.00 27.87           H  
ATOM   4365  HD2 LYS L  10      -3.334  16.816  13.206  1.00 27.87           H  
ATOM   4366  HE3 LYS L  10      -5.609  17.919  13.074  1.00 25.88           H  
ATOM   4367  HE2 LYS L  10      -6.153  16.955  14.433  1.00 25.88           H  
ATOM   4368  HZ1 LYS L  10      -5.736  14.990  13.141  1.00 30.63           H  
ATOM   4369  HZ2 LYS L  10      -6.793  15.995  12.372  1.00 30.63           H  
ATOM   4370  HZ3 LYS L  10      -5.229  15.897  11.861  1.00 30.63           H  
ATOM   4371  N   SER L  11      -3.806  18.448  19.847  1.00 16.11           N  
ATOM   4372  CA  SER L  11      -4.405  18.162  21.154  1.00 16.47           C  
ATOM   4373  C   SER L  11      -5.438  17.011  21.095  1.00 18.07           C  
ATOM   4374  O   SER L  11      -6.482  17.079  21.745  1.00 20.10           O  
ATOM   4375  CB  SER L  11      -4.928  19.465  21.806  1.00 21.16           C  
ATOM   4376  OG  SER L  11      -5.272  19.270  23.164  1.00 20.95           O  
ATOM   4377  H   SER L  11      -2.814  18.266  19.786  1.00 16.11           H  
ATOM   4378  HA  SER L  11      -3.583  17.795  21.770  1.00 16.47           H  
ATOM   4379  HB3 SER L  11      -5.800  19.851  21.275  1.00 21.16           H  
ATOM   4380  HB2 SER L  11      -4.163  20.241  21.764  1.00 21.16           H  
ATOM   4381  HG  SER L  11      -6.008  18.652  23.200  1.00 20.95           H  
ATOM   4382  N   LEU L  12      -5.115  15.971  20.310  1.00 14.85           N  
ATOM   4383  CA  LEU L  12      -5.867  14.723  20.221  1.00 15.21           C  
ATOM   4384  C   LEU L  12      -5.076  13.648  20.965  1.00 15.18           C  
ATOM   4385  O   LEU L  12      -3.873  13.530  20.740  1.00 16.61           O  
ATOM   4386  CB  LEU L  12      -6.030  14.308  18.740  1.00 14.59           C  
ATOM   4387  CG  LEU L  12      -6.909  15.244  17.887  1.00 16.78           C  
ATOM   4388  CD1 LEU L  12      -6.877  14.802  16.415  1.00 22.28           C  
ATOM   4389  CD2 LEU L  12      -8.356  15.343  18.408  1.00 17.76           C  
ATOM   4390  H   LEU L  12      -4.231  15.984  19.816  1.00 14.85           H  
ATOM   4391  HA  LEU L  12      -6.849  14.822  20.687  1.00 15.21           H  
ATOM   4392  HB3 LEU L  12      -6.449  13.300  18.692  1.00 14.59           H  
ATOM   4393  HB2 LEU L  12      -5.047  14.240  18.274  1.00 14.59           H  
ATOM   4394  HG  LEU L  12      -6.476  16.245  17.926  1.00 16.78           H  
ATOM   4395 HD11 LEU L  12      -7.540  15.413  15.803  1.00 22.28           H  
ATOM   4396 HD12 LEU L  12      -5.871  14.893  16.004  1.00 22.28           H  
ATOM   4397 HD13 LEU L  12      -7.186  13.762  16.307  1.00 22.28           H  
ATOM   4398 HD21 LEU L  12      -9.089  15.203  17.612  1.00 17.76           H  
ATOM   4399 HD22 LEU L  12      -8.573  14.594  19.170  1.00 17.76           H  
ATOM   4400 HD23 LEU L  12      -8.541  16.322  18.850  1.00 17.76           H  
ATOM   4401  N   GLU L  13      -5.764  12.859  21.801  1.00 17.03           N  
ATOM   4402  CA  GLU L  13      -5.178  11.682  22.436  1.00 15.25           C  
ATOM   4403  C   GLU L  13      -5.421  10.440  21.574  1.00 14.08           C  
ATOM   4404  O   GLU L  13      -6.471  10.332  20.937  1.00 17.40           O  
ATOM   4405  CB  GLU L  13      -5.762  11.480  23.849  1.00 21.50           C  
ATOM   4406  CG  GLU L  13      -5.422  12.632  24.823  1.00 30.10           C  
ATOM   4407  CD  GLU L  13      -5.811  12.397  26.295  1.00 41.84           C  
ATOM   4408  OE1 GLU L  13      -6.368  11.324  26.625  1.00 48.98           O  
ATOM   4409  OE2 GLU L  13      -5.539  13.322  27.093  1.00 52.33           O1-
ATOM   4410  H   GLU L  13      -6.753  13.001  21.941  1.00 17.03           H  
ATOM   4411  HA  GLU L  13      -4.104  11.825  22.536  1.00 15.25           H  
ATOM   4412  HB3 GLU L  13      -5.383  10.539  24.251  1.00 21.50           H  
ATOM   4413  HB2 GLU L  13      -6.845  11.366  23.787  1.00 21.50           H  
ATOM   4414  HG3 GLU L  13      -5.906  13.549  24.485  1.00 30.10           H  
ATOM   4415  HG2 GLU L  13      -4.350  12.825  24.787  1.00 30.10           H  
ATOM   4416  N   ASP L  14      -4.465   9.497  21.619  1.00 13.69           N  
ATOM   4417  CA  ASP L  14      -4.659   8.143  21.098  1.00 14.28           C  
ATOM   4418  C   ASP L  14      -5.506   7.331  22.109  1.00 15.08           C  
ATOM   4419  O   ASP L  14      -5.749   7.787  23.228  1.00 16.03           O  
ATOM   4420  CB  ASP L  14      -3.315   7.483  20.688  1.00 13.82           C  
ATOM   4421  CG  ASP L  14      -2.412   6.969  21.814  1.00 14.70           C  
ATOM   4422  OD1 ASP L  14      -2.763   5.944  22.430  1.00 13.32           O  
ATOM   4423  OD2 ASP L  14      -1.391   7.627  22.084  1.00 14.04           O1-
ATOM   4424  H   ASP L  14      -3.632   9.653  22.173  1.00 13.69           H  
ATOM   4425  HA  ASP L  14      -5.252   8.208  20.185  1.00 14.28           H  
ATOM   4426  HB3 ASP L  14      -2.743   8.215  20.115  1.00 13.82           H  
ATOM   4427  HB2 ASP L  14      -3.489   6.678  19.979  1.00 13.82           H  
ATOM   4428  N   LYS L  14A     -5.949   6.137  21.693  1.00 16.32           N  
ATOM   4429  CA  LYS L  14A     -6.868   5.280  22.445  1.00 17.75           C  
ATOM   4430  C   LYS L  14A     -6.332   4.682  23.763  1.00 17.81           C  
ATOM   4431  O   LYS L  14A     -7.160   4.244  24.561  1.00 20.15           O  
ATOM   4432  CB  LYS L  14A     -7.374   4.157  21.517  1.00 21.75           C  
ATOM   4433  CG  LYS L  14A     -8.312   4.655  20.404  1.00 28.86           C  
ATOM   4434  CD  LYS L  14A     -8.605   3.559  19.365  1.00 41.47           C  
ATOM   4435  CE  LYS L  14A     -9.646   3.958  18.306  1.00 46.60           C  
ATOM   4436  NZ  LYS L  14A    -11.019   3.961  18.845  1.00 54.68           N1+
ATOM   4437  H   LYS L  14A     -5.688   5.805  20.771  1.00 16.32           H  
ATOM   4438  HA  LYS L  14A     -7.725   5.899  22.718  1.00 17.75           H  
ATOM   4439  HB3 LYS L  14A     -7.921   3.410  22.095  1.00 21.75           H  
ATOM   4440  HB2 LYS L  14A     -6.521   3.630  21.089  1.00 21.75           H  
ATOM   4441  HG3 LYS L  14A     -7.876   5.515  19.897  1.00 28.86           H  
ATOM   4442  HG2 LYS L  14A     -9.239   5.010  20.856  1.00 28.86           H  
ATOM   4443  HD3 LYS L  14A     -8.909   2.640  19.870  1.00 41.47           H  
ATOM   4444  HD2 LYS L  14A     -7.674   3.312  18.853  1.00 41.47           H  
ATOM   4445  HE3 LYS L  14A     -9.616   3.244  17.483  1.00 46.60           H  
ATOM   4446  HE2 LYS L  14A     -9.410   4.937  17.886  1.00 46.60           H  
ATOM   4447  HZ1 LYS L  14A    -11.081   4.636  19.594  1.00 54.68           H  
ATOM   4448  HZ2 LYS L  14A    -11.668   4.211  18.113  1.00 54.68           H  
ATOM   4449  HZ3 LYS L  14A    -11.245   3.043  19.200  1.00 54.68           H  
ATOM   4450  N   THR L  14B     -5.003   4.640  23.978  1.00 15.53           N  
ATOM   4451  CA  THR L  14B     -4.392   3.895  25.089  1.00 14.06           C  
ATOM   4452  C   THR L  14B     -3.262   4.643  25.836  1.00 11.76           C  
ATOM   4453  O   THR L  14B     -2.670   4.044  26.732  1.00 16.21           O  
ATOM   4454  CB  THR L  14B     -3.863   2.504  24.622  1.00 15.46           C  
ATOM   4455  OG1 THR L  14B     -2.657   2.597  23.886  1.00 17.55           O  
ATOM   4456  CG2 THR L  14B     -4.866   1.664  23.819  1.00 20.85           C  
ATOM   4457  H   THR L  14B     -4.366   5.046  23.302  1.00 15.53           H  
ATOM   4458  HA  THR L  14B     -5.141   3.714  25.861  1.00 14.06           H  
ATOM   4459  HB  THR L  14B     -3.641   1.921  25.517  1.00 15.46           H  
ATOM   4460  HG1 THR L  14B     -2.850   3.018  23.043  1.00 17.55           H  
ATOM   4461 HG21 THR L  14B     -4.472   0.665  23.628  1.00 20.85           H  
ATOM   4462 HG22 THR L  14B     -5.804   1.548  24.363  1.00 20.85           H  
ATOM   4463 HG23 THR L  14B     -5.092   2.114  22.852  1.00 20.85           H  
ATOM   4464  N   GLU L  14C     -2.973   5.921  25.524  1.00 12.36           N  
ATOM   4465  CA  GLU L  14C     -1.967   6.709  26.258  1.00 12.46           C  
ATOM   4466  C   GLU L  14C     -2.369   7.046  27.702  1.00 13.05           C  
ATOM   4467  O   GLU L  14C     -1.488   7.278  28.527  1.00 15.23           O  
ATOM   4468  CB  GLU L  14C     -1.597   7.995  25.506  1.00 11.85           C  
ATOM   4469  CG  GLU L  14C     -2.796   8.889  25.132  1.00 12.54           C  
ATOM   4470  CD  GLU L  14C     -2.333  10.294  24.760  1.00 12.31           C  
ATOM   4471  OE1 GLU L  14C     -2.102  10.527  23.556  1.00 13.04           O  
ATOM   4472  OE2 GLU L  14C     -2.206  11.118  25.690  1.00 13.55           O1-
ATOM   4473  H   GLU L  14C     -3.466   6.389  24.775  1.00 12.36           H  
ATOM   4474  HA  GLU L  14C     -1.058   6.108  26.326  1.00 12.46           H  
ATOM   4475  HB3 GLU L  14C     -1.024   7.732  24.621  1.00 11.85           H  
ATOM   4476  HB2 GLU L  14C     -0.896   8.566  26.118  1.00 11.85           H  
ATOM   4477  HG3 GLU L  14C     -3.506   8.968  25.957  1.00 12.54           H  
ATOM   4478  HG2 GLU L  14C     -3.352   8.450  24.304  1.00 12.54           H  
ATOM   4479  N   ARG L  14D     -3.681   7.047  27.984  1.00 14.88           N  
ATOM   4480  CA  ARG L  14D     -4.228   7.258  29.317  1.00 15.21           C  
ATOM   4481  C   ARG L  14D     -3.900   6.112  30.287  1.00 17.59           C  
ATOM   4482  O   ARG L  14D     -3.721   6.384  31.470  1.00 17.01           O  
ATOM   4483  CB  ARG L  14D     -5.734   7.526  29.204  1.00 21.80           C  
ATOM   4484  CG  ARG L  14D     -6.332   8.109  30.485  1.00 33.45           C  
ATOM   4485  CD  ARG L  14D     -7.779   8.580  30.281  1.00 43.62           C  
ATOM   4486  NE  ARG L  14D     -8.138   9.614  31.261  1.00 54.75           N  
ATOM   4487  CZ  ARG L  14D     -7.767  10.910  31.198  1.00 59.51           C  
ATOM   4488  NH1 ARG L  14D     -7.036  11.406  30.183  1.00 64.41           N  
ATOM   4489  NH2 ARG L  14D     -8.140  11.736  32.182  1.00 63.32           N1+
ATOM   4490  H   ARG L  14D     -4.353   6.888  27.244  1.00 14.88           H  
ATOM   4491  HA  ARG L  14D     -3.757   8.164  29.705  1.00 15.21           H  
ATOM   4492  HB3 ARG L  14D     -6.270   6.625  28.903  1.00 21.80           H  
ATOM   4493  HB2 ARG L  14D     -5.888   8.260  28.411  1.00 21.80           H  
ATOM   4494  HG3 ARG L  14D     -5.695   8.895  30.897  1.00 33.45           H  
ATOM   4495  HG2 ARG L  14D     -6.337   7.311  31.226  1.00 33.45           H  
ATOM   4496  HD3 ARG L  14D     -8.442   7.745  30.513  1.00 43.62           H  
ATOM   4497  HD2 ARG L  14D     -8.002   8.869  29.253  1.00 43.62           H  
ATOM   4498  HE  ARG L  14D     -8.635   9.287  32.077  1.00 54.75           H  
ATOM   4499 HH12 ARG L  14D     -6.780  12.382  30.150  1.00 64.41           H  
ATOM   4500 HH11 ARG L  14D     -6.775  10.815  29.405  1.00 64.41           H  
ATOM   4501 HH22 ARG L  14D     -7.876  12.710  32.160  1.00 63.32           H  
ATOM   4502 HH21 ARG L  14D     -8.683  11.390  32.960  1.00 63.32           H  
ATOM   4503  N   GLU L  14E     -3.749   4.878  29.767  1.00 16.34           N  
ATOM   4504  CA  GLU L  14E     -3.236   3.721  30.506  1.00 15.42           C  
ATOM   4505  C   GLU L  14E     -1.807   3.956  31.031  1.00 15.59           C  
ATOM   4506  O   GLU L  14E     -1.515   3.576  32.165  1.00 15.68           O  
ATOM   4507  CB  GLU L  14E     -3.311   2.468  29.607  1.00 18.75           C  
ATOM   4508  CG  GLU L  14E     -2.840   1.154  30.271  1.00 21.27           C  
ATOM   4509  CD  GLU L  14E     -2.847  -0.086  29.362  1.00 21.14           C  
ATOM   4510  OE1 GLU L  14E     -2.555  -1.170  29.911  1.00 21.03           O  
ATOM   4511  OE2 GLU L  14E     -3.123   0.037  28.148  1.00 22.62           O1-
ATOM   4512  H   GLU L  14E     -3.899   4.740  28.778  1.00 16.34           H  
ATOM   4513  HA  GLU L  14E     -3.889   3.565  31.367  1.00 15.42           H  
ATOM   4514  HB3 GLU L  14E     -2.696   2.636  28.726  1.00 18.75           H  
ATOM   4515  HB2 GLU L  14E     -4.335   2.346  29.250  1.00 18.75           H  
ATOM   4516  HG3 GLU L  14E     -3.462   0.954  31.144  1.00 21.27           H  
ATOM   4517  HG2 GLU L  14E     -1.820   1.265  30.634  1.00 21.27           H  
ATOM   4518  N   LEU L  14F     -0.965   4.613  30.212  1.00 13.94           N  
ATOM   4519  CA  LEU L  14F      0.382   5.028  30.595  1.00 12.59           C  
ATOM   4520  C   LEU L  14F      0.352   6.117  31.678  1.00 14.10           C  
ATOM   4521  O   LEU L  14F      1.051   5.965  32.676  1.00 13.76           O  
ATOM   4522  CB  LEU L  14F      1.204   5.486  29.369  1.00 13.31           C  
ATOM   4523  CG  LEU L  14F      1.251   4.505  28.177  1.00 18.30           C  
ATOM   4524  CD1 LEU L  14F      2.248   4.991  27.115  1.00 20.91           C  
ATOM   4525  CD2 LEU L  14F      1.571   3.064  28.589  1.00 19.60           C  
ATOM   4526  H   LEU L  14F     -1.283   4.908  29.300  1.00 13.94           H  
ATOM   4527  HA  LEU L  14F      0.879   4.162  31.033  1.00 12.59           H  
ATOM   4528  HB3 LEU L  14F      2.224   5.654  29.703  1.00 13.31           H  
ATOM   4529  HB2 LEU L  14F      0.856   6.456  29.016  1.00 13.31           H  
ATOM   4530  HG  LEU L  14F      0.263   4.500  27.713  1.00 18.30           H  
ATOM   4531 HD11 LEU L  14F      1.855   4.806  26.117  1.00 20.91           H  
ATOM   4532 HD12 LEU L  14F      2.452   6.058  27.209  1.00 20.91           H  
ATOM   4533 HD13 LEU L  14F      3.207   4.474  27.186  1.00 20.91           H  
ATOM   4534 HD21 LEU L  14F      2.114   2.520  27.816  1.00 19.60           H  
ATOM   4535 HD22 LEU L  14F      2.186   3.049  29.480  1.00 19.60           H  
ATOM   4536 HD23 LEU L  14F      0.656   2.514  28.806  1.00 19.60           H  
ATOM   4537  N   LEU L  14G     -0.495   7.149  31.499  1.00 12.42           N  
ATOM   4538  CA  LEU L  14G     -0.683   8.256  32.445  1.00 12.02           C  
ATOM   4539  C   LEU L  14G     -1.106   7.765  33.845  1.00 12.46           C  
ATOM   4540  O   LEU L  14G     -0.483   8.148  34.833  1.00 15.07           O  
ATOM   4541  CB  LEU L  14G     -1.715   9.262  31.875  1.00 18.06           C  
ATOM   4542  CG  LEU L  14G     -1.472  10.759  32.197  1.00 31.04           C  
ATOM   4543  CD1 LEU L  14G     -2.721  11.598  31.861  1.00 26.98           C  
ATOM   4544  CD2 LEU L  14G     -0.989  11.061  33.628  1.00 18.81           C  
ATOM   4545  H   LEU L  14G     -1.046   7.190  30.652  1.00 12.42           H  
ATOM   4546  HA  LEU L  14G      0.284   8.752  32.526  1.00 12.02           H  
ATOM   4547  HB3 LEU L  14G     -2.717   8.976  32.203  1.00 18.06           H  
ATOM   4548  HB2 LEU L  14G     -1.747   9.173  30.788  1.00 18.06           H  
ATOM   4549  HG  LEU L  14G     -0.672  11.091  31.534  1.00 31.04           H  
ATOM   4550 HD11 LEU L  14G     -2.465  12.421  31.194  1.00 26.98           H  
ATOM   4551 HD12 LEU L  14G     -3.492  11.010  31.360  1.00 26.98           H  
ATOM   4552 HD13 LEU L  14G     -3.178  12.030  32.752  1.00 26.98           H  
ATOM   4553 HD21 LEU L  14G     -1.022  12.131  33.836  1.00 18.81           H  
ATOM   4554 HD22 LEU L  14G     -1.615  10.570  34.372  1.00 18.81           H  
ATOM   4555 HD23 LEU L  14G      0.043  10.743  33.781  1.00 18.81           H  
ATOM   4556  N   GLU L  14H     -2.127   6.892  33.886  1.00 13.80           N  
ATOM   4557  CA  GLU L  14H     -2.690   6.278  35.090  1.00 15.25           C  
ATOM   4558  C   GLU L  14H     -1.714   5.392  35.881  1.00 15.10           C  
ATOM   4559  O   GLU L  14H     -1.901   5.255  37.088  1.00 18.46           O  
ATOM   4560  CB  GLU L  14H     -3.941   5.469  34.699  1.00 15.96           C  
ATOM   4561  CG  GLU L  14H     -5.154   6.357  34.337  1.00 18.42           C  
ATOM   4562  CD  GLU L  14H     -6.357   5.615  33.728  1.00 21.86           C  
ATOM   4563  OE1 GLU L  14H     -6.246   4.402  33.434  1.00 28.06           O  
ATOM   4564  OE2 GLU L  14H     -7.392   6.295  33.554  1.00 27.54           O1-
ATOM   4565  H   GLU L  14H     -2.581   6.635  33.018  1.00 13.80           H  
ATOM   4566  HA  GLU L  14H     -2.994   7.084  35.760  1.00 15.25           H  
ATOM   4567  HB3 GLU L  14H     -4.227   4.790  35.504  1.00 15.96           H  
ATOM   4568  HB2 GLU L  14H     -3.681   4.832  33.851  1.00 15.96           H  
ATOM   4569  HG3 GLU L  14H     -4.857   7.142  33.642  1.00 18.42           H  
ATOM   4570  HG2 GLU L  14H     -5.489   6.873  35.239  1.00 18.42           H  
ATOM   4571  N   SER L  14I     -0.699   4.822  35.210  1.00 14.69           N  
ATOM   4572  CA  SER L  14I      0.346   4.012  35.839  1.00 14.59           C  
ATOM   4573  C   SER L  14I      1.449   4.847  36.522  1.00 17.39           C  
ATOM   4574  O   SER L  14I      2.209   4.279  37.307  1.00 16.44           O  
ATOM   4575  CB  SER L  14I      0.907   3.028  34.794  1.00 16.20           C  
ATOM   4576  OG  SER L  14I      1.849   3.628  33.930  1.00 15.39           O  
ATOM   4577  H   SER L  14I     -0.610   4.981  34.216  1.00 14.69           H  
ATOM   4578  HA  SER L  14I     -0.126   3.409  36.617  1.00 14.59           H  
ATOM   4579  HB3 SER L  14I      0.106   2.580  34.207  1.00 16.20           H  
ATOM   4580  HB2 SER L  14I      1.407   2.206  35.303  1.00 16.20           H  
ATOM   4581  HG  SER L  14I      1.438   4.379  33.487  1.00 15.39           H  
ATOM   4582  N   TYR L  14J      1.518   6.159  36.227  1.00 15.83           N  
ATOM   4583  CA  TYR L  14J      2.498   7.095  36.785  1.00 16.88           C  
ATOM   4584  C   TYR L  14J      1.990   7.638  38.132  1.00 18.21           C  
ATOM   4585  O   TYR L  14J      1.577   8.794  38.236  1.00 22.69           O  
ATOM   4586  CB  TYR L  14J      2.832   8.192  35.747  1.00 16.76           C  
ATOM   4587  CG  TYR L  14J      3.281   7.705  34.372  1.00 15.38           C  
ATOM   4588  CD1 TYR L  14J      3.926   6.460  34.199  1.00 16.96           C  
ATOM   4589  CD2 TYR L  14J      3.019   8.499  33.238  1.00 13.99           C  
ATOM   4590  CE1 TYR L  14J      4.321   6.025  32.922  1.00 14.47           C  
ATOM   4591  CE2 TYR L  14J      3.388   8.048  31.957  1.00 15.93           C  
ATOM   4592  CZ  TYR L  14J      4.070   6.828  31.797  1.00 15.75           C  
ATOM   4593  OH  TYR L  14J      4.462   6.417  30.557  1.00 14.16           O  
ATOM   4594  H   TYR L  14J      0.852   6.557  35.578  1.00 15.83           H  
ATOM   4595  HA  TYR L  14J      3.421   6.559  36.999  1.00 16.88           H  
ATOM   4596  HB3 TYR L  14J      3.618   8.837  36.142  1.00 16.76           H  
ATOM   4597  HB2 TYR L  14J      1.962   8.833  35.603  1.00 16.76           H  
ATOM   4598  HD1 TYR L  14J      4.105   5.810  35.038  1.00 16.96           H  
ATOM   4599  HD2 TYR L  14J      2.504   9.443  33.342  1.00 13.99           H  
ATOM   4600  HE1 TYR L  14J      4.800   5.065  32.816  1.00 14.47           H  
ATOM   4601  HE2 TYR L  14J      3.109   8.627  31.095  1.00 15.93           H  
ATOM   4602  HH  TYR L  14J      4.725   5.491  30.547  1.00 14.16           H  
ATOM   4603  N   ILE L  14K      1.998   6.731  39.120  1.00 22.66           N  
ATOM   4604  CA  ILE L  14K      1.479   6.872  40.478  1.00 27.83           C  
ATOM   4605  C   ILE L  14K      2.298   7.855  41.340  1.00 32.37           C  
ATOM   4606  O   ILE L  14K      3.516   7.931  41.189  1.00 47.34           O  
ATOM   4607  CB  ILE L  14K      1.406   5.445  41.139  1.00 32.12           C  
ATOM   4608  CG1 ILE L  14K     -0.055   4.976  41.306  1.00 36.66           C  
ATOM   4609  CG2 ILE L  14K      2.165   5.224  42.469  1.00 41.15           C  
ATOM   4610  CD1 ILE L  14K     -0.835   4.879  39.988  1.00 31.82           C  
ATOM   4611  H   ILE L  14K      2.350   5.810  38.898  1.00 22.66           H  
ATOM   4612  HA  ILE L  14K      0.475   7.290  40.387  1.00 27.83           H  
ATOM   4613  HB  ILE L  14K      1.870   4.735  40.451  1.00 32.12           H  
ATOM   4614 HG13 ILE L  14K     -0.577   5.645  41.991  1.00 36.66           H  
ATOM   4615 HG12 ILE L  14K     -0.072   3.994  41.779  1.00 36.66           H  
ATOM   4616 HG21 ILE L  14K      2.087   4.186  42.791  1.00 41.15           H  
ATOM   4617 HG22 ILE L  14K      3.230   5.436  42.367  1.00 41.15           H  
ATOM   4618 HG23 ILE L  14K      1.766   5.841  43.275  1.00 41.15           H  
ATOM   4619 HD11 ILE L  14K     -1.649   4.159  40.070  1.00 31.82           H  
ATOM   4620 HD12 ILE L  14K     -1.272   5.838  39.714  1.00 31.82           H  
ATOM   4621 HD13 ILE L  14K     -0.195   4.556  39.168  1.00 31.82           H  
HETATM 4622  N   NME L  14L      1.601   8.548  42.255  1.00  0.00           N  
HETATM 4623  C   NME L  14L      2.192   9.481  43.205  1.00  0.00           C  
HETATM 4624  H   NME L  14L      0.601   8.416  42.312  1.00  0.00           H  
HETATM 4625  H1  NME L  14L      3.277   9.560  43.118  1.00  0.00           H  
HETATM 4626  H2  NME L  14L      1.770  10.475  43.056  1.00  0.00           H  
HETATM 4627  H3  NME L  14L      1.960   9.166  44.222  1.00  0.00           H  
TER    4628      NME L  14L
HETATM 4629  O   HOH H3071      25.415 -14.928  23.030  1.00 26.49           O  
HETATM 4630  H1  HOH H3071      25.972 -14.146  22.736  1.00 26.49           H  
HETATM 4631  H2  HOH H3071      25.883 -15.393  23.784  1.00 26.49           H  
HETATM 4632  O   HOH H3134      14.659 -10.722  16.077  1.00 43.15           O  
HETATM 4633  H1  HOH H3134      14.892  -9.964  16.695  1.00 43.15           H  
HETATM 4634  H2  HOH H3134      15.099 -11.560  16.402  1.00 43.15           H  
HETATM 4635  O   HOH H3160      15.606 -15.465  20.077  1.00 48.58           O  
HETATM 4636  H1  HOH H3160      15.700 -14.479  19.914  1.00 48.58           H  
HETATM 4637  H2  HOH H3160      15.090 -15.870  19.322  1.00 48.58           H  
CONECT  439  672
CONECT  672  439
CONECT 1978 4204
CONECT 2806 3038
CONECT 3038 2806
CONECT 3231 3671
CONECT 3671 3231
CONECT 4204 1978
CONECT 4629 4630 4631
CONECT 4630 4629
CONECT 4631 4629
CONECT 4632 4633 4634
CONECT 4633 4632
CONECT 4634 4632
CONECT 4635 4636 4637
CONECT 4636 4635
CONECT 4637 4635
END
"""


@pytest.fixture(scope="session")
def thrombin():
    m = Chem.MolFromPDBBlock(thrombin_pdb, proximityBonding=False, removeHs=False)

    return pdbinf.assign_pdb_bonds(m, templates=[pdbinf.STANDARD_AA_DOC])


def test_fragments(thrombin):
    # test inter residue bonds are correctly assigned via a connected subgraph check
    # we should have one large molecule and three waters
    frags = Chem.rdmolops.GetMolFrags(thrombin)

    assert len(frags) == 4
    assert len(frags[0]) == 4626
    assert len(frags[1]) == 3
    assert len(frags[2]) == 3
    assert len(frags[3]) == 3


def test_sulphur_bonds(thrombin):
    # we detect these via geometry, but this file happens to list the SSBOND
    # [(42 H, 58 H), (122 H, 1 L), (168 H, 182 H), (191 H, 220 H)]
    for i, j in [(438, 671), (1977, 4202), (2805, 3037), (3230, 3670)]:
        assert thrombin.GetBondBetweenAtoms(i, j) is not None, (i, j)


def test_charges(thrombin):
    ref = dict(
        [
            (49, -1),
            (81, -1),
            (104, -1),
            (302, +1),
            (324, +1),
            (388, -1),
            (527, -1),
            (542, +1),
            (794, -1),
            (807, +1),
            (877, -1),
            (905, -1),
            (974, +1),
            (1022, +1),
            (1074, +1),
            (1112, +1),
            (1155, -1),
            (1172, +1),
            (1227, -1),
            (1242, +1),
            (1330, -1),
            (1345, +1),
            (1459, +1),
            (1542, +1),
            (1564, -1),
            (1611, -1),
            (1626, +1),
            (1647, -1),
            (1725, +1),
            (1766, +1),
            (1788, +1),
            (1880, -1),
            (2022, -1),
            (2037, +1),
            (2059, -1),
            (2212, +1),
            (2243, +1),
            (2366, +1),
            (2388, -1),
            (2502, +1),
            (2739, -1),
            (2756, +1),
            (2818, +1),
            (2839, -1),
            (2879, +1),
            (2922, +1),
            (2976, -1),
            (3088, +1),
            (3123, -1),
            (3136, -1),
            (3158, +1),
            (3182, +1),
            (3210, -1),
            (3243, -1),
            (3264, -1),
            (3369, +1),
            (3466, +1),
            (3651, -1),
            (3682, -1),
            (3697, +1),
            (3718, -1),
            (3738, +1),
            (3898, +1),
            (3939, +1),
            (3961, +1),
            (4043, +1),
            (4099, -1),
            (4168, -1),
            (4192, -1),
            (4243, +1),
            (4318, -1),
            (4333, +1),
            (4355, +1),
            (4407, -1),
            (4421, -1),
            (4434, +1),
            (4470, -1),
            (4487, +1),
            (4509, -1),
            (4562, -1),
        ]
    )

    for i, at in enumerate(thrombin.GetAtoms()):
        c = ref.get(i, 0)

        assert at.GetFormalCharge() == c, i
