'''
3. Реализовать дескриптор для класса серверного сокета,
а в нем — проверку номера порта. Это должно быть целое число (>=0).
Значение порта по умолчанию равняется 7777. Дескриптор надо создать
в отдельном классе. Его экземпляр добавить в пределах класса серверного сокета.
Номер порта передается в экземпляр дескриптора при запуске сервера.
'''

import logging

Serv_log = logging.getLogger('server_dist')


class Port:
    def __set__(self, instance, value):
        if value < 0:
            Serv_log.debug(
                f'Порт {value} недопустимо использовать. '
                f'Выбран порт по умолчанию: 7777')
            value = 7777
        instance.__dict__[self.name] = value

    def __set_name__(self, owner, name):
        self.name = name