"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnGrant = exports.toJson_CfnGrantProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnGrantProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnGrantProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'RoleName': obj.roleName,
        'User': obj.user,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnGrantProps = toJson_CfnGrantProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `Snowflake::Role::Grant`
 *
 * @cloudformationResource Snowflake::Role::Grant
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-snowflake-resource-providers.git
 */
class CfnGrant extends cdk.CfnResource {
    /**
     * Create a new `Snowflake::Role::Grant`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnGrant.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnGrantProps(props) });
        this.props = props;
    }
}
exports.CfnGrant = CfnGrant;
_a = JSII_RTTI_SYMBOL_1;
CfnGrant[_a] = { fqn: "@cdk-cloudformation/snowflake-role-grant.CfnGrant", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnGrant.CFN_RESOURCE_TYPE_NAME = "Snowflake::Role::Grant";
//# sourceMappingURL=data:application/json;base64,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