"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DISCARD = exports.Errors = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Predefined error strings
 * Error names in Amazon States Language - https://states-language.net/spec.html#appendix-a
 * Error handling in Step Functions - https://docs.aws.amazon.com/step-functions/latest/dg/concepts-error-handling.html
 */
class Errors {
}
exports.Errors = Errors;
_a = JSII_RTTI_SYMBOL_1;
Errors[_a] = { fqn: "@aws-cdk/aws-stepfunctions.Errors", version: "1.149.0" };
/**
 * Matches any Error.
 */
Errors.ALL = 'States.ALL';
/**
 * A Task State failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 */
Errors.HEARTBEAT_TIMEOUT = 'States.HeartbeatTimeout';
/**
 * A Task State either ran longer than the “TimeoutSeconds” value, or
 * failed to heartbeat for a time longer than the “HeartbeatSeconds” value.
 */
Errors.TIMEOUT = 'States.Timeout';
/**
 * A Task State failed during the execution.
 */
Errors.TASKS_FAILED = 'States.TaskFailed';
/**
 * A Task State failed because it had insufficient privileges to execute
 * the specified code.
 */
Errors.PERMISSIONS = 'States.Permissions';
/**
 * A Task State’s “ResultPath” field cannot be applied to the input the state received.
 */
Errors.RESULT_PATH_MATCH_FAILURE = 'States.ResultPathMatchFailure';
/**
 * Within a state’s “Parameters” field, the attempt to replace a field whose
 * name ends in “.$” using a Path failed.
 */
Errors.PARAMETER_PATH_FAILURE = 'States.ParameterPathFailure';
/**
 * A branch of a Parallel state failed.
 */
Errors.BRANCH_FAILED = 'States.BranchFailed';
/**
 * A Choice state failed to find a match for the condition field extracted
 * from its input.
 */
Errors.NO_CHOICE_MATCHED = 'States.NoChoiceMatched';
/**
 * Special string value to discard state input, output or result
 */
exports.DISCARD = 'DISCARD';
//# sourceMappingURL=data:application/json;base64,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