from __future__ import annotations

from tcsoa.gen.Query._2019_06.SavedQuery import AttributeSortOption
from tcsoa.gen.Query._2010_09.SavedQuery import BusinessObjectQueryClause
from typing import Dict, List
from tcsoa.utils import TcBaseObj
from dataclasses import dataclass


@dataclass
class BusinessObjectQueryInput4(TcBaseObj):
    """
    Input structure for executeBOQueriesWithSortAndContext operation.
    
    :var boTypeName: Name of business object type. Supports BusinessObject and all subtypes.
    :var clauses: Query clauses in search criteria. Each clause consists of property name on typeName, property value,
    logic and math operators.
    :var sortOptions: A list of attribute sort options based on which the results will be sorted. The first element of
    the list is the primary sort field, second is the secondary sort field and so on.
    :var maxNumToReturn: Specified maximum number of objects to return.
    :var requestId: Unique ID used to register the query execution task. This can be used by the caller to cancel the
    time consuming query, the value can be generated by any unique string generator. The query can be cancelled by
    calling: TcSoaFrameworkCore.Session.cancelOperations (requestId).
    :var clientId: This unique ID is used to identify return data elements and partial errors associated with this
    input structure. This is currently not yet used by the return data elements, the caller can leave it empty.
    :var configurationContextMap: A map (string, string) of an included logical object ID and the selected
    Configuration Context UID. An Included Logical Object ( Fnd0IncludedLODef ) is a logical object definition that has
    been added to another logical object defintion.
    """
    boTypeName: str = ''
    clauses: List[BusinessObjectQueryClause] = ()
    sortOptions: List[AttributeSortOption] = ()
    maxNumToReturn: int = 0
    requestId: str = ''
    clientId: str = ''
    configurationContextMap: NameValueMap2 = None


"""
A map of name value pairs.
"""
NameValueMap2 = Dict[str, str]
