from __future__ import annotations

from tcsoa.gen.BusinessObjects import BusinessObject
from typing import List
from tcsoa.gen.Server import ServiceData
from tcsoa.utils import TcBaseObj
from dataclasses import dataclass


@dataclass
class ExportObjectsForTranslationResponse(TcBaseObj):
    """
    This structure holds the file tickets for the generated XML files as well as any partial errors.
    
    :var data: This holds the partial errors, for which XML data could not be generated. Each partial error has the
    offending business object.
    :var tickets: A list of FMS transient file tickets.
    """
    data: ServiceData = None
    tickets: List[LocaleTicketInfo] = ()


@dataclass
class LocaleTicketInfo(TcBaseObj):
    """
    Holds the locale and the corresponding file ticket for the generated XML file.
    
    :var locale: Locale-  The valid locale name should be in the format as outlined in the Java Standard Language - for
    instance "fr_FR" for French or "en_US" for English.
    :var ticket: The transient file ticket to be used for downloading the generated xml file.
    """
    locale: str = ''
    ticket: str = ''


@dataclass
class ObjectsInfo(TcBaseObj):
    """
    'ObjectsInfo' structure contains parameter required to filter Teamcenter business objects based on selected
    criteria that can be used to export localized business objects for review or translation purpose.
    
    :var translationsExist:  "true" value indicates review mode and "false" indicates translate mode.
     
    Review allows user to export all localized business objects into XML file based on status and locale selected. 
    
    Translate option exports business objects into XML file for selected target locale.
    
    :var locale: The name of the desired locale. The valid locale name should be in the format as outlined in the Java
    Standard Language (i.e. en_US for English, United States). A full list of locales supported by the Teamcenter
    server can be obtained from the service operation 'LanguageInformation.getLanguageList'.
    This can also be set to English word Master for exporting all business objects into XML file that needs to be
    translated to different locale. This parameter works in conjunction with "'translationsExist'" and "'statuses'". 
    
     If "'locale'" is set to Master, it indicates translate mode and valid values for other parameters:
           "'translationsExist'" must be "false", In case of value is set to "true", the 'ServiceData' contains error
    269002. "'statuses'" should be empty; this value is ignored for Master 'locale'.
    
    If "locale" is set to any other valid locale value then possible values for other parameters and behavior is:
          "'translationsExist'" is set to "true" indicate review mode. This will export all the business objects for
    selected "'statuses'". 
    
    :var statuses: A list of status to filter the localized values on. The status may be one or more of the following:
    Approved, In-Review, Pending or Invalid . This is ignored if mode is "translate" ('translationsExist' is false) and
    selected locale is Master.  In "review" mode nothing is exported in case of invalid "'statuses'" is passed and
    operation returns error 269002 in 'ServiceData'.
    :var transferMode: The name  of the Transfer Mode that is used while exporting objects. This is retrieved using
    'ImportExportImpl::GetTransferModesResponse ImportExportImpl::getTransferModes' operation.
    :var objects: A list of Teamcenter business objects which need to be filtered or exported based on the passed in
    parameters. Valid Teamcenter business objects are: Item, ItemRevision etc.
    :var typesPropertiesInfo: A list of type names and the corresponding properties.
    """
    translationsExist: bool = False
    locale: str = ''
    statuses: List[str] = ()
    transferMode: str = ''
    objects: List[BusinessObject] = ()
    typesPropertiesInfo: List[TypePropertiesInfo] = ()


@dataclass
class TransientFileTicketStatusInfo(TcBaseObj):
    """
    It holds the transient file ticket and the status for the translations in the file to be set in the DB.
    
    :var transientFileTicket: A valid FMS ticket to an XML file. This XML file is generated by language expert for
    business objects that need to be imported into system with status  as specified by "'localizationStatus'".
    :var localizationStatus: Localization status for the translations in the input XML file. The localization status
    can be one of the following: Approved, In-Review, Pending or Invalid. The default localization status is Approved.
    In case of empty or wrong status, the operation uses default status.
    """
    transientFileTicket: str = ''
    localizationStatus: str = ''


@dataclass
class TypePropertiesInfo(TcBaseObj):
    """
    TypePropertiesInfo structure holds the type name and the corresponding list of properties.
    
    :var typeName: Type name is a Teamcenter business object  type name for instance Item, Form etc.
    :var propertyNames: List of properties for the type.
    """
    typeName: str = ''
    propertyNames: List[str] = ()
