CLINSIG_MAP = {
    0: "Uncertain significance",
    1: "not provided",
    2: "Benign",
    3: "Likely benign",
    4: "Likely pathogenic",
    5: "Pathogenic",
    6: "drug response",
    7: "histocompatibility",
    8: "Conflicting interpretations of pathogenicity",
    9: "affects",
    10: "association",
    11: "protective",
    12: "risk factor",
    13: "association not found",
    255: "other",
}

REV_CLINSIG_MAP = {
    "other": 255,
    "not_provided": 1,
    "drug_response": 6,
    "association_not_found": 13,
    "risk_factor": 12,
    "protective": 11,
    "association": 10,
    "affects": 9,
    "histocompatibility": 7,
    "benign": 2,
    "likely_benign": 3,
    "conflicting_interpretations_of_pathogenicity": 8,
    "conflicting_interpretations": 8,
    "uncertain_significance": 0,
    "likely_pathogenic": 4,
    "pathogenic": 5,
    # These are here so that the parsing function will work with the older clinvar format
    # Where significance where annotated with numbers
    0: 0,
    1: 1,
    2: 2,
    3: 3,
    4: 4,
    5: 5,
    6: 6,
    7: 7,
    8: 8,
    9: 9,
    10: 10,
    11: 11,
    12: 12,
    13: 13,
    255: 255,
}
