# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class Egress(Base):
    """Sets the behavior and values for egress router destination route ranges.
    The Egress class encapsulates a required egress resource which will be retrieved from the server every time the property is accessed.
    """

    __slots__ = ()
    _SDM_NAME = 'egress'

    def __init__(self, parent):
        super(Egress, self).__init__(parent)

    @property
    def Bandwidth(self):
        """The requested bandwidth for the tunnel, expressed in kbits per second.

        Returns:
            number
        """
        return self._get_attribute('bandwidth')
    @Bandwidth.setter
    def Bandwidth(self, value):
        self._set_attribute('bandwidth', value)

    @property
    def EgressBehavior(self):
        """Dictates the RSVP reservation style when the value of behavior is rsvpEgress.

        Returns:
            str(alwaysUseConfiguredStyle|useSeWhenIndicatedInSessionAttribute)
        """
        return self._get_attribute('egressBehavior')
    @EgressBehavior.setter
    def EgressBehavior(self, value):
        self._set_attribute('egressBehavior', value)

    @property
    def EnableFixedLabelForResv(self):
        """Enables the use of a fixed label in RESV messages while in Egress mode.

        Returns:
            bool
        """
        return self._get_attribute('enableFixedLabelForResv')
    @EnableFixedLabelForResv.setter
    def EnableFixedLabelForResv(self, value):
        self._set_attribute('enableFixedLabelForResv', value)

    @property
    def LabelValue(self):
        """RSVP label for IPV4 and IPv6 RSVP related routes.

        Returns:
            str
        """
        return self._get_attribute('labelValue')
    @LabelValue.setter
    def LabelValue(self, value):
        self._set_attribute('labelValue', value)

    @property
    def PathErrorTlv(self):
        """When signaling fails in the head-end area, a path error message is sent to the head-end.

        Returns:
            list(dict(arg1:number,arg2:number,arg3:str))
        """
        return self._get_attribute('pathErrorTlv')
    @PathErrorTlv.setter
    def PathErrorTlv(self, value):
        self._set_attribute('pathErrorTlv', value)

    @property
    def ReflectRro(self):
        """Enables the reflection of a received RRO object for Egress mode destination ranges. When selected, any RRO items added with addRroItem are ignored. (default = true)

        Returns:
            bool
        """
        return self._get_attribute('reflectRro')
    @ReflectRro.setter
    def ReflectRro(self, value):
        self._set_attribute('reflectRro', value)

    @property
    def RefreshInterval(self):
        """When the destination range is used in Egress mode, this indicates the time, in seconds, between the simulated router's message to the DUT.

        Returns:
            number
        """
        return self._get_attribute('refreshInterval')
    @RefreshInterval.setter
    def RefreshInterval(self, value):
        self._set_attribute('refreshInterval', value)

    @property
    def ReservationStyle(self):
        """The reservation style desired. One of the following options: rsvpFF (fixed filtered mode) or rsvpSE (shared explicit mode).

        Returns:
            str(se|ff|wf)
        """
        return self._get_attribute('reservationStyle')
    @ReservationStyle.setter
    def ReservationStyle(self, value):
        self._set_attribute('reservationStyle', value)

    @property
    def ReservationTearTlv(self):
        """a set of custom TLVs to be included in RESV TEAR messages. These may only be used for egress routers.

        Returns:
            list(dict(arg1:number,arg2:number,arg3:str))
        """
        return self._get_attribute('reservationTearTlv')
    @ReservationTearTlv.setter
    def ReservationTearTlv(self, value):
        self._set_attribute('reservationTearTlv', value)

    @property
    def ReservationTlv(self):
        """a set of custom TLVs to be included in RESV messages. These may only be used for egress routers.

        Returns:
            list(dict(arg1:number,arg2:number,arg3:str))
        """
        return self._get_attribute('reservationTlv')
    @ReservationTlv.setter
    def ReservationTlv(self, value):
        self._set_attribute('reservationTlv', value)

    @property
    def Rro(self):
        """If enabled, an RRO is reflected back to the originating router.

        Returns:
            list(dict(arg1:str[ip|label],arg2:str,arg3:bool,arg4:bool,arg5:number,arg6:bool,arg7:bool,arg8:bool))
        """
        return self._get_attribute('rro')
    @Rro.setter
    def Rro(self, value):
        self._set_attribute('rro', value)

    @property
    def SendResvConfirmation(self):
        """Enables the generation of RESV Confirmation messages for received RESV messages which contain a RESV Confirmation Class object. (default = false)

        Returns:
            bool
        """
        return self._get_attribute('sendResvConfirmation')
    @SendResvConfirmation.setter
    def SendResvConfirmation(self, value):
        self._set_attribute('sendResvConfirmation', value)

    @property
    def TimeoutMultiplier(self):
        """The number of Hellos before a router is declared dead.

        Returns:
            number
        """
        return self._get_attribute('timeoutMultiplier')
    @TimeoutMultiplier.setter
    def TimeoutMultiplier(self, value):
        self._set_attribute('timeoutMultiplier', value)

    def update(self, Bandwidth=None, EgressBehavior=None, EnableFixedLabelForResv=None, LabelValue=None, PathErrorTlv=None, ReflectRro=None, RefreshInterval=None, ReservationStyle=None, ReservationTearTlv=None, ReservationTlv=None, Rro=None, SendResvConfirmation=None, TimeoutMultiplier=None):
        """Updates a child instance of egress on the server.

        Args:
            Bandwidth (number): The requested bandwidth for the tunnel, expressed in kbits per second.
            EgressBehavior (str(alwaysUseConfiguredStyle|useSeWhenIndicatedInSessionAttribute)): Dictates the RSVP reservation style when the value of behavior is rsvpEgress.
            EnableFixedLabelForResv (bool): Enables the use of a fixed label in RESV messages while in Egress mode.
            LabelValue (str): RSVP label for IPV4 and IPv6 RSVP related routes.
            PathErrorTlv (list(dict(arg1:number,arg2:number,arg3:str))): When signaling fails in the head-end area, a path error message is sent to the head-end.
            ReflectRro (bool): Enables the reflection of a received RRO object for Egress mode destination ranges. When selected, any RRO items added with addRroItem are ignored. (default = true)
            RefreshInterval (number): When the destination range is used in Egress mode, this indicates the time, in seconds, between the simulated router's message to the DUT.
            ReservationStyle (str(se|ff|wf)): The reservation style desired. One of the following options: rsvpFF (fixed filtered mode) or rsvpSE (shared explicit mode).
            ReservationTearTlv (list(dict(arg1:number,arg2:number,arg3:str))): a set of custom TLVs to be included in RESV TEAR messages. These may only be used for egress routers.
            ReservationTlv (list(dict(arg1:number,arg2:number,arg3:str))): a set of custom TLVs to be included in RESV messages. These may only be used for egress routers.
            Rro (list(dict(arg1:str[ip|label],arg2:str,arg3:bool,arg4:bool,arg5:number,arg6:bool,arg7:bool,arg8:bool))): If enabled, an RRO is reflected back to the originating router.
            SendResvConfirmation (bool): Enables the generation of RESV Confirmation messages for received RESV messages which contain a RESV Confirmation Class object. (default = false)
            TimeoutMultiplier (number): The number of Hellos before a router is declared dead.

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())
