# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class OpenFlowSwitch(Base):
    """OpenFlow Session (Device) level Configuration
    The OpenFlowSwitch class encapsulates a list of openFlowSwitch resources that is be managed by the user.
    A list of resources can be retrieved from the server using the OpenFlowSwitch.find() method.
    The list can be managed by the user by using the OpenFlowSwitch.add() and OpenFlowSwitch.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'openFlowSwitch'

    def __init__(self, parent):
        super(OpenFlowSwitch, self).__init__(parent)

    @property
    def OFSwitchChannel(self):
        """An instance of the OFSwitchChannel class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.ofswitchchannel.OFSwitchChannel)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.ofswitchchannel import OFSwitchChannel
        return OFSwitchChannel(self)

    @property
    def LearnedInfo(self):
        """An instance of the LearnedInfo class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.learnedinfo.learnedinfo.LearnedInfo)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.learnedinfo.learnedinfo import LearnedInfo
        return LearnedInfo(self)

    @property
    def OFSwitchLearnedInfoConfig(self):
        """An instance of the OFSwitchLearnedInfoConfig class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.ofswitchlearnedinfoconfig.OFSwitchLearnedInfoConfig)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.ofswitchlearnedinfoconfig import OFSwitchLearnedInfoConfig
        return OFSwitchLearnedInfoConfig(self)._select()

    @property
    def OfSwitchPorts(self):
        """An instance of the OfSwitchPorts class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.ofswitchports.OfSwitchPorts)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.ofswitchports import OfSwitchPorts
        return OfSwitchPorts(self)._select()

    @property
    def PacketInList(self):
        """An instance of the PacketInList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.packetinlist.PacketInList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.packetinlist import PacketInList
        return PacketInList(self)

    @property
    def SwitchGroupsList(self):
        """An instance of the SwitchGroupsList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.switchgroupslist.SwitchGroupsList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.switchgroupslist import SwitchGroupsList
        return SwitchGroupsList(self)

    @property
    def SwitchTablesList(self):
        """An instance of the SwitchTablesList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.switchtableslist.SwitchTablesList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.switchtableslist import SwitchTablesList
        return SwitchTablesList(self)

    @property
    def Active(self):
        """Activate/Deactivate Configuration

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('active')

    @property
    def AuxConnTimeout(self):
        """The inactive time in milliseconds after which the auxiliary connection will timeout and close.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('auxConnTimeout')

    @property
    def AuxNonHelloStartupOption(self):
        """Specify the action from the following options for non-hello message when connection is established. The options are: 1) Accept Connection 2) Return Error

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('auxNonHelloStartupOption')

    @property
    def BadVersionErrorAction(self):
        """Specify the action to be performed when an invalid version error occurs. The options are: 1) Re-send Hello 2) Terminate Connection

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('badVersionErrorAction')

    @property
    def BandTypes(self):
        """Select meter band types from the list

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('bandTypes')

    @property
    def BarrierReplyDelayType(self):
        """Select the Barrier Reply Delay Type

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('barrierReplyDelayType')

    @property
    def BarrierReplyMaxDelay(self):
        """Configure Barrier Reply Max Delay in milli seconds.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('barrierReplyMaxDelay')

    @property
    def Capabilities(self):
        """Capabilities

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('capabilities')

    @property
    def ConnectedVia(self):
        """DEPRECATED List of layers this layer used to connect to the wire

        Returns:
            list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])
        """
        return self._get_attribute('connectedVia')
    @ConnectedVia.setter
    def ConnectedVia(self, value):
        self._set_attribute('connectedVia', value)

    @property
    def ControllerFlowTxRate(self):
        """If selected, statistics is published showing the rate at which Flows are transmitted per second, by the Controller

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('controllerFlowTxRate')

    @property
    def Count(self):
        """Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.

        Returns:
            number
        """
        return self._get_attribute('count')

    @property
    def DatapathDesc(self):
        """The description of the Data Path used.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('datapathDesc')

    @property
    def DatapathId(self):
        """The Datapath ID of the OF Channel.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('datapathId')

    @property
    def DatapathIdHex(self):
        """The Datapath ID in Hex of the OF Channel.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('datapathIdHex')

    @property
    def DescriptiveName(self):
        """Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context

        Returns:
            str
        """
        return self._get_attribute('descriptiveName')

    @property
    def DirectoryName(self):
        """Location of Directory in Client where the Certificate and Key Files are available

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('directoryName')

    @property
    def EchoInterval(self):
        """The periodic interval in seconds at which the Interface sends Echo Request Packets.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('echoInterval')

    @property
    def EchoTimeOut(self):
        """If selected, the echo request times out when they have been sent for a specified number of times, or when the time value specified has lapsed, but no response is received

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('echoTimeOut')

    @property
    def EnableHelloElement(self):
        """Enable Hello Element

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableHelloElement')

    @property
    def Errors(self):
        """A list of errors that have occurred

        Returns:
            list(dict(arg1:str[None|/api/v1/sessions/1/ixnetwork/?deepchild=*],arg2:list[str]))
        """
        return self._get_attribute('errors')

    @property
    def FileCaCertificate(self):
        """Browse and upload a CA Certificate file for TLS session.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('fileCaCertificate')

    @property
    def FileCertificate(self):
        """Browse and upload the certificate file for TLS session.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('fileCertificate')

    @property
    def FilePrivKey(self):
        """Browse and upload the private key file for TLS session.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('filePrivKey')

    @property
    def FlowRemovedMask(self):
        """Specify the flow removed message types that will not be received when the controller has the Master role

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('flowRemovedMask')

    @property
    def FlowRemovedMaskSlave(self):
        """Specify the flow removed message types that will not be received when the controller has the Slave role

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('flowRemovedMaskSlave')

    @property
    def GroupCapabilities(self):
        """Group configuration flags: Weight:Support weight for select groups. Liveness:Support liveness for select groups. Chaining:Support chaining groups. Check Loops:Check chaining for loops and delete.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('groupCapabilities')

    @property
    def GroupType(self):
        """Can be of the following types per switch: 1)All: Execute all buckets in the group. 2)Select:Execute one bucket in the group. 3)Indirect:Execute the one defined bucket in this group. 4)Fast Failover:Execute the first live bucket.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('groupType')

    @property
    def HardwareDesc(self):
        """The description of the hardware used.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('hardwareDesc')

    @property
    def InterPacketInBurstGap(self):
        """Specify the duration (in milliseconds) for which the switch waits between successive packet-in bursts.The default value is 1,000 milliseconds.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('interPacketInBurstGap')

    @property
    def ManufacturerDesc(self):
        """The description of the manufacturer. The default value is Ixia.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('manufacturerDesc')

    @property
    def MaxBandPerMeter(self):
        """Maximum number of bands per meter

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('maxBandPerMeter')

    @property
    def MaxColorValue(self):
        """Maximum Color Value

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('maxColorValue')

    @property
    def MaxNumberOfBucketsPerGroups(self):
        """To specify the maximum number of group buckets each group can have.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('maxNumberOfBucketsPerGroups')

    @property
    def MaxPacketInBytes(self):
        """The maximum length of the Packet-in messages in bytes.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('maxPacketInBytes')

    @property
    def MeterCapabilities(self):
        """Select meter capabilities from the list

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('meterCapabilities')

    @property
    def Multiplier(self):
        """Number of layer instances per parent instance (multiplier)

        Returns:
            number
        """
        return self._get_attribute('multiplier')
    @Multiplier.setter
    def Multiplier(self, value):
        self._set_attribute('multiplier', value)

    @property
    def Name(self):
        """Name of NGPF element, guaranteed to be unique in Scenario

        Returns:
            str
        """
        return self._get_attribute('name')
    @Name.setter
    def Name(self, value):
        self._set_attribute('name', value)

    @property
    def NumMeter(self):
        """Maximum number of Openflow meters configured for the switch

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('numMeter')

    @property
    def NumberOfBuffers(self):
        """Specify the maximum number of packets the switch can buffer when sending packets to the controller using packet-in messages.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('numberOfBuffers')

    @property
    def NumberOfChannels(self):
        """Total number of OpenFlow channels to be added for this protocol interface.

        Returns:
            number
        """
        return self._get_attribute('numberOfChannels')
    @NumberOfChannels.setter
    def NumberOfChannels(self, value):
        self._set_attribute('numberOfChannels', value)

    @property
    def NumberOfHostPorts(self):
        """Number of Host Ports per Switch

        Returns:
            number
        """
        return self._get_attribute('numberOfHostPorts')

    @property
    def NumberOfPacketIn(self):
        """Specify the number of packet-in ranges supported by the switch.The maximum allowed value is 10 ranges.

        Returns:
            number
        """
        return self._get_attribute('numberOfPacketIn')
    @NumberOfPacketIn.setter
    def NumberOfPacketIn(self, value):
        self._set_attribute('numberOfPacketIn', value)

    @property
    def NumberOfPorts(self):
        """Number of Ports per Switch

        Returns:
            number
        """
        return self._get_attribute('numberOfPorts')

    @property
    def NumberOfTableRanges(self):
        """Number of Tables per Switch

        Returns:
            number
        """
        return self._get_attribute('numberOfTableRanges')
    @NumberOfTableRanges.setter
    def NumberOfTableRanges(self, value):
        self._set_attribute('numberOfTableRanges', value)

    @property
    def NumberOfTopologyPorts(self):
        """Number of Topology Ports per Switch

        Returns:
            number
        """
        return self._get_attribute('numberOfTopologyPorts')

    @property
    def NumberOfUnconnectedPorts(self):
        """Number of Unconnected Ports per Switch

        Returns:
            number
        """
        return self._get_attribute('numberOfUnconnectedPorts')
    @NumberOfUnconnectedPorts.setter
    def NumberOfUnconnectedPorts(self, value):
        self._set_attribute('numberOfUnconnectedPorts', value)

    @property
    def PacketInMaskMaster(self):
        """Packet In Mask Master

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('packetInMaskMaster')

    @property
    def PacketInMaskSlave(self):
        """Packet In Mask Slave

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('packetInMaskSlave')

    @property
    def PacketInReplyDelay(self):
        """If selected, delay between packet-in and the corresponding packet-out or flow mod is published.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('packetInReplyDelay')

    @property
    def PacketInReplyTimeout(self):
        """The amount of time, in seconds, that the switch keeps the packet-in message in buffer, if it does not receive any corresponding packet-out or flow mod.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('packetInReplyTimeout')

    @property
    def PacketInTxBurst(self):
        """Specify the number of packet-in transmitting packets that can be sent in a single burst within the time frame specified by the Inter PacketIn Burst Gap value.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('packetInTxBurst')

    @property
    def PacketOutRxRate(self):
        """If selected, packet_out rx rate and packet_in tx rate is calculated for the switch.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('packetOutRxRate')

    @property
    def PeriodicEcho(self):
        """If selected, the Interface sends echo requests periodically to keep the OpenFlow session connected.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('periodicEcho')

    @property
    def PortStatusMaskMaster(self):
        """Port Status Mask Master

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('portStatusMaskMaster')

    @property
    def PortStatusMaskSlave(self):
        """Port Status Mask Slave

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('portStatusMaskSlave')

    @property
    def SerialNumber(self):
        """The serial number used.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('serialNumber')

    @property
    def SessionStatus(self):
        """Current state of protocol session: Not Started - session negotiation not started, the session is not active yet. Down - actively trying to bring up a protocol session, but negotiation is didn't successfully complete (yet). Up - session came up successfully.

        Returns:
            list(str[down|notStarted|up])
        """
        return self._get_attribute('sessionStatus')

    @property
    def SoftwareDesc(self):
        """The description of the software used.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('softwareDesc')

    @property
    def StackedLayers(self):
        """List of secondary (many to one) child layer protocols

        Returns:
            list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])
        """
        return self._get_attribute('stackedLayers')
    @StackedLayers.setter
    def StackedLayers(self, value):
        self._set_attribute('stackedLayers', value)

    @property
    def StateCounts(self):
        """A list of values that indicates the total number of sessions, the number of sessions not started, the number of sessions down and the number of sessions that are up

        Returns:
            dict(total:number,notStarted:number,down:number,up:number)
        """
        return self._get_attribute('stateCounts')

    @property
    def Status(self):
        """Running status of associated network element. Once in Started state, protocol sessions will begin to negotiate.

        Returns:
            str(configured|error|mixed|notStarted|started|starting|stopping)
        """
        return self._get_attribute('status')

    @property
    def StoreFlows(self):
        """If selected, the flow information sent by the Controller are learned by the Switch.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('storeFlows')

    @property
    def SwitchDesc(self):
        """A description of the Switch

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('switchDesc')

    @property
    def SwitchLocalIp(self):
        """The local IP address of the interface. This field is auto-populated and cannot be changed.

        Returns:
            list(str)
        """
        return self._get_attribute('switchLocalIp')

    @property
    def TableMissAction(self):
        """Specify what the Switch should do when there is no match for the packets

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('tableMissAction')

    @property
    def TcpPort(self):
        """Specify the TCP port for this interface

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('tcpPort')

    @property
    def TimeoutOption(self):
        """The types of timeout options supported. Choose one of the following: 1) Multiplier 2) Timeout Value

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('timeoutOption')

    @property
    def TimeoutOptionValue(self):
        """The value specified for the selected Timeout option.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('timeoutOptionValue')

    @property
    def TlsVersion(self):
        """TLS version selection

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('tlsVersion')

    @property
    def TransactionID(self):
        """If selected, PacketIn Delay Calculation will be done by matching transaction ID

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('transactionID')

    @property
    def TypeOfConnection(self):
        """The type of connection used for the Interface. Options include: 1) TCP 2) TLS

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('typeOfConnection')

    @property
    def VersionSupported(self):
        """Indicates the supported OpenFlow version number.

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('versionSupported')

    def update(self, ConnectedVia=None, Multiplier=None, Name=None, NumberOfChannels=None, NumberOfPacketIn=None, NumberOfTableRanges=None, NumberOfUnconnectedPorts=None, StackedLayers=None):
        """Updates a child instance of openFlowSwitch on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args:
            ConnectedVia (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of layers this layer used to connect to the wire
            Multiplier (number): Number of layer instances per parent instance (multiplier)
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            NumberOfChannels (number): Total number of OpenFlow channels to be added for this protocol interface.
            NumberOfPacketIn (number): Specify the number of packet-in ranges supported by the switch.The maximum allowed value is 10 ranges.
            NumberOfTableRanges (number): Number of Tables per Switch
            NumberOfUnconnectedPorts (number): Number of Unconnected Ports per Switch
            StackedLayers (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of secondary (many to one) child layer protocols

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, ConnectedVia=None, Multiplier=None, Name=None, NumberOfChannels=None, NumberOfPacketIn=None, NumberOfTableRanges=None, NumberOfUnconnectedPorts=None, StackedLayers=None):
        """Adds a new openFlowSwitch node on the server and retrieves it in this instance.

        Args:
            ConnectedVia (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of layers this layer used to connect to the wire
            Multiplier (number): Number of layer instances per parent instance (multiplier)
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            NumberOfChannels (number): Total number of OpenFlow channels to be added for this protocol interface.
            NumberOfPacketIn (number): Specify the number of packet-in ranges supported by the switch.The maximum allowed value is 10 ranges.
            NumberOfTableRanges (number): Number of Tables per Switch
            NumberOfUnconnectedPorts (number): Number of Unconnected Ports per Switch
            StackedLayers (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of secondary (many to one) child layer protocols

        Returns:
            self: This instance with all currently retrieved openFlowSwitch data using find and the newly added openFlowSwitch data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the openFlowSwitch data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, ConnectedVia=None, Count=None, DescriptiveName=None, Errors=None, Multiplier=None, Name=None, NumberOfChannels=None, NumberOfHostPorts=None, NumberOfPacketIn=None, NumberOfPorts=None, NumberOfTableRanges=None, NumberOfTopologyPorts=None, NumberOfUnconnectedPorts=None, SessionStatus=None, StackedLayers=None, StateCounts=None, Status=None, SwitchLocalIp=None):
        """Finds and retrieves openFlowSwitch data from the server.

        All named parameters support regex and can be used to selectively retrieve openFlowSwitch data from the server.
        By default the find method takes no parameters and will retrieve all openFlowSwitch data from the server.

        Args:
            ConnectedVia (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of layers this layer used to connect to the wire
            Count (number): Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.
            DescriptiveName (str): Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context
            Errors (list(dict(arg1:str[None|/api/v1/sessions/1/ixnetwork/?deepchild=*],arg2:list[str]))): A list of errors that have occurred
            Multiplier (number): Number of layer instances per parent instance (multiplier)
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            NumberOfChannels (number): Total number of OpenFlow channels to be added for this protocol interface.
            NumberOfHostPorts (number): Number of Host Ports per Switch
            NumberOfPacketIn (number): Specify the number of packet-in ranges supported by the switch.The maximum allowed value is 10 ranges.
            NumberOfPorts (number): Number of Ports per Switch
            NumberOfTableRanges (number): Number of Tables per Switch
            NumberOfTopologyPorts (number): Number of Topology Ports per Switch
            NumberOfUnconnectedPorts (number): Number of Unconnected Ports per Switch
            SessionStatus (list(str[down|notStarted|up])): Current state of protocol session: Not Started - session negotiation not started, the session is not active yet. Down - actively trying to bring up a protocol session, but negotiation is didn't successfully complete (yet). Up - session came up successfully.
            StackedLayers (list(str[None|/api/v1/sessions/1/ixnetwork/topology?deepchild=*])): List of secondary (many to one) child layer protocols
            StateCounts (dict(total:number,notStarted:number,down:number,up:number)): A list of values that indicates the total number of sessions, the number of sessions not started, the number of sessions down and the number of sessions that are up
            Status (str(configured|error|mixed|notStarted|started|starting|stopping)): Running status of associated network element. Once in Started state, protocol sessions will begin to negotiate.
            SwitchLocalIp (list(str)): The local IP address of the interface. This field is auto-populated and cannot be changed.

        Returns:
            self: This instance with matching openFlowSwitch data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of openFlowSwitch data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the openFlowSwitch data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def get_device_ids(self, PortNames=None, Active=None, AuxConnTimeout=None, AuxNonHelloStartupOption=None, BadVersionErrorAction=None, BandTypes=None, BarrierReplyDelayType=None, BarrierReplyMaxDelay=None, Capabilities=None, ControllerFlowTxRate=None, DatapathDesc=None, DatapathId=None, DatapathIdHex=None, DirectoryName=None, EchoInterval=None, EchoTimeOut=None, EnableHelloElement=None, FileCaCertificate=None, FileCertificate=None, FilePrivKey=None, FlowRemovedMask=None, FlowRemovedMaskSlave=None, GroupCapabilities=None, GroupType=None, HardwareDesc=None, InterPacketInBurstGap=None, ManufacturerDesc=None, MaxBandPerMeter=None, MaxColorValue=None, MaxNumberOfBucketsPerGroups=None, MaxPacketInBytes=None, MeterCapabilities=None, NumMeter=None, NumberOfBuffers=None, PacketInMaskMaster=None, PacketInMaskSlave=None, PacketInReplyDelay=None, PacketInReplyTimeout=None, PacketInTxBurst=None, PacketOutRxRate=None, PeriodicEcho=None, PortStatusMaskMaster=None, PortStatusMaskSlave=None, SerialNumber=None, SoftwareDesc=None, StoreFlows=None, SwitchDesc=None, TableMissAction=None, TcpPort=None, TimeoutOption=None, TimeoutOptionValue=None, TlsVersion=None, TransactionID=None, TypeOfConnection=None, VersionSupported=None):
        """Base class infrastructure that gets a list of openFlowSwitch device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args:
            PortNames (str): optional regex of port names
            Active (str): optional regex of active
            AuxConnTimeout (str): optional regex of auxConnTimeout
            AuxNonHelloStartupOption (str): optional regex of auxNonHelloStartupOption
            BadVersionErrorAction (str): optional regex of badVersionErrorAction
            BandTypes (str): optional regex of bandTypes
            BarrierReplyDelayType (str): optional regex of barrierReplyDelayType
            BarrierReplyMaxDelay (str): optional regex of barrierReplyMaxDelay
            Capabilities (str): optional regex of capabilities
            ControllerFlowTxRate (str): optional regex of controllerFlowTxRate
            DatapathDesc (str): optional regex of datapathDesc
            DatapathId (str): optional regex of datapathId
            DatapathIdHex (str): optional regex of datapathIdHex
            DirectoryName (str): optional regex of directoryName
            EchoInterval (str): optional regex of echoInterval
            EchoTimeOut (str): optional regex of echoTimeOut
            EnableHelloElement (str): optional regex of enableHelloElement
            FileCaCertificate (str): optional regex of fileCaCertificate
            FileCertificate (str): optional regex of fileCertificate
            FilePrivKey (str): optional regex of filePrivKey
            FlowRemovedMask (str): optional regex of flowRemovedMask
            FlowRemovedMaskSlave (str): optional regex of flowRemovedMaskSlave
            GroupCapabilities (str): optional regex of groupCapabilities
            GroupType (str): optional regex of groupType
            HardwareDesc (str): optional regex of hardwareDesc
            InterPacketInBurstGap (str): optional regex of interPacketInBurstGap
            ManufacturerDesc (str): optional regex of manufacturerDesc
            MaxBandPerMeter (str): optional regex of maxBandPerMeter
            MaxColorValue (str): optional regex of maxColorValue
            MaxNumberOfBucketsPerGroups (str): optional regex of maxNumberOfBucketsPerGroups
            MaxPacketInBytes (str): optional regex of maxPacketInBytes
            MeterCapabilities (str): optional regex of meterCapabilities
            NumMeter (str): optional regex of numMeter
            NumberOfBuffers (str): optional regex of numberOfBuffers
            PacketInMaskMaster (str): optional regex of packetInMaskMaster
            PacketInMaskSlave (str): optional regex of packetInMaskSlave
            PacketInReplyDelay (str): optional regex of packetInReplyDelay
            PacketInReplyTimeout (str): optional regex of packetInReplyTimeout
            PacketInTxBurst (str): optional regex of packetInTxBurst
            PacketOutRxRate (str): optional regex of packetOutRxRate
            PeriodicEcho (str): optional regex of periodicEcho
            PortStatusMaskMaster (str): optional regex of portStatusMaskMaster
            PortStatusMaskSlave (str): optional regex of portStatusMaskSlave
            SerialNumber (str): optional regex of serialNumber
            SoftwareDesc (str): optional regex of softwareDesc
            StoreFlows (str): optional regex of storeFlows
            SwitchDesc (str): optional regex of switchDesc
            TableMissAction (str): optional regex of tableMissAction
            TcpPort (str): optional regex of tcpPort
            TimeoutOption (str): optional regex of timeoutOption
            TimeoutOptionValue (str): optional regex of timeoutOptionValue
            TlsVersion (str): optional regex of tlsVersion
            TransactionID (str): optional regex of transactionID
            TypeOfConnection (str): optional regex of typeOfConnection
            VersionSupported (str): optional regex of versionSupported

        Returns:
            list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())

    def ClearAllLearnedInfo(self, *args, **kwargs):
        """Executes the clearAllLearnedInfo operation on the server.

        Clear OF Channels learnt by this Switch.

        clearAllLearnedInfo(Arg2:list)list
            Args:
                args[0] is Arg2 (list(number)): List of OF Channel into the protocol plugin. An empty list indicates all instances in the plugin.

            Returns:
                list(str): ID to associate each async action invocation

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('clearAllLearnedInfo', payload=payload, response_object=None)

    def GetOFChannelLearnedInfo(self, *args, **kwargs):
        """Executes the getOFChannelLearnedInfo operation on the server.

        Gets OF Channels learnt by this switch.

        getOFChannelLearnedInfo(Arg2:list)list
            Args:
                args[0] is Arg2 (list(number)): List of OF Channel into the protocol plugin. An empty list indicates all instances in the plugin.

            Returns:
                list(str): ID to associate each async action invocation

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('getOFChannelLearnedInfo', payload=payload, response_object=None)

    def GetOFSwitchFlowStatLearnedInfo(self, *args, **kwargs):
        """Executes the getOFSwitchFlowStatLearnedInfo operation on the server.

        Gets OF Switch Flows learnt by this switch.

        getOFSwitchFlowStatLearnedInfo(Arg2:list)list
            Args:
                args[0] is Arg2 (list(number)): List of OF Switch Flows into the protocol plugin. An empty list indicates all instances in the plugin.

            Returns:
                list(str): ID to associate each async action invocation

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('getOFSwitchFlowStatLearnedInfo', payload=payload, response_object=None)

    def GetOFSwitchGroupLearnedInfo(self, *args, **kwargs):
        """Executes the getOFSwitchGroupLearnedInfo operation on the server.

        Gets OF Switch Groups learnt by this switch.

        getOFSwitchGroupLearnedInfo(Arg2:list)list
            Args:
                args[0] is Arg2 (list(number)): List of OF Switch Flows into the protocol plugin. An empty list indicates all instances in the plugin.

            Returns:
                list(str): ID to associate each async action invocation

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('getOFSwitchGroupLearnedInfo', payload=payload, response_object=None)

    def GetOFSwitchMeterLearnedInfo(self, *args, **kwargs):
        """Executes the getOFSwitchMeterLearnedInfo operation on the server.

        Gets OF Switch Meter learned info for this switch.

        getOFSwitchMeterLearnedInfo(Arg2:list)list
            Args:
                args[0] is Arg2 (list(number)): List of OF Switch Flows into the protocol plugin. An empty list indicates all instances in the plugin.

            Returns:
                list(str): ID to associate each async action invocation

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self.href }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('getOFSwitchMeterLearnedInfo', payload=payload, response_object=None)

    def RestartDown(self, *args, **kwargs):
        """Executes the restartDown operation on the server.

        Stop and start interfaces and sessions that are in Down state.

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        restartDown()

        restartDown(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        restartDown(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('restartDown', payload=payload, response_object=None)

    def Start(self, *args, **kwargs):
        """Executes the start operation on the server.

        Start selected protocols.

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        start()

        start(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        start(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('start', payload=payload, response_object=None)

    def Stop(self, *args, **kwargs):
        """Executes the stop operation on the server.

        Stop selected protocols.

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        stop()

        stop(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        stop(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('stop', payload=payload, response_object=None)
