# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class IsisTrillRouter(Base):
    """TRILL Configuration
    The IsisTrillRouter class encapsulates a list of isisTrillRouter resources that is managed by the system.
    A list of resources can be retrieved from the server using the IsisTrillRouter.find() method.
    """

    __slots__ = ()
    _SDM_NAME = 'isisTrillRouter'

    def __init__(self, parent):
        super(IsisTrillRouter, self).__init__(parent)

    @property
    def TrillMCastIpv4GroupList(self):
        """An instance of the TrillMCastIpv4GroupList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.trillmcastipv4grouplist.TrillMCastIpv4GroupList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.trillmcastipv4grouplist import TrillMCastIpv4GroupList
        return TrillMCastIpv4GroupList(self)._select()

    @property
    def TrillMCastIpv6GroupList(self):
        """An instance of the TrillMCastIpv6GroupList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.trillmcastipv6grouplist.TrillMCastIpv6GroupList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.trillmcastipv6grouplist import TrillMCastIpv6GroupList
        return TrillMCastIpv6GroupList(self)._select()

    @property
    def TrillMCastMacGroupList(self):
        """An instance of the TrillMCastMacGroupList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.trillmcastmacgrouplist.TrillMCastMacGroupList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.trillmcastmacgrouplist import TrillMCastMacGroupList
        return TrillMCastMacGroupList(self)._select()

    @property
    def TrillTopologyList(self):
        """An instance of the TrillTopologyList class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.trilltopologylist.TrillTopologyList)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.topology.trilltopologylist import TrillTopologyList
        return TrillTopologyList(self)._select()

    @property
    def Active(self):
        """Activate/Deactivate Configuration

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('active')

    @property
    def AreaAddresses(self):
        """Area Addresses

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('areaAddresses')

    @property
    def AreaAuthenticationType(self):
        """Area Authentication Type

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('areaAuthenticationType')

    @property
    def AreaTransmitPasswordOrMD5Key(self):
        """Area Transmit Password / MD5-Key

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('areaTransmitPasswordOrMD5Key')

    @property
    def Attached(self):
        """Attached

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('attached')

    @property
    def CSNPInterval(self):
        """CSNP Interval (ms)

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('cSNPInterval')

    @property
    def CapabilityRouterId(self):
        """Capability Router Id

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('capabilityRouterId')

    @property
    def Count(self):
        """Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.

        Returns:
            number
        """
        return self._get_attribute('count')

    @property
    def DescriptiveName(self):
        """Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context

        Returns:
            str
        """
        return self._get_attribute('descriptiveName')

    @property
    def DiscardLSPs(self):
        """Discard LSPs

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('discardLSPs')

    @property
    def EnableHelloPadding(self):
        """Enable Hello Padding

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableHelloPadding')

    @property
    def EnableHostName(self):
        """Enable Host Name

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableHostName')

    @property
    def EnableMtuProbe(self):
        """Enable MTU Probe

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableMtuProbe')

    @property
    def EnableWideMetric(self):
        """Enable Wide Metric

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('enableWideMetric')

    @property
    def Errors(self):
        """A list of errors that have occurred

        Returns:
            list(dict(arg1:str[None|/api/v1/sessions/1/ixnetwork/?deepchild=*],arg2:list[str]))
        """
        return self._get_attribute('errors')

    @property
    def HostName(self):
        """Host Name

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('hostName')

    @property
    def IgnoreReceiveMD5(self):
        """Ignore Receive MD5

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('ignoreReceiveMD5')

    @property
    def InterLSPsOrMGroupPDUBurstGap(self):
        """Inter LSPs/MGROUP-PDUs Burst Gap (ms)

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('interLSPsOrMGroupPDUBurstGap')

    @property
    def LSPLifetime(self):
        """LSP Rifetime (sec)

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('lSPLifetime')

    @property
    def LSPRefreshRate(self):
        """LSP Refresh Rate (sec)

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('lSPRefreshRate')

    @property
    def LSPorMGroupPDUMinTransmissionInterval(self):
        """LSP/MGROUP-PDU Min Transmission Interval (ms)

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('lSPorMGroupPDUMinTransmissionInterval')

    @property
    def LocalSystemID(self):
        """System ID

        Returns:
            list(str)
        """
        return self._get_attribute('localSystemID')

    @property
    def MaxAreaAddresses(self):
        """Maximum Area Addresses

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('maxAreaAddresses')

    @property
    def MaxLSPSize(self):
        """Max LSP Size

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('maxLSPSize')

    @property
    def MaxLSPsOrMGroupPDUsPerBurst(self):
        """Max LSPs/MGROUP-PDUs Per Burst

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('maxLSPsOrMGroupPDUsPerBurst')

    @property
    def Name(self):
        """Name of NGPF element, guaranteed to be unique in Scenario

        Returns:
            str
        """
        return self._get_attribute('name')
    @Name.setter
    def Name(self, value):
        self._set_attribute('name', value)

    @property
    def NoOfMtuProbes(self):
        """No. of MTU Probes

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('noOfMtuProbes')

    @property
    def OrigLspBufSize(self):
        """Originating LSP Buf Size(Sz)

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('origLspBufSize')

    @property
    def Overloaded(self):
        """Overloaded

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('overloaded')

    @property
    def PSNPInterval(self):
        """PSNP Interval (ms)

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('pSNPInterval')

    @property
    def PartitionRepair(self):
        """Partition Repair

        Returns:
            obj(ixnetwork_restpy.multivalue.Multivalue)
        """
        return self._get_attribute('partitionRepair')

    @property
    def SessionInfo(self):
        """Logs additional information about the session Information

        Returns:
            list(str[noIfaceUp|up])
        """
        return self._get_attribute('sessionInfo')

    @property
    def SessionStatus(self):
        """Current state of protocol session: Not Started - session negotiation not started, the session is not active yet. Down - actively trying to bring up a protocol session, but negotiation is didn't successfully complete (yet). Up - session came up successfully.

        Returns:
            list(str[down|notStarted|up])
        """
        return self._get_attribute('sessionStatus')

    @property
    def StateCounts(self):
        """A list of values that indicates the total number of sessions, the number of sessions not started, the number of sessions down and the number of sessions that are up

        Returns:
            dict(total:number,notStarted:number,down:number,up:number)
        """
        return self._get_attribute('stateCounts')

    @property
    def Status(self):
        """Running status of associated network element. Once in Started state, protocol sessions will begin to negotiate.

        Returns:
            str(configured|error|mixed|notStarted|started|starting|stopping)
        """
        return self._get_attribute('status')

    @property
    def TrillMCastIpv4GroupCount(self):
        """# Multicast IPv4 Groups(multiplier)

        Returns:
            number
        """
        return self._get_attribute('trillMCastIpv4GroupCount')
    @TrillMCastIpv4GroupCount.setter
    def TrillMCastIpv4GroupCount(self, value):
        self._set_attribute('trillMCastIpv4GroupCount', value)

    @property
    def TrillMCastIpv6GroupCount(self):
        """# Multicast IPv6 Groups(multiplier)

        Returns:
            number
        """
        return self._get_attribute('trillMCastIpv6GroupCount')
    @TrillMCastIpv6GroupCount.setter
    def TrillMCastIpv6GroupCount(self, value):
        self._set_attribute('trillMCastIpv6GroupCount', value)

    @property
    def TrillMCastMacGroupCount(self):
        """MAC Group Count(multiplier)

        Returns:
            number
        """
        return self._get_attribute('trillMCastMacGroupCount')
    @TrillMCastMacGroupCount.setter
    def TrillMCastMacGroupCount(self, value):
        self._set_attribute('trillMCastMacGroupCount', value)

    def update(self, Name=None, TrillMCastIpv4GroupCount=None, TrillMCastIpv6GroupCount=None, TrillMCastMacGroupCount=None):
        """Updates a child instance of isisTrillRouter on the server.

        This method has some named parameters with a type: obj (Multivalue).
        The Multivalue class has documentation that details the possible values for those named parameters.

        Args:
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            TrillMCastIpv4GroupCount (number): # Multicast IPv4 Groups(multiplier)
            TrillMCastIpv6GroupCount (number): # Multicast IPv6 Groups(multiplier)
            TrillMCastMacGroupCount (number): MAC Group Count(multiplier)

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def find(self, Count=None, DescriptiveName=None, Errors=None, LocalSystemID=None, Name=None, SessionInfo=None, SessionStatus=None, StateCounts=None, Status=None, TrillMCastIpv4GroupCount=None, TrillMCastIpv6GroupCount=None, TrillMCastMacGroupCount=None):
        """Finds and retrieves isisTrillRouter data from the server.

        All named parameters support regex and can be used to selectively retrieve isisTrillRouter data from the server.
        By default the find method takes no parameters and will retrieve all isisTrillRouter data from the server.

        Args:
            Count (number): Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.
            DescriptiveName (str): Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context
            Errors (list(dict(arg1:str[None|/api/v1/sessions/1/ixnetwork/?deepchild=*],arg2:list[str]))): A list of errors that have occurred
            LocalSystemID (list(str)): System ID
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            SessionInfo (list(str[noIfaceUp|up])): Logs additional information about the session Information
            SessionStatus (list(str[down|notStarted|up])): Current state of protocol session: Not Started - session negotiation not started, the session is not active yet. Down - actively trying to bring up a protocol session, but negotiation is didn't successfully complete (yet). Up - session came up successfully.
            StateCounts (dict(total:number,notStarted:number,down:number,up:number)): A list of values that indicates the total number of sessions, the number of sessions not started, the number of sessions down and the number of sessions that are up
            Status (str(configured|error|mixed|notStarted|started|starting|stopping)): Running status of associated network element. Once in Started state, protocol sessions will begin to negotiate.
            TrillMCastIpv4GroupCount (number): # Multicast IPv4 Groups(multiplier)
            TrillMCastIpv6GroupCount (number): # Multicast IPv6 Groups(multiplier)
            TrillMCastMacGroupCount (number): MAC Group Count(multiplier)

        Returns:
            self: This instance with matching isisTrillRouter data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of isisTrillRouter data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the isisTrillRouter data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)

    def get_device_ids(self, PortNames=None, Active=None, AreaAddresses=None, AreaAuthenticationType=None, AreaTransmitPasswordOrMD5Key=None, Attached=None, CSNPInterval=None, CapabilityRouterId=None, DiscardLSPs=None, EnableHelloPadding=None, EnableHostName=None, EnableMtuProbe=None, EnableWideMetric=None, HostName=None, IgnoreReceiveMD5=None, InterLSPsOrMGroupPDUBurstGap=None, LSPLifetime=None, LSPRefreshRate=None, LSPorMGroupPDUMinTransmissionInterval=None, MaxAreaAddresses=None, MaxLSPSize=None, MaxLSPsOrMGroupPDUsPerBurst=None, NoOfMtuProbes=None, OrigLspBufSize=None, Overloaded=None, PSNPInterval=None, PartitionRepair=None):
        """Base class infrastructure that gets a list of isisTrillRouter device ids encapsulated by this object.

        Use the optional regex parameters in the method to refine the list of device ids encapsulated by this object.

        Args:
            PortNames (str): optional regex of port names
            Active (str): optional regex of active
            AreaAddresses (str): optional regex of areaAddresses
            AreaAuthenticationType (str): optional regex of areaAuthenticationType
            AreaTransmitPasswordOrMD5Key (str): optional regex of areaTransmitPasswordOrMD5Key
            Attached (str): optional regex of attached
            CSNPInterval (str): optional regex of cSNPInterval
            CapabilityRouterId (str): optional regex of capabilityRouterId
            DiscardLSPs (str): optional regex of discardLSPs
            EnableHelloPadding (str): optional regex of enableHelloPadding
            EnableHostName (str): optional regex of enableHostName
            EnableMtuProbe (str): optional regex of enableMtuProbe
            EnableWideMetric (str): optional regex of enableWideMetric
            HostName (str): optional regex of hostName
            IgnoreReceiveMD5 (str): optional regex of ignoreReceiveMD5
            InterLSPsOrMGroupPDUBurstGap (str): optional regex of interLSPsOrMGroupPDUBurstGap
            LSPLifetime (str): optional regex of lSPLifetime
            LSPRefreshRate (str): optional regex of lSPRefreshRate
            LSPorMGroupPDUMinTransmissionInterval (str): optional regex of lSPorMGroupPDUMinTransmissionInterval
            MaxAreaAddresses (str): optional regex of maxAreaAddresses
            MaxLSPSize (str): optional regex of maxLSPSize
            MaxLSPsOrMGroupPDUsPerBurst (str): optional regex of maxLSPsOrMGroupPDUsPerBurst
            NoOfMtuProbes (str): optional regex of noOfMtuProbes
            OrigLspBufSize (str): optional regex of origLspBufSize
            Overloaded (str): optional regex of overloaded
            PSNPInterval (str): optional regex of pSNPInterval
            PartitionRepair (str): optional regex of partitionRepair

        Returns:
            list(int): A list of device ids that meets the regex criteria provided in the method parameters

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._get_ngpf_device_ids(locals())

    def IsisStartRouter(self, *args, **kwargs):
        """Executes the isisStartRouter operation on the server.

        Start ISIS Router

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        isisStartRouter()

        isisStartRouter(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        isisStartRouter(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('isisStartRouter', payload=payload, response_object=None)

    def IsisStopRouter(self, *args, **kwargs):
        """Executes the isisStopRouter operation on the server.

        Stop ISIS Router

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        isisStopRouter()

        isisStopRouter(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        isisStopRouter(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('isisStopRouter', payload=payload, response_object=None)

    def RestartDown(self, *args, **kwargs):
        """Executes the restartDown operation on the server.

        Stop and start interfaces and sessions that are in Down state.

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        restartDown()

        restartDown(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        restartDown(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('restartDown', payload=payload, response_object=None)

    def Start(self, *args, **kwargs):
        """Executes the start operation on the server.

        Start selected protocols.

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        start()

        start(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        start(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('start', payload=payload, response_object=None)

    def Stop(self, *args, **kwargs):
        """Executes the stop operation on the server.

        Stop selected protocols.

        The IxNetwork modeling infrastructure allows for multiple method Signatures with the same name while python does not.
        The following correlates the modeling Signatures to the python *args variable length list:

        stop()

        stop(SessionIndices:list)
            Args:
                args[0] is SessionIndices (list(number)): This parameter requires an array of session numbers 0 1 2 3

        stop(SessionIndices:string)
            Args:
                args[0] is SessionIndices (str): This parameter requires a string of session numbers 1-4;6;7-12

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        payload = { "Arg1": self }
        for i in range(len(args)): payload['Arg%s' % (i + 2)] = args[i]
        for item in kwargs.items(): payload[item[0]] = item[1]
        return self._execute('stop', payload=payload, response_object=None)
