# MIT LICENSE
#
# Copyright 1997 - 2019 by IXIA Keysight
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE. 
from ixnetwork_restpy.base import Base
from ixnetwork_restpy.files import Files


class ActionTemplate(Base):
    """Action Builder Template.
    The ActionTemplate class encapsulates a list of actionTemplate resources that is be managed by the user.
    A list of resources can be retrieved from the server using the ActionTemplate.find() method.
    The list can be managed by the user by using the ActionTemplate.add() and ActionTemplate.remove() methods.
    """

    __slots__ = ()
    _SDM_NAME = 'actionTemplate'

    def __init__(self, parent):
        super(ActionTemplate, self).__init__(parent)

    @property
    def Action(self):
        """An instance of the Action class.

        Returns:
            obj(ixnetwork_restpy.testplatform.sessions.ixnetwork.globals.topology.openflowcontroller.action.Action)

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        from ixnetwork_restpy.testplatform.sessions.ixnetwork.globals.topology.openflowcontroller.action import Action
        return Action(self)

    @property
    def Count(self):
        """Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.

        Returns:
            number
        """
        return self._get_attribute('count')

    @property
    def DescriptiveName(self):
        """Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context

        Returns:
            str
        """
        return self._get_attribute('descriptiveName')

    @property
    def Name(self):
        """Name of NGPF element, guaranteed to be unique in Scenario

        Returns:
            str
        """
        return self._get_attribute('name')
    @Name.setter
    def Name(self, value):
        self._set_attribute('name', value)

    @property
    def SavedInVersion(self):
        """The cpf version of the session

        Returns:
            str
        """
        return self._get_attribute('savedInVersion')
    @SavedInVersion.setter
    def SavedInVersion(self, value):
        self._set_attribute('savedInVersion', value)

    def update(self, Name=None, SavedInVersion=None):
        """Updates a child instance of actionTemplate on the server.

        Args:
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            SavedInVersion (str): The cpf version of the session

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        self._update(locals())

    def add(self, Name=None, SavedInVersion=None):
        """Adds a new actionTemplate node on the server and retrieves it in this instance.

        Args:
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            SavedInVersion (str): The cpf version of the session

        Returns:
            self: This instance with all currently retrieved actionTemplate data using find and the newly added actionTemplate data available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._create(locals())

    def remove(self):
        """Deletes all the actionTemplate data in this instance from server.

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        self._delete()

    def find(self, Count=None, DescriptiveName=None, Name=None, SavedInVersion=None):
        """Finds and retrieves actionTemplate data from the server.

        All named parameters support regex and can be used to selectively retrieve actionTemplate data from the server.
        By default the find method takes no parameters and will retrieve all actionTemplate data from the server.

        Args:
            Count (number): Number of elements inside associated multiplier-scaled container object, e.g. number of devices inside a Device Group.
            DescriptiveName (str): Longer, more descriptive name for element. It's not guaranteed to be unique like -name-, but may offers more context
            Name (str): Name of NGPF element, guaranteed to be unique in Scenario
            SavedInVersion (str): The cpf version of the session

        Returns:
            self: This instance with matching actionTemplate data retrieved from the server available through an iterator or index

        Raises:
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._select(locals())

    def read(self, href):
        """Retrieves a single instance of actionTemplate data from the server.

        Args:
            href (str): An href to the instance to be retrieved

        Returns:
            self: This instance with the actionTemplate data from the server available through an iterator or index

        Raises:
            NotFoundError: The requested resource does not exist on the server
            ServerError: The server has encountered an uncategorized error condition
        """
        return self._read(href)
