"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcEndpointService = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const ec2_generated_1 = require("./ec2.generated");
/**
 * A VPC endpoint service
 * @resource AWS::EC2::VPCEndpointService
 *
 */
class VpcEndpointService extends core_1.Resource {
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_ec2_VpcEndpointServiceProps(props);
        if (props.vpcEndpointServiceLoadBalancers === undefined || props.vpcEndpointServiceLoadBalancers.length === 0) {
            throw new Error('VPC Endpoint Service must have at least one load balancer specified.');
        }
        this.vpcEndpointServiceLoadBalancers = props.vpcEndpointServiceLoadBalancers;
        this.acceptanceRequired = (_b = props.acceptanceRequired) !== null && _b !== void 0 ? _b : true;
        if (props.allowedPrincipals && props.whitelistedPrincipals) {
            throw new Error('`whitelistedPrincipals` is deprecated; please use `allowedPrincipals` instead');
        }
        this.allowedPrincipals = (_d = (_c = props.allowedPrincipals) !== null && _c !== void 0 ? _c : props.whitelistedPrincipals) !== null && _d !== void 0 ? _d : [];
        this.whitelistedPrincipals = this.allowedPrincipals;
        this.endpointService = new ec2_generated_1.CfnVPCEndpointService(this, id, {
            networkLoadBalancerArns: this.vpcEndpointServiceLoadBalancers.map(lb => lb.loadBalancerArn),
            acceptanceRequired: this.acceptanceRequired,
        });
        this.vpcEndpointServiceId = this.endpointService.ref;
        const { region } = core_1.Stack.of(this);
        const serviceNamePrefix = !core_1.Token.isUnresolved(region) ?
            ((_e = region_info_1.RegionInfo.get(region).vpcEndpointServiceNamePrefix) !== null && _e !== void 0 ? _e : region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX) :
            region_info_1.Default.VPC_ENDPOINT_SERVICE_NAME_PREFIX;
        this.vpcEndpointServiceName = core_1.Fn.join('.', [serviceNamePrefix, core_1.Aws.REGION, this.vpcEndpointServiceId]);
        if (this.allowedPrincipals.length > 0) {
            new ec2_generated_1.CfnVPCEndpointServicePermissions(this, 'Permissions', {
                serviceId: this.endpointService.ref,
                allowedPrincipals: this.allowedPrincipals.map(x => x.arn),
            });
        }
    }
}
exports.VpcEndpointService = VpcEndpointService;
_a = JSII_RTTI_SYMBOL_1;
VpcEndpointService[_a] = { fqn: "@aws-cdk/aws-ec2.VpcEndpointService", version: "1.146.0" };
//# sourceMappingURL=data:application/json;base64,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