# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator
from synctera_client.models.environment import Environment

class Workspace(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    bank_id: StrictInt = Field(..., description="Bank ID")
    bank_name: StrictStr = Field(..., description="First Name")
    environment: Environment = ...
    partner_id: StrictInt = Field(..., description="Partner ID")
    partner_name: StrictStr = Field(..., description="Last Name")
    rank: StrictInt = Field(..., description="Each workspace has a rank. The highest-ranked (lowest numerical value) workspace is intended to be presented first within its environment. ")
    tenant: Optional[StrictStr] = Field(None, description="The id of the tenant containing the resource. ")
    verification_status: StrictStr = ...
    __properties = ["bank_id", "bank_name", "environment", "partner_id", "partner_name", "rank", "tenant", "verification_status"]

    @validator('verification_status')
    def verification_status_validate_enum(cls, v):
        if v not in ('UNVERIFIED', 'PENDING', 'PROVISIONAL', 'ACCEPTED', 'REVIEW', 'REJECTED'):
            raise ValueError("must validate the enum values ('UNVERIFIED', 'PENDING', 'PROVISIONAL', 'ACCEPTED', 'REVIEW', 'REJECTED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Workspace:
        """Create an instance of Workspace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Workspace:
        """Create an instance of Workspace from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Workspace.parse_obj(obj)

        _obj = Workspace.parse_obj({
            "bank_id": obj.get("bank_id"),
            "bank_name": obj.get("bank_name"),
            "environment": obj.get("environment"),
            "partner_id": obj.get("partner_id"),
            "partner_name": obj.get("partner_name"),
            "rank": obj.get("rank"),
            "tenant": obj.get("tenant"),
            "verification_status": obj.get("verification_status")
        })
        return _obj

