# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class WireTransactionData(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    customer_id: Optional[StrictStr] = Field(None, description="The UUID if the customer associated with the wire payment")
    file_name: Optional[StrictStr] = Field(None, description="The file name the wire was sent in or received from")
    id: Optional[StrictStr] = Field(None, description="The Synctera Wire payment UUID")
    originating_account_id: Optional[StrictStr] = Field(None, description="The UUID of the account that the wire payment is being sent from")
    receiving_account_id: Optional[StrictStr] = Field(None, description="The UUID if the account that is receiving the wire")
    recipient_message: Optional[StrictStr] = Field(None, description="The message to the recipient")
    wire_reference_number: Optional[StrictStr] = Field(None, description="The wire Sender Reference Number for the transfer")
    __properties = ["customer_id", "file_name", "id", "originating_account_id", "receiving_account_id", "recipient_message", "wire_reference_number"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WireTransactionData:
        """Create an instance of WireTransactionData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WireTransactionData:
        """Create an instance of WireTransactionData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WireTransactionData.parse_obj(obj)

        _obj = WireTransactionData.parse_obj({
            "customer_id": obj.get("customer_id"),
            "file_name": obj.get("file_name"),
            "id": obj.get("id"),
            "originating_account_id": obj.get("originating_account_id"),
            "receiving_account_id": obj.get("receiving_account_id"),
            "recipient_message": obj.get("recipient_message"),
            "wire_reference_number": obj.get("wire_reference_number")
        })
        return _obj

