# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, validator

class Wire(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: StrictInt = Field(..., description="Transfer amount in cents ($100 would be 10000)")
    bank_message: Optional[StrictStr] = Field(None, description="Instructions intended for the financial institutions that are processing the wire.")
    creation_time: datetime = ...
    currency: StrictStr = Field(..., description="3-character currency code")
    customer_id: StrictStr = Field(..., description="The customer UUID representing the person initiating the Wire transfer")
    id: StrictStr = Field(..., description="wire ID")
    last_updated_time: datetime = ...
    originating_account_id: StrictStr = Field(..., description="Sender account ID")
    receiving_account_id: StrictStr = Field(..., description="The external account uuid representing the recipient of the wire.")
    recipient_message: Optional[StrictStr] = Field(None, description="Information from the originator to the beneficiary (recipient).")
    sender_reference_id: StrictStr = Field(..., description="Sender's id associated with fedwire transfer")
    status: StrictStr = Field(..., description="The current status of the transfer")
    transaction_id: StrictStr = Field(..., description="ID of the resulting transaction resource")
    __properties = ["amount", "bank_message", "creation_time", "currency", "customer_id", "id", "last_updated_time", "originating_account_id", "receiving_account_id", "recipient_message", "sender_reference_id", "status", "transaction_id"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('PENDING', 'COMPLETED', 'CANCELED', 'DECLINED'):
            raise ValueError("must validate the enum values ('PENDING', 'COMPLETED', 'CANCELED', 'DECLINED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Wire:
        """Create an instance of Wire from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                            "sender_reference_id",
                            "status",
                            "transaction_id",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Wire:
        """Create an instance of Wire from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Wire.parse_obj(obj)

        _obj = Wire.parse_obj({
            "amount": obj.get("amount"),
            "bank_message": obj.get("bank_message"),
            "creation_time": obj.get("creation_time"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "originating_account_id": obj.get("originating_account_id"),
            "receiving_account_id": obj.get("receiving_account_id"),
            "recipient_message": obj.get("recipient_message"),
            "sender_reference_id": obj.get("sender_reference_id"),
            "status": obj.get("status"),
            "transaction_id": obj.get("transaction_id")
        })
        return _obj

