# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictBool
from synctera_client.models.digital_wallet_token_address_verification import DigitalWalletTokenAddressVerification

class WalletProviderCardOnFile(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    address_verification: Optional[DigitalWalletTokenAddressVerification] = None
    enabled: Optional[StrictBool] = False
    __properties = ["address_verification", "enabled"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> WalletProviderCardOnFile:
        """Create an instance of WalletProviderCardOnFile from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of address_verification
        if self.address_verification:
            _dict['address_verification'] = self.address_verification.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> WalletProviderCardOnFile:
        """Create an instance of WalletProviderCardOnFile from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return WalletProviderCardOnFile.parse_obj(obj)

        _obj = WalletProviderCardOnFile.parse_obj({
            "address_verification": DigitalWalletTokenAddressVerification.from_dict(obj.get("address_verification")) if obj.get("address_verification") is not None else None,
            "enabled": obj.get("enabled") if obj.get("enabled") is not None else False
        })
        return _obj

