# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, validator
from synctera_client.models.verification_vendor_info_detail import VerificationVendorInfoDetail

class VerificationVendorJson(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    content_type: StrictStr = Field(..., description="Describes the content-type encoding received from the vendor.")
    details: Optional[List[VerificationVendorInfoDetail]] = Field(None, description="Array of vendor specific information.")
    var_json: Dict[str, Any] = Field(..., alias="json", description="Data representation in JSON.")
    vendor: StrictStr = Field(..., description="Name of the vendor used.")
    __properties = ["content_type", "details", "json", "vendor"]

    @validator('content_type')
    def content_type_validate_enum(cls, v):
        if v not in ('application/json'):
            raise ValueError("must validate the enum values ('application/json')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VerificationVendorJson:
        """Create an instance of VerificationVendorJson from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "details",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in details (list)
        _items = []
        if self.details:
            for _item in self.details:
                if _item:
                    _items.append(_item.to_dict())
            _dict['details'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VerificationVendorJson:
        """Create an instance of VerificationVendorJson from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VerificationVendorJson.parse_obj(obj)

        _obj = VerificationVendorJson.parse_obj({
            "content_type": obj.get("content_type"),
            "details": [VerificationVendorInfoDetail.from_dict(_item) for _item in obj.get("details")] if obj.get("details") is not None else None,
            "var_json": obj.get("json"),
            "vendor": obj.get("vendor")
        })
        return _obj

