# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator

class VerificationRequestAllOf(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    business_id: Optional[StrictStr] = Field(None, description="Unique ID for the business. Exactly one of `business_id` or `person_id` must be set. ")
    customer_consent: Optional[StrictBool] = Field(None, description="Whether this customer has consented to be verified.")
    customer_ip_address: Optional[constr(strict=True)] = Field(None, description="The customer's IP address.")
    document_id: Optional[StrictStr] = Field(None, description="The ID of the uploaded government-issued identification document provided by the Socure SDK. ")
    person_id: Optional[StrictStr] = Field(None, description="Unique ID for the person. Exactly one of `person_id` or `business_id` must be set. ")
    __properties = ["business_id", "customer_consent", "customer_ip_address", "document_id", "person_id"]

    @validator('customer_ip_address')
    def customer_ip_address_validate_regular_expression(cls, v):
        if not re.match(r"^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$", v):
            raise ValueError(r"must validate the regular expression /^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VerificationRequestAllOf:
        """Create an instance of VerificationRequestAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VerificationRequestAllOf:
        """Create an instance of VerificationRequestAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return VerificationRequestAllOf.parse_obj(obj)

        _obj = VerificationRequestAllOf.parse_obj({
            "business_id": obj.get("business_id"),
            "customer_consent": obj.get("customer_consent"),
            "customer_ip_address": obj.get("customer_ip_address"),
            "document_id": obj.get("document_id"),
            "person_id": obj.get("person_id")
        })
        return _obj

