# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from synctera_client.models.dc_sign import DcSign

class TransactionLine1(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_id: StrictStr = Field(..., description="The account uuid associated with this transaction line")
    account_no: StrictStr = Field(..., description="The account number associated with this transaction line")
    amount: StrictInt = Field(..., description="The amount (in cents) of the transaction")
    avail_balance: StrictInt = Field(..., description="The account \"available balance\" at the point in time this (to be deprecated) transaction was posted")
    available_balance: StrictInt = Field(..., description="The account \"available balance\" at the point in time this transaction was posted")
    balance: StrictInt = Field(..., description="The account balance at the point in time this transaction was posted")
    created: datetime = Field(..., description="The creation date of the transaction")
    currency: StrictStr = Field(..., description="ISO 4217 alphabetic currency code of the transfer amount")
    dc_sign: DcSign = ...
    is_fee: StrictBool = Field(..., description="Whether or not this line is considered a fee")
    is_gl_acc: StrictBool = Field(..., description="Whether or not this line represents a GL account")
    is_offset: StrictBool = Field(..., description="Whether or not this line is considered the \"offset\" line")
    is_primary: StrictBool = Field(..., description="Whether or not this line is considered the \"primary\" line")
    meta: Optional[Dict[str, Any]] = ...
    network: StrictStr = Field(..., description="The network this transaction is associated with")
    related_line: StrictInt = ...
    seq: StrictInt = ...
    tenant: StrictStr = Field(..., description="The tenant associated with this transaction, in the form \"<bankid>_<partnerid>\"")
    updated: datetime = Field(..., description="The date the transaction was last updated")
    uuid: StrictStr = ...
    __properties = ["account_id", "account_no", "amount", "avail_balance", "available_balance", "balance", "created", "currency", "dc_sign", "is_fee", "is_gl_acc", "is_offset", "is_primary", "meta", "network", "related_line", "seq", "tenant", "updated", "uuid"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TransactionLine1:
        """Create an instance of TransactionLine1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if meta (nullable) is None
        if self.meta is None:
            _dict['meta'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TransactionLine1:
        """Create an instance of TransactionLine1 from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TransactionLine1.parse_obj(obj)

        _obj = TransactionLine1.parse_obj({
            "account_id": obj.get("account_id"),
            "account_no": obj.get("account_no"),
            "amount": obj.get("amount"),
            "avail_balance": obj.get("avail_balance"),
            "available_balance": obj.get("available_balance"),
            "balance": obj.get("balance"),
            "created": obj.get("created"),
            "currency": obj.get("currency"),
            "dc_sign": obj.get("dc_sign"),
            "is_fee": obj.get("is_fee"),
            "is_gl_acc": obj.get("is_gl_acc"),
            "is_offset": obj.get("is_offset"),
            "is_primary": obj.get("is_primary"),
            "meta": obj.get("meta"),
            "network": obj.get("network"),
            "related_line": obj.get("related_line"),
            "seq": obj.get("seq"),
            "tenant": obj.get("tenant"),
            "updated": obj.get("updated"),
            "uuid": obj.get("uuid")
        })
        return _obj

