# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conint, constr, validator
from synctera_client.models.balance_ceiling import BalanceCeiling
from synctera_client.models.balance_floor import BalanceFloor
from synctera_client.models.spending_limits import SpendingLimits

class TemplateFieldsDepository(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_type: StrictStr = ...
    bank_country: constr(strict=True) = Field(..., description="Bank country of the account. ISO 3166-1 Alpha-2 or Alpha-3 country code.")
    currency: constr(strict=True) = Field(..., description="Account currency. ISO 4217 alphabetic currency code")
    balance_ceiling: Optional[BalanceCeiling] = None
    balance_floor: Optional[BalanceFloor] = None
    fee_product_ids: Optional[List[StrictStr]] = Field(None, description="A list of fee account products that the current account associates with.")
    interest_product_id: Optional[StrictStr] = Field(None, description="An interest account product that the current account associates with. The account product must have its calculation_method set to COMPOUNDED_MONTHLY. ")
    is_ach_enabled: Optional[StrictBool] = Field(False, description="Enable ACH transaction.")
    is_card_enabled: Optional[StrictBool] = Field(False, description="Enable card transaction.")
    is_p2p_enabled: Optional[StrictBool] = Field(False, description="Enable P2P transaction.")
    is_wire_enabled: Optional[StrictBool] = Field(False, description="Enable wire transaction.")
    overdraft_limit: Optional[conint(strict=True, ge=0)] = Field(None, description="Account's overdraft limit. Default is 0. Unit in cents.")
    spend_control_ids: Optional[List[StrictStr]] = Field(None, description="List of spend control IDs to control spending for the account")
    spending_limits: Optional[SpendingLimits] = None
    __properties = ["account_type", "bank_country", "currency", "balance_ceiling", "balance_floor", "fee_product_ids", "interest_product_id", "is_ach_enabled", "is_card_enabled", "is_p2p_enabled", "is_wire_enabled", "overdraft_limit", "spend_control_ids", "spending_limits"]

    @validator('bank_country')
    def bank_country_validate_regular_expression(cls, v):
        if not re.match(r"^[A-Z]{2,3}$", v):
            raise ValueError(r"must validate the regular expression /^[A-Z]{2,3}$/")
        return v

    @validator('currency')
    def currency_validate_regular_expression(cls, v):
        if not re.match(r"^[A-Z]{3}$", v):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> TemplateFieldsDepository:
        """Create an instance of TemplateFieldsDepository from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of balance_ceiling
        if self.balance_ceiling:
            _dict['balance_ceiling'] = self.balance_ceiling.to_dict()
        # override the default output from pydantic by calling `to_dict()` of balance_floor
        if self.balance_floor:
            _dict['balance_floor'] = self.balance_floor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of spending_limits
        if self.spending_limits:
            _dict['spending_limits'] = self.spending_limits.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> TemplateFieldsDepository:
        """Create an instance of TemplateFieldsDepository from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return TemplateFieldsDepository.parse_obj(obj)

        _obj = TemplateFieldsDepository.parse_obj({
            "account_type": obj.get("account_type"),
            "bank_country": obj.get("bank_country"),
            "currency": obj.get("currency"),
            "balance_ceiling": BalanceCeiling.from_dict(obj.get("balance_ceiling")) if obj.get("balance_ceiling") is not None else None,
            "balance_floor": BalanceFloor.from_dict(obj.get("balance_floor")) if obj.get("balance_floor") is not None else None,
            "fee_product_ids": obj.get("fee_product_ids"),
            "interest_product_id": obj.get("interest_product_id"),
            "is_ach_enabled": obj.get("is_ach_enabled") if obj.get("is_ach_enabled") is not None else False,
            "is_card_enabled": obj.get("is_card_enabled") if obj.get("is_card_enabled") is not None else False,
            "is_p2p_enabled": obj.get("is_p2p_enabled") if obj.get("is_p2p_enabled") is not None else False,
            "is_wire_enabled": obj.get("is_wire_enabled") if obj.get("is_wire_enabled") is not None else False,
            "overdraft_limit": obj.get("overdraft_limit"),
            "spend_control_ids": obj.get("spend_control_ids"),
            "spending_limits": SpendingLimits.from_dict(obj.get("spending_limits")) if obj.get("spending_limits") is not None else None
        })
        return _obj

